/*
 * LineReportElement.java
 *
 * Created on 28 febbraio 2003, 20.02
 /*
 *  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 */
package it.businesslogic.ireport;

import it.businesslogic.ireport.gui.*;
import it.businesslogic.ireport.util.*;
import java.awt.*;
import java.awt.image.*;
import java.awt.geom.*;

public class LineReportElement extends GraphicReportElement 
{

	public String direction;
	
	public LineReportElement(int x, int y, int width, int height)
	{
		//this(x,y,width,height,"TopDown");
        // I expect the delta width and height to be passed
        // so with + or - sign.
        this(x, y , width, height, "whatever");

        if (width * height >= 0) {
            setDirection( "TopDown" );
        } else {
            setDirection( "BottomUp" );
        }
	}
	
	public LineReportElement(int x, int y, int width, int height, String direction)
	{
		super(x, y, Math.abs(width) , Math.abs(height) );
		graphicElementPen  = "Thin";
		this.bgcolor = Color.WHITE;
		this.fgcolor = Color.BLACK;
		this.direction = direction;
        setKey("line");
	}
	
	public void drawObject(Graphics2D g,double zoom_factor, int x_shift_origin, int y_shift_origin)
	{
		this.zoom_factor = zoom_factor;
		int height_draw = 0;
                if (height <= 1) height_draw = 0;
                else height_draw = height-1;
                int width_draw = 0;
                if (width <= 1) width_draw = 0;
                else width_draw = width-1;
		
                //g.fill( position.x,position.y,width,height,new Brush(bgcolor, BrushStyle.SOLID));
		Point a = new Point( getZoomedDim( position.x-10) +10-x_shift_origin, getZoomedDim( position.y-10) +10-y_shift_origin );
		Point b = new Point( getZoomedDim(position.x+width_draw-10)+10-x_shift_origin,getZoomedDim( position.y+height_draw-10)+10-y_shift_origin);
		
                if (!direction.equalsIgnoreCase("TopDown"))
		{
			b.y = getZoomedDim( position.y-10) +10-y_shift_origin;
			a.y = getZoomedDim( position.y+height-10)+10-y_shift_origin;
		}
		
                Stroke stroke = this.getPenStroke( getGraphicElementPen() ,zoom_factor );
		if(stroke != null){
	                Stroke oldStroke = g.getStroke();
                	g.setStroke(stroke);
                
			g.setColor( this.fgcolor );    
			g.drawLine(a.x,a.y,b.x,b.y);                
	                g.setStroke(oldStroke);
		}
	}
	
	public ReportElement cloneMe()
	{
		LineReportElement newReportElement = new LineReportElement(position.x, position.y, width, height);
		copyBaseReportElement(newReportElement, this);
		
		return newReportElement;
	}
        
        /** Getter for property direction.
         * @return Value of property direction.
         *
         */
        public java.lang.String getDirection() {
            return direction;
        }
        
        /** Setter for property direction.
         * @param direction New value of property direction.
         *
         */
        public void setDirection(java.lang.String direction) {
            this.direction = direction;
        }
        
        public void copyBaseReportElement(ReportElement destination, ReportElement source)
        {
                super.copyBaseReportElement(destination, source);
                
                if (destination instanceof LineReportElement &&
                    source instanceof LineReportElement )
                {
                    ((LineReportElement)destination).setDirection( new String(  ((LineReportElement)source).getDirection()));
                }
        }
        
         public boolean insideBand()
        {

            int r_height = (height == 0) ? 1 : height;
            if (band == null)
            {

                return false;
            }

            int yband = band.getBandYLocation();

            if (position.y - yband + r_height > band.getHeight())
            {
                return false;
            }
            return super.insideBand();
        }
}