/*
 * PieDatasetPanel.java
 *
 * Created on 15 agosto 2005, 17.55
 */

package it.businesslogic.ireport.chart;

/**
 *
 * @author  Administrator
 */
public class PieDatasetPanel extends javax.swing.JPanel {
    
    private PieDataset pieDataset = null;
    
    /** Creates new form PieDatasetPanel */
    public PieDatasetPanel() {
        initComponents();
        
        this.jRTextExpressionKey.getDocument().addDocumentListener( new javax.swing.event.DocumentListener() {
            public void changedUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionKeyTextChanged();
            }
            public void insertUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionKeyTextChanged();
            }
            public void removeUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionKeyTextChanged();
            }
        });
        
        
        this.jRTextExpressionValue.getDocument().addDocumentListener( new javax.swing.event.DocumentListener() {
            public void changedUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionValueTextChanged();
            }
            public void insertUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionValueTextChanged();
            }
            public void removeUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionValueTextChanged();
            }
        });
        
        this.jRTextExpressionLabel.getDocument().addDocumentListener( new javax.swing.event.DocumentListener() {
            public void changedUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionLabelTextChanged();
            }
            public void insertUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionLabelTextChanged();
            }
            public void removeUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionLabelTextChanged();
            }
        });
    }

    public PieDataset getPieDataset() {
        return pieDataset;
    }

    public void setPieDataset(PieDataset pieDataset) {
        this.pieDataset = pieDataset;
        jRTextExpressionKey.setText( pieDataset.getKeyExpression() );
        jRTextExpressionValue.setText( pieDataset.getValueExpression() );
        jRTextExpressionLabel.setText( pieDataset.getLabelExpression() );
    }
    
    public void jRTextExpressionKeyTextChanged()
    {
        pieDataset.setKeyExpression( jRTextExpressionKey.getText() );
    }
    
    public void jRTextExpressionValueTextChanged()
    {
        pieDataset.setValueExpression( jRTextExpressionValue.getText() );
    }
    
    public void jRTextExpressionLabelTextChanged()
    {
        pieDataset.setLabelExpression( jRTextExpressionLabel.getText() );
    }
    
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jLabelKeyExpression = new javax.swing.JLabel();
        jLabelValueExpression = new javax.swing.JLabel();
        jLabelLabelExpression = new javax.swing.JLabel();
        jRTextExpressionKey = new it.businesslogic.ireport.gui.JRTextExpressionArea();
        jRTextExpressionValue = new it.businesslogic.ireport.gui.JRTextExpressionArea();
        jRTextExpressionLabel = new it.businesslogic.ireport.gui.JRTextExpressionArea();

        setLayout(new java.awt.GridBagLayout());

        jLabelKeyExpression.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabelKeyExpression.setText("Key expression");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        add(jLabelKeyExpression, gridBagConstraints);

        jLabelValueExpression.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabelValueExpression.setText("Value expression");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 0, 0);
        add(jLabelValueExpression, gridBagConstraints);

        jLabelLabelExpression.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabelLabelExpression.setText("Label expression");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 0, 0);
        add(jLabelLabelExpression, gridBagConstraints);

        jRTextExpressionKey.setBorder(new javax.swing.border.EtchedBorder());
        jRTextExpressionKey.setElectricScroll(0);
        jRTextExpressionKey.setMinimumSize(new java.awt.Dimension(10, 10));
        jRTextExpressionKey.setPreferredSize(new java.awt.Dimension(10, 10));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(jRTextExpressionKey, gridBagConstraints);

        jRTextExpressionValue.setBorder(new javax.swing.border.EtchedBorder());
        jRTextExpressionValue.setElectricScroll(0);
        jRTextExpressionValue.setMinimumSize(new java.awt.Dimension(10, 10));
        jRTextExpressionValue.setPreferredSize(new java.awt.Dimension(10, 10));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(jRTextExpressionValue, gridBagConstraints);

        jRTextExpressionLabel.setBorder(new javax.swing.border.EtchedBorder());
        jRTextExpressionLabel.setElectricScroll(0);
        jRTextExpressionLabel.setMinimumSize(new java.awt.Dimension(10, 10));
        jRTextExpressionLabel.setPreferredSize(new java.awt.Dimension(10, 10));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(jRTextExpressionLabel, gridBagConstraints);

    }
    // </editor-fold>//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabelKeyExpression;
    private javax.swing.JLabel jLabelLabelExpression;
    private javax.swing.JLabel jLabelValueExpression;
    private it.businesslogic.ireport.gui.JRTextExpressionArea jRTextExpressionKey;
    private it.businesslogic.ireport.gui.JRTextExpressionArea jRTextExpressionLabel;
    private it.businesslogic.ireport.gui.JRTextExpressionArea jRTextExpressionValue;
    // End of variables declaration//GEN-END:variables
    
}
