/*
 * ExpressionEditor.java
 *
 * Created on 17 novembre 2003, 22.03
 */

package it.businesslogic.ireport.gui;
import it.businesslogic.ireport.gui.syntax.*;
import javax.swing.tree.*;
import javax.swing.*;
import java.util.*;
/**
 *
 * @author  Administrator
 */
public class ExpressionEditor extends javax.swing.JDialog
{
   
   
   /** Creates new form ExpressionEditor */
   public ExpressionEditor()
   {
      initComponents();
      this.setSize(600, 450);
      
      this.setModal(true);
      //this.setModal(true);
      org.syntax.jedit.SyntaxDocument sd = new org.syntax.jedit.SyntaxDocument();
      sd.setTokenMarker(new org.syntax.jedit.tokenmarker.JavaTokenMarker() );
      
      this.jEditTextArea1.setDocument( sd );
      this.jEditTextArea1.getPainter().setEOLMarkersPainted(false);
      this.jEditTextArea1.getPainter().setInvalidLinesPainted(false);
      this.jEditTextArea1.getPainter().setLineHighlightEnabled(false);
        
      
      DefaultMutableTreeNode dmtn = new DefaultMutableTreeNode("root");
      dmtn.add( new DefaultMutableTreeNode("Fields"));
      dmtn.add( new DefaultMutableTreeNode("Variables"));
      dmtn.add( new DefaultMutableTreeNode("Parameters"));
      dmtn.add( new DefaultMutableTreeNode("Formulas"));
      this.jTree1.setCellRenderer(new DocumentExpressionEditorTreeCellRenderer());
      this.jTree1.setModel(new javax.swing.tree.DefaultTreeModel(dmtn));
      
      it.businesslogic.ireport.util.Misc.centerFrame(this);
      
      jList1.setModel(new DefaultListModel());
      for (int i=0; i<50; ++i)
      ( (DefaultListModel)jList1.getModel()).addElement( "$F{PIPPO}" );

      this.pack();
   }
   
   
   
   /** This method is called from within the constructor to
    * initialize the form.
    * WARNING: Do NOT modify this code. The content of this method is
    * always regenerated by the Form Editor.
    */
    private void initComponents() {//GEN-BEGIN:initComponents
        jPanel1 = new javax.swing.JPanel();
        jSplitPane1 = new javax.swing.JSplitPane();
        jEditTextArea1 = new org.syntax.jedit.JEditTextArea();
        jSplitPane2 = new javax.swing.JSplitPane();
        jPanel4 = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        jList1 = new javax.swing.JList();
        jPanel3 = new javax.swing.JPanel();
        jScrollPane2 = new javax.swing.JScrollPane();
        jTree1 = new javax.swing.JTree();
        jPanel2 = new javax.swing.JPanel();
        jButton2 = new javax.swing.JButton();
        jButton1 = new javax.swing.JButton();

        setTitle("Expression editor...");
        setModal(true);
        addComponentListener(new java.awt.event.ComponentAdapter() {
            public void componentResized(java.awt.event.ComponentEvent evt) {
                formComponentResized(evt);
            }
        });
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                exitForm(evt);
            }
        });

        jPanel1.setLayout(new java.awt.BorderLayout());

        jSplitPane1.setDividerSize(4);
        jSplitPane1.setOrientation(javax.swing.JSplitPane.VERTICAL_SPLIT);
        jSplitPane1.setResizeWeight(0.5);
        jEditTextArea1.setPreferredSize(new java.awt.Dimension(150, 150));
        jEditTextArea1.setMinimumSize(new java.awt.Dimension(20, 20));
        jEditTextArea1.addComponentListener(new java.awt.event.ComponentAdapter() {
            public void componentResized(java.awt.event.ComponentEvent evt) {
                jEditTextArea1ComponentResized(evt);
            }
        });

        jSplitPane1.setLeftComponent(jEditTextArea1);

        jSplitPane2.setResizeWeight(0.5);
        jSplitPane2.setDividerSize(4);
        jSplitPane2.setPreferredSize(new java.awt.Dimension(361, 160));
        jSplitPane2.setAutoscrolls(true);
        jPanel4.setLayout(new java.awt.BorderLayout());

        jPanel4.setPreferredSize(new java.awt.Dimension(100, 100));
        jList1.setFont(new java.awt.Font("SansSerif", 0, 12));
        jList1.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
                jList1ValueChanged(evt);
            }
        });
        jList1.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jList1MouseClicked(evt);
            }
        });

        jScrollPane1.setViewportView(jList1);

        jPanel4.add(jScrollPane1, java.awt.BorderLayout.CENTER);

        jSplitPane2.setRightComponent(jPanel4);
        jPanel4.getAccessibleContext().setAccessibleParent(jPanel1);

        jPanel3.setLayout(new java.awt.BorderLayout());

        jScrollPane2.setPreferredSize(new java.awt.Dimension(100, 100));
        jTree1.setRootVisible(false);
        jTree1.addTreeSelectionListener(new javax.swing.event.TreeSelectionListener() {
            public void valueChanged(javax.swing.event.TreeSelectionEvent evt) {
                jTree1ValueChanged(evt);
            }
        });

        jScrollPane2.setViewportView(jTree1);

        jPanel3.add(jScrollPane2, java.awt.BorderLayout.CENTER);

        jSplitPane2.setLeftComponent(jPanel3);
        jPanel3.getAccessibleContext().setAccessibleParent(jPanel1);

        jSplitPane1.setBottomComponent(jSplitPane2);

        jPanel1.add(jSplitPane1, java.awt.BorderLayout.CENTER);

        getContentPane().add(jPanel1, java.awt.BorderLayout.CENTER);

        jPanel2.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.RIGHT));

        jPanel2.setPreferredSize(new java.awt.Dimension(10, 30));
        jPanel2.setMinimumSize(new java.awt.Dimension(10, 30));
        jButton2.setFont(new java.awt.Font("Dialog", 0, 11));
        jButton2.setText("Apply");
        jButton2.setMnemonic('a');
        jButton2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton2ActionPerformed(evt);
            }
        });

        jPanel2.add(jButton2);

        jButton1.setFont(new java.awt.Font("Dialog", 0, 11));
        jButton1.setText("Cancel");
        jButton1.setMnemonic('c');
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });

        jPanel2.add(jButton1);

        getContentPane().add(jPanel2, java.awt.BorderLayout.SOUTH);

        pack();
    }//GEN-END:initComponents

    private void jList1MouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jList1MouseClicked
        
        if (evt.getButton() == evt.BUTTON1 && evt.getClickCount() == 2)
        {
            try {
            jEditTextArea1.getDocument().replace(jEditTextArea1.getSelectionStart(), 
                                             jEditTextArea1.getSelectionEnd()-jEditTextArea1.getSelectionStart(), 
                                             jList1.getSelectedValue()+"", null);
            } catch (Exception ex){}
        }
    }//GEN-LAST:event_jList1MouseClicked

    private void jList1ValueChanged(javax.swing.event.ListSelectionEvent evt) {//GEN-FIRST:event_jList1ValueChanged
        
        
        
        
    }//GEN-LAST:event_jList1ValueChanged
        
    private void jTree1ValueChanged(javax.swing.event.TreeSelectionEvent evt) {//GEN-FIRST:event_jTree1ValueChanged
       
       ( (DefaultListModel)jList1.getModel()).removeAllElements();
       
       if (jrf == null) return;
       DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)jTree1.getSelectionPath().getLastPathComponent();
       if ((""+dmtn.getUserObject()).equalsIgnoreCase("Fields"))
       {
          Enumeration e = jrf.getReport().getFields().elements();
          while (e.hasMoreElements())
          {
             ( (DefaultListModel)jList1.getModel()).addElement( "$F{"+e.nextElement() +"}" );
          }
       }
       else if ((""+dmtn.getUserObject()).equalsIgnoreCase("Parameters"))
       {
          Enumeration e = jrf.getReport().getParameters().elements();
          while (e.hasMoreElements())
          {
             ( (DefaultListModel)jList1.getModel()).addElement( "$P{"+ e.nextElement()+"}" );
          }
       }
       else if ((""+dmtn.getUserObject()).equalsIgnoreCase("Variables"))
       {
          Enumeration e = jrf.getReport().getVariables().elements();
          while (e.hasMoreElements())
          {
             ( (DefaultListModel)jList1.getModel()).addElement( "$V{"+e.nextElement() +"}" );
          }
       }
       else if ((""+dmtn.getUserObject()).equalsIgnoreCase("Formulas"))
       {
           ( (DefaultListModel)jList1.getModel()).addElement( "((it.businesslogic.ireport.IReportScriptlet)$P{REPORT_SCRIPTLET}).addValueToSerie(<serieName>,<exp>)" );
           ( (DefaultListModel)jList1.getModel()).addElement( "((it.businesslogic.ireport.IReportScriptlet)$P{REPORT_SCRIPTLET}).resetSerie(<serieName>,<exp>)" );
           ( (DefaultListModel)jList1.getModel()).addElement( "((it.businesslogic.ireport.IReportScriptlet)$P{REPORT_SCRIPTLET}).getSerie(<serieName>)" );
           ( (DefaultListModel)jList1.getModel()).addElement( "((net.sf.jasperreports.engine.data.JRXmlDataSource)$P{REPORT_DATA_SOURCE}).subDataSource(<select expression>)" );
           ( (DefaultListModel)jList1.getModel()).addElement( "((net.sf.jasperreports.engine.data.JRXmlDataSource)$P{REPORT_DATA_SOURCE}).dataSource(<select expression>)" );
           ( (DefaultListModel)jList1.getModel()).addElement( "msg(<pattern>, <arg0>)" );
           ( (DefaultListModel)jList1.getModel()).addElement( "msg(<pattern>, <arg0>, <arg1>)" );
           ( (DefaultListModel)jList1.getModel()).addElement( "msg(<pattern>, <arg0>, <arg1>, <arg2>)" );
           ( (DefaultListModel)jList1.getModel()).addElement( "str(<key>)" );
       }
    }//GEN-LAST:event_jTree1ValueChanged
    
    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
       //this.setExpression( this.jEditTextArea1.getText() );
       this.setDialogResult( javax.swing.JOptionPane.NO_OPTION );
       this.dispose();
    }//GEN-LAST:event_jButton1ActionPerformed
    
    private void jButton2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton2ActionPerformed
       this.setExpression( this.jEditTextArea1.getText() );
       this.setDialogResult( javax.swing.JOptionPane.OK_OPTION );
       this.dispose();
    }//GEN-LAST:event_jButton2ActionPerformed
    
    private void jEditTextArea1ComponentResized(java.awt.event.ComponentEvent evt) {//GEN-FIRST:event_jEditTextArea1ComponentResized
       // Add your handling code here:
    }//GEN-LAST:event_jEditTextArea1ComponentResized
    
    private void formComponentResized(java.awt.event.ComponentEvent evt) {//GEN-FIRST:event_formComponentResized
       //this.jEditTextArea1.recalculateVisibleLines();
       this.jEditTextArea1.updateScrollBars();
    }//GEN-LAST:event_formComponentResized
    
    /** Exit the Application */
    private void exitForm(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_exitForm
       
    }//GEN-LAST:event_exitForm
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[])
    {
       new ExpressionEditor().show();
    }
    
    /** Getter for property jrf.
     * @return Value of property jrf.
     *
     */
    public it.businesslogic.ireport.gui.JReportFrame getJrf()
    {
       return jrf;
    }
    
    /** Setter for property jrf.
     * @param jrf New value of property jrf.
     *
     */
    public void setJrf(it.businesslogic.ireport.gui.JReportFrame jrf)
    {
       this.jrf = jrf;
       // Selezioniamo il campo fields....
       jTree1.setSelectionRow(0);
       
       jEditTextArea1.getTokenMarker().setKeywordLookup(
       jrf.getReport().getKeywordLookup());
    }
    
    /** Getter for property Expression.
     * @return Value of property Expression.
     *
     */
    public java.lang.String getExpression()
    {
       return Expression;
    }
    
    /** Setter for property Expression.
     * @param Expression New value of property Expression.
     *
     */
    public void setExpression(java.lang.String Expression)
    {
       this.jEditTextArea1.setText( Expression );
       this.Expression = Expression;
    }
    
    /** Getter for property dialogResult.
     * @return Value of property dialogResult.
     *
     */
    public int getDialogResult()
    {
       return dialogResult;
    }
    
    /** Setter for property dialogResult.
     * @param dialogResult New value of property dialogResult.
     *
     */
    public void setDialogResult(int dialogResult)
    {
       this.dialogResult = dialogResult;
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButton1;
    private javax.swing.JButton jButton2;
    private org.syntax.jedit.JEditTextArea jEditTextArea1;
    private javax.swing.JList jList1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JSplitPane jSplitPane1;
    private javax.swing.JSplitPane jSplitPane2;
    private javax.swing.JTree jTree1;
    // End of variables declaration//GEN-END:variables
    
    private JReportFrame jrf;
    
    private String Expression;
    
    private int dialogResult;
    
}

/*
 if (evt.getClickCount() == 2 && evt.getButton() == java.awt.event.MouseEvent.BUTTON1)
       {
          if (this.jList1.getSelectedIndex() >= 0)
          {
             String s = ""+this.jList1.getSelectedValue();
             try
             {
                jEditTextArea1.getDocument().insertString( jEditTextArea1.getCaretPosition(), s, null);
             } catch (Exception ex)
             {}
          }
       }
 */
