/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.syntax.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.syntax.Types;

public class ASTHelper {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String[] DEFAULT_IMPORTS = new String[]{"java.lang.", "groovy.lang.", "groovy.util."};
    private SourceUnit controller;
    private ClassLoader classLoader;
    private Map imports;
    protected ModuleNode output;
    private String packageName;
    protected static HashMap resolutions = new HashMap();
    private static String NOT_RESOLVED = new String();
    private List newClasses = new ArrayList();

    public ASTHelper(SourceUnit controller, ClassLoader classLoader) {
        this();
        this.controller = controller;
        this.classLoader = classLoader;
    }

    public ASTHelper() {
        this.imports = new HashMap();
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
        this.output.setPackageName(packageName);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public SourceUnit getController() {
        return this.controller;
    }

    public void setController(SourceUnit controller) {
        this.controller = controller;
    }

    protected String resolveName(String name, boolean safe) {
        String resolution;
        block20: {
            resolution = (String)resolutions.get(name);
            if (NOT_RESOLVED.equals(resolution)) {
                return safe ? name : null;
            }
            if (resolution != null) {
                return resolution;
            }
            if (name.indexOf(".") >= 0) {
                resolution = name;
            } else {
                String scalar = name;
                String postfix = "";
                while (scalar.endsWith("[]")) {
                    scalar = scalar.substring(0, scalar.length() - 2);
                    postfix = postfix + "[]";
                }
                if (Types.ofType(Types.lookupKeyword(scalar), 1340)) {
                    resolution = name;
                } else if (this.imports.containsKey(scalar)) {
                    resolution = (String)this.imports.get(scalar) + postfix;
                } else {
                    int i;
                    if (this.packageName != null && this.packageName.length() > 0) {
                        try {
                            this.getClassLoader().loadClass(this.dot(this.packageName, scalar));
                            resolution = this.dot(this.packageName, name);
                            break block20;
                        }
                        catch (Throwable e) {
                            // empty catch block
                        }
                    }
                    List packageImports = this.output.getImportPackages();
                    for (i = 0; i < packageImports.size(); ++i) {
                        String pack = (String)packageImports.get(i);
                        String clsName = pack + name;
                        try {
                            this.getClassLoader().loadClass(clsName);
                            resolution = clsName;
                            break;
                        }
                        catch (Throwable e) {
                            continue;
                        }
                    }
                    if (resolution == null) {
                        for (i = 0; i < DEFAULT_IMPORTS.length; ++i) {
                            try {
                                String qualified = DEFAULT_IMPORTS[i] + scalar;
                                this.getClassLoader().loadClass(qualified);
                                resolution = qualified + postfix;
                                break;
                            }
                            catch (Throwable e) {
                                continue;
                            }
                        }
                    }
                }
            }
        }
        if (resolution == null) {
            resolutions.put(name, NOT_RESOLVED);
            return safe ? name : null;
        }
        resolutions.put(name, resolution);
        return resolution;
    }

    protected String dot(String base, String name) {
        if (base != null && base.length() > 0) {
            return base + "." + name;
        }
        return name;
    }

    protected void makeModule() {
        this.newClasses.clear();
        this.output = new ModuleNode(this.controller);
        resolutions.clear();
    }

    protected boolean isDatatype(String name) {
        return this.resolveName(name, false) != null;
    }

    protected String dot(String base) {
        return this.dot(base, "");
    }

    protected String resolveNewClassOrName(String name, boolean safe) {
        if (this.newClasses.contains(name)) {
            return this.dot(this.packageName, name);
        }
        return this.resolveName(name, safe);
    }

    protected void addNewClassName(String name) {
        this.newClasses.add(name);
    }

    protected void importClass(String importPackage, String name, String as) {
        this.output.addImport(as, name);
        name = this.dot(importPackage, name);
        this.imports.put(as, name);
    }

    protected void importPackageWithStar(String importPackage) {
        String[] classes = this.output.addImportPackage(this.dot(importPackage));
        for (int i = 0; i < classes.length; ++i) {
            this.imports.put(classes[i], this.dot(importPackage, classes[i]));
        }
    }
}

