/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.chart;

import it.businesslogic.ireport.chart.CategorySeriesDialog;
import it.businesslogic.ireport.gui.JRTextExpressionArea;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.Misc;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;

public class XYSeriesDialog
extends JDialog {
    private String seriesExpression = "";
    private String xValueExpression = "";
    private String yValueExpression = "";
    private String labelExpression = "";
    private int dialogResult = 2;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JLabel jLabelLabelExpression;
    private JLabel jLabelSeriesExpression;
    private JLabel jLabelXValueExpression;
    private JLabel jLabelYValueExpression;
    private JPanel jPanel1;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JRTextExpressionArea jRTextExpressionLabel;
    private JRTextExpressionArea jRTextExpressionSeries;
    private JRTextExpressionArea jRTextExpressionXValue;
    private JRTextExpressionArea jRTextExpressionYValue;

    public XYSeriesDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.applyI18n();
        this.setSize(500, 500);
        Misc.centerFrame(this);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabelSeriesExpression = new JLabel();
        this.jLabelXValueExpression = new JLabel();
        this.jLabelYValueExpression = new JLabel();
        this.jLabelLabelExpression = new JLabel();
        this.jRTextExpressionSeries = new JRTextExpressionArea();
        this.jRTextExpressionXValue = new JRTextExpressionArea();
        this.jRTextExpressionYValue = new JRTextExpressionArea();
        this.jRTextExpressionLabel = new JRTextExpressionArea();
        this.jPanel6 = new JPanel();
        this.jPanel7 = new JPanel();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.setTitle("XY series");
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabelSeriesExpression.setFont(new Font("Dialog", 0, 11));
        this.jLabelSeriesExpression.setText("Series expression (required)");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jLabelSeriesExpression, gridBagConstraints);
        this.jLabelXValueExpression.setFont(new Font("Dialog", 0, 11));
        this.jLabelXValueExpression.setText("X value expression (required)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanel1.add((Component)this.jLabelXValueExpression, gridBagConstraints);
        this.jLabelYValueExpression.setFont(new Font("Dialog", 0, 11));
        this.jLabelYValueExpression.setText("Y value expression (required)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanel1.add((Component)this.jLabelYValueExpression, gridBagConstraints);
        this.jLabelLabelExpression.setFont(new Font("Dialog", 0, 11));
        this.jLabelLabelExpression.setText("Label expression");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanel1.add((Component)this.jLabelLabelExpression, gridBagConstraints);
        this.jRTextExpressionSeries.setBorder(new EtchedBorder());
        this.jRTextExpressionSeries.setElectricScroll(0);
        this.jRTextExpressionSeries.setMinimumSize(new Dimension(10, 10));
        this.jRTextExpressionSeries.setPreferredSize(new Dimension(10, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jRTextExpressionSeries, gridBagConstraints);
        this.jRTextExpressionXValue.setBorder(new EtchedBorder());
        this.jRTextExpressionXValue.setElectricScroll(0);
        this.jRTextExpressionXValue.setMinimumSize(new Dimension(10, 10));
        this.jRTextExpressionXValue.setPreferredSize(new Dimension(10, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jRTextExpressionXValue, gridBagConstraints);
        this.jRTextExpressionYValue.setBorder(new EtchedBorder());
        this.jRTextExpressionYValue.setElectricScroll(0);
        this.jRTextExpressionYValue.setMinimumSize(new Dimension(10, 10));
        this.jRTextExpressionYValue.setPreferredSize(new Dimension(10, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jRTextExpressionYValue, gridBagConstraints);
        this.jRTextExpressionLabel.setBorder(new EtchedBorder());
        this.jRTextExpressionLabel.setElectricScroll(0);
        this.jRTextExpressionLabel.setMinimumSize(new Dimension(10, 10));
        this.jRTextExpressionLabel.setPreferredSize(new Dimension(10, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jRTextExpressionLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel6.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel6.add((Component)this.jPanel7, gridBagConstraints);
        this.jButtonOK.setFont(new Font("Dialog", 0, 11));
        this.jButtonOK.setMnemonic('o');
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                XYSeriesDialog.this.jButtonOKActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel6.add((Component)this.jButtonOK, gridBagConstraints);
        this.jButtonCancel.setFont(new Font("Dialog", 0, 11));
        this.jButtonCancel.setMnemonic('c');
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                XYSeriesDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.jPanel6.add((Component)this.jButtonCancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jPanel6, gridBagConstraints);
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        this.seriesExpression = this.jRTextExpressionSeries.getText();
        this.setXValueExpression(this.jRTextExpressionXValue.getText());
        this.setYValueExpression(this.jRTextExpressionYValue.getText());
        this.labelExpression = this.jRTextExpressionLabel.getText();
        MessageFormat formatter = new MessageFormat(I18n.getString("gui.notvalidexp", "{0} cannot be blank!"));
        if (this.seriesExpression.trim().length() == 0) {
            JOptionPane.showMessageDialog(this, formatter.format(new Object[]{I18n.getString("charts.seriesExpression", "Series expression")}), "Invalid expression", 0);
            return;
        }
        if (this.xValueExpression.trim().length() == 0) {
            JOptionPane.showMessageDialog(this, formatter.format(new Object[]{I18n.getString("charts.yValueExpression", "X Value expression")}), "Invalid expression", 0);
            return;
        }
        if (this.yValueExpression.trim().length() == 0) {
            JOptionPane.showMessageDialog(this, formatter.format(new Object[]{I18n.getString("charts.yValueExpression", "Y Value expression")}), "Invalid expression", 0);
            return;
        }
        this.setDialogResult(0);
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new CategorySeriesDialog((Frame)new JFrame(), true).setVisible(true);
            }
        });
    }

    public String getSeriesExpression() {
        return this.seriesExpression;
    }

    public void setSeriesExpression(String seriesExpression) {
        this.seriesExpression = seriesExpression;
        this.jRTextExpressionSeries.setText(seriesExpression);
    }

    public String getLabelExpression() {
        return this.labelExpression;
    }

    public void setLabelExpression(String labelExpression) {
        this.labelExpression = labelExpression;
        this.jRTextExpressionLabel.setText(labelExpression);
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public void applyI18n() {
        this.jButtonOK.setText(I18n.getString("ok", "Ok"));
        this.jButtonCancel.setText(I18n.getString("cancel", "Cancel"));
        this.jLabelSeriesExpression.setText(I18n.getString("charts.seriesExpression", "Series expression"));
        this.jLabelXValueExpression.setText(I18n.getString("charts.xValueExpression", "X Value expression"));
        this.jLabelYValueExpression.setText(I18n.getString("charts.yValueExpression", "Y Value expression"));
        this.jLabelLabelExpression.setText(I18n.getString("charts.labelExpression", "Label expression"));
        this.getRootPane().updateUI();
    }

    public String getXValueExpression() {
        return this.xValueExpression;
    }

    public void setXValueExpression(String xValueExpression) {
        this.xValueExpression = xValueExpression;
        this.jRTextExpressionXValue.setText(xValueExpression);
    }

    public String getYValueExpression() {
        return this.yValueExpression;
    }

    public void setYValueExpression(String yValueExpression) {
        this.yValueExpression = yValueExpression;
        this.jRTextExpressionYValue.setText(yValueExpression);
    }
}

