/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.sql.DriverManager;
import java.util.Hashtable;
import java.util.Properties;
import org.hsqldb.Database;
import org.hsqldb.ServerConnection;

public class Server {
    boolean mSilent;
    Database mDatabase;

    public static void main(String[] stringArray) {
        Server server = new Server();
        server.run(stringArray);
    }

    private void run(String[] stringArray) {
        Object object;
        Object object2;
        ServerSocket serverSocket = null;
        try {
            object2 = new Properties();
            object = new File("Server.properties");
            if (((File)object).exists()) {
                FileInputStream fileInputStream = new FileInputStream((File)object);
                ((Properties)object2).load(fileInputStream);
                fileInputStream.close();
            }
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n];
                if (string.equals("-?")) {
                    this.printHelp();
                }
                if (string.charAt(0) == '-') {
                    ((Hashtable)object2).put(string.substring(1), stringArray[n + 1]);
                    ++n;
                }
                ++n;
            }
            int n2 = 9001;
            n2 = Integer.parseInt(((Properties)object2).getProperty("port", "" + n2));
            String string = ((Properties)object2).getProperty("database", "test");
            this.mSilent = ((Properties)object2).getProperty("silent", "true").equalsIgnoreCase("true");
            if (((Properties)object2).getProperty("trace", "false").equalsIgnoreCase("true")) {
                DriverManager.setLogStream(System.out);
            }
            serverSocket = new ServerSocket(n2);
            this.trace("port    =" + n2);
            this.trace("database=" + string);
            this.trace("silent  =" + this.mSilent);
            this.mDatabase = new Database(string);
            System.out.println("Server 1.6 is running");
            System.out.println("Press [Ctrl]+[C] to abort");
        }
        catch (Exception exception) {
            this.traceError("Server.run/init: " + exception);
            exception.printStackTrace();
            return;
        }
        try {
            while (true) {
                object2 = serverSocket.accept();
                object = new ServerConnection((Socket)object2, this);
                ((Thread)object).start();
            }
        }
        catch (IOException iOException) {
            this.traceError("Server.run/loop: " + iOException.getMessage());
            iOException.printStackTrace();
            return;
        }
    }

    void printHelp() {
        System.out.println("Usage: java Server [-options]\nwhere options include:\n    -port <nr>            port where the server is listening\n    -database <name>      name of the database\n    -silent <true/false>  false means display all queries\n    -trace <true/false>   display print JDBC trace messages\nThe command line arguments override the values in the properties file.");
        System.exit(0);
    }

    void trace(String string) {
        if (!this.mSilent) {
            System.out.println(string);
        }
    }

    void traceError(String string) {
        System.out.println(string);
    }
}

