/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import net.sf.jasperreports.engine.JRAbstractRenderer;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.util.JRImageLoader;

public abstract class JRAbstractSvgRenderer
extends JRAbstractRenderer {
    private static final long serialVersionUID = 10100L;

    public byte getType() {
        return 1;
    }

    public byte getImageType() {
        return 2;
    }

    public Dimension2D getDimension() {
        return null;
    }

    public Color getBackcolor() {
        return null;
    }

    public byte[] getImageData() throws JRException {
        Dimension2D dimension = this.getDimension();
        if (dimension != null) {
            BufferedImage bi = new BufferedImage((int)dimension.getWidth(), (int)dimension.getHeight(), 1);
            Graphics2D g = bi.createGraphics();
            Color backcolor = this.getBackcolor();
            if (backcolor != null) {
                g.setColor(backcolor);
                g.fillRect(0, 0, (int)dimension.getWidth(), (int)dimension.getHeight());
            }
            this.render(g, new Rectangle((int)dimension.getWidth(), (int)dimension.getHeight()));
            g.dispose();
            try {
                return JRImageLoader.loadImageDataFromAWTImage(bi);
            }
            catch (JRException e) {
                throw new JRRuntimeException(e);
            }
        }
        return null;
    }
}

