/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.awt.Color;
import java.io.Serializable;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.util.JRStyleResolver;

public abstract class JRBaseElement
implements JRElement,
Serializable {
    private static final long serialVersionUID = 10100L;
    protected String key = null;
    protected byte positionType;
    protected byte stretchType;
    protected boolean isPrintRepeatedValues = true;
    protected Byte mode;
    protected int x = 0;
    protected int y = 0;
    protected int width = 0;
    protected int height = 0;
    protected boolean isRemoveLineWhenBlank = false;
    protected boolean isPrintInFirstWholeBand = false;
    protected boolean isPrintWhenDetailOverflows = false;
    protected Color forecolor = null;
    protected Color backcolor = null;
    protected JRExpression printWhenExpression = null;
    protected JRGroup printWhenGroupChanges = null;
    protected JRElementGroup elementGroup = null;
    protected JRDefaultStyleProvider defaultStyleProvider;
    protected JRStyle parentStyle;

    protected JRBaseElement(JRDefaultStyleProvider defaultStyleProvider) {
        this.defaultStyleProvider = defaultStyleProvider;
    }

    protected JRBaseElement(JRElement element, JRBaseObjectFactory factory) {
        factory.put(element, this);
        this.defaultStyleProvider = factory.getDefaultStyleProvider();
        this.parentStyle = factory.getStyle(element.getStyle());
        this.key = element.getKey();
        this.positionType = element.getPositionType();
        this.stretchType = element.getStretchType();
        this.isPrintRepeatedValues = element.isPrintRepeatedValues();
        this.mode = element.getOwnMode();
        this.x = element.getX();
        this.y = element.getY();
        this.width = element.getWidth();
        this.height = element.getHeight();
        this.isRemoveLineWhenBlank = element.isRemoveLineWhenBlank();
        this.isPrintInFirstWholeBand = element.isPrintInFirstWholeBand();
        this.isPrintWhenDetailOverflows = element.isPrintWhenDetailOverflows();
        this.forecolor = element.getOwnForecolor();
        this.backcolor = element.getOwnBackcolor();
        this.printWhenExpression = factory.getExpression(element.getPrintWhenExpression());
        this.printWhenGroupChanges = factory.getGroup(element.getPrintWhenGroupChanges());
        this.elementGroup = factory.getElementGroup(element.getElementGroup());
    }

    public JRDefaultStyleProvider getDefaultStyleProvider() {
        return this.defaultStyleProvider;
    }

    protected JRStyle getBaseStyle() {
        if (this.parentStyle != null) {
            return this.parentStyle;
        }
        if (this.defaultStyleProvider != null) {
            return this.defaultStyleProvider.getDefaultStyle();
        }
        return null;
    }

    public String getKey() {
        return this.key;
    }

    public byte getPositionType() {
        return this.positionType;
    }

    public void setPositionType(byte positionType) {
        this.positionType = positionType;
    }

    public byte getStretchType() {
        return this.stretchType;
    }

    public void setStretchType(byte stretchType) {
        this.stretchType = stretchType;
    }

    public boolean isPrintRepeatedValues() {
        return this.isPrintRepeatedValues;
    }

    public void setPrintRepeatedValues(boolean isPrintRepeatedValues) {
        this.isPrintRepeatedValues = isPrintRepeatedValues;
    }

    public byte getMode() {
        return JRStyleResolver.getMode(this, (byte)1);
    }

    public Byte getOwnMode() {
        return this.mode;
    }

    public void setMode(byte mode) {
        this.mode = new Byte(mode);
    }

    public void setMode(Byte mode) {
        this.mode = mode;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isRemoveLineWhenBlank() {
        return this.isRemoveLineWhenBlank;
    }

    public void setRemoveLineWhenBlank(boolean isRemoveLine) {
        this.isRemoveLineWhenBlank = isRemoveLine;
    }

    public boolean isPrintInFirstWholeBand() {
        return this.isPrintInFirstWholeBand;
    }

    public void setPrintInFirstWholeBand(boolean isPrint) {
        this.isPrintInFirstWholeBand = isPrint;
    }

    public boolean isPrintWhenDetailOverflows() {
        return this.isPrintWhenDetailOverflows;
    }

    public void setPrintWhenDetailOverflows(boolean isPrint) {
        this.isPrintWhenDetailOverflows = isPrint;
    }

    public Color getForecolor() {
        return JRStyleResolver.getForecolor(this);
    }

    public Color getOwnForecolor() {
        return this.forecolor;
    }

    public void setForecolor(Color forecolor) {
        this.forecolor = forecolor;
    }

    public Color getBackcolor() {
        return JRStyleResolver.getBackcolor(this);
    }

    public Color getOwnBackcolor() {
        return this.backcolor;
    }

    public void setBackcolor(Color backcolor) {
        this.backcolor = backcolor;
    }

    public JRExpression getPrintWhenExpression() {
        return this.printWhenExpression;
    }

    public JRGroup getPrintWhenGroupChanges() {
        return this.printWhenGroupChanges;
    }

    public JRElementGroup getElementGroup() {
        return this.elementGroup;
    }

    public JRStyle getStyle() {
        return this.parentStyle;
    }
}

