/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.engine.JRAbstractObjectFactory;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRFrame;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.xml.JRXmlWriter;

public class JRBaseElementGroup
implements JRElementGroup,
Serializable {
    private static final long serialVersionUID = 10100L;
    protected List children = new ArrayList();
    protected JRElementGroup elementGroup = null;

    protected JRBaseElementGroup() {
    }

    protected JRBaseElementGroup(JRElementGroup elementGrp, JRBaseObjectFactory factory) {
        factory.put(elementGrp, this);
        List list = elementGrp.getChildren();
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                JRChild child = (JRChild)list.get(i);
                child = child.getCopy(factory);
                this.children.add(child);
            }
        }
        this.elementGroup = factory.getElementGroup(elementGrp.getElementGroup());
    }

    public List getChildren() {
        return this.children;
    }

    public JRElementGroup getElementGroup() {
        return this.elementGroup;
    }

    public static JRElement[] getElements(List children) {
        JRElement[] elements = null;
        if (children != null) {
            ArrayList<JRElement> allElements = new ArrayList<JRElement>();
            Object child = null;
            JRElement[] childElementArray = null;
            for (int i = 0; i < children.size(); ++i) {
                child = children.get(i);
                if (child instanceof JRElement) {
                    allElements.add((JRElement)child);
                    continue;
                }
                if (!(child instanceof JRElementGroup) || (childElementArray = ((JRElementGroup)child).getElements()) == null) continue;
                allElements.addAll(Arrays.asList(childElementArray));
            }
            elements = new JRElement[allElements.size()];
            allElements.toArray(elements);
        }
        return elements;
    }

    public JRElement[] getElements() {
        return JRBaseElementGroup.getElements(this.children);
    }

    public static JRElement getElementByKey(JRElement[] elements, String key) {
        JRElement element = null;
        if (key != null && elements != null) {
            for (int i = 0; element == null && i < elements.length; ++i) {
                JRElement elem = elements[i];
                if (key.equals(elem.getKey())) {
                    element = elem;
                    continue;
                }
                if (elem instanceof JRFrame) {
                    element = ((JRFrame)elem).getElementByKey(key);
                    continue;
                }
                if (!(elem instanceof JRCrosstab)) continue;
                element = ((JRCrosstab)elem).getElementByKey(key);
            }
        }
        return element;
    }

    public JRElement getElementByKey(String key) {
        return JRBaseElementGroup.getElementByKey(this.getElements(), key);
    }

    public JRChild getCopy(JRAbstractObjectFactory factory) {
        return factory.getElementGroup(this);
    }

    public void writeXml(JRXmlWriter xmlWriter) throws IOException {
        xmlWriter.writeElementGroup(this);
    }
}

