/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRQuery;
import net.sf.jasperreports.engine.JRReportFont;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.base.JRBaseReport;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JRDesignVariable;

public class JasperDesign
extends JRBaseReport {
    private transient PropertyChangeSupport propSupport;
    public static final String NAME_PROPERTY = "name";
    public static final String LANGUAGE_PROPERTY = "language";
    public static final String QUERY_PROPERTY = "query";
    public static final String RESOURCE_BUNDLE_PROPERTY = "resourceBundle";
    public static final String SCRIPTLET_CLASS_PROPERTY = "scriptletClass";
    public static final String ORIENTATION_PROPERTY = "orientation";
    public static final String BACKGROUND_PROPERTY = "background";
    public static final String COLUMN_COUNT_PROPERTY = "columnCount";
    public static final String COLUMN_HEADER_PROPERTY = "columnHeader";
    public static final String COLUMN_FOOTER_PROPERTY = "columnFooter";
    public static final String LEFT_MARGIN_PROPERTY = "leftMargin";
    public static final String RIGHT_MARGIN_PROPERTY = "rightMargin";
    public static final String TOP_MARGIN_PROPERTY = "topMargin";
    public static final String BOTTOM_MARGIN_PROPERTY = "bottomMargin";
    public static final String COLUMN_WIDTH_PROPERTY = "columnWidth";
    public static final String COLUMN_SPACING_PROPERTY = "columnSpacing";
    public static final String PRINT_ORDER_PROPERTY = "printOrder";
    public static final String DEFAULT_FONT_PROPERTY = "defaultFont";
    public static final String DEFAULT_STYLE_PROPERTY = "defaultStyle";
    public static final String TITLE_PROPERTY = "title";
    public static final String TITLE_NEW_PAGE_PROPERTY = "titleNewPage";
    public static final String PAGE_WIDTH_PROPERTY = "pageWidth";
    public static final String PAGE_HEIGHT_PROPERTY = "pageHeight";
    public static final String PAGE_HEADER_PROPERTY = "pageHeader";
    public static final String PAGE_FOOTER_PROPERTY = "pageFooter";
    public static final String LAST_PAGE_FOOTER_PROPERTY = "lastPageFooter";
    public static final String SUMMARY_PROPERTY = "summary";
    public static final String SUMMARY_NEW_PAGE_PROPERTY = "summaryNewPage";
    public static final String FLOAT_COLUMN_FOOTER_PROPERTY = "floatColumnFooter";
    public static final String DETAIL_PROPERTY = "detail";
    private static final long serialVersionUID = 10100L;
    private Map fontsMap = new HashMap();
    private List fontsList = new ArrayList();
    private Map stylesMap = new HashMap();
    private List stylesList = new ArrayList();
    private JRDesignDataset mainDesignDataset;
    private Map datasetMap = new HashMap();
    private List datasetList = new ArrayList();
    private transient List crosstabs;

    public JasperDesign() {
        this.setMainDataset(new JRDesignDataset(true));
    }

    public void setName(String name) {
        String oldValue = this.name;
        this.name = name;
        this.mainDesignDataset.setName(name);
        this.getPropertyChangeSupport().firePropertyChange(NAME_PROPERTY, oldValue, this.name);
    }

    public void setLanguage(String language) {
        String oldValue = this.language;
        this.language = language;
        this.getPropertyChangeSupport().firePropertyChange(LANGUAGE_PROPERTY, oldValue, this.language);
    }

    public void setColumnCount(int columnCount) {
        int oldValue = this.columnCount;
        this.columnCount = columnCount;
        this.getPropertyChangeSupport().firePropertyChange(COLUMN_COUNT_PROPERTY, oldValue, this.columnCount);
    }

    public void setPrintOrder(byte printOrder) {
        Byte oldValue = new Byte(this.printOrder);
        this.printOrder = printOrder;
        this.getPropertyChangeSupport().firePropertyChange(PRINT_ORDER_PROPERTY, oldValue, new Byte(this.printOrder));
    }

    public void setPageWidth(int pageWidth) {
        int oldValue = this.pageWidth;
        this.pageWidth = pageWidth;
        this.getPropertyChangeSupport().firePropertyChange(PAGE_WIDTH_PROPERTY, oldValue, this.pageWidth);
    }

    public void setPageHeight(int pageHeight) {
        int oldValue = this.pageHeight;
        this.pageHeight = pageHeight;
        this.getPropertyChangeSupport().firePropertyChange(PAGE_HEIGHT_PROPERTY, oldValue, this.pageHeight);
    }

    public void setOrientation(byte orientation) {
        Byte oldValue = new Byte(this.orientation);
        this.orientation = orientation;
        this.getPropertyChangeSupport().firePropertyChange(ORIENTATION_PROPERTY, oldValue, new Byte(this.orientation));
    }

    public void setColumnWidth(int columnWidth) {
        int oldValue = this.columnWidth;
        this.columnWidth = columnWidth;
        this.getPropertyChangeSupport().firePropertyChange(COLUMN_WIDTH_PROPERTY, oldValue, this.columnWidth);
    }

    public void setColumnSpacing(int columnSpacing) {
        int oldValue = this.columnSpacing;
        this.columnSpacing = columnSpacing;
        this.getPropertyChangeSupport().firePropertyChange(COLUMN_SPACING_PROPERTY, oldValue, this.columnSpacing);
    }

    public void setLeftMargin(int leftMargin) {
        int oldValue = this.leftMargin;
        this.leftMargin = leftMargin;
        this.getPropertyChangeSupport().firePropertyChange(LEFT_MARGIN_PROPERTY, oldValue, this.leftMargin);
    }

    public void setRightMargin(int rightMargin) {
        int oldValue = this.rightMargin;
        this.rightMargin = rightMargin;
        this.getPropertyChangeSupport().firePropertyChange(RIGHT_MARGIN_PROPERTY, oldValue, this.rightMargin);
    }

    public void setTopMargin(int topMargin) {
        int oldValue = this.topMargin;
        this.topMargin = topMargin;
        this.getPropertyChangeSupport().firePropertyChange(TOP_MARGIN_PROPERTY, oldValue, this.topMargin);
    }

    public void setBottomMargin(int bottomMargin) {
        int oldValue = this.bottomMargin;
        this.bottomMargin = bottomMargin;
        this.getPropertyChangeSupport().firePropertyChange(BOTTOM_MARGIN_PROPERTY, oldValue, this.bottomMargin);
    }

    public void setBackground(JRBand background) {
        JRBand oldValue = this.background;
        this.background = background;
        this.getPropertyChangeSupport().firePropertyChange(BACKGROUND_PROPERTY, oldValue, this.background);
    }

    public void setTitle(JRBand title) {
        JRBand oldValue = this.title;
        this.title = title;
        this.getPropertyChangeSupport().firePropertyChange(TITLE_PROPERTY, oldValue, this.title);
    }

    public void setTitleNewPage(boolean isTitleNewPage) {
        boolean oldValue = this.isTitleNewPage;
        this.isTitleNewPage = isTitleNewPage;
        this.getPropertyChangeSupport().firePropertyChange(TITLE_NEW_PAGE_PROPERTY, oldValue, this.isTitleNewPage);
    }

    public void setSummary(JRBand summary) {
        JRBand oldValue = this.summary;
        this.summary = summary;
        this.getPropertyChangeSupport().firePropertyChange(SUMMARY_PROPERTY, oldValue, this.summary);
    }

    public void setSummaryNewPage(boolean isSummaryNewPage) {
        boolean oldValue = this.isSummaryNewPage;
        this.isSummaryNewPage = isSummaryNewPage;
        this.getPropertyChangeSupport().firePropertyChange(SUMMARY_NEW_PAGE_PROPERTY, oldValue, this.isSummaryNewPage);
    }

    public void setFloatColumnFooter(boolean isFloatColumnFooter) {
        boolean oldValue = this.isFloatColumnFooter;
        this.isFloatColumnFooter = isFloatColumnFooter;
        this.getPropertyChangeSupport().firePropertyChange(FLOAT_COLUMN_FOOTER_PROPERTY, oldValue, this.isFloatColumnFooter);
    }

    public void setPageHeader(JRBand pageHeader) {
        JRBand oldValue = this.pageHeader;
        this.pageHeader = pageHeader;
        this.getPropertyChangeSupport().firePropertyChange(PAGE_HEADER_PROPERTY, oldValue, this.pageHeader);
    }

    public void setPageFooter(JRBand pageFooter) {
        JRBand oldValue = this.pageFooter;
        this.pageFooter = pageFooter;
        this.getPropertyChangeSupport().firePropertyChange(PAGE_FOOTER_PROPERTY, oldValue, this.pageFooter);
    }

    public void setLastPageFooter(JRBand lastPageFooter) {
        JRBand oldValue = this.lastPageFooter;
        this.lastPageFooter = lastPageFooter;
        this.getPropertyChangeSupport().firePropertyChange(LAST_PAGE_FOOTER_PROPERTY, oldValue, this.lastPageFooter);
    }

    public void setColumnHeader(JRBand columnHeader) {
        JRBand oldValue = this.columnHeader;
        this.columnHeader = columnHeader;
        this.getPropertyChangeSupport().firePropertyChange(COLUMN_HEADER_PROPERTY, oldValue, this.columnHeader);
    }

    public void setColumnFooter(JRBand columnFooter) {
        JRBand oldValue = this.columnFooter;
        this.columnFooter = columnFooter;
        this.getPropertyChangeSupport().firePropertyChange(COLUMN_FOOTER_PROPERTY, oldValue, this.columnFooter);
    }

    public void setDetail(JRBand detail) {
        JRBand oldValue = this.detail;
        this.detail = detail;
        this.getPropertyChangeSupport().firePropertyChange(DETAIL_PROPERTY, oldValue, this.detail);
    }

    public void setScriptletClass(String scriptletClass) {
        String oldValue = this.mainDesignDataset.getScriptletClass();
        this.mainDesignDataset.setScriptletClass(scriptletClass);
        this.getPropertyChangeSupport().firePropertyChange(SCRIPTLET_CLASS_PROPERTY, oldValue, scriptletClass);
    }

    public void setResourceBundle(String resourceBundle) {
        String oldValue = this.mainDesignDataset.getResourceBundle();
        this.mainDesignDataset.setResourceBundle(resourceBundle);
        this.getPropertyChangeSupport().firePropertyChange(RESOURCE_BUNDLE_PROPERTY, oldValue, resourceBundle);
    }

    public void addImport(String value) {
        if (this.importsSet == null) {
            this.importsSet = new HashSet();
        }
        this.importsSet.add(value);
    }

    public void removeImport(String value) {
        if (this.importsSet != null) {
            this.importsSet.remove(value);
        }
    }

    public void setDefaultFont(JRReportFont font) {
        JRReportFont oldValue = this.defaultFont;
        this.defaultFont = font;
        this.getPropertyChangeSupport().firePropertyChange(DEFAULT_FONT_PROPERTY, oldValue, this.defaultFont);
    }

    public JRReportFont[] getFonts() {
        JRReportFont[] fontsArray = new JRReportFont[this.fontsList.size()];
        this.fontsList.toArray(fontsArray);
        return fontsArray;
    }

    public List getFontsList() {
        return this.fontsList;
    }

    public Map getFontsMap() {
        return this.fontsMap;
    }

    public void addFont(JRReportFont reportFont) throws JRException {
        if (this.fontsMap.containsKey(reportFont.getName())) {
            throw new JRException("Duplicate declaration of report font : " + reportFont.getName());
        }
        this.fontsList.add(reportFont);
        this.fontsMap.put(reportFont.getName(), reportFont);
        if (reportFont.isDefault()) {
            this.setDefaultFont(reportFont);
        }
    }

    public JRReportFont removeFont(String propName) {
        return this.removeFont((JRReportFont)this.fontsMap.get(propName));
    }

    public JRReportFont removeFont(JRReportFont reportFont) {
        if (reportFont != null) {
            if (reportFont.isDefault()) {
                this.setDefaultFont(null);
            }
            this.fontsList.remove(reportFont);
            this.fontsMap.remove(reportFont.getName());
        }
        return reportFont;
    }

    public void setDefaultStyle(JRStyle style) {
        JRStyle oldValue = this.defaultStyle;
        this.defaultStyle = style;
        this.getPropertyChangeSupport().firePropertyChange(DEFAULT_STYLE_PROPERTY, oldValue, this.defaultStyle);
    }

    public JRStyle[] getStyles() {
        JRStyle[] stylesArray = new JRStyle[this.stylesList.size()];
        this.stylesList.toArray(stylesArray);
        return stylesArray;
    }

    public List getStylesList() {
        return this.stylesList;
    }

    public Map getStylesMap() {
        return this.stylesMap;
    }

    public void addStyle(JRStyle style) throws JRException {
        if (this.stylesMap.containsKey(style.getName())) {
            throw new JRException("Duplicate declaration of report style : " + style.getName());
        }
        this.stylesList.add(style);
        this.stylesMap.put(style.getName(), style);
        if (style.isDefault()) {
            this.setDefaultStyle(style);
        }
    }

    public JRStyle removeStyle(String styleName) {
        return this.removeStyle((JRStyle)this.stylesMap.get(styleName));
    }

    public JRStyle removeStyle(JRStyle style) {
        if (style != null) {
            if (style.isDefault()) {
                this.setDefaultStyle(null);
            }
            this.stylesList.remove(style);
            this.stylesMap.remove(style.getName());
        }
        return style;
    }

    public List getParametersList() {
        return this.mainDesignDataset.getParametersList();
    }

    public Map getParametersMap() {
        return this.mainDesignDataset.getParametersMap();
    }

    public void addParameter(JRParameter parameter) throws JRException {
        this.mainDesignDataset.addParameter(parameter);
    }

    public JRParameter removeParameter(String parameterName) {
        return this.mainDesignDataset.removeParameter(parameterName);
    }

    public JRParameter removeParameter(JRParameter parameter) {
        return this.mainDesignDataset.removeParameter(parameter);
    }

    public void setQuery(JRQuery query) {
        JRQuery oldValue = this.mainDesignDataset.getQuery();
        this.mainDesignDataset.setQuery(query);
        this.getPropertyChangeSupport().firePropertyChange(QUERY_PROPERTY, oldValue, query);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.getPropertyChangeSupport().addPropertyChangeListener(l);
    }

    public void addPropertyChangeListener(String propName, PropertyChangeListener l) {
        this.getPropertyChangeSupport().addPropertyChangeListener(propName, l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.getPropertyChangeSupport().removePropertyChangeListener(l);
    }

    protected PropertyChangeSupport getPropertyChangeSupport() {
        if (this.propSupport == null) {
            this.propSupport = new PropertyChangeSupport(this);
        }
        return this.propSupport;
    }

    public List getFieldsList() {
        return this.mainDesignDataset.getFieldsList();
    }

    public Map getFieldsMap() {
        return this.mainDesignDataset.getFieldsMap();
    }

    public void addField(JRField field) throws JRException {
        this.mainDesignDataset.addField(field);
    }

    public JRField removeField(String fieldName) {
        return this.mainDesignDataset.removeField(fieldName);
    }

    public JRField removeField(JRField field) {
        return this.mainDesignDataset.removeField(field);
    }

    public List getVariablesList() {
        return this.mainDesignDataset.getVariablesList();
    }

    public Map getVariablesMap() {
        return this.mainDesignDataset.getVariablesMap();
    }

    public void addVariable(JRDesignVariable variable) throws JRException {
        this.mainDesignDataset.addVariable(variable);
    }

    public JRVariable removeVariable(String variableName) {
        return this.mainDesignDataset.removeVariable(variableName);
    }

    public JRVariable removeVariable(JRVariable variable) {
        return this.mainDesignDataset.removeVariable(variable);
    }

    public List getGroupsList() {
        return this.mainDesignDataset.getGroupsList();
    }

    public Map getGroupsMap() {
        return this.mainDesignDataset.getGroupsMap();
    }

    public void addGroup(JRDesignGroup group) throws JRException {
        this.mainDesignDataset.addGroup(group);
    }

    public JRGroup removeGroup(String groupName) {
        return this.mainDesignDataset.removeGroup(groupName);
    }

    public JRGroup removeGroup(JRGroup group) {
        return this.mainDesignDataset.removeGroup(group);
    }

    public Collection getExpressions() {
        JRExpressionCollector expressionCollector = new JRExpressionCollector();
        return expressionCollector.collect(this);
    }

    public JRDataset[] getDatasets() {
        JRDataset[] datasetArray = new JRDataset[this.datasetList.size()];
        this.datasetList.toArray(datasetArray);
        return datasetArray;
    }

    public List getDatasetsList() {
        return this.datasetList;
    }

    public Map getDatasetMap() {
        return this.datasetMap;
    }

    public void addDataset(JRDesignDataset dataset) throws JRException {
        if (this.datasetMap.containsKey(dataset.getName())) {
            throw new JRException("Duplicate declaration of dataset : " + dataset.getName());
        }
        this.datasetList.add(dataset);
        this.datasetMap.put(dataset.getName(), dataset);
    }

    public JRDataset removeDataset(String datasetName) {
        return this.removeDataset((JRDataset)this.datasetMap.get(datasetName));
    }

    public JRDataset removeDataset(JRDataset dataset) {
        if (dataset != null) {
            this.datasetList.remove(dataset);
            this.datasetMap.remove(dataset.getName());
        }
        return dataset;
    }

    public JRDesignDataset getMainDesignDataset() {
        return this.mainDesignDataset;
    }

    public void setMainDataset(JRDesignDataset dataset) {
        this.mainDesignDataset = dataset;
        this.mainDataset = this.mainDesignDataset;
        this.mainDesignDataset.setName(this.getName());
    }

    public void preprocess() {
        this.collectCrosstabs();
        Iterator it = this.crosstabs.iterator();
        while (it.hasNext()) {
            JRDesignCrosstab crosstab = (JRDesignCrosstab)it.next();
            crosstab.preprocess();
        }
    }

    protected List getCrosstabs() {
        if (this.crosstabs == null) {
            this.collectCrosstabs();
        }
        return this.crosstabs;
    }

    protected List collectCrosstabs() {
        this.crosstabs = new ArrayList();
        this.collectCrosstabs(this.background);
        this.collectCrosstabs(this.title);
        this.collectCrosstabs(this.pageHeader);
        this.collectCrosstabs(this.columnHeader);
        this.collectCrosstabs(this.detail);
        this.collectCrosstabs(this.columnFooter);
        this.collectCrosstabs(this.pageFooter);
        this.collectCrosstabs(this.lastPageFooter);
        this.collectCrosstabs(this.summary);
        JRGroup[] groups = this.getGroups();
        if (groups != null) {
            for (int i = 0; i < groups.length; ++i) {
                this.collectCrosstabs(groups[i].getGroupHeader());
                this.collectCrosstabs(groups[i].getGroupFooter());
            }
        }
        return this.crosstabs;
    }

    protected void collectCrosstabs(JRBand band) {
        JRElement[] elements;
        if (band != null && (elements = band.getElements()) != null) {
            for (int i = 0; i < elements.length; ++i) {
                if (!(elements[i] instanceof JRCrosstab)) continue;
                this.crosstabs.add(elements[i]);
            }
        }
    }
}

