/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.JRGridLayout;
import net.sf.jasperreports.engine.export.JRXlsAbstractExporter;
import net.sf.jasperreports.engine.util.JRStringUtil;
import net.sf.jasperreports.engine.util.JRStyledText;
import org.apache.commons.collections.ReferenceMap;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.hssf.util.Region;

public class JRXlsExporter
extends JRXlsAbstractExporter {
    private static Map hssfColorsCache = new ReferenceMap();
    protected List loadedCellStyles = new ArrayList();
    protected HSSFWorkbook workbook = null;
    protected HSSFSheet sheet = null;
    protected HSSFRow row = null;
    protected HSSFCell cell = null;
    protected HSSFCellStyle emptyCellStyle = null;
    protected short whiteIndex = new HSSFColor.WHITE().getIndex();
    protected short blackIndex = new HSSFColor.BLACK().getIndex();
    protected short backgroundMode = 1;

    protected void setBackground() {
        if (!this.isWhitePageBackground) {
            this.backgroundMode = 0;
        }
    }

    protected void openWorkbook(OutputStream os) {
        this.workbook = new HSSFWorkbook();
        this.emptyCellStyle = this.workbook.createCellStyle();
        this.emptyCellStyle.setFillForegroundColor(new HSSFColor.WHITE().getIndex());
        this.emptyCellStyle.setFillPattern(this.backgroundMode);
    }

    protected void createSheet(String name) {
        this.sheet = this.workbook.createSheet(name);
    }

    protected void closeWorkbook(OutputStream os) throws JRException {
        try {
            this.workbook.write(os);
        }
        catch (IOException e) {
            throw new JRException("Error generating XLS report : " + this.jasperPrint.getName(), e);
        }
    }

    protected void setColumnWidth(short index, short width) {
        this.sheet.setColumnWidth(index, width);
    }

    protected void setRowHeight(int rowIndex, int lastRowHeight) {
        this.row = this.sheet.getRow((int)((short)rowIndex));
        if (this.row == null) {
            this.row = this.sheet.createRow((int)((short)rowIndex));
        }
        this.row.setHeightInPoints((float)((short)lastRowHeight));
    }

    protected void setCell(int colIndex, int rowIndex) {
        HSSFCell emptyCell = this.row.getCell((short)colIndex);
        if (emptyCell == null) {
            emptyCell = this.row.createCell((short)colIndex);
            emptyCell.setCellStyle(this.emptyCellStyle);
        }
    }

    protected void addBlankCell(JRExporterGridCell gridCell, int colIndex, int rowIndex) {
        this.cell = this.row.createCell((short)colIndex);
        short mode = this.backgroundMode;
        short backcolor = this.whiteIndex;
        if (gridCell.getBackcolor() != null) {
            mode = 1;
            backcolor = JRXlsExporter.getNearestColor(gridCell.getBackcolor()).getIndex();
        }
        short forecolor = this.blackIndex;
        if (gridCell.getForecolor() != null) {
            forecolor = JRXlsExporter.getNearestColor(gridCell.getForecolor()).getIndex();
        }
        HSSFCellStyle cellStyle = this.getLoadedCellStyle(mode, backcolor, (short)1, (short)0, (short)0, this.getLoadedFont(this.getDefaultFont(), forecolor), gridCell);
        this.cell.setCellStyle(cellStyle);
    }

    protected void exportLine(JRPrintLine line, JRExporterGridCell gridCell, int colIndex, int rowIndex) {
        short forecolor = JRXlsExporter.getNearestColor(line.getForecolor()).getIndex();
        HSSFFont cellFont = this.getLoadedFont(this.getDefaultFont(), forecolor);
        HSSFCellStyle cellStyle = this.getLoadedCellStyle((short)1, forecolor, (short)1, (short)0, (short)0, cellFont, gridCell);
        this.createMergeRegion(gridCell, colIndex, rowIndex, cellStyle);
        this.cell = this.row.createCell((short)colIndex);
        this.cell.setEncoding((short)1);
        this.cell.setCellValue("");
        this.cell.setCellStyle(cellStyle);
    }

    protected void exportRectangle(JRPrintElement element, JRExporterGridCell gridCell, int colIndex, int rowIndex) {
        short forecolor = JRXlsExporter.getNearestColor(element.getForecolor()).getIndex();
        short mode = this.backgroundMode;
        short backcolor = this.whiteIndex;
        if (element.getMode() == 1) {
            mode = 1;
            backcolor = JRXlsExporter.getNearestColor(element.getBackcolor()).getIndex();
        } else if (gridCell.getBackcolor() != null) {
            mode = 1;
            backcolor = JRXlsExporter.getNearestColor(gridCell.getBackcolor()).getIndex();
        }
        HSSFFont cellFont = this.getLoadedFont(this.getDefaultFont(), forecolor);
        HSSFCellStyle cellStyle = this.getLoadedCellStyle(mode, backcolor, (short)1, (short)0, (short)0, cellFont, gridCell);
        this.createMergeRegion(gridCell, colIndex, rowIndex, cellStyle);
        this.cell = this.row.createCell((short)colIndex);
        this.cell.setEncoding((short)1);
        this.cell.setCellValue("");
        this.cell.setCellStyle(cellStyle);
    }

    protected void exportText(JRPrintText textElement, JRExporterGridCell gridCell, int colIndex, int rowIndex) {
        JRStyledText styledText = this.getStyledText(textElement);
        if (styledText == null) {
            return;
        }
        short forecolor = JRXlsExporter.getNearestColor(textElement.getForecolor()).getIndex();
        HSSFFont cellFont = this.getLoadedFont(textElement, forecolor);
        JRXlsAbstractExporter.TextAlignHolder textAlignHolder = JRXlsExporter.getTextAlignHolder(textElement);
        short horizontalAlignment = this.getHorizontalAlignment(textAlignHolder);
        short verticalAlignment = this.getVerticalAlignment(textAlignHolder);
        short rotation = this.getRotation(textAlignHolder);
        short mode = this.backgroundMode;
        short backcolor = this.whiteIndex;
        if (textElement.getMode() == 1) {
            mode = 1;
            backcolor = JRXlsExporter.getNearestColor(textElement.getBackcolor()).getIndex();
        } else if (gridCell.getBackcolor() != null) {
            mode = 1;
            backcolor = JRXlsExporter.getNearestColor(gridCell.getBackcolor()).getIndex();
        }
        HSSFCellStyle cellStyle = this.getLoadedCellStyle(mode, backcolor, horizontalAlignment, verticalAlignment, rotation, cellFont, gridCell);
        this.createMergeRegion(gridCell, colIndex, rowIndex, cellStyle);
        this.cell = this.row.createCell((short)colIndex);
        this.cell.setEncoding((short)1);
        if (this.isAutoDetectCellType) {
            try {
                this.cell.setCellValue(Double.parseDouble(styledText.getText()));
            }
            catch (NumberFormatException e) {
                this.cell.setCellValue(JRStringUtil.replaceDosEOL(styledText.getText()));
            }
        } else {
            this.cell.setCellValue(JRStringUtil.replaceDosEOL(styledText.getText()));
        }
        this.cell.setCellStyle(cellStyle);
    }

    protected void createMergeRegion(JRExporterGridCell gridCell, int colIndex, int rowIndex, HSSFCellStyle cellStyle) {
        if (gridCell.colSpan > 1 || gridCell.rowSpan > 1) {
            this.sheet.addMergedRegion(new Region(rowIndex, (short)colIndex, rowIndex + gridCell.rowSpan - 1, (short)(colIndex + gridCell.colSpan - 1)));
            for (int i = 0; i < gridCell.rowSpan; ++i) {
                HSSFRow spanRow = this.sheet.getRow(rowIndex + i);
                if (spanRow == null) {
                    spanRow = this.sheet.createRow(rowIndex + i);
                }
                for (int j = 0; j < gridCell.colSpan; ++j) {
                    HSSFCell spanCell = spanRow.getCell((short)(colIndex + j));
                    if (spanCell == null) {
                        spanCell = spanRow.createCell((short)(colIndex + j));
                    }
                    spanCell.setCellStyle(cellStyle);
                }
            }
        }
    }

    private short getHorizontalAlignment(JRXlsAbstractExporter.TextAlignHolder alignment) {
        switch (alignment.horizontalAlignment) {
            case 3: {
                return 3;
            }
            case 2: {
                return 2;
            }
            case 4: {
                return 5;
            }
        }
        return 1;
    }

    private short getVerticalAlignment(JRXlsAbstractExporter.TextAlignHolder alignment) {
        switch (alignment.verticalAlignment) {
            case 3: {
                return 2;
            }
            case 2: {
                return 1;
            }
            case 4: {
                return 3;
            }
        }
        return 0;
    }

    private short getRotation(JRXlsAbstractExporter.TextAlignHolder alignment) {
        switch (alignment.rotation) {
            case 1: {
                return 90;
            }
            case 2: {
                return -90;
            }
        }
        return 0;
    }

    protected static HSSFColor getNearestColor(Color awtColor) {
        HSSFColor color = (HSSFColor)hssfColorsCache.get(awtColor);
        if (color == null) {
            Set keys;
            Hashtable triplets = HSSFColor.getTripletHash();
            if (triplets != null && (keys = triplets.keySet()) != null && keys.size() > 0) {
                Object key = null;
                HSSFColor crtColor = null;
                short[] rgb = null;
                int diff = 0;
                int minDiff = 999;
                Iterator it = keys.iterator();
                while (it.hasNext()) {
                    key = it.next();
                    crtColor = (HSSFColor)triplets.get(key);
                    rgb = crtColor.getTriplet();
                    diff = Math.abs(rgb[0] - awtColor.getRed()) + Math.abs(rgb[1] - awtColor.getGreen()) + Math.abs(rgb[2] - awtColor.getBlue());
                    if (diff >= minDiff) continue;
                    minDiff = diff;
                    color = crtColor;
                }
            }
            hssfColorsCache.put(awtColor, color);
        }
        return color;
    }

    protected HSSFFont getLoadedFont(JRFont font, short forecolor) {
        HSSFFont cellFont = null;
        String fontName = font.getFontName();
        if (this.fontMap != null && this.fontMap.containsKey(fontName)) {
            fontName = (String)this.fontMap.get(fontName);
        }
        for (int i = 0; i < this.loadedFonts.size(); ++i) {
            HSSFFont cf = (HSSFFont)this.loadedFonts.get(i);
            if (!cf.getFontName().equals(fontName) || cf.getColor() != forecolor || cf.getFontHeightInPoints() != (short)font.getFontSize() || !(cf.getUnderline() == 1 ? font.isUnderline() : !font.isUnderline()) || cf.getStrikeout() != font.isStrikeThrough() || !(cf.getBoldweight() == 700 ? font.isBold() : !font.isBold()) || cf.getItalic() != font.isItalic()) continue;
            cellFont = cf;
            break;
        }
        if (cellFont == null) {
            cellFont = this.workbook.createFont();
            cellFont.setFontName(fontName);
            cellFont.setColor(forecolor);
            cellFont.setFontHeightInPoints((short)font.getFontSize());
            if (font.isUnderline()) {
                cellFont.setUnderline((byte)1);
            }
            if (font.isStrikeThrough()) {
                cellFont.setStrikeout(true);
            }
            if (font.isBold()) {
                cellFont.setBoldweight((short)700);
            }
            if (font.isItalic()) {
                cellFont.setItalic(true);
            }
            this.loadedFonts.add(cellFont);
        }
        return cellFont;
    }

    protected HSSFCellStyle getLoadedCellStyle(short mode, short backcolor, short horizontalAlignment, short verticalAlignment, short rotation, HSSFFont font, short topBorder, short topBorderColor, short leftBorder, short leftBorderColor, short bottomBorder, short bottomBorderColor, short rightBorder, short rightBorderColor) {
        HSSFCellStyle cellStyle = null;
        if (this.loadedCellStyles != null && this.loadedCellStyles.size() > 0) {
            HSSFCellStyle cs = null;
            for (int i = 0; i < this.loadedCellStyles.size(); ++i) {
                cs = (HSSFCellStyle)this.loadedCellStyles.get(i);
                if (cs.getFillPattern() != mode || cs.getFillForegroundColor() != backcolor || cs.getAlignment() != horizontalAlignment || cs.getVerticalAlignment() != verticalAlignment || cs.getRotation() != rotation || cs.getFontIndex() != font.getIndex() || cs.getBorderTop() != topBorder || cs.getTopBorderColor() != topBorderColor || cs.getBorderLeft() != leftBorder || cs.getLeftBorderColor() != leftBorderColor || cs.getBorderBottom() != bottomBorder || cs.getBottomBorderColor() != bottomBorderColor || cs.getBorderRight() != rightBorder || cs.getRightBorderColor() != rightBorderColor) continue;
                cellStyle = cs;
                break;
            }
        }
        if (cellStyle == null) {
            cellStyle = this.workbook.createCellStyle();
            cellStyle.setFillForegroundColor(backcolor);
            cellStyle.setFillPattern(mode);
            cellStyle.setAlignment(horizontalAlignment);
            cellStyle.setVerticalAlignment(verticalAlignment);
            cellStyle.setRotation(rotation);
            cellStyle.setFont(font);
            cellStyle.setWrapText(true);
            cellStyle.setBorderTop(topBorder);
            cellStyle.setTopBorderColor(topBorderColor);
            cellStyle.setBorderLeft(leftBorder);
            cellStyle.setLeftBorderColor(leftBorderColor);
            cellStyle.setBorderBottom(bottomBorder);
            cellStyle.setBottomBorderColor(bottomBorderColor);
            cellStyle.setBorderRight(rightBorder);
            cellStyle.setRightBorderColor(rightBorderColor);
            this.loadedCellStyles.add(cellStyle);
        }
        return cellStyle;
    }

    protected HSSFCellStyle getLoadedCellStyle(short mode, short backcolor, short horizontalAlignment, short verticalAlignment, short rotation, HSSFFont font, JRExporterGridCell gridCell) {
        short topBorder = 0;
        short topBorderColor = backcolor;
        short leftBorder = 0;
        short leftBorderColor = backcolor;
        short bottomBorder = 0;
        short bottomBorderColor = backcolor;
        short rightBorder = 0;
        short rightBorderColor = backcolor;
        JRBox gridBox = gridCell.getBox();
        if (gridBox != null) {
            short gridForecolor = gridCell.getForecolor() == null ? this.blackIndex : JRXlsExporter.getNearestColor(gridCell.getForecolor()).getIndex();
            topBorder = JRXlsExporter.getBorder(gridBox.getTopBorder());
            topBorderColor = gridBox.getTopBorderColor() == null ? gridForecolor : JRXlsExporter.getNearestColor(gridBox.getTopBorderColor()).getIndex();
            leftBorder = JRXlsExporter.getBorder(gridBox.getLeftBorder());
            leftBorderColor = gridBox.getLeftBorderColor() == null ? gridForecolor : JRXlsExporter.getNearestColor(gridBox.getLeftBorderColor()).getIndex();
            bottomBorder = JRXlsExporter.getBorder(gridBox.getBottomBorder());
            bottomBorderColor = gridBox.getBottomBorderColor() == null ? gridForecolor : JRXlsExporter.getNearestColor(gridBox.getBottomBorderColor()).getIndex();
            rightBorder = JRXlsExporter.getBorder(gridBox.getRightBorder());
            rightBorderColor = gridBox.getRightBorderColor() == null ? gridForecolor : JRXlsExporter.getNearestColor(gridBox.getRightBorderColor()).getIndex();
        }
        return this.getLoadedCellStyle(mode, backcolor, horizontalAlignment, verticalAlignment, rotation, font, topBorder, topBorderColor, leftBorder, leftBorderColor, bottomBorder, bottomBorderColor, rightBorder, rightBorderColor);
    }

    private static short getBorder(byte pen) {
        short border = 0;
        switch (pen) {
            case 4: {
                border = 3;
                break;
            }
            case 3: {
                border = 5;
                break;
            }
            case 2: {
                border = 5;
                break;
            }
            case 5: {
                border = 1;
                break;
            }
            case 0: {
                border = 0;
                break;
            }
            default: {
                border = 2;
            }
        }
        return border;
    }

    protected void exportImage(JRPrintImage image, JRExporterGridCell gridCell, int colIndex, int rowIndex) {
    }

    protected JRGridLayout.ExporterElements getExporterElements() {
        return JRGridLayout.NO_IMAGES_EXPORTER;
    }

    protected void exportFrame(JRPrintFrame frame, JRExporterGridCell gridCell, int x, int y) throws JRException {
        short mode = this.backgroundMode;
        short backcolor = this.whiteIndex;
        if (frame.getMode() == 1) {
            mode = 1;
            backcolor = JRXlsExporter.getNearestColor(frame.getBackcolor()).getIndex();
        }
        short forecolor = JRXlsExporter.getNearestColor(frame.getForecolor()).getIndex();
        HSSFCellStyle cellStyle = this.getLoadedCellStyle(mode, backcolor, (short)1, (short)0, (short)0, this.getLoadedFont(this.getDefaultFont(), forecolor), gridCell);
        this.createMergeRegion(gridCell, x, y, cellStyle);
        this.cell = this.row.createCell((short)x);
        this.cell.setCellStyle(cellStyle);
    }
}

