/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.math.BigDecimal;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.fill.AbstractValueProvider;
import net.sf.jasperreports.engine.fill.JRAbstractExtendedIncrementer;
import net.sf.jasperreports.engine.fill.JRBigDecimalIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRCalculable;

class JRBigDecimalCountIncrementer
extends JRAbstractExtendedIncrementer {
    private static JRBigDecimalCountIncrementer mainInstance = new JRBigDecimalCountIncrementer();

    private JRBigDecimalCountIncrementer() {
    }

    public static JRBigDecimalCountIncrementer getInstance() {
        return mainInstance;
    }

    public Object increment(JRCalculable variable, Object expressionValue, AbstractValueProvider valueProvider) {
        BigDecimal value = (BigDecimal)variable.getIncrementedValue();
        if (expressionValue == null) {
            if (variable.isInitialized()) {
                return JRBigDecimalIncrementerFactory.ZERO;
            }
            return value;
        }
        if (value == null || variable.isInitialized()) {
            value = JRBigDecimalIncrementerFactory.ZERO;
        }
        return value.add(JRBigDecimalIncrementerFactory.ONE);
    }

    public Object combine(JRCalculable calculable, JRCalculable calculableValue, AbstractValueProvider valueProvider) throws JRException {
        BigDecimal value = (BigDecimal)calculable.getIncrementedValue();
        BigDecimal combineValue = (BigDecimal)calculableValue.getValue();
        if (combineValue == null) {
            if (calculable.isInitialized()) {
                return JRBigDecimalIncrementerFactory.ZERO;
            }
            return value;
        }
        if (value == null || calculable.isInitialized()) {
            value = JRBigDecimalIncrementerFactory.ZERO;
        }
        return value.add(combineValue);
    }

    public Object initialValue() {
        return JRBigDecimalIncrementerFactory.ZERO;
    }
}

