/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.awt.Color;
import java.util.Map;
import net.sf.jasperreports.crosstabs.JRCellContents;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRFrame;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.base.JRBaseBox;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFillCrosstab;
import net.sf.jasperreports.engine.fill.JRFillElement;
import net.sf.jasperreports.engine.fill.JRFillElementContainer;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRTemplateFrame;
import net.sf.jasperreports.engine.fill.JRTemplatePrintFrame;
import org.apache.commons.collections.ReferenceMap;

public class JRFillCellContents
extends JRFillElementContainer
implements JRCellContents,
Cloneable {
    protected static final Map transformedContentsCache = new ReferenceMap();
    protected static final Map boxContentsCache = new ReferenceMap();
    private final JRFillCrosstab crosstab;
    private final JRCellContents parentCell;
    private JRBox box;
    private int height;
    private int width;
    private int span;
    private JRTemplateFrame template;

    public JRFillCellContents(JRBaseFiller filler, JRCellContents cell, JRFillObjectFactory factory) {
        super(filler, cell, factory);
        this.crosstab = factory.getCrosstab();
        this.parentCell = cell;
        this.box = cell.getBox();
        this.width = cell.getWidth();
        this.height = cell.getHeight();
        this.initElements();
        this.createTemplate();
    }

    protected void createTemplate() {
        this.template = new JRTemplateFrame(this.crosstab, this);
    }

    public Color getBackcolor() {
        return this.parentCell.getBackcolor();
    }

    public JRBox getBox() {
        return this.box;
    }

    protected void setBox(JRBox box) {
        this.box = box;
        this.createTemplate();
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    protected void setHeight(int height) {
        this.height = height;
    }

    protected void setWidth(int width) {
        this.width = width;
    }

    public void setSpan(int span) {
        this.span = span;
    }

    public int getSpan() {
        return this.span;
    }

    public static JRFillCellContents getBoxContents(JRFillCellContents contents, boolean left, boolean top) {
        boolean copyTop;
        JRBox box = contents.getBox();
        if (box == null) {
            return contents;
        }
        boolean copyLeft = left && box.getLeftBorder() == 0 && box.getRightBorder() != 0;
        boolean bl = copyTop = top && box.getTopBorder() == 0 && box.getBottomBorder() != 0;
        if (!copyLeft && !copyTop) {
            return contents;
        }
        BoxContents key = new BoxContents(contents, copyLeft, copyTop);
        JRFillCellContents boxContents = (JRFillCellContents)boxContentsCache.get(key);
        if (boxContents == null) {
            try {
                boxContents = (JRFillCellContents)contents.clone();
                JRBaseBox newBox = new JRBaseBox(box);
                if (copyLeft) {
                    newBox.setLeftBorder(box.getRightBorder());
                    newBox.setLeftBorderColor(box.getRightBorderColor());
                }
                if (copyTop) {
                    newBox.setTopBorder(box.getBottomBorder());
                    newBox.setTopBorderColor(box.getBottomBorderColor());
                }
                boxContents.setBox(newBox);
                boxContentsCache.put(key, boxContents);
            }
            catch (CloneNotSupportedException e) {
                throw new JRRuntimeException(e);
            }
        }
        return boxContents;
    }

    public static JRFillCellContents getTransformedContents(JRBaseFiller filler, JRFillCrosstab crosstab, JRFillCellContents contents, int newWidth, int newHeight, byte xPosition, byte yPosition) throws JRException {
        if (contents.getHeight() == newHeight && contents.getWidth() == newWidth) {
            return contents;
        }
        if (newHeight < contents.getHeight() || newWidth < contents.getWidth()) {
            throw new JRException("Cannot shrink cell contents.");
        }
        StretchedContents key = new StretchedContents(contents, newWidth, newHeight, xPosition, yPosition);
        JRFillCellContents transformedCell = (JRFillCellContents)transformedContentsCache.get(key);
        if (transformedCell == null) {
            JRFillObjectFactory factory = new JRFillObjectFactory(filler, crosstab);
            transformedCell = factory.getCell(contents.parentCell);
            filler.setTextFieldsFormats();
            transformedCell.setWidth(contents.getWidth());
            transformedCell.setHeight(contents.getHeight());
            transformedCell.transform(newWidth, newHeight, xPosition, yPosition);
            transformedCell.setElementsBandBottomY();
            transformedContentsCache.put(key, transformedCell);
        }
        return transformedCell;
    }

    private void transform(int newWidth, int newHeight, byte xPosition, byte yPosition) {
        this.transformElements(newWidth, newHeight, xPosition, yPosition);
        this.width = newWidth;
        this.height = newHeight;
    }

    private void transformElements(int newWidth, int newHeight, byte xPosition, byte yPosition) {
        if (!(this.height != newHeight && yPosition != 1 || this.width != newWidth && xPosition != 1)) {
            return;
        }
        double scaleX = -1.0;
        int offsetX = 0;
        switch (xPosition) {
            case 2: {
                offsetX = (newWidth - this.width) / 2;
                break;
            }
            case 3: {
                offsetX = newWidth - this.width;
                break;
            }
            case 4: {
                scaleX = (double)newWidth / (double)this.width;
            }
        }
        double scaleY = -1.0;
        int offsetY = 0;
        switch (yPosition) {
            case 2: {
                offsetY = (newHeight - this.height) / 2;
                break;
            }
            case 3: {
                offsetY = newHeight - this.height;
                break;
            }
            case 4: {
                scaleY = (double)newHeight / (double)this.height;
            }
        }
        JRFillCellContents.transformElements(this.getElements(), scaleX, offsetX, scaleY, offsetY);
    }

    private static void transformElements(JRElement[] elements, double scaleX, int offsetX, double scaleY, int offsetY) {
        if (elements != null) {
            for (int i = 0; i < elements.length; ++i) {
                JRFillElement element = (JRFillElement)elements[i];
                if (scaleX != -1.0) {
                    element.setX((int)((double)element.getX() * scaleX));
                    element.setWidth((int)((double)element.getWidth() * scaleX));
                }
                if (offsetX != 0) {
                    element.setX(element.getX() + offsetX);
                }
                if (scaleY != -1.0) {
                    element.setY((int)((double)element.getY() * scaleY));
                    element.setHeight((int)((double)element.getHeight() * scaleY));
                }
                if (offsetY != 0) {
                    element.setY(element.getY() + offsetY);
                }
                if (!(element instanceof JRFrame)) continue;
                JRElement[] frameElements = ((JRFrame)((Object)element)).getElements();
                JRFillCellContents.transformElements(frameElements, scaleX, offsetX, scaleY, offsetY);
            }
        }
    }

    protected JRPrintFrame fill(int availableStretchHeight, int x, int y) throws JRException {
        this.initFill();
        this.resetElements();
        this.prepareElements(availableStretchHeight, false);
        this.stretchElements();
        this.moveBandBottomElements();
        this.removeBlankElements();
        JRTemplatePrintFrame printCell = new JRTemplatePrintFrame(this.template);
        printCell.setX(x);
        printCell.setY(y);
        printCell.setWidth(this.width);
        this.fillElements(printCell);
        printCell.setHeight(this.height);
        return printCell;
    }

    protected int getContainerHeight() {
        int topPadding = 0;
        int bottomPadding = 0;
        if (this.box != null) {
            topPadding = this.box.getTopPadding();
            bottomPadding = this.box.getBottomPadding();
        }
        return this.getHeight() - topPadding - bottomPadding;
    }

    protected static class StretchedContents {
        final JRFillCellContents contents;
        final int newHeight;
        final int newWidth;
        final int hashCode;
        final byte xPosition;
        final byte yPosition;

        StretchedContents(JRFillCellContents contents, int newWidth, int newHeight, byte xPosition, byte yPosition) {
            this.contents = contents;
            this.newHeight = newHeight;
            this.newWidth = newWidth;
            this.xPosition = xPosition;
            this.yPosition = yPosition;
            int hash = contents.hashCode();
            hash = 31 * hash + newHeight;
            hash = 31 * hash + newWidth;
            hash = 31 * hash + xPosition;
            this.hashCode = hash = 31 * hash + yPosition;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            StretchedContents s = (StretchedContents)o;
            return s.contents.equals(this.contents) && s.newHeight == this.newHeight && s.newWidth == this.newWidth && s.xPosition == this.xPosition && s.yPosition == this.yPosition;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    protected static class BoxContents {
        final JRFillCellContents contents;
        final boolean left;
        final boolean top;
        final int hashCode;

        public BoxContents(JRFillCellContents contents, boolean left, boolean top) {
            this.contents = contents;
            this.left = left;
            this.top = top;
            int hash = contents.hashCode();
            hash = 31 * hash + (left ? 1231 : 1237);
            this.hashCode = hash = 31 * hash + (top ? 1231 : 1237);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            BoxContents b = (BoxContents)obj;
            return b.contents.equals(this.contents) && b.left == this.left && b.top == this.top;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

