/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.fill.AbstractValueProvider;
import net.sf.jasperreports.engine.fill.JRAbstractExtendedIncrementer;
import net.sf.jasperreports.engine.fill.JRCalculable;
import net.sf.jasperreports.engine.fill.JRFloatIncrementerFactory;

class JRFloatCountIncrementer
extends JRAbstractExtendedIncrementer {
    private static JRFloatCountIncrementer mainInstance = new JRFloatCountIncrementer();

    private JRFloatCountIncrementer() {
    }

    public static JRFloatCountIncrementer getInstance() {
        return mainInstance;
    }

    public Object increment(JRCalculable variable, Object expressionValue, AbstractValueProvider valueProvider) {
        Number value = (Number)variable.getIncrementedValue();
        if (expressionValue == null) {
            if (variable.isInitialized()) {
                return JRFloatIncrementerFactory.ZERO;
            }
            return value;
        }
        if (value == null || variable.isInitialized()) {
            value = JRFloatIncrementerFactory.ZERO;
        }
        return new Float(value.floatValue() + 1.0f);
    }

    public Object combine(JRCalculable calculable, JRCalculable calculableValue, AbstractValueProvider valueProvider) throws JRException {
        Number value = (Number)calculable.getIncrementedValue();
        Number combineValue = (Number)calculableValue.getValue();
        if (combineValue == null) {
            if (calculable.isInitialized()) {
                return JRFloatIncrementerFactory.ZERO;
            }
            return value;
        }
        if (value == null || calculable.isInitialized()) {
            value = JRFloatIncrementerFactory.ZERO;
        }
        return new Float(value.floatValue() + combineValue.floatValue());
    }

    public Object initialValue() {
        return JRFloatIncrementerFactory.ZERO;
    }
}

