/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui;

import bsh.EvalError;
import bsh.Interpreter;
import it.businesslogic.ireport.IReportConnection;
import it.businesslogic.ireport.JRField;
import it.businesslogic.ireport.JRParameter;
import it.businesslogic.ireport.ReportClassLoader;
import it.businesslogic.ireport.connection.JRDataSourceProviderConnection;
import it.businesslogic.ireport.gui.JBTreeCellRenderer;
import it.businesslogic.ireport.gui.JRSQLExpressionArea;
import it.businesslogic.ireport.gui.JReportFrame;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.TreeJRField;
import it.businesslogic.ireport.util.Misc;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.BevelBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.apache.commons.beanutils.PropertyUtils;

public class ReportQueryDialog
extends JDialog
implements ClipboardOwner {
    protected static String[] standard_types = new String[]{"java.lang.String", "java.lang.Object", "java.lang.Boolean", "java.lang.Byte", "java.util.Date", "java.sql.Timestamp", "java.sql.Time", "java.lang.Double", "java.lang.Float", "java.lang.Integer", "java.io.InputStream", "java.lang.Long", "java.lang.Short", "java.math.BigDecimal"};
    public FieldReader readerThread = null;
    public static int num = 1;
    Timer stoppedChanging = new Timer(500, new ActionListener(){

        public void actionPerformed(ActionEvent evt) {
            if (ReportQueryDialog.this.automaticlyReadFieldsCheckBox.isSelected()) {
                ReportQueryDialog.this.processQueryChanged(ReportQueryDialog.this.jRSQLExpressionArea1.getText().trim());
            }
        }
    });
    Map parameterNameToExpressionID = null;
    private JCheckBox automaticlyReadFieldsCheckBox;
    private JButton cancelButton;
    private JLabel columnsErrorMsgLabel;
    private JScrollPane columnsErrorScrollPane;
    private JScrollPane columnsScrollPane;
    private JButton exportQueryButton;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButtonReadBeanAttributes;
    private JButton jButtonReadBeanAttributes3;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabelStatusSQL;
    private JPanel jPanel1;
    private JPanel jPanel10;
    private JPanel jPanel11;
    private JPanel jPanel12;
    private JPanel jPanel13;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private JPanel jPanelSQL;
    private JRSQLExpressionArea jRSQLExpressionArea1;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSplitPane jSplitPane1;
    private JTabbedPane jTabbedPane1;
    private JTable jTableFields;
    private JTextField jTextFieldBeanClass;
    private JTextField jTextFieldBeanClass1;
    private JTree jTree1;
    private JButton okButton;
    private JButton readFieldsButton;
    private JReportFrame jReportFrame;
    private boolean isSettingSQLExpression = false;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$math$BigDecimal;

    private JLabel getJLabelStatusSQL() {
        return this.jLabelStatusSQL;
    }

    public ReportQueryDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setSize(520, 500);
        Misc.centerFrame(this);
        this.stoppedChanging.setRepeats(false);
        DefaultTreeModel dttm = (DefaultTreeModel)this.jTree1.getModel();
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        this.jTree1.setModel(new DefaultTreeModel(root));
        this.jTree1.setCellRenderer(new JBTreeCellRenderer());
        this.jRSQLExpressionArea1.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                if (ReportQueryDialog.this.isSettingSQLExpression) {
                    return;
                }
                ReportQueryDialog.this.stoppedChanging.restart();
            }

            public void insertUpdate(DocumentEvent e) {
                if (ReportQueryDialog.this.isSettingSQLExpression) {
                    return;
                }
                ReportQueryDialog.this.stoppedChanging.restart();
            }

            public void removeUpdate(DocumentEvent e) {
                if (ReportQueryDialog.this.isSettingSQLExpression) {
                    return;
                }
                ReportQueryDialog.this.stoppedChanging.restart();
            }
        });
        this.setColumnsError("Please open a report.");
        if (MainFrame.getMainInstance().getProperties().getProperty("beanClass") != null) {
            this.jTextFieldBeanClass1.setText(MainFrame.getMainInstance().getProperties().getProperty("beanClass") + "");
        }
        this.okButton.setEnabled(false);
    }

    private void processQueryChanged(String query) {
        if (this.jReportFrame == null) {
            this.setColumnsError("Please open a report.");
            return;
        }
        if (query.length() == 0) {
            this.setColumnsError("You must insert a valid query first");
            return;
        }
        IReportConnection conn = (IReportConnection)this.getJReportFrame().getMainFrame().getProperties().get("DefaultConnection");
        if (conn == null || !conn.isJDBCConnection()) {
            this.setColumnsError("The active connection is not of type JDBC. Activate a JDBC connection first.");
            return;
        }
        try {
            if (this.readerThread != null && this.readerThread.isAlive()) {
                this.readerThread.interrupt();
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        this.readerThread = new FieldReader(query, conn);
        this.readerThread.start();
    }

    private void setColumns(List cols) {
        this.columnsErrorMsgLabel.setText("");
        this.jPanel2.remove(this.columnsErrorScrollPane);
        this.jPanel2.add((Component)this.columnsScrollPane, "Center");
        this.jPanel2.revalidate();
        DefaultTableModel dtm = (DefaultTableModel)this.jTableFields.getModel();
        dtm.getDataVector().clear();
        for (int i = 0; i < cols.size(); ++i) {
            Object[] row = (Object[])cols.get(i);
            dtm.addRow(row);
        }
        this.jTableFields.selectAll();
        this.okButton.setEnabled(true);
    }

    private void setColumnsError(String msg) {
        this.columnsErrorMsgLabel.setText(msg);
        this.jPanel2.remove(this.columnsScrollPane);
        this.jPanel2.add((Component)this.columnsErrorScrollPane, "Center");
        this.jPanel2.revalidate();
        this.columnsErrorMsgLabel.repaint();
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanelSQL = new JPanel();
        this.jRSQLExpressionArea1 = new JRSQLExpressionArea();
        this.jPanel7 = new JPanel();
        this.automaticlyReadFieldsCheckBox = new JCheckBox();
        this.readFieldsButton = new JButton();
        this.exportQueryButton = new JButton();
        this.jLabelStatusSQL = new JLabel();
        this.jPanel5 = new JPanel();
        this.jTextFieldBeanClass = new JTextField();
        this.jLabel2 = new JLabel();
        this.jButtonReadBeanAttributes = new JButton();
        this.jPanel10 = new JPanel();
        this.jPanel8 = new JPanel();
        this.jTextFieldBeanClass1 = new JTextField();
        this.jLabel3 = new JLabel();
        this.jButtonReadBeanAttributes3 = new JButton();
        this.jPanel11 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTree1 = new JTree();
        this.jPanel12 = new JPanel();
        this.jButton1 = new JButton();
        this.jPanel13 = new JPanel();
        this.jSeparator1 = new JSeparator();
        this.jPanel6 = new JPanel();
        this.jButton2 = new JButton();
        this.jPanel2 = new JPanel();
        this.columnsScrollPane = new JScrollPane();
        this.jTableFields = new JTable();
        this.jPanel3 = new JPanel();
        this.jPanel4 = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.jPanel9 = new JPanel();
        this.columnsErrorScrollPane = new JScrollPane();
        this.columnsErrorMsgLabel = new JLabel();
        this.setTitle("Report query");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ReportQueryDialog.this.closeDialog(evt);
            }

            public void windowOpened(WindowEvent evt) {
                ReportQueryDialog.this.formWindowOpened(evt);
            }
        });
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setResizeWeight(0.5);
        this.jPanel1.setLayout(new BorderLayout());
        this.jPanel1.setMinimumSize(new Dimension(10, 100));
        this.jPanel1.setPreferredSize(new Dimension(10, 350));
        this.jTabbedPane1.setMinimumSize(new Dimension(154, 350));
        this.jTabbedPane1.setPreferredSize(new Dimension(154, 350));
        this.jPanelSQL.setLayout(new BorderLayout());
        this.jPanelSQL.setPreferredSize(new Dimension(1, 350));
        this.jPanelSQL.setMinimumSize(new Dimension(1, 100));
        this.jRSQLExpressionArea1.setBorder(new BevelBorder(1));
        this.jRSQLExpressionArea1.setMinimumSize(new Dimension(661, 200));
        this.jRSQLExpressionArea1.setPreferredSize(new Dimension(661, 340));
        this.jPanelSQL.add((Component)this.jRSQLExpressionArea1, "Center");
        this.jPanel7.setLayout(new GridBagLayout());
        this.automaticlyReadFieldsCheckBox.setSelected(true);
        this.automaticlyReadFieldsCheckBox.setText("Automatically Retrieve Fields");
        this.automaticlyReadFieldsCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportQueryDialog.this.automaticlyReadFieldsCheckBoxActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 5, 2, 0);
        this.jPanel7.add((Component)this.automaticlyReadFieldsCheckBox, gridBagConstraints);
        this.readFieldsButton.setText("Read Fields");
        this.readFieldsButton.setEnabled(false);
        this.readFieldsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportQueryDialog.this.readFieldsButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 10, 2, 0);
        this.jPanel7.add((Component)this.readFieldsButton, gridBagConstraints);
        this.exportQueryButton.setText("Send to clipboard");
        this.exportQueryButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportQueryDialog.this.exportQueryButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 10, 2, 0);
        this.jPanel7.add((Component)this.exportQueryButton, gridBagConstraints);
        this.jLabelStatusSQL.setFont(new Font("Dialog", 0, 11));
        this.jLabelStatusSQL.setBorder(new BevelBorder(1));
        this.jLabelStatusSQL.setMinimumSize(new Dimension(4, 18));
        this.jLabelStatusSQL.setPreferredSize(new Dimension(4, 18));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        this.jPanel7.add((Component)this.jLabelStatusSQL, gridBagConstraints);
        this.jPanelSQL.add((Component)this.jPanel7, "South");
        this.jTabbedPane1.addTab("Report SQL query ", this.jPanelSQL);
        this.jPanel5.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 3, 5, 3);
        this.jPanel5.add((Component)this.jTextFieldBeanClass, gridBagConstraints);
        this.jLabel2.setText("Class name");
        this.jLabel2.setVerticalAlignment(3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 5, 3);
        this.jPanel5.add((Component)this.jLabel2, gridBagConstraints);
        this.jButtonReadBeanAttributes.setText("Read javabeans attributes");
        this.jButtonReadBeanAttributes.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportQueryDialog.this.jButtonReadBeanAttributesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 5, 3);
        this.jPanel5.add((Component)this.jButtonReadBeanAttributes, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel5.add((Component)this.jPanel10, gridBagConstraints);
        this.jTabbedPane1.addTab("JavaBean Datasource", this.jPanel5);
        this.jPanel8.setLayout(new GridBagLayout());
        this.jPanel8.setMinimumSize(new Dimension(235, 30));
        this.jPanel8.setPreferredSize(new Dimension(215, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 5, 3);
        this.jPanel8.add((Component)this.jTextFieldBeanClass1, gridBagConstraints);
        this.jLabel3.setText("Class name");
        this.jLabel3.setVerticalAlignment(3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 5, 3);
        this.jPanel8.add((Component)this.jLabel3, gridBagConstraints);
        this.jButtonReadBeanAttributes3.setText("Read attributes");
        this.jButtonReadBeanAttributes3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportQueryDialog.this.jButtonReadBeanAttributes3ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 3, 5, 3);
        this.jPanel8.add((Component)this.jButtonReadBeanAttributes3, gridBagConstraints);
        this.jPanel11.setLayout(new GridBagLayout());
        this.jTree1.setRootVisible(false);
        this.jTree1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ReportQueryDialog.this.jTree1MouseClicked(evt);
            }

            public void mouseEntered(MouseEvent evt) {
                ReportQueryDialog.this.jTree1MouseEntered(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTree1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel11.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jPanel12.setLayout(new GridBagLayout());
        this.jPanel12.setPreferredSize(new Dimension(120, 50));
        this.jPanel12.setMinimumSize(new Dimension(120, 50));
        this.jButton1.setText("Add field(s)");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportQueryDialog.this.jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.jPanel12.add((Component)this.jButton1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel12.add((Component)this.jPanel13, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        this.jPanel11.add((Component)this.jPanel12, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel8.add((Component)this.jPanel11, gridBagConstraints);
        this.jSeparator1.setPreferredSize(new Dimension(0, 4));
        this.jSeparator1.setMinimumSize(new Dimension(0, 4));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.jPanel8.add((Component)this.jSeparator1, gridBagConstraints);
        this.jTabbedPane1.addTab("JavaBean Ext Datasource", this.jPanel8);
        this.jButton2.setText("Get fields from datasource");
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportQueryDialog.this.jButton2ActionPerformed(evt);
            }
        });
        this.jPanel6.add(this.jButton2);
        this.jTabbedPane1.addTab("Use DataSource Provider", this.jPanel6);
        this.jPanel1.add((Component)this.jTabbedPane1, "Center");
        this.jSplitPane1.setTopComponent(this.jPanel1);
        this.jPanel2.setLayout(new BorderLayout());
        this.jPanel2.setPreferredSize(new Dimension(453, 150));
        this.columnsScrollPane.setPreferredSize(new Dimension(453, 150));
        this.jTableFields.setModel(new DefaultTableModel(new Object[0][], new String[]{"Field name", "Field type", "Description"}){
            boolean[] canEdit = new boolean[]{false, false, false};

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jTableFields.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                ReportQueryDialog.this.jTableFieldsKeyReleased(evt);
            }
        });
        this.columnsScrollPane.setViewportView(this.jTableFields);
        this.jPanel2.add((Component)this.columnsScrollPane, "Center");
        this.jPanel3.setLayout(new BorderLayout());
        this.jPanel3.setPreferredSize(new Dimension(10, 34));
        this.jPanel3.setMinimumSize(new Dimension(10, 34));
        this.jPanel4.setLayout(new GridBagLayout());
        this.jPanel4.setPreferredSize(new Dimension(150, 10));
        this.okButton.setText("OK");
        this.okButton.setEnabled(false);
        this.okButton.setMaximumSize(new Dimension(67, 26));
        this.okButton.setMinimumSize(new Dimension(67, 26));
        this.okButton.setPreferredSize(new Dimension(67, 26));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportQueryDialog.this.okButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.jPanel4.add((Component)this.okButton, gridBagConstraints);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportQueryDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.jPanel4.add((Component)this.cancelButton, gridBagConstraints);
        this.jPanel3.add((Component)this.jPanel4, "East");
        this.jPanel9.setLayout(null);
        this.jPanel9.setMinimumSize(new Dimension(100, 20));
        this.jPanel3.add((Component)this.jPanel9, "Center");
        this.jPanel2.add((Component)this.jPanel3, "South");
        this.columnsErrorMsgLabel.setText("jLabel1");
        this.columnsErrorMsgLabel.setVerticalAlignment(1);
        this.columnsErrorMsgLabel.setVerticalTextPosition(1);
        this.columnsErrorScrollPane.setViewportView(this.columnsErrorMsgLabel);
        this.jPanel2.add((Component)this.columnsErrorScrollPane, "Center");
        this.jSplitPane1.setBottomComponent(this.jPanel2);
        this.getContentPane().add((Component)this.jSplitPane1, "Center");
        this.pack();
    }

    private void formWindowOpened(WindowEvent evt) {
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        IReportConnection conn = (IReportConnection)this.getJReportFrame().getMainFrame().getProperties().get("DefaultConnection");
        if (conn == null || !(conn instanceof JRDataSourceProviderConnection)) {
            this.setColumnsError("The active connection is not a JasperReports DataSource provider.");
            return;
        }
        JRDataSourceProviderConnection ic = (JRDataSourceProviderConnection)conn;
        try {
            net.sf.jasperreports.engine.JRField[] jrfields = ic.getDataSourceProvider().getFields(null);
            DefaultTableModel dtm = (DefaultTableModel)this.jTableFields.getModel();
            dtm.setRowCount(0);
            for (int i = 0; i < jrfields.length; ++i) {
                JRField field = new JRField(jrfields[i].getName(), jrfields[i].getValueClassName());
                field.setDescription(Misc.nvl(jrfields[i].getDescription(), ""));
                Vector<Object> row = new Vector<Object>();
                row.addElement(field);
                row.addElement(field.getClassType());
                row.addElement(field.getDescription());
                dtm.addRow(row);
            }
        }
        catch (Exception ex) {
            this.setColumnsError("" + ex.getMessage());
        }
    }

    private void exportQueryButtonActionPerformed(ActionEvent evt) {
        FieldReader fr = new FieldReader(this.jRSQLExpressionArea1.getText(), null);
        String query = fr.interpretQuery();
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection fieldContent = new StringSelection(query);
        clipboard.setContents(fieldContent, this);
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        if (MainFrame.getMainInstance().getActiveReportFrame() == null) {
            return;
        }
        DefaultTableModel dtm = (DefaultTableModel)this.jTableFields.getModel();
        TreePath[] paths = this.jTree1.getSelectionPaths();
        for (int i = 0; i < paths.length; ++i) {
            boolean valid = true;
            TreePath tp = paths[i];
            TreeJRField tjrf = (TreeJRField)((DefaultMutableTreeNode)tp.getLastPathComponent()).getUserObject();
            String returnType = tjrf.getObj().getName();
            JRField field = new JRField(tjrf.getField().getName(), returnType);
            field.setDescription(tjrf.getField().getDescription());
            Vector<Object> row = new Vector<Object>();
            row.addElement(field);
            row.addElement(field.getClassType());
            row.addElement(field.getDescription());
            boolean found = false;
            for (int j = 0; j < this.jTableFields.getRowCount(); ++j) {
                Object ff = this.jTableFields.getValueAt(j, 0);
                if (!(ff instanceof JRField) || !((JRField)ff).getName().equals(field.getName())) continue;
                found = true;
                break;
            }
            if (found) continue;
            dtm.addRow(row);
        }
    }

    private void jTree1MouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            if (evt.getButton() == 1) {
                TreeJRField jrf;
                DefaultMutableTreeNode tn = (DefaultMutableTreeNode)this.jTree1.getSelectionPath().getLastPathComponent();
                if (tn.getChildCount() > 0) {
                    return;
                }
                if (tn.getUserObject() instanceof TreeJRField && !(jrf = (TreeJRField)tn.getUserObject()).getObj().getName().startsWith("java.lang.")) {
                    this.exploreBean(tn, jrf.getObj().getName(), Misc.nvl(jrf.getField().getDescription(), ""));
                }
            }
        }
    }

    private void jTree1MouseEntered(MouseEvent evt) {
    }

    private void jButtonReadBeanAttributes3ActionPerformed(ActionEvent evt) {
        if (MainFrame.getMainInstance().getActiveReportFrame() == null) {
            return;
        }
        DefaultTableModel dtm = (DefaultTableModel)this.jTableFields.getModel();
        dtm.setRowCount(0);
        this.jTableFields.updateUI();
        DefaultTreeModel dttm = (DefaultTreeModel)this.jTree1.getModel();
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        this.jTree1.setModel(new DefaultTreeModel(root));
        String classname = this.jTextFieldBeanClass1.getText().trim();
        if (classname.equals("")) {
            JOptionPane.showMessageDialog(this, "No class specified!", "Error", 0);
            return;
        }
        this.exploreBean(root, classname, "");
    }

    protected void getFieldsFromClass(Class clazz, String path) throws Exception {
        DefaultTableModel dtm = (DefaultTableModel)this.jTableFields.getModel();
        Method[] methods = clazz.getMethods();
        Field[] fields = clazz.getFields();
        for (int i = 0; i < methods.length; ++i) {
            if (!Modifier.isPublic(methods[i].getModifiers()) || !methods[i].getDeclaringClass().getName().equals(clazz.getName()) || Modifier.isNative(methods[i].getModifiers()) || !methods[i].getName().startsWith("get") || methods[i].getReturnType().isPrimitive() || methods[i].getReturnType().isArray()) continue;
            String fieldName = methods[i].getName().substring(3);
            for (int f = 0; f < fields.length; ++f) {
                if (!fields[f].getName().equalsIgnoreCase(fieldName)) continue;
                fieldName = fields[f].getName();
                break;
            }
            String returnType = methods[i].getReturnType().getName();
            boolean found = false;
            for (int cc = 0; cc < standard_types.length; ++cc) {
                if (!returnType.equalsIgnoreCase(standard_types[cc])) continue;
                JRField field = new JRField(fieldName, returnType);
                field.setDescription(path + "" + fieldName);
                Vector<Object> row = new Vector<Object>();
                row.addElement(field);
                row.addElement(field.getClassType());
                row.addElement(field.getDescription());
                dtm.addRow(row);
                found = true;
                break;
            }
            if (found) continue;
            JRField field = new JRField(fieldName, "java.lang.Object");
            field.setDescription(path + "" + fieldName);
            Vector<Object> row = new Vector<Object>();
            row.addElement(field);
            row.addElement(field.getClassType());
            row.addElement(field.getDescription());
            dtm.addRow(row);
            Class<?> subClazz = Class.forName(returnType);
            this.getFieldsFromClass(subClazz, path + fieldName + ".");
        }
    }

    private void automaticlyReadFieldsCheckBoxActionPerformed(ActionEvent evt) {
        if (this.automaticlyReadFieldsCheckBox.isSelected()) {
            this.readFieldsButton.setEnabled(false);
            this.processQueryChanged(this.jRSQLExpressionArea1.getText().trim());
        } else {
            this.readFieldsButton.setEnabled(true);
            this.setColumnsError("Enter your query above. Then use the Read Fields button to retrieve the list of fields.");
        }
    }

    private void readFieldsButtonActionPerformed(ActionEvent evt) {
        this.processQueryChanged(this.jRSQLExpressionArea1.getText().trim());
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        ++num;
        this.setVisible(false);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.getJReportFrame() != null) {
            ++num;
            this.getJReportFrame().getReport().setQuery(this.jRSQLExpressionArea1.getText());
            try {
                if (this.jTableFields.getRowCount() > 0) {
                    this.getJReportFrame().getReport().getFields().clear();
                    int[] selectedRows = this.jTableFields.getSelectedRows();
                    for (int i = 0; i < selectedRows.length; ++i) {
                        if (selectedRows[i] > this.jTableFields.getRowCount()) continue;
                        JRField field = (JRField)this.jTableFields.getValueAt(selectedRows[i], 0);
                        Enumeration e = this.getJReportFrame().getReport().getFields().elements();
                        boolean found = false;
                        while (e.hasMoreElements()) {
                            JRField f = (JRField)e.nextElement();
                            if (!f.getName().equalsIgnoreCase(field.getName())) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        this.getJReportFrame().getReport().addField(field);
                    }
                    this.getJReportFrame().getMainFrame().getValuesDialog().getValuesPanel().updateFields();
                }
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
        this.setVisible(false);
    }

    private void jTableFieldsKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 127) {
            DefaultTableModel dtm = (DefaultTableModel)this.jTableFields.getModel();
            int[] selectedRows = this.jTableFields.getSelectedRows();
            for (int i = selectedRows.length - 1; i >= 0; --i) {
                JRField field = (JRField)this.jTableFields.getValueAt(i, 0);
                this.getJReportFrame().getReport().removeField(field);
                this.jTableFields.removeRowSelectionInterval(i, i);
            }
        }
    }

    private void jButtonReadBeanAttributesActionPerformed(ActionEvent evt) {
        String classname = this.jTextFieldBeanClass.getText().trim();
        if (classname.equals("")) {
            JOptionPane.showMessageDialog(this, "No class specified!", "Error", 0);
            return;
        }
        try {
            DefaultTableModel dtm = (DefaultTableModel)this.jTableFields.getModel();
            dtm.setRowCount(0);
            ReportClassLoader reportClassLoader = new ReportClassLoader();
            reportClassLoader.rescanLibDirectory();
            Class<?> clazz = Class.forName(classname, true, reportClassLoader);
            PropertyDescriptor[] pd = PropertyUtils.getPropertyDescriptors(clazz);
            for (int nd = 0; nd < pd.length; ++nd) {
                String fieldName = pd[nd].getName();
                if (pd[nd].getPropertyType() == null || pd[nd].getReadMethod() == null) continue;
                String returnType = pd[nd].getPropertyType().getName();
                JRField field = new JRField(fieldName, this.getJRFieldType(returnType));
                field.setDescription("");
                Vector<Object> row = new Vector<Object>();
                row.addElement(field);
                row.addElement(field.getClassType());
                row.addElement(field.getDescription());
                dtm.addRow(row);
            }
            this.jTableFields.setRowSelectionInterval(0, this.jTableFields.getRowCount() - 1);
        }
        catch (ClassNotFoundException cnf) {
            JOptionPane.showMessageDialog(this, "Class not found!\nCheck your classpath and retry.", "Error", 0);
            return;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this, ex.getMessage(), "Error", 0);
            return;
        }
    }

    private String getJRFieldType(String type) {
        if (type == null) {
            return "java.lang.Object";
        }
        if (type.equals("java.lang.Boolean") || type.equals("boolean")) {
            return "java.lang.Boolean";
        }
        if (type.equals("java.lang.Byte") || type.equals("byte")) {
            return "java.lang.Byte";
        }
        if (type.equals("java.lang.Integer") || type.equals("int")) {
            return "java.lang.Integer";
        }
        if (type.equals("java.lang.Long") || type.equals("long")) {
            return "java.lang.Long";
        }
        if (type.equals("java.lang.Double") || type.equals("double")) {
            return "java.lang.Double";
        }
        if (type.equals("java.lang.Float") || type.equals("float")) {
            return "java.lang.Float";
        }
        if (type.equals("java.lang.Short") || type.equals("short")) {
            return "java.lang.Short";
        }
        if (type.equals("java.util.Date") || type.equals("java.sql.Timestamp") || type.equals("java.io.InputStream") || type.equals("java.math.BigDecimal") || type.equals("java.lang.String") || type.equals("java.sql.Time")) {
            return type;
        }
        return "java.lang.Object";
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) {
        new ReportQueryDialog((Frame)new JFrame(), true).show();
    }

    public JReportFrame getJReportFrame() {
        return this.jReportFrame;
    }

    public void setJReportFrame(JReportFrame jReportFrame) {
        this.jReportFrame = jReportFrame;
        DefaultTableModel dtm = (DefaultTableModel)this.jTableFields.getModel();
        dtm.setRowCount(0);
        ++num;
        this.jLabelStatusSQL.setText("");
        if (jReportFrame == null) {
            this.jRSQLExpressionArea1.setText("");
        } else {
            this.isSettingSQLExpression = true;
            this.jRSQLExpressionArea1.setText(this.jReportFrame.getReport().getQuery());
            this.isSettingSQLExpression = false;
            ArrayList<Object[]> columns = new ArrayList<Object[]>();
            Iterator i = jReportFrame.getReport().getFields().iterator();
            while (i.hasNext()) {
                JRField field = (JRField)i.next();
                columns.add(new Object[]{field, field.getClassType()});
            }
            this.setColumns(columns);
        }
    }

    private Interpreter prepareExpressionEvaluator() throws EvalError {
        Interpreter interpreter = new Interpreter();
        interpreter.setClassLoader(interpreter.getClass().getClassLoader());
        return interpreter;
    }

    private Class classStringToClass(String classType) {
        Class c = null;
        if (classType.equals("java.lang.String")) {
            c = class$java$lang$String == null ? (class$java$lang$String = ReportQueryDialog.class$("java.lang.String")) : class$java$lang$String;
        } else if (classType.equals("java.lang.Integer")) {
            c = class$java$lang$Integer == null ? (class$java$lang$Integer = ReportQueryDialog.class$("java.lang.Integer")) : class$java$lang$Integer;
        } else if (classType.equals("java.lang.Boolean")) {
            c = class$java$lang$Boolean == null ? (class$java$lang$Boolean = ReportQueryDialog.class$("java.lang.Boolean")) : class$java$lang$Boolean;
        } else if (classType.equals("java.lang.Byte")) {
            c = class$java$lang$Byte == null ? (class$java$lang$Byte = ReportQueryDialog.class$("java.lang.Byte")) : class$java$lang$Byte;
        } else if (classType.equals("java.util.Date")) {
            c = class$java$util$Date == null ? (class$java$util$Date = ReportQueryDialog.class$("java.util.Date")) : class$java$util$Date;
        } else if (classType.equals("java.sql.Timestamp")) {
            c = class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = ReportQueryDialog.class$("java.sql.Timestamp")) : class$java$sql$Timestamp;
        } else if (classType.equals("java.sql.Time")) {
            c = class$java$sql$Time == null ? (class$java$sql$Time = ReportQueryDialog.class$("java.sql.Time")) : class$java$sql$Time;
        } else if (classType.equals("java.lang.Double")) {
            c = class$java$lang$Double == null ? (class$java$lang$Double = ReportQueryDialog.class$("java.lang.Double")) : class$java$lang$Double;
        } else if (classType.equals("java.lang.Float")) {
            c = class$java$lang$Float == null ? (class$java$lang$Float = ReportQueryDialog.class$("java.lang.Float")) : class$java$lang$Float;
        } else if (classType.equals("java.lang.Long")) {
            c = class$java$lang$Long == null ? (class$java$lang$Long = ReportQueryDialog.class$("java.lang.Long")) : class$java$lang$Long;
        } else if (classType.equals("java.lang.Short")) {
            c = class$java$lang$Short == null ? (class$java$lang$Short = ReportQueryDialog.class$("java.lang.Short")) : class$java$lang$Short;
        } else if (classType.equals("java.math.BigDecimal")) {
            c = class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = ReportQueryDialog.class$("java.math.BigDecimal")) : class$java$math$BigDecimal;
        }
        return c;
    }

    public void exploreBean(DefaultMutableTreeNode root, String classname, String parentPath) {
        try {
            root.removeAllChildren();
            if (parentPath.length() > 0) {
                parentPath = parentPath + ".";
            }
            ReportClassLoader reportClassLoader = new ReportClassLoader();
            reportClassLoader.rescanLibDirectory();
            Class<?> clazz = Class.forName(classname, true, reportClassLoader);
            Method[] methods = clazz.getMethods();
            Field[] fields = clazz.getFields();
            for (int i = 0; i < methods.length; ++i) {
                String fieldName;
                if (!Modifier.isPublic(methods[i].getModifiers()) || !methods[i].getDeclaringClass().getName().equals(classname) || Modifier.isNative(methods[i].getModifiers()) || !methods[i].getName().startsWith("get") || methods[i].getReturnType().isPrimitive() || methods[i].getReturnType().isArray() || (fieldName = methods[i].getName().substring(3)).length() == 0) continue;
                for (int f = 0; f < fields.length; ++f) {
                    if (!fields[f].getName().equalsIgnoreCase(fieldName)) continue;
                    fieldName = fields[f].getName();
                    break;
                }
                String returnType = methods[i].getReturnType().getName();
                JRField field = new JRField(fieldName, returnType);
                field.setDescription(parentPath + fieldName);
                TreeJRField jtf = new TreeJRField();
                jtf.setField(field);
                jtf.setObj(methods[i].getReturnType());
                boolean bChildrens = true;
                if (methods[i].getReturnType().getName().startsWith("java.lang.")) {
                    bChildrens = false;
                }
                root.add(new DefaultMutableTreeNode(jtf, bChildrens));
            }
            this.jTree1.expandPath(new TreePath(root.getPath()));
            this.jTree1.updateUI();
        }
        catch (ClassNotFoundException cnf) {
            JOptionPane.showMessageDialog(this, "Class not found!\nCheck your classpath and retry.", "Error", 0);
            return;
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), "Error", 0);
            return;
        }
    }

    public void lostOwnership(Clipboard parClipboard, Transferable parTransferable) {
    }

    public static Object recursiveInterpreter(Interpreter interpreter, String expression, Vector parameters) throws EvalError {
        return ReportQueryDialog.recursiveInterpreter(interpreter, expression, parameters, 0);
    }

    public static Object recursiveInterpreter(Interpreter interpreter, String expression, Vector parameters, int recursion_level) throws EvalError {
        if (++recursion_level > 100) {
            return null;
        }
        if (expression != null && expression.trim().length() > 0) {
            while (expression.indexOf("$P{") >= 0) {
                int start_index = expression.indexOf("$P{") + 3;
                String param_name = expression.substring(start_index, expression.indexOf("}", start_index));
                String param_expression = "";
                for (int i = 0; i < parameters.size(); ++i) {
                    JRParameter p = (JRParameter)parameters.elementAt(i);
                    if (!p.getName().equals(param_name)) continue;
                    param_expression = p.getDefaultValueExpression();
                    break;
                }
                expression = Misc.string_replace(param_name, "$P{" + param_name + "}", expression);
                interpreter.set(param_name, ReportQueryDialog.recursiveInterpreter(interpreter, param_expression, parameters, recursion_level));
            }
            Object res = interpreter.eval(expression);
            return res;
        }
        return null;
    }

    static /* synthetic */ void access$500(ReportQueryDialog x0, List x1) {
        x0.setColumns(x1);
    }

    static /* synthetic */ void access$600(ReportQueryDialog x0, String x1) {
        x0.setColumnsError(x1);
    }

    static /* synthetic */ JLabel access$800(ReportQueryDialog x0) {
        return x0.getJLabelStatusSQL();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class FieldReader
    extends Thread {
        String src_query;
        IReportConnection conn;

        public FieldReader(String query, IReportConnection conn) {
            this.src_query = query;
            this.conn = conn;
        }

        private void setColumnsFromWorker(List columns) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(this, columns){
                    private final /* synthetic */ List val$columns;
                    private final /* synthetic */ FieldReader this$1;
                    {
                        this.this$1 = this$1;
                        this.val$columns = val$columns;
                    }

                    public void run() {
                        String str = ReportQueryDialog.access$200(FieldReader.access$400(this.this$1)).getText().trim();
                        if (str.compareTo(this.this$1.src_query) == 0) {
                            ReportQueryDialog.access$500(FieldReader.access$400(this.this$1), this.val$columns);
                        }
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void setColumnErrorFromWork(String error_msg) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(this, error_msg){
                    private final /* synthetic */ String val$error_msg;
                    private final /* synthetic */ FieldReader this$1;
                    {
                        this.this$1 = this$1;
                        this.val$error_msg = val$error_msg;
                    }

                    public void run() {
                        String str = ReportQueryDialog.access$200(FieldReader.access$400(this.this$1)).getText().trim();
                        if (str.compareTo(this.this$1.src_query) == 0) {
                            ReportQueryDialog.access$600(FieldReader.access$400(this.this$1), this.val$error_msg);
                        }
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public String interpretQuery() {
            String query = this.src_query;
            try {
                Interpreter interpreter = ReportQueryDialog.this.prepareExpressionEvaluator();
                ArrayList queryParams = new ArrayList();
                Enumeration enumParams = ReportQueryDialog.this.getJReportFrame().getReport().getParameters().elements();
                while (enumParams.hasMoreElements()) {
                    JRParameter parameter = (JRParameter)enumParams.nextElement();
                    String p1 = "$P{" + parameter.getName() + "}";
                    String p2 = "$P!{" + parameter.getName() + "}";
                    Object defValue = parameter.getDefaultValueExpression() != null && !parameter.getDefaultValueExpression().equals("") ? ReportQueryDialog.recursiveInterpreter(interpreter, parameter.getDefaultValueExpression(), ReportQueryDialog.this.getJReportFrame().getReport().getParameters()) : null;
                    int ip1 = query.indexOf(p1);
                    while (ip1 != -1) {
                        if (defValue == null) {
                            throw new IllegalArgumentException("Please set a default value for the parameter '" + parameter.getName() + "'");
                        }
                        String before = query.substring(0, ip1);
                        String after = query.substring(ip1 + p1.length());
                        if (parameter.getClassType().equals("java.lang.String")) {
                            String stt = defValue.toString();
                            stt = Misc.string_replace("''", "'", stt);
                            query = before + "'" + stt + "'" + after;
                        } else {
                            query = before + "" + defValue.toString() + "" + after;
                        }
                        ip1 = query.indexOf(p1);
                    }
                    int ip2 = query.indexOf(p2);
                    while (ip2 != -1) {
                        if (defValue == null) {
                            throw new IllegalArgumentException("Please set a default value for the parameter '" + parameter.getName() + "'");
                        }
                        String before = query.substring(0, ip2);
                        String after = query.substring(ip2 + p2.length());
                        query = before + "" + defValue.toString() + "" + after;
                        ip2 = query.indexOf(p2);
                    }
                }
                return query;
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, ex.getMessage());
                return "";
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block57: {
                block64: {
                    block55: {
                        block63: {
                            block54: {
                                block62: {
                                    block53: {
                                        block51: {
                                            block52: {
                                                error_msg = "";
                                                in = ++ReportQueryDialog.num;
                                                ReportQueryDialog.access$800(ReportQueryDialog.this).setText("Executing SQL query....");
                                                con = null;
                                                ps = null;
                                                try {
                                                    try {
                                                        query = this.src_query;
                                                        interpreter = ReportQueryDialog.access$700(ReportQueryDialog.this);
                                                        queryParams = new ArrayList<Object>();
                                                        enumParams = ReportQueryDialog.this.getJReportFrame().getReport().getParameters().elements();
                                                        while (enumParams.hasMoreElements()) {
                                                            parameter = (JRParameter)enumParams.nextElement();
                                                            p1 = "$P{" + parameter.getName() + "}";
                                                            p2 = "$P!{" + parameter.getName() + "}";
                                                            defValue = parameter.getDefaultValueExpression() != null && parameter.getDefaultValueExpression().equals("") == false ? ReportQueryDialog.recursiveInterpreter(interpreter, parameter.getDefaultValueExpression(), ReportQueryDialog.this.getJReportFrame().getReport().getParameters()) : null;
                                                            ip1 = query.indexOf(p1);
                                                            while (ip1 != -1) {
                                                                if (defValue == null) {
                                                                    throw new IllegalArgumentException("Please set a default value for the parameter '" + parameter.getName() + "'");
                                                                }
                                                                before = query.substring(0, ip1);
                                                                after = query.substring(ip1 + p1.length());
                                                                query = before + " ? " + after;
                                                                queryParams.add(defValue);
                                                                ip1 = query.indexOf(p1);
                                                            }
                                                            ip2 = query.indexOf(p2);
                                                            while (ip2 != -1) {
                                                                if (defValue == null) {
                                                                    throw new IllegalArgumentException("Please set a default value for the parameter '" + parameter.getName() + "'");
                                                                }
                                                                before = query.substring(0, ip2);
                                                                after = query.substring(ip2 + p2.length());
                                                                query = before + "" + defValue.toString() + "" + after;
                                                                ip2 = query.indexOf(p2);
                                                            }
                                                        }
                                                        con = this.conn.getConnection();
                                                        if (in < ReportQueryDialog.num) {
                                                            var18_28 = null;
                                                            if (ps == null) break block51;
                                                            break block52;
                                                        }
                                                        ps = con.prepareStatement(query);
                                                        for (pc = 0; pc < queryParams.size(); ++pc) {
                                                            ps.setObject(pc + 1, queryParams.get(pc));
                                                        }
                                                        try {
                                                            ps.setFetchSize(0);
                                                        }
                                                        catch (Exception e) {
                                                            // empty catch block
                                                        }
                                                        rs = ps.executeQuery();
                                                        if (in < ReportQueryDialog.num) {
                                                            break block53;
                                                        }
                                                        rsmd = rs.getMetaData();
                                                        if (in < ReportQueryDialog.num) {
                                                            break block54;
                                                        }
                                                        columns = new ArrayList<Object[]>();
                                                        for (i = 1; i <= rsmd.getColumnCount(); ++i) {
                                                            field = new JRField(rsmd.getColumnLabel(i), Misc.getJdbcTypeClass(rsmd.getColumnType(i)));
                                                            columns.add(new Object[]{field, field.getClassType()});
                                                        }
                                                        this.setColumnsFromWorker(columns);
                                                        ReportQueryDialog.access$800(ReportQueryDialog.this).setText("Ready");
                                                        break block55;
                                                    }
                                                    catch (IllegalArgumentException ie) {
                                                        error_msg = ie.getMessage();
                                                        ReportQueryDialog.access$800(ReportQueryDialog.this).setText("Ready");
                                                        var18_32 = null;
                                                        if (ps != null) {
                                                            try {
                                                                ps.close();
                                                            }
                                                            catch (Exception e) {
                                                                // empty catch block
                                                            }
                                                        }
                                                        if (con != null) {
                                                            try {
                                                                con.close();
                                                            }
                                                            catch (Exception e) {}
                                                        }
                                                        break block57;
                                                    }
                                                    catch (NoClassDefFoundError ex) {
                                                        block58: {
                                                            ex.printStackTrace();
                                                            error_msg = "NoClassDefFoundError!!\nCheck your classpath!";
                                                            ReportQueryDialog.access$800(ReportQueryDialog.this).setText("Ready");
                                                            var18_33 = null;
                                                            if (ps != null) {
                                                                ** try [egrp 3[TRYBLOCK] [26 : 859->869)] { 
lbl97:
                                                                // 1 sources

                                                                ps.close();
                                                                break block58;
lbl99:
                                                                // 1 sources

                                                                catch (Exception e) {
                                                                    // empty catch block
                                                                }
                                                            }
                                                        }
                                                        if (con != null) {
                                                            try {}
                                                            catch (Exception e) {}
                                                            con.close();
                                                        }
                                                        break block57;
                                                    }
                                                    catch (SQLException ex) {
                                                        block59: {
                                                            error_msg = "SQL problems:\n" + ex.getMessage();
                                                            var18_34 = null;
                                                            if (ps != null) {
                                                                ** try [egrp 3[TRYBLOCK] [26 : 859->869)] { 
lbl114:
                                                                // 1 sources

                                                                ps.close();
                                                                break block59;
lbl116:
                                                                // 1 sources

                                                                catch (Exception e) {
                                                                    // empty catch block
                                                                }
                                                            }
                                                        }
                                                        if (con != null) {
                                                            try {}
                                                            catch (Exception e) {}
                                                            con.close();
                                                        }
                                                        break block57;
                                                    }
                                                    catch (Exception ex) {
                                                        block60: {
                                                            ex.printStackTrace();
                                                            error_msg = "General problem:\n" + ex.getMessage() + "\n\nCheck username and password; is the DBMS active ?!";
                                                            ReportQueryDialog.access$800(ReportQueryDialog.this).setText("Ready");
                                                            var18_35 = null;
                                                            if (ps != null) {
                                                                ** try [egrp 3[TRYBLOCK] [26 : 859->869)] { 
lbl133:
                                                                // 1 sources

                                                                ps.close();
                                                                break block60;
lbl135:
                                                                // 1 sources

                                                                catch (Exception e) {
                                                                    // empty catch block
                                                                }
                                                            }
                                                        }
                                                        if (con != null) {
                                                            try {}
                                                            catch (Exception e) {}
                                                            con.close();
                                                        }
                                                        break block57;
                                                    }
                                                }
                                                catch (Throwable var17_46) {
                                                    block61: {
                                                        var18_36 = null;
                                                        if (ps != null) {
                                                            ** try [egrp 3[TRYBLOCK] [26 : 859->869)] { 
lbl149:
                                                            // 1 sources

                                                            ps.close();
                                                            break block61;
lbl151:
                                                            // 1 sources

                                                            catch (Exception e) {
                                                                // empty catch block
                                                            }
                                                        }
                                                    }
                                                    if (con == null) throw var17_46;
                                                    ** try [egrp 4[TRYBLOCK] [27 : 875->884)] { 
lbl156:
                                                    // 1 sources

                                                    con.close();
                                                    throw var17_46;
lbl158:
                                                    // 1 sources

                                                    catch (Exception e) {
                                                        // empty catch block
                                                    }
                                                    throw var17_46;
                                                }
                                            }
                                            ** try [egrp 3[TRYBLOCK] [26 : 859->869)] { 
lbl163:
                                            // 1 sources

                                            ps.close();
                                            break block51;
lbl165:
                                            // 1 sources

                                            catch (Exception e) {
                                                // empty catch block
                                            }
                                        }
                                        if (con == null) return;
                                        ** try [egrp 4[TRYBLOCK] [27 : 875->884)] { 
lbl170:
                                        // 1 sources

                                        con.close();
                                        return;
lbl172:
                                        // 1 sources

                                        catch (Exception e) {
                                            // empty catch block
                                        }
                                        return;
                                    }
                                    var18_29 = null;
                                    if (ps != null) {
                                        ** try [egrp 3[TRYBLOCK] [26 : 859->869)] { 
lbl179:
                                        // 1 sources

                                        ps.close();
                                        break block62;
lbl181:
                                        // 1 sources

                                        catch (Exception e) {
                                            // empty catch block
                                        }
                                    }
                                }
                                if (con == null) return;
                                ** try [egrp 4[TRYBLOCK] [27 : 875->884)] { 
lbl186:
                                // 1 sources

                                con.close();
                                return;
lbl188:
                                // 1 sources

                                catch (Exception e) {
                                    // empty catch block
                                }
                                return;
                            }
                            var18_30 = null;
                            if (ps != null) {
                                ** try [egrp 3[TRYBLOCK] [26 : 859->869)] { 
lbl195:
                                // 1 sources

                                ps.close();
                                break block63;
lbl197:
                                // 1 sources

                                catch (Exception e) {
                                    // empty catch block
                                }
                            }
                        }
                        if (con == null) return;
                        ** try [egrp 4[TRYBLOCK] [27 : 875->884)] { 
lbl202:
                        // 1 sources

                        con.close();
                        return;
lbl204:
                        // 1 sources

                        catch (Exception e) {
                            // empty catch block
                        }
                        return;
                    }
                    var18_31 = null;
                    if (ps != null) {
                        ** try [egrp 3[TRYBLOCK] [26 : 859->869)] { 
lbl211:
                        // 1 sources

                        ps.close();
                        break block64;
lbl213:
                        // 1 sources

                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
                if (con == null) return;
                ** try [egrp 4[TRYBLOCK] [27 : 875->884)] { 
lbl218:
                // 1 sources

                con.close();
                return;
lbl220:
                // 1 sources

                catch (Exception e) {
                    // empty catch block
                }
                return;
            }
            ReportQueryDialog.access$800(ReportQueryDialog.this).setText("Ready");
            this.setColumnErrorFromWork(error_msg);
        }

        static /* synthetic */ ReportQueryDialog access$400(FieldReader x0) {
            return x0.ReportQueryDialog.this;
        }
    }
}

