/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui;

import it.businesslogic.ireport.JRParameter;
import it.businesslogic.ireport.gui.JReportFrame;
import it.businesslogic.ireport.gui.ValuesPanel;
import it.businesslogic.ireport.gui.event.ReportObjectChangedEvent;
import it.businesslogic.ireport.gui.event.ReportObjectChangedListener;
import it.businesslogic.ireport.util.LanguageChangedEvent;
import it.businesslogic.ireport.util.Misc;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class ValuesDialog
extends JDialog
implements ReportObjectChangedListener {
    private ValuesPanel valuesPanel = null;
    private JReportFrame jReportFrame;

    public ValuesDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.valuesPanel = new ValuesPanel();
        this.getContentPane().add("Center", this.valuesPanel);
        this.valuesPanel.applyI18n();
        this.applyI18n();
        this.setSize(500, 300);
        Misc.centerFrame(this);
    }

    private void initComponents() {
        this.setTitle("Values");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ValuesDialog.this.closeDialog(evt);
            }
        });
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
    }

    public static void main(String[] args) {
        new ValuesDialog((Frame)new JFrame(), true).show();
    }

    public JReportFrame getJReportFrame() {
        return this.jReportFrame;
    }

    public void setJReportFrame(JReportFrame jReportFrame) {
        this.jReportFrame = jReportFrame;
        if (jReportFrame == null) {
            this.setVisible(false);
        } else if (this.isVisible()) {
            this.setTitle(jReportFrame.getReport().getName() + " values...");
            this.getValuesPanel().setSubDataset(this.getJReportFrame().getReport());
        }
    }

    public void applyI18n() {
        this.getValuesPanel().applyI18n();
    }

    public void languageChanged(LanguageChangedEvent evt) {
        this.applyI18n();
    }

    public void setVisible(boolean visible) {
        if (visible == this.isVisible()) {
            return;
        }
        super.setVisible(visible);
        if (visible) {
            this.setJReportFrame(this.jReportFrame);
        }
    }

    public void modifyErrorParameter(JRParameter p) {
        this.getValuesPanel().modifyErrorParameter(p);
    }

    public void gotoTab(String tab) {
        this.getValuesPanel().gotoTab(tab);
    }

    public Vector getClipboardFields() {
        return this.getValuesPanel().getClipboardFields();
    }

    public void setClipboardFields(Vector clipboardFields) {
        this.getValuesPanel().setClipboardFields(clipboardFields);
    }

    public Vector getClipboardVariables() {
        return this.getValuesPanel().getClipboardVariables();
    }

    public void setClipboardVariables(Vector clipboardVariables) {
        this.getValuesPanel().setClipboardVariables(clipboardVariables);
    }

    public Vector getClipboardParameters() {
        return this.getValuesPanel().getClipboardParameters();
    }

    public void setClipboardParameters(Vector clipboardParameters) {
        this.getValuesPanel().setClipboardParameters(clipboardParameters);
    }

    public void reportObjectChanged(ReportObjectChangedEvent evt) {
        if (evt.getType() == 2) {
            this.getValuesPanel().updateParameters();
        } else if (evt.getType() == 1) {
            this.getValuesPanel().updateVariables();
        } else if (evt.getType() == 0) {
            this.getValuesPanel().updateFields();
        }
    }

    public ValuesPanel getValuesPanel() {
        return this.valuesPanel;
    }

    public void setValuesPanel(ValuesPanel valuesPanel) {
        this.valuesPanel = valuesPanel;
    }
}

