/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JRCompilationUnit;
import net.sf.jasperreports.engine.design.JRCompiler;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRReportCompileData;
import net.sf.jasperreports.engine.design.JRVerifier;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.fill.JREvaluator;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.util.JRSaver;

public abstract class JRAbstractCompiler
implements JRCompiler {
    private final boolean needsSourceFiles;

    protected JRAbstractCompiler(boolean needsSourceFiles) {
        this.needsSourceFiles = needsSourceFiles;
    }

    public static String getUnitName(JRReport report, JRDataset dataset) {
        String className = dataset.isMainDataset() ? report.getName() : report.getName() + "_" + dataset.getName();
        return className;
    }

    public static String getUnitName(JRReport report, JRCrosstab crosstab) {
        return report.getName() + "_CROSSTAB_" + crosstab.getName();
    }

    public final JasperReport compileReport(JasperDesign jasperDesign) throws JRException {
        String tempDirStr;
        this.checkLanguage(jasperDesign.getLanguage());
        JRExpressionCollector expressionCollector = new JRExpressionCollector();
        expressionCollector.collect(jasperDesign);
        this.verifyDesign(jasperDesign, expressionCollector);
        boolean isKeepJavaFile = JRProperties.getBooleanProperty("net.sf.jasperreports.compiler.keep.java.file");
        File tempDirFile = null;
        if (!(!isKeepJavaFile && !this.needsSourceFiles || (tempDirFile = new File(tempDirStr = JRProperties.getProperty("net.sf.jasperreports.compiler.temp.dir"))).exists() && tempDirFile.isDirectory())) {
            throw new JRException("Temporary directory not found : " + tempDirStr);
        }
        List datasets = jasperDesign.getDatasetsList();
        List crosstabs = jasperDesign.getCrosstabs();
        JRCompilationUnit[] units = new JRCompilationUnit[datasets.size() + crosstabs.size() + 1];
        units[0] = this.createCompileUnit(jasperDesign, jasperDesign.getMainDesignDataset(), expressionCollector, tempDirFile);
        int sourcesCount = 1;
        Iterator it = datasets.iterator();
        while (it.hasNext()) {
            JRDesignDataset dataset = (JRDesignDataset)it.next();
            units[sourcesCount] = this.createCompileUnit(jasperDesign, dataset, expressionCollector, tempDirFile);
            ++sourcesCount;
        }
        it = crosstabs.iterator();
        while (it.hasNext()) {
            JRDesignCrosstab crosstab = (JRDesignCrosstab)it.next();
            units[sourcesCount] = this.createCompileUnit(jasperDesign, crosstab, expressionCollector, tempDirFile);
            ++sourcesCount;
        }
        String classpath = JRProperties.getProperty("net.sf.jasperreports.compiler.classpath");
        try {
            JasperReport jasperReport;
            String compileErrors = this.compileUnits(units, classpath, tempDirFile);
            if (compileErrors != null) {
                throw new JRException("Errors were encountered when compiling report expressions class file:\n" + compileErrors);
            }
            JRReportCompileData reportCompileData = new JRReportCompileData();
            reportCompileData.setMainDatasetCompileData(units[0].getCompileData());
            ListIterator it2 = datasets.listIterator();
            while (it2.hasNext()) {
                JRDesignDataset dataset = (JRDesignDataset)it2.next();
                reportCompileData.setDatasetCompileData(dataset, units[it2.nextIndex()].getCompileData());
            }
            it2 = crosstabs.listIterator();
            while (it2.hasNext()) {
                JRDesignCrosstab crosstab = (JRDesignCrosstab)it2.next();
                reportCompileData.setCrosstabCompileData(crosstab, units[datasets.size() + it2.nextIndex()].getCompileData());
            }
            JasperReport jasperReport2 = jasperReport = new JasperReport(jasperDesign, this.getClass().getName(), reportCompileData, expressionCollector);
            return jasperReport2;
        }
        catch (JRException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JRException("Error compiling report design.", e);
        }
        finally {
            if (this.needsSourceFiles && !isKeepJavaFile) {
                this.deleteSourceFiles(units);
            }
        }
    }

    private void verifyDesign(JasperDesign jasperDesign, JRExpressionCollector expressionCollector) throws JRException {
        Collection brokenRules = JRVerifier.verifyDesign(jasperDesign, expressionCollector);
        if (brokenRules != null && brokenRules.size() > 0) {
            StringBuffer sbuffer = new StringBuffer();
            sbuffer.append("Report design not valid : ");
            int i = 1;
            Iterator it = brokenRules.iterator();
            while (it.hasNext()) {
                sbuffer.append("\n\t " + i + ". " + (String)it.next());
                ++i;
            }
            throw new JRException(sbuffer.toString());
        }
    }

    private JRCompilationUnit createCompileUnit(JasperDesign jasperDesign, JRDesignDataset dataset, JRExpressionCollector expressionCollector, File saveSourceDir) throws JRException {
        String unitName = JRAbstractCompiler.getUnitName((JRReport)jasperDesign, dataset);
        String sourceCode = this.generateSourceCode(jasperDesign, dataset, expressionCollector);
        File sourceFile = this.getSourceFile(saveSourceDir, unitName, sourceCode);
        return new JRCompilationUnit(unitName, sourceCode, sourceFile, expressionCollector.getExpressions(dataset));
    }

    private JRCompilationUnit createCompileUnit(JasperDesign jasperDesign, JRDesignCrosstab crosstab, JRExpressionCollector expressionCollector, File saveSourceDir) throws JRException {
        String unitName = JRAbstractCompiler.getUnitName((JRReport)jasperDesign, crosstab);
        String sourceCode = this.generateSourceCode(jasperDesign, crosstab, expressionCollector);
        File sourceFile = this.getSourceFile(saveSourceDir, unitName, sourceCode);
        return new JRCompilationUnit(unitName, sourceCode, sourceFile, expressionCollector.getExpressions(crosstab));
    }

    private File getSourceFile(File saveSourceDir, String unitName, String sourceCode) throws JRException {
        File sourceFile = null;
        if (saveSourceDir != null) {
            String fileName = this.getSourceFileName(unitName);
            sourceFile = new File(saveSourceDir, fileName);
            JRSaver.saveClassSource(sourceCode, sourceFile);
        }
        return sourceFile;
    }

    private void deleteSourceFiles(JRCompilationUnit[] units) {
        for (int i = 0; i < units.length; ++i) {
            units[i].getSourceFile().delete();
        }
    }

    public JREvaluator loadEvaluator(JasperReport jasperReport) throws JRException {
        return this.loadEvaluator(jasperReport, jasperReport.getMainDataset());
    }

    public JREvaluator loadEvaluator(JasperReport jasperReport, JRDataset dataset) throws JRException {
        String unitName = JRAbstractCompiler.getUnitName((JRReport)jasperReport, dataset);
        JRReportCompileData reportCompileData = (JRReportCompileData)jasperReport.getCompileData();
        Serializable compileData = reportCompileData.getDatasetCompileData(dataset);
        return this.loadEvaluator(compileData, unitName);
    }

    public JREvaluator loadEvaluator(JasperReport jasperReport, JRCrosstab crosstab) throws JRException {
        String unitName = JRAbstractCompiler.getUnitName((JRReport)jasperReport, crosstab);
        JRReportCompileData reportCompileData = (JRReportCompileData)jasperReport.getCompileData();
        Serializable compileData = reportCompileData.getCrosstabCompileData(crosstab);
        return this.loadEvaluator(compileData, unitName);
    }

    protected abstract JREvaluator loadEvaluator(Serializable var1, String var2) throws JRException;

    protected abstract void checkLanguage(String var1) throws JRException;

    protected abstract String generateSourceCode(JasperDesign var1, JRDesignDataset var2, JRExpressionCollector var3) throws JRException;

    protected abstract String generateSourceCode(JasperDesign var1, JRDesignCrosstab var2, JRExpressionCollector var3) throws JRException;

    protected abstract String compileUnits(JRCompilationUnit[] var1, String var2, File var3) throws JRException;

    protected abstract String getSourceFileName(String var1);
}

