/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.fill.AbstractValueProvider;
import net.sf.jasperreports.engine.fill.JRAbstractExtendedIncrementer;
import net.sf.jasperreports.engine.fill.JRCalculable;
import net.sf.jasperreports.engine.fill.JRLongIncrementerFactory;

class JRLongCountIncrementer
extends JRAbstractExtendedIncrementer {
    private static JRLongCountIncrementer mainInstance = new JRLongCountIncrementer();

    private JRLongCountIncrementer() {
    }

    public static JRLongCountIncrementer getInstance() {
        return mainInstance;
    }

    public Object increment(JRCalculable variable, Object expressionValue, AbstractValueProvider valueProvider) {
        Number value = (Number)variable.getIncrementedValue();
        if (expressionValue == null) {
            if (variable.isInitialized()) {
                return JRLongIncrementerFactory.ZERO;
            }
            return value;
        }
        if (value == null || variable.isInitialized()) {
            value = JRLongIncrementerFactory.ZERO;
        }
        return new Long(value.longValue() + 1L);
    }

    public Object combine(JRCalculable calculable, JRCalculable calculableValue, AbstractValueProvider valueProvider) throws JRException {
        Number value = (Number)calculable.getIncrementedValue();
        Number combineValue = (Number)calculableValue.getValue();
        if (combineValue == null) {
            if (calculable.isInitialized()) {
                return JRLongIncrementerFactory.ZERO;
            }
            return value;
        }
        if (value == null || calculable.isInitialized()) {
            value = JRLongIncrementerFactory.ZERO;
        }
        return new Long(value.longValue() + combineValue.longValue());
    }

    public Object initialValue() {
        return JRLongIncrementerFactory.ZERO;
    }
}

