/*
 * ElementFactory.java
 *
 * Created on 22 July 2004, 22:55
 */

package it.businesslogic.ireport;



/**
 *
 * @author  Robert Lamping
 */
public class ReportElementFactory {
    
    /** Creates a new instance of ElementFactory */
    public ReportElementFactory () {
    }
    
    public static ReportElement create ( int newObjectType, int originX, int originY, int width, int height) {
        // width and height can be positive and negative.
        // most elements will abs the widht and height.
        // Lines won't, because they need the direction.
        // Many ReportElement classes must all be adapted to Math.abs all incoming width and height
        
        ReportElement re = null;
        
        switch (newObjectType) {
            case ReportElementType.RECTANGLE_ELEMENT :
                re = new RectangleReportElement ( originX,originY,width,height);
                break;
            case ReportElementType.ROUND_RECTANGLE_ELEMENT:
                re = new RoundRectangleReportElement ( originX,originY,width,height);
                break;
            case  ReportElementType.ELLIPSE_ELEMENT:
                re = new EllipseReportElement ( originX,originY,width,height);
                break;
            case ReportElementType.SUBREPORT_ELEMENT:
                re = new SubReportElement ( originX,originY,width,height);
                break;
            case  ReportElementType.IMAGE_ELEMENT:
                re = new ImageReportElement ( originX,originY,width,height);
                break;
            case ReportElementType.CHART_ELEMENT:
                re = new ChartReportElement2 ( originX,originY,width,height);
                break;
            case  ReportElementType.STATICTEXT_ELEMENT:
                re = new StaticTextReportElement ( originX,originY,width,height);
                break;
            case ReportElementType.LINE_ELEMENT:
                re = new LineReportElement ( originX,originY, width, height);
                break;
            case ReportElementType.TEXTFIELD_ELEMENT:
                re = new TextFieldReportElement ( originX,originY,width,height);
                break;
            case ReportElementType.BARCODE_ELEMENT:
                re = new BarcodeReportElement (originX, originY, width, height);
                break;
            case ReportElementType.FRAME_ELEMENT:
                re = new FrameReportElement (originX, originY, width, height);
                break;
            default:
                re = new ReportElement ( originX,originY,width,height);
        }
        return re;
    }
    
}




