/*
 * PluginConfigurationFrame.java
 *
 * Created on 21 maggio 2004, 7.52
 */

package it.businesslogic.ireport.gui;

import java.util.*;
import it.businesslogic.ireport.*;
/**
 *
 * @author  Administrator
 */
public class PluginConfigurationDialog extends javax.swing.JDialog {
    
    /** Creates new form PluginConfigurationFrame */
    public PluginConfigurationDialog(javax.swing.JFrame owner ) {
        super(owner,false);
        initComponents();
        this.setSize(450, 250);
        it.businesslogic.ireport.util.Misc.centerFrame(this);
        jListPlugins.setModel(new javax.swing.DefaultListModel());
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        jScrollPane1 = new javax.swing.JScrollPane();
        jListPlugins = new javax.swing.JList();
        jPanel1 = new javax.swing.JPanel();
        jButtonConfig = new javax.swing.JButton();
        jButtonClose = new javax.swing.JButton();
        jPanel2 = new javax.swing.JPanel();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        setTitle("Plugins configuration");
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                exitForm(evt);
            }
        });

        jListPlugins.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        jListPlugins.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
                jListPluginsValueChanged(evt);
            }
        });
        jListPlugins.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jListPluginsMouseClicked(evt);
            }
        });

        jScrollPane1.setViewportView(jListPlugins);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        getContentPane().add(jScrollPane1, gridBagConstraints);

        jPanel1.setLayout(new java.awt.GridBagLayout());

        jPanel1.setMinimumSize(new java.awt.Dimension(120, 150));
        jPanel1.setPreferredSize(new java.awt.Dimension(120, 150));
        jButtonConfig.setFont(new java.awt.Font("Dialog", 0, 11));
        jButtonConfig.setText("Configure");
        jButtonConfig.setEnabled(false);
        jButtonConfig.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonConfigActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHEAST;
        gridBagConstraints.weightx = 1.0;
        jPanel1.add(jButtonConfig, gridBagConstraints);

        jButtonClose.setFont(new java.awt.Font("Dialog", 0, 11));
        jButtonClose.setText("Close");
        jButtonClose.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonCloseActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHEAST;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 0, 0);
        jPanel1.add(jButtonClose, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weighty = 1.0;
        jPanel1.add(jPanel2, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 4, 4);
        getContentPane().add(jPanel1, gridBagConstraints);

        pack();
    }//GEN-END:initComponents

    private void jListPluginsMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jListPluginsMouseClicked
        if (evt.getButton() == evt.BUTTON1 && evt.getClickCount() == 2)
        {
            jButtonConfigActionPerformed( new java.awt.event.ActionEvent(this,0,""));
        }
    }//GEN-LAST:event_jListPluginsMouseClicked

    private void jButtonConfigActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonConfigActionPerformed
        
        if (jListPlugins.getSelectedValue() == null) return;
        
        PluginEntry pe = (PluginEntry)jListPlugins.getSelectedValue();
        pe.getPlugin().configure();
        
    }//GEN-LAST:event_jButtonConfigActionPerformed

    private void jListPluginsValueChanged(javax.swing.event.ListSelectionEvent evt) {//GEN-FIRST:event_jListPluginsValueChanged
        
        if (this.jListPlugins.getSelectedValue() != null)
        {
            PluginEntry pe = (PluginEntry)jListPlugins.getSelectedValue();
            if (pe.isConfigurable())
            {
                jButtonConfig.setEnabled(true);
            }
            else
            {
                jButtonConfig.setEnabled(false);
            }
        }
        else
        {
            jButtonConfig.setEnabled(false);
        }
    }//GEN-LAST:event_jListPluginsValueChanged

    private void jButtonCloseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonCloseActionPerformed
        this.setVisible(false);
    }//GEN-LAST:event_jButtonCloseActionPerformed
    
    /** Exit the Application */
    private void exitForm(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_exitForm
        this.setVisible(false);
    }//GEN-LAST:event_exitForm

    public void setPlugins(Collection plugins)
    {
        Iterator iter = plugins.iterator();
        while (iter.hasNext())
        {
            PluginEntry pe = (PluginEntry)iter.next();
            ((javax.swing.DefaultListModel)(jListPlugins.getModel())).addElement(pe);            
        }
        
        
        //jListPlugins.setCellRenderer(this);
    }
    
    /*
    public java.awt.Component getListCellRendererComponent(javax.swing.JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        
        if (value instanceof PluginEntry)
        {
            PluginEntry pe = (PluginEntry)value;
            javax.swing.JLabel label = new javax.swing.JLabel(pe.getName(),pe.getIcon(),javax.swing.JLabel.LEFT);
            if (isSelected)
            {
                
            }
            return label;
        }
        return new javax.swing.JLabel(""+value);
    } 
     */   
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonClose;
    private javax.swing.JButton jButtonConfig;
    private javax.swing.JList jListPlugins;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JScrollPane jScrollPane1;
    // End of variables declaration//GEN-END:variables
    
}
