/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import net.sf.jasperreports.engine.JRExpressionChunk;
import net.sf.jasperreports.engine.base.JRBaseExpression;
import net.sf.jasperreports.engine.design.JRDesignExpressionChunk;

public class JRDesignExpression
extends JRBaseExpression {
    private transient PropertyChangeSupport propSupport;
    public static final String NAME_PROPERTY = "name";
    public static final String ID_PROPERTY = "id";
    public static final String VALUE_CLASS_PROPERTY = "valueClassName";
    private static final long serialVersionUID = 10101L;
    protected List chunks = new ArrayList();

    public JRDesignExpression() {
        this.regenerateId();
    }

    public void setValueClass(Class clazz) {
        this.setValueClassName(clazz.getName());
    }

    public void setValueClassName(String className) {
        String oldValue = this.valueClassName;
        this.valueClassName = className;
        this.valueClass = null;
        this.getPropertyChangeSupport().firePropertyChange(VALUE_CLASS_PROPERTY, oldValue, this.valueClassName);
    }

    public void setId(int id) {
        int oldValue = this.id;
        this.id = id;
        this.getPropertyChangeSupport().firePropertyChange(ID_PROPERTY, oldValue, this.id);
    }

    public JRExpressionChunk[] getChunks() {
        JRExpressionChunk[] chunkArray = null;
        if (this.chunks != null && this.chunks.size() > 0) {
            chunkArray = new JRExpressionChunk[this.chunks.size()];
            this.chunks.toArray(chunkArray);
        }
        return chunkArray;
    }

    public void setChunks(List chunks) {
        this.chunks.clear();
        this.chunks.addAll(chunks);
    }

    public void addChunk(JRDesignExpressionChunk chunk) {
        this.chunks.add(chunk);
    }

    public void addTextChunk(String text) {
        JRDesignExpressionChunk chunk = new JRDesignExpressionChunk();
        chunk.setType((byte)1);
        chunk.setText(text);
        this.chunks.add(chunk);
    }

    public void addParameterChunk(String text) {
        JRDesignExpressionChunk chunk = new JRDesignExpressionChunk();
        chunk.setType((byte)2);
        chunk.setText(text);
        this.chunks.add(chunk);
    }

    public void addFieldChunk(String text) {
        JRDesignExpressionChunk chunk = new JRDesignExpressionChunk();
        chunk.setType((byte)3);
        chunk.setText(text);
        this.chunks.add(chunk);
    }

    public void addVariableChunk(String text) {
        JRDesignExpressionChunk chunk = new JRDesignExpressionChunk();
        chunk.setType((byte)4);
        chunk.setText(text);
        this.chunks.add(chunk);
    }

    public void addResourceChunk(String text) {
        JRDesignExpressionChunk chunk = new JRDesignExpressionChunk();
        chunk.setType((byte)5);
        chunk.setText(text);
        this.chunks.add(chunk);
    }

    public void setText(String text) {
        this.chunks.clear();
        if (text != null) {
            int end = 0;
            StringBuffer textChunk = new StringBuffer();
            StringTokenizer tkzer = new StringTokenizer(text, "$", true);
            String token = null;
            boolean wasDelim = false;
            while (tkzer.hasMoreTokens()) {
                token = tkzer.nextToken();
                if (token.equals("$")) {
                    if (wasDelim) {
                        textChunk.append("$");
                    }
                    wasDelim = true;
                    continue;
                }
                if (token.startsWith("P{") && wasDelim) {
                    end = token.indexOf(125);
                    if (end > 0) {
                        if (textChunk.length() > 0) {
                            this.addTextChunk(textChunk.toString());
                        }
                        this.addParameterChunk(token.substring(2, end));
                        textChunk = new StringBuffer(token.substring(end + 1));
                    } else {
                        if (wasDelim) {
                            textChunk.append("$");
                        }
                        textChunk.append(token);
                    }
                } else if (token.startsWith("F{") && wasDelim) {
                    end = token.indexOf(125);
                    if (end > 0) {
                        if (textChunk.length() > 0) {
                            this.addTextChunk(textChunk.toString());
                        }
                        this.addFieldChunk(token.substring(2, end));
                        textChunk = new StringBuffer(token.substring(end + 1));
                    } else {
                        if (wasDelim) {
                            textChunk.append("$");
                        }
                        textChunk.append(token);
                    }
                } else if (token.startsWith("V{") && wasDelim) {
                    end = token.indexOf(125);
                    if (end > 0) {
                        if (textChunk.length() > 0) {
                            this.addTextChunk(textChunk.toString());
                        }
                        this.addVariableChunk(token.substring(2, end));
                        textChunk = new StringBuffer(token.substring(end + 1));
                    } else {
                        if (wasDelim) {
                            textChunk.append("$");
                        }
                        textChunk.append(token);
                    }
                } else if (token.startsWith("R{") && wasDelim) {
                    end = token.indexOf(125);
                    if (end > 0) {
                        if (textChunk.length() > 0) {
                            this.addTextChunk(textChunk.toString());
                        }
                        this.addResourceChunk(token.substring(2, end));
                        textChunk = new StringBuffer(token.substring(end + 1));
                    } else {
                        if (wasDelim) {
                            textChunk.append("$");
                        }
                        textChunk.append(token);
                    }
                } else {
                    if (wasDelim) {
                        textChunk.append("$");
                    }
                    textChunk.append(token);
                }
                wasDelim = false;
            }
            if (wasDelim) {
                textChunk.append("$");
            }
            if (textChunk.length() > 0) {
                this.addTextChunk(textChunk.toString());
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.getPropertyChangeSupport().addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.getPropertyChangeSupport().removePropertyChangeListener(l);
    }

    protected PropertyChangeSupport getPropertyChangeSupport() {
        if (this.propSupport == null) {
            this.propSupport = new PropertyChangeSupport(this);
        }
        return this.propSupport;
    }
}

