/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.sql.Connection;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDatasetParameter;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRScriptletException;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFillDataset;
import net.sf.jasperreports.engine.fill.JRFillElementDataset;
import net.sf.jasperreports.engine.fill.JRFillInterruptedException;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRFillParameter;
import net.sf.jasperreports.engine.fill.JRFillSubreport;

public class JRFillDatasetRun
implements JRDatasetRun {
    private final JRBaseFiller filler;
    private final JRFillDataset dataset;
    private JRExpression parametersMapExpression;
    private JRDatasetParameter[] parameters;
    private JRExpression connectionExpression;
    private JRExpression dataSourceExpression;

    public JRFillDatasetRun(JRBaseFiller filler, JRDatasetRun datasetRun, JRFillObjectFactory factory) {
        factory.put(datasetRun, this);
        this.filler = filler;
        this.dataset = (JRFillDataset)filler.datasetMap.get(datasetRun.getDatasetName());
        this.parametersMapExpression = datasetRun.getParametersMapExpression();
        this.parameters = datasetRun.getParameters();
        this.connectionExpression = datasetRun.getConnectionExpression();
        this.dataSourceExpression = datasetRun.getDataSourceExpression();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluate(JRFillElementDataset elementDataset, byte evaluation) throws JRException {
        Map parameterValues = JRFillSubreport.getParameterValues(this.filler, this.parametersMapExpression, this.parameters, evaluation, false);
        this.dataset.setParameters(parameterValues);
        this.dataset.setParameterValues(parameterValues);
        try {
            if (this.dataSourceExpression != null) {
                JRDataSource dataSource = (JRDataSource)this.filler.evaluateExpression(this.dataSourceExpression, evaluation);
                this.dataset.setDatasource(parameterValues, dataSource);
            } else if (this.dataset.getQuery() != null) {
                Connection connection = null;
                if (this.connectionExpression != null) {
                    connection = (Connection)this.filler.evaluateExpression(this.connectionExpression, evaluation);
                } else {
                    JRFillParameter connParam = (JRFillParameter)this.filler.getParametersMap().get("REPORT_CONNECTION");
                    connection = (Connection)connParam.getValue();
                }
                JRDataSource dataSource = this.dataset.createDataSource(parameterValues, connection);
                this.dataset.setDatasource(parameterValues, dataSource);
            } else {
                throw new JRException("Cannot instantiate data set.");
            }
            this.dataset.filterElementDatasets(elementDataset);
            this.dataset.initScriptlet();
            this.dataset.initCalculator();
            this.iterate();
        }
        finally {
            this.dataset.closeStatement();
            this.dataset.restoreElementDatasets();
        }
    }

    protected void iterate() throws JRException {
        this.dataset.start();
        this.init();
        if (this.dataset.next()) {
            this.detail();
            while (this.dataset.next()) {
                this.checkInterrupted();
                this.group();
                this.detail();
            }
        }
    }

    protected void checkInterrupted() {
        if (Thread.currentThread().isInterrupted() || this.filler.isInterrupted()) {
            this.filler.setInterrupted(true);
            throw new JRFillInterruptedException();
        }
    }

    protected void group() throws JRException, JRScriptletException {
        this.dataset.calculator.estimateGroupRuptures();
        this.dataset.scriptlet.callBeforeGroupInit();
        this.dataset.calculator.initializeVariables((byte)4);
        this.dataset.scriptlet.callAfterGroupInit();
    }

    protected void init() throws JRScriptletException, JRException {
        this.dataset.scriptlet.callBeforeReportInit();
        this.dataset.calculator.initializeVariables((byte)1);
        this.dataset.scriptlet.callAfterReportInit();
    }

    protected void detail() throws JRScriptletException, JRException {
        this.dataset.scriptlet.callBeforeDetailEval();
        this.dataset.calculator.calculateVariables();
        this.dataset.scriptlet.callAfterDetailEval();
    }

    public String getDatasetName() {
        return this.dataset.getName();
    }

    public JRExpression getParametersMapExpression() {
        return this.parametersMapExpression;
    }

    public JRDatasetParameter[] getParameters() {
        return this.parameters;
    }

    public JRExpression getConnectionExpression() {
        return this.connectionExpression;
    }

    public JRExpression getDataSourceExpression() {
        return this.dataSourceExpression;
    }

    protected JRFillDataset getDataset() {
        return this.dataset;
    }
}

