/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.undo;

import it.businesslogic.ireport.ReportElement;
import it.businesslogic.ireport.UndoOperation;
import it.businesslogic.ireport.gui.JReportFrame;
import it.businesslogic.ireport.gui.event.ReportElementChangedEvent;
import it.businesslogic.ireport.undo.PositionedElement;
import java.util.Enumeration;
import java.util.Vector;

public class DeleteElementsOperation
implements UndoOperation {
    private Vector elements = new Vector();
    private JReportFrame jrf = null;

    public DeleteElementsOperation(JReportFrame jrf) {
        this.jrf = jrf;
    }

    public void redo() {
        if (this.jrf == null) {
            return;
        }
        Enumeration e = this.getElements().elements();
        Vector<ReportElement> changed_elements = new Vector<ReportElement>();
        while (e.hasMoreElements()) {
            PositionedElement pe = (PositionedElement)e.nextElement();
            ReportElement element = pe.getElement();
            this.jrf.getSelectedElements().remove(element);
            this.jrf.getReport().getElements().remove(element);
            changed_elements.add(element);
        }
        this.jrf.fireReportListenerReportElementsChanged(new ReportElementChangedEvent(this.jrf, changed_elements, 1));
        this.jrf.getReportPanel().repaint();
    }

    public void undo() {
        if (this.jrf == null) {
            return;
        }
        Vector<ReportElement> changed_elements = new Vector<ReportElement>();
        for (int i = this.getElements().size() - 1; i >= 0; --i) {
            PositionedElement pe = (PositionedElement)this.getElements().get(i);
            ReportElement element = pe.getElement();
            this.jrf.getReport().getElements().insertElementAt(element, pe.getOldPosition());
            changed_elements.add(element);
        }
        this.jrf.fireReportListenerReportElementsChanged(new ReportElementChangedEvent(this.jrf, changed_elements, 2));
        this.jrf.setSelectedElements(changed_elements);
        this.jrf.getReportPanel().repaint();
    }

    public String toString() {
        return "delete element(s)";
    }

    public Vector getElements() {
        return this.elements;
    }

    public void setElements(Vector elements) {
        this.elements = elements;
    }

    public void addElement(ReportElement element, int position) {
        PositionedElement pe = new PositionedElement(element, position, position);
        this.getElements().add(pe);
    }
}

