/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.crosstab.gui;

import it.businesslogic.ireport.CrosstabReportElement;
import it.businesslogic.ireport.crosstab.CrosstabGroup;
import it.businesslogic.ireport.crosstab.CrosstabParameter;
import it.businesslogic.ireport.crosstab.Measure;
import it.businesslogic.ireport.gui.event.CrosstabLayoutChangedEvent;
import it.businesslogic.ireport.gui.event.CrosstabLayoutChangedListener;
import it.businesslogic.ireport.gui.library.LibraryTreeCellRenderer;
import it.businesslogic.ireport.gui.library.TreeTransfertHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class CrosstabMeasuresView
extends JPanel
implements CrosstabLayoutChangedListener {
    private CrosstabReportElement crosstabReportElement = null;
    private JScrollPane jScrollPane1;
    private JTree jTree;

    public CrosstabMeasuresView() {
        this.initComponents();
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("measures");
        DefaultTreeModel dtm = new DefaultTreeModel(root);
        this.jTree.setModel(dtm);
        this.jTree.setDragEnabled(true);
        this.jTree.setRootVisible(false);
        this.jTree.setTransferHandler(new TreeTransfertHandler());
        this.jTree.setCellRenderer(new LibraryTreeCellRenderer());
        this.jTree.expandPath(new TreePath(root));
    }

    public CrosstabReportElement getCrosstabReportElement() {
        return this.crosstabReportElement;
    }

    public void setCrosstabReportElement(CrosstabReportElement crosstabReportElement) {
        if (this.crosstabReportElement != null && this.crosstabReportElement != crosstabReportElement) {
            this.crosstabReportElement.removeCrosstabLayoutChangedListener(this);
        }
        if (crosstabReportElement != null && this.crosstabReportElement != crosstabReportElement) {
            crosstabReportElement.addCrosstabLayoutChangedListener(this);
        }
        this.crosstabReportElement = crosstabReportElement;
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.jTree.getModel().getRoot();
        root.removeAllChildren();
        if (crosstabReportElement != null) {
            CrosstabGroup group;
            int i;
            for (i = 0; i < crosstabReportElement.getRowGroups().size(); ++i) {
                group = (CrosstabGroup)crosstabReportElement.getRowGroups().elementAt(i);
                root.add(new DefaultMutableTreeNode(group));
            }
            for (i = 0; i < crosstabReportElement.getColumnGroups().size(); ++i) {
                group = (CrosstabGroup)crosstabReportElement.getColumnGroups().elementAt(i);
                root.add(new DefaultMutableTreeNode(group));
            }
            for (i = 0; i < crosstabReportElement.getMeasures().size(); ++i) {
                Measure measure = (Measure)crosstabReportElement.getMeasures().elementAt(i);
                root.add(new DefaultMutableTreeNode(measure));
            }
            for (i = 0; i < crosstabReportElement.getCrosstabParameters().size(); ++i) {
                CrosstabParameter parameter = (CrosstabParameter)crosstabReportElement.getCrosstabParameters().elementAt(i);
                root.add(new DefaultMutableTreeNode(parameter));
            }
        }
        this.jTree.expandPath(new TreePath(root));
        this.jTree.updateUI();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTree = new JTree();
        this.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView(this.jTree);
        this.add((Component)this.jScrollPane1, "Center");
    }

    public void crosstabLayoutChanged(CrosstabLayoutChangedEvent evt) {
        this.setCrosstabReportElement(this.crosstabReportElement);
    }

    public void crosstabMeasureChanged(CrosstabLayoutChangedEvent evt) {
        this.setCrosstabReportElement(this.crosstabReportElement);
    }
}

