/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.undo;

import it.businesslogic.ireport.CrosstabReportElement;
import it.businesslogic.ireport.ReportElement;
import it.businesslogic.ireport.UndoOperation;
import it.businesslogic.ireport.gui.JReportFrame;
import it.businesslogic.ireport.gui.event.ReportElementChangedEvent;
import it.businesslogic.ireport.undo.ElementTransformation;
import it.businesslogic.ireport.undo.ITransformation;
import it.businesslogic.ireport.undo.PageTransformation;
import java.util.Vector;

public class TransformElementsOperation
implements UndoOperation {
    private Vector transformations = new Vector();
    private JReportFrame jrf = null;
    private CrosstabReportElement crosstabReportElement = null;

    public TransformElementsOperation(JReportFrame jrf) {
        this.jrf = jrf;
    }

    public TransformElementsOperation(JReportFrame jrf, CrosstabReportElement crosstabReportElement) {
        this.crosstabReportElement = crosstabReportElement;
        this.jrf = jrf;
    }

    public void redo() {
        if (this.jrf == null) {
            return;
        }
        if (this.crosstabReportElement != null) {
            this.jrf.getCrosstabEditor(this.crosstabReportElement).getPanelEditor().setSelectedElement(null);
        } else {
            this.jrf.setSelectedElement(null);
        }
        Vector<ReportElement> changed_elements = new Vector<ReportElement>();
        for (int i = 0; i < this.getTransformations().size(); ++i) {
            ((UndoOperation)this.getTransformations().get(i)).redo();
            if (!(this.getTransformations().get(i) instanceof ElementTransformation)) continue;
            ElementTransformation pe = (ElementTransformation)this.getTransformations().get(i);
            ReportElement element = pe.element;
            if (this.crosstabReportElement != null) {
                this.jrf.getCrosstabEditor(this.crosstabReportElement).getPanelEditor().addSelectedElement(element, false);
            } else {
                this.jrf.addSelectedElement(element, false);
            }
            changed_elements.add(element);
        }
        this.jrf.fireReportListenerReportElementsChanged(new ReportElementChangedEvent(this.jrf, this.crosstabReportElement, changed_elements, 3));
        this.jrf.getMainFrame().getElementPropertiesDialog().updateSelection();
        this.jrf.getReportPanel().repaint();
    }

    public void undo() {
        if (this.jrf == null) {
            return;
        }
        if (this.crosstabReportElement != null) {
            this.jrf.getCrosstabEditor(this.crosstabReportElement).getPanelEditor().setSelectedElement(null);
        } else {
            this.jrf.setSelectedElement(null);
        }
        Vector<ReportElement> changed_elements = new Vector<ReportElement>();
        for (int i = 0; i < this.getTransformations().size(); ++i) {
            ((UndoOperation)this.getTransformations().get(i)).undo();
            if (!(this.getTransformations().get(i) instanceof ElementTransformation)) continue;
            ElementTransformation pe = (ElementTransformation)this.getTransformations().get(i);
            ReportElement element = pe.element;
            if (this.crosstabReportElement != null) {
                this.jrf.getCrosstabEditor(this.crosstabReportElement).getPanelEditor().addSelectedElement(element, false);
            } else {
                this.jrf.addSelectedElement(element, false);
            }
            changed_elements.add(element);
        }
        this.jrf.fireReportListenerReportElementsChanged(new ReportElementChangedEvent(this.jrf, this.crosstabReportElement, changed_elements, 3));
        this.jrf.getMainFrame().getElementPropertiesDialog().updateSelection();
        this.jrf.getReportPanel().repaint();
    }

    public String toString() {
        return "transformation";
    }

    public Vector getTransformations() {
        return this.transformations;
    }

    public void setTransformations(Vector transformations) {
        this.transformations = transformations;
    }

    public void addElement(Object object) {
        UndoOperation et = null;
        if (object instanceof ReportElement) {
            et = new ElementTransformation();
        } else if (object instanceof JReportFrame) {
            et = new PageTransformation();
        }
        try {
            this.getTransformations().add(et);
            et.captureCurrent(object);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void captureUniqueModified(Object obj) {
        int pos = this.findTransformationElement(obj);
        try {
            ((ITransformation)this.getTransformations().elementAt(pos)).captureModified(obj);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int findTransformationElement(Object object) {
        int pos = -1;
        for (int i = 0; i < this.getTransformations().size(); ++i) {
            if (!((Object)((ITransformation)this.getTransformations().get(i))).equals(object)) continue;
            pos = i;
            break;
        }
        return pos;
    }
}

