/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.io.Serializable;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.design.JRAbstractCompiler;
import net.sf.jasperreports.engine.fill.JREvaluator;
import net.sf.jasperreports.engine.util.JRClassLoader;
import org.apache.commons.collections.ReferenceMap;

public abstract class JRAbstractJavaCompiler
extends JRAbstractCompiler {
    private static ThreadLocal classFromBytesRef = new ThreadLocal();
    private static Map classCache = new ReferenceMap(0, 1);

    protected JRAbstractJavaCompiler(boolean needsSourceFiles) {
        super(needsSourceFiles);
    }

    protected JREvaluator loadEvaluator(Serializable compileData, String className) throws JRException {
        JREvaluator evaluator = null;
        try {
            Class clazz = JRAbstractJavaCompiler.getClassFromCache(className);
            if (clazz == null) {
                clazz = JRClassLoader.loadClassFromBytes(className, (byte[])compileData);
                JRAbstractJavaCompiler.putClassInCache(className, clazz);
            }
            classFromBytesRef.set(clazz);
            evaluator = (JREvaluator)clazz.newInstance();
        }
        catch (Exception e) {
            throw new JRException("Error loading expression class : " + className, e);
        }
        return evaluator;
    }

    protected static synchronized Class getClassFromCache(String className) {
        return (Class)classCache.get(className);
    }

    protected static synchronized void putClassInCache(String className, Class loadedClass) {
        classCache.put(className, loadedClass);
    }
}

