/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.fill.JREvaluationTime;

public class JRRecordedValues
implements Serializable {
    private Set evaluationTimes;
    private Map recordedVariableValues;
    private Map recordedFieldValues;

    public JRRecordedValues(Set evaluationTimes) {
        this.evaluationTimes = new HashSet(evaluationTimes);
    }

    public void doneEvaluation(JREvaluationTime evaluationTime) {
        this.evaluationTimes.remove(evaluationTime);
    }

    public boolean lastEvaluationTime() {
        return this.evaluationTimes.size() == 1;
    }

    public boolean finishedEvaluations() {
        return this.evaluationTimes.isEmpty();
    }

    public void recordVariableValue(String variableName, Object value) {
        if (this.recordedVariableValues == null) {
            this.recordedVariableValues = new HashMap();
        }
        this.recordedVariableValues.put(variableName, value);
    }

    public void recordFieldValue(String fieldName, Object value) {
        if (this.recordedFieldValues == null) {
            this.recordedFieldValues = new HashMap();
        }
        this.recordedFieldValues.put(fieldName, value);
    }

    public Map getRecordedVariableValues() {
        return this.recordedVariableValues;
    }

    public Map getRecordedFieldValues() {
        return this.recordedFieldValues;
    }
}

