/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui;

import it.businesslogic.ireport.IReportConnection;
import it.businesslogic.ireport.gui.ConnectionDialog;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.ValuesDialog;
import it.businesslogic.ireport.util.Misc;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;

public class ConnectionsDialog
extends JDialog {
    private JButton jButtonDefault;
    private JButton jButtonDeleteParameter;
    private JButton jButtonModifyParameter;
    private JButton jButtonNewParameter;
    private JPanel jPanelButtons;
    private JPanel jPanelParameters;
    private JScrollPane jScrollPane1;
    private JTable jTableParameters;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Boolean;

    public ConnectionsDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setSize(490, 250);
        DefaultListSelectionModel dlsm = (DefaultListSelectionModel)this.jTableParameters.getSelectionModel();
        dlsm.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                ConnectionsDialog.this.jTableParametersListSelectionValueChanged(e);
            }
        });
        Misc.centerFrame(this);
        DefaultTableModel dtm = (DefaultTableModel)this.jTableParameters.getModel();
        Enumeration e = MainFrame.getMainInstance().getConnections().elements();
        Object defaultConnection = MainFrame.getMainInstance().getProperties().get("DefaultConnection");
        IReportConnection default_irc = null;
        if (defaultConnection != null && defaultConnection instanceof IReportConnection) {
            default_irc = (IReportConnection)defaultConnection;
        } else if (((MainFrame)parent).getConnections().size() > 0) {
            default_irc = (IReportConnection)MainFrame.getMainInstance().getConnections().elementAt(0);
            MainFrame.getMainInstance().setActiveConnection(default_irc);
        }
        while (e.hasMoreElements()) {
            IReportConnection con = (IReportConnection)e.nextElement();
            dtm.addRow(new Object[]{con, con.getDescription(), new Boolean(default_irc == con)});
        }
    }

    public void jTableParametersListSelectionValueChanged(ListSelectionEvent e) {
        if (this.jTableParameters.getSelectedRowCount() > 0) {
            this.jButtonModifyParameter.setEnabled(true);
            this.jButtonDeleteParameter.setEnabled(true);
            this.jButtonDefault.setEnabled(true);
        } else {
            this.jButtonModifyParameter.setEnabled(false);
            this.jButtonDeleteParameter.setEnabled(false);
            this.jButtonDefault.setEnabled(false);
        }
    }

    private void initComponents() {
        this.jPanelParameters = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTableParameters = new JTable();
        this.jPanelButtons = new JPanel();
        this.jButtonNewParameter = new JButton();
        this.jButtonModifyParameter = new JButton();
        this.jButtonDeleteParameter = new JButton();
        this.jButtonDefault = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Connections / Datasources");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ConnectionsDialog.this.closeDialog(evt);
            }
        });
        this.jPanelParameters.setLayout(new BorderLayout(2, 2));
        this.jScrollPane1.setBackground(new Color(255, 255, 255));
        this.jTableParameters.setModel(new DefaultTableModel(new Object[0][], new String[]{"Name", "Datasource type", "Default"}){
            Class[] types = new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = ConnectionsDialog.class$("java.lang.Object")) : class$java$lang$Object, class$java$lang$Object == null ? (class$java$lang$Object = ConnectionsDialog.class$("java.lang.Object")) : class$java$lang$Object, class$java$lang$Boolean == null ? (class$java$lang$Boolean = ConnectionsDialog.class$("java.lang.Boolean")) : class$java$lang$Boolean};
            boolean[] canEdit = new boolean[]{false, false, false};

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jTableParameters.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ConnectionsDialog.this.jTableParametersMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTableParameters);
        this.jPanelParameters.add((Component)this.jScrollPane1, "Center");
        this.jPanelButtons.setLayout(new GridBagLayout());
        this.jPanelButtons.setMinimumSize(new Dimension(100, 10));
        this.jPanelButtons.setPreferredSize(new Dimension(100, 10));
        this.jButtonNewParameter.setText("New");
        this.jButtonNewParameter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConnectionsDialog.this.jButtonNewParameterActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanelButtons.add((Component)this.jButtonNewParameter, gridBagConstraints);
        this.jButtonModifyParameter.setText("Modify");
        this.jButtonModifyParameter.setEnabled(false);
        this.jButtonModifyParameter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConnectionsDialog.this.jButtonModifyParameterActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 3, 5, 3);
        this.jPanelButtons.add((Component)this.jButtonModifyParameter, gridBagConstraints);
        this.jButtonDeleteParameter.setText("Delete");
        this.jButtonDeleteParameter.setEnabled(false);
        this.jButtonDeleteParameter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConnectionsDialog.this.jButtonDeleteParameterActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 5, 3);
        this.jPanelButtons.add((Component)this.jButtonDeleteParameter, gridBagConstraints);
        this.jButtonDefault.setText("Set as default");
        this.jButtonDefault.setActionCommand("Set as active");
        this.jButtonDefault.setEnabled(false);
        this.jButtonDefault.setMargin(new Insets(2, 4, 2, 4));
        this.jButtonDefault.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConnectionsDialog.this.jButtonDeleteParameterActionPerformed1(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(8, 3, 5, 3);
        this.jPanelButtons.add((Component)this.jButtonDefault, gridBagConstraints);
        this.jPanelParameters.add((Component)this.jPanelButtons, "East");
        this.getContentPane().add((Component)this.jPanelParameters, "Center");
        this.pack();
    }

    private void jTableParametersMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            if (evt.getButton() == 1) {
                this.jButtonModifyParameterActionPerformed(null);
            }
        }
    }

    private void jButtonDeleteParameterActionPerformed1(ActionEvent evt) {
        if (this.jTableParameters.getSelectedRowCount() > 0) {
            IReportConnection irc = null;
            try {
                irc = (IReportConnection)this.jTableParameters.getModel().getValueAt(this.jTableParameters.getSelectedRow(), 0);
                MainFrame.getMainInstance().setActiveConnection(irc);
                this.jTableParameters.getModel().setValueAt(new Boolean(true), this.jTableParameters.getSelectedRow(), 2);
                for (int i = 0; i < this.jTableParameters.getRowCount(); ++i) {
                    if (i == this.jTableParameters.getSelectedRow()) continue;
                    this.jTableParameters.getModel().setValueAt(new Boolean(false), i, 2);
                }
            }
            catch (Exception ex) {
                return;
            }
        }
    }

    private void jButtonDeleteParameterActionPerformed(ActionEvent evt) {
        if (this.jTableParameters.getSelectedRowCount() > 0) {
            IReportConnection irc = null;
            try {
                irc = (IReportConnection)this.jTableParameters.getModel().getValueAt(this.jTableParameters.getSelectedRow(), 0);
            }
            catch (Exception ex) {
                return;
            }
            if (MainFrame.getMainInstance().getProperties().get("DefaultConnection") == irc) {
                MainFrame.getMainInstance().getProperties().remove("DefaultConnection");
            }
            MainFrame.getMainInstance().getConnections().removeElement(irc);
            MainFrame.getMainInstance().saveiReportConfiguration();
            ((DefaultTableModel)this.jTableParameters.getModel()).removeRow(this.jTableParameters.getSelectedRow());
            this.jTableParameters.updateUI();
        }
    }

    private void jButtonModifyParameterActionPerformed(ActionEvent evt) {
        Frame parent = Misc.frameFromComponent(this);
        ConnectionDialog cd = new ConnectionDialog(parent, false);
        if (this.jTableParameters.getSelectedRow() < 0) {
            return;
        }
        IReportConnection irc = null;
        try {
            irc = (IReportConnection)this.jTableParameters.getModel().getValueAt(this.jTableParameters.getSelectedRow(), 0);
        }
        catch (Exception ex) {
            return;
        }
        if (irc == null) {
            return;
        }
        cd.setIReportConnection(irc);
        cd.show();
        if (cd.getDialogResult() == 0) {
            IReportConnection con = cd.getIReportConnection();
            try {
                this.jTableParameters.getModel().setValueAt(con, this.jTableParameters.getSelectedRow(), 0);
                this.jTableParameters.getModel().setValueAt(con.getDescription(), this.jTableParameters.getSelectedRow(), 1);
            }
            catch (Exception ex) {
                return;
            }
            if (MainFrame.getMainInstance().getProperties().get("DefaultConnection") == irc) {
                MainFrame.getMainInstance().getProperties().put("DefaultConnection", con);
            }
            MainFrame.getMainInstance().getConnections().setElementAt(con, MainFrame.getMainInstance().getConnections().indexOf(irc));
            MainFrame.getMainInstance().saveiReportConfiguration();
        }
    }

    private void jButtonNewParameterActionPerformed(ActionEvent evt) {
        Frame parent = Misc.frameFromComponent(this);
        ConnectionDialog cd = new ConnectionDialog(parent, false);
        cd.show();
        if (cd.getDialogResult() == 0) {
            IReportConnection con = cd.getIReportConnection();
            DefaultTableModel dtm = (DefaultTableModel)this.jTableParameters.getModel();
            dtm.addRow(new Object[]{con, con.getDescription()});
            MainFrame.getMainInstance().getConnections().addElement(con);
            MainFrame.getMainInstance().saveiReportConfiguration();
        }
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
    }

    public static void main(String[] args) {
        new ValuesDialog((Frame)new JFrame(), true).show();
    }

    public void updateConnections() {
    }

    public void setVisible(boolean visible) {
        this.updateConnections();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

