/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.docking;

import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.docking.DockingContainer;
import it.businesslogic.ireport.gui.docking.PanelTransferable;
import it.businesslogic.ireport.gui.docking.PanelView;
import java.awt.Font;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;

public class JDraggableTabbedPane
extends JTabbedPane {
    private JMenuItem jMenuItemMerge;
    private JMenuItem jMenuItemUnmerge;
    private JPopupMenu jPopupMenu;
    private DockingContainer dockingContainer = null;
    private int position = 0;
    private DragSource dragSource = DragSource.getDefaultDragSource();
    private DragGestureListener dgListener = new DGListener();
    private DragSourceListener dsListener = new DSListener();
    private DropTarget dropTarget;
    private DropTargetListener dtListener = new DTListener();
    private int dragAction = 2;
    private int acceptableActions = 2;
    static /* synthetic */ Class class$it$businesslogic$ireport$gui$docking$PanelView;

    public JDraggableTabbedPane() {
        this.dropTarget = new DropTarget(this, this.acceptableActions, this.dtListener, true);
        this.dragSource.createDefaultDragGestureRecognizer(this, this.dragAction, this.dgListener);
        this.jPopupMenu = new JPopupMenu();
        this.jMenuItemMerge = new JMenuItem();
        this.jMenuItemMerge.setFont(new Font("Tahoma", 0, 11));
        this.jMenuItemMerge.setText("Merge panels");
        this.jMenuItemMerge.setEnabled(true);
        this.jMenuItemMerge.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JDraggableTabbedPane.this.jMenuItemMergeActionPerformed(evt);
            }
        });
        this.jPopupMenu.add(this.jMenuItemMerge);
        this.jMenuItemUnmerge = new JMenuItem();
        this.jMenuItemUnmerge.setFont(new Font("Tahoma", 0, 11));
        this.jMenuItemUnmerge.setText("Separate panel");
        this.jMenuItemUnmerge.setEnabled(true);
        this.jMenuItemUnmerge.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JDraggableTabbedPane.this.jMenuItemUnmergeActionPerformed(evt);
            }
        });
        this.jPopupMenu.add(this.jMenuItemUnmerge);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                JDraggableTabbedPane.this.onMouseClicked(evt);
            }
        });
    }

    private void jMenuItemUnmergeActionPerformed(ActionEvent evt) {
        PanelView pv = new PanelView(this.getTitleAt(this.getSelectedIndex()), this.getSelectedComponent(), this.getPosition());
        this.getDockingContainer().moveComponent(pv, pv.getPosition(), 1);
    }

    private void jMenuItemMergeActionPerformed(ActionEvent evt) {
        this.getDockingContainer().mergePosition(this.getPosition());
    }

    public void onMouseClicked(MouseEvent evt) {
        if (evt.getButton() == 3 && evt.getClickCount() == 1) {
            this.jPopupMenu.show(this, evt.getPoint().x, evt.getPoint().y);
        }
    }

    public DockingContainer getDockingContainer() {
        return this.dockingContainer;
    }

    public void setDockingContainer(DockingContainer dockingContainer) {
        this.dockingContainer = dockingContainer;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class DTListener
    implements DropTargetListener {
        DTListener() {
        }

        public void dragEnter(DropTargetDragEvent e) {
            e.acceptDrag(e.getDropAction());
        }

        public void dragOver(DropTargetDragEvent e) {
            e.acceptDrag(e.getDropAction());
        }

        public void dropActionChanged(DropTargetDragEvent e) {
        }

        public void dragExit(DropTargetEvent e) {
        }

        public void drop(DropTargetDropEvent dtde) {
            try {
                DropTargetContext context = dtde.getDropTargetContext();
                Transferable tr = dtde.getTransferable();
                DataFlavor[] df = tr.getTransferDataFlavors();
                if (tr.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    dtde.acceptDrop(3);
                    List fileList = (List)tr.getTransferData(DataFlavor.javaFileListFlavor);
                    MainFrame.getMainInstance().openFiles(fileList);
                } else if (df[0].getHumanPresentableName().equals("it.businesslogic.ireport.gui.docking.PanelView")) {
                    DataFlavor myFlavor = new DataFlavor(class$it$businesslogic$ireport$gui$docking$PanelView == null ? (class$it$businesslogic$ireport$gui$docking$PanelView = JDraggableTabbedPane.class$("it.businesslogic.ireport.gui.docking.PanelView")) : class$it$businesslogic$ireport$gui$docking$PanelView, (class$it$businesslogic$ireport$gui$docking$PanelView == null ? (class$it$businesslogic$ireport$gui$docking$PanelView = JDraggableTabbedPane.class$("it.businesslogic.ireport.gui.docking.PanelView")) : class$it$businesslogic$ireport$gui$docking$PanelView).getName());
                    PanelView panelView = (PanelView)tr.getTransferData(myFlavor);
                    if (JDraggableTabbedPane.this.getDockingContainer() == panelView.getDockingContainer()) {
                        if (panelView.getPosition() != JDraggableTabbedPane.this.getPosition()) {
                            JDraggableTabbedPane.this.getDockingContainer().moveComponent(panelView, JDraggableTabbedPane.this.getPosition());
                        }
                    } else {
                        panelView.getDockingContainer().removePanel(panelView.getComponent());
                        JDraggableTabbedPane.this.getDockingContainer().insertPanel(JDraggableTabbedPane.this.getPosition(), panelView.getName(), panelView.getComponent());
                    }
                }
                context.dropComplete(true);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    class DSListener
    implements DragSourceListener {
        DSListener() {
        }

        public void dragDropEnd(DragSourceDropEvent e) {
        }

        public void dragEnter(DragSourceDragEvent e) {
            DragSourceContext context = e.getDragSourceContext();
            int myaction = e.getDropAction();
            if ((myaction & JDraggableTabbedPane.this.dragAction) != 0) {
                context.setCursor(DragSource.DefaultCopyDrop);
            } else {
                context.setCursor(DragSource.DefaultCopyNoDrop);
            }
        }

        public void dragOver(DragSourceDragEvent e) {
            DragSourceContext context = e.getDragSourceContext();
            int sa = context.getSourceActions();
            int ua = e.getUserAction();
            int da = e.getDropAction();
            int ta = e.getTargetActions();
        }

        public void dragExit(DragSourceEvent e) {
        }

        public void dropActionChanged(DragSourceDragEvent e) {
            DragSourceContext context = e.getDragSourceContext();
            context.setCursor(DragSource.DefaultCopyNoDrop);
        }
    }

    class DGListener
    implements DragGestureListener {
        DGListener() {
        }

        public void dragGestureRecognized(DragGestureEvent e) {
            if ((e.getDragAction() & JDraggableTabbedPane.this.dragAction) == 0) {
                return;
            }
            if (JDraggableTabbedPane.this.getSelectedIndex() < 0) {
                return;
            }
            PanelView pv = new PanelView(JDraggableTabbedPane.this.getTitleAt(JDraggableTabbedPane.this.getSelectedIndex()), JDraggableTabbedPane.this.getSelectedComponent(), JDraggableTabbedPane.this.getPosition());
            pv.setDockingContainer(JDraggableTabbedPane.this.getDockingContainer());
            PanelTransferable transferable = new PanelTransferable(pv);
            try {
                e.startDrag(DragSource.DefaultCopyNoDrop, transferable, JDraggableTabbedPane.this.dsListener);
            }
            catch (InvalidDnDOperationException idoe) {
                // empty catch block
            }
        }
    }
}

