/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.style;

import it.businesslogic.ireport.Box;
import it.businesslogic.ireport.IReportFont;
import it.businesslogic.ireport.ReportElement;
import it.businesslogic.ireport.Style;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.util.Java2DUtil;
import it.businesslogic.ireport.util.Misc;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.JPanel;

public class JPanelStyleSample
extends JPanel {
    private Style style = null;
    public static Rotation ROTATION_NONE = new Rotation("None", 0);
    public static Rotation ROTATION_LEFT = new Rotation("Left", 1);
    public static Rotation ROTATION_RIGHT = new Rotation("Right", 2);

    public JPanelStyleSample() {
        this.initComponents();
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style) {
        this.style = style;
        this.repaint();
    }

    private void initComponents() {
        this.setLayout(null);
    }

    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2 = (Graphics2D)g;
        if (this.getStyle() == null) {
            return;
        }
        if (this.getSize().getWidth() <= 10.0) {
            return;
        }
        if (this.getSize().getHeight() <= 10.0) {
            return;
        }
        int x = 5;
        int y = 5;
        int width = (int)this.getSize().getWidth() - 10;
        int heigth = (int)this.getSize().getHeight() - 10;
        if (MainFrame.getMainInstance().getProperties().getProperty("Antialias", "true").equals("false")) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            g2.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
        } else {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT);
            g2.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        }
        int round = Integer.parseInt(this.getStyle().getAttributeString("radius", "0"));
        round *= 2;
        Color c = this.getStyle().getAttributeColor("backcolor", null);
        String transparent = this.getStyle().getAttributeString("mode", "Transparent");
        if (c != null && !transparent.equals("Transparent")) {
            g2.setColor(c);
            g2.fillRoundRect(x, y, width, heigth, round, round);
        }
        c = this.getStyle().getAttributeColor("forecolor", null);
        Stroke stroke = ReportElement.getPenStroke(this.getStyle().getAttributeString("pen", "Thin"), 1.0);
        if (c != null && stroke != null) {
            g2.setStroke(stroke);
            g2.setColor(c);
            g2.drawRoundRect(x, y, width, heigth, round, round);
        }
        Box box = new Box();
        if (this.style.getAttributeString("border", null, true) != null) {
            box.setBorder(this.style.getAttributeString("border", null, true));
        }
        if (this.style.getAttributeColor("borderColor", null, true) != null) {
            box.setBorderColor(this.style.getAttributeColor("borderColor", null, true));
        }
        if (this.style.getAttributeString("padding", null, true) != null) {
            box.setPadding(Integer.parseInt(this.style.getAttributeString("padding", null, true)));
        }
        if (this.style.getAttributeString("topBorder", null, true) != null) {
            box.setTopBorder(this.style.getAttributeString("topBorder", null, true));
        }
        if (this.style.getAttributeColor("topBorderColor", null, true) != null) {
            box.setTopBorderColor(this.style.getAttributeColor("topBorderColor", null, true));
        }
        if (this.style.getAttributeString("topPadding", null, true) != null) {
            box.setTopPadding(Integer.parseInt(this.style.getAttributeString("topPadding", null, true)));
        }
        if (this.style.getAttributeString("leftBorder", null, true) != null) {
            box.setLeftBorder(this.style.getAttributeString("leftBorder", null, true));
        }
        if (this.style.getAttributeColor("leftBorderColor", null, true) != null) {
            box.setLeftBorderColor(this.style.getAttributeColor("leftBorderColor", null, true));
        }
        if (this.style.getAttributeString("leftPadding", null, true) != null) {
            box.setLeftPadding(Integer.parseInt(this.style.getAttributeString("leftPadding", null, true)));
        }
        if (this.style.getAttributeString("rightBorder", null, true) != null) {
            box.setRightBorder(this.style.getAttributeString("rightBorder", null, true));
        }
        if (this.style.getAttributeColor("rightBorderColor", null, true) != null) {
            box.setRightBorderColor(this.style.getAttributeColor("rightBorderColor", null, true));
        }
        if (this.style.getAttributeString("rightPadding", null, true) != null) {
            box.setRightPadding(Integer.parseInt(this.style.getAttributeString("rightPadding", null, true)));
        }
        if (this.style.getAttributeString("bottomBorder", null, true) != null) {
            box.setBottomBorder(this.style.getAttributeString("bottomBorder", null, true));
        }
        if (this.style.getAttributeColor("bottomBorderColor", null, true) != null) {
            box.setBottomBorderColor(this.style.getAttributeColor("bottomBorderColor", null, true));
        }
        if (this.style.getAttributeString("bottomPadding", null, true) != null) {
            box.setBottomPadding(Integer.parseInt(this.style.getAttributeString("bottomPadding", null, true)));
        }
        int ax = x;
        int ay = y;
        int bx = x + width;
        int by = y + heigth;
        Stroke newBoxStroke = null;
        if (box.getLeftBorderColor() != null) {
            g2.setColor(box.getLeftBorderColor());
        } else {
            g2.setColor(g2.getBackground());
        }
        newBoxStroke = ReportElement.getPenStroke(box.getLeftBorder(), 1.0);
        if (newBoxStroke != null) {
            g2.setStroke(newBoxStroke);
            g2.drawLine(x, y, x + width, y + heigth);
        }
        if (box.getTopBorderColor() != null) {
            g2.setColor(box.getTopBorderColor());
        } else {
            g2.setColor(g2.getBackground());
        }
        newBoxStroke = ReportElement.getPenStroke(box.getTopBorder(), 1.0);
        if (newBoxStroke != null) {
            g2.setStroke(newBoxStroke);
            g2.drawLine(ax, ay, bx, ay);
        }
        if (box.getRightBorderColor() != null) {
            g2.setColor(box.getRightBorderColor());
        } else {
            g2.setColor(g2.getBackground());
        }
        newBoxStroke = ReportElement.getPenStroke(box.getRightBorder(), 1.0);
        if (newBoxStroke != null) {
            g2.setStroke(newBoxStroke);
            g2.drawLine(bx, ay, bx, by);
        }
        if (box.getBottomBorderColor() != null) {
            g2.setColor(box.getBottomBorderColor());
        } else {
            g2.setColor(g2.getBackground());
        }
        newBoxStroke = ReportElement.getPenStroke(box.getBottomBorder(), 1.0);
        if (newBoxStroke != null) {
            g2.setStroke(newBoxStroke);
            g2.drawLine(ax, by, bx, by);
        }
        this.renderText(g2, "This is a\ntest", this.getStyle(), new Box(), width, heigth);
    }

    public static IReportFont createIreportFont(Style myStyle) {
        if (myStyle.getAttribute("style.font") != null) {
            return (IReportFont)myStyle.getAttribute("style.font");
        }
        IReportFont ir = new IReportFont();
        ir.setBold(myStyle.getAttributeBoolean("isBold", false));
        ir.setFontName(myStyle.getAttributeString("fontName", ir.getFontName()));
        ir.setFontSize(myStyle.getAttributeInteger("fontSize", ir.getFontSize()));
        ir.setItalic(myStyle.getAttributeBoolean("isItalic", false));
        ir.setPdfEmbedded(myStyle.getAttributeBoolean("isPdfEmbedded", false));
        ir.setPdfEncoding(myStyle.getAttributeString("pdfEncoding", ir.getPdfEncoding()));
        ir.setStrikeTrought(myStyle.getAttributeBoolean("isStrikeThrough", false));
        ir.setPDFFontName(myStyle.getAttributeString("pdfFontName", ir.getPDFFontName()));
        ir.setUnderline(myStyle.getAttributeBoolean("isUnderline", false));
        return ir;
    }

    public void renderText(Graphics2D g, String str, Style s, Box box, int width, int height) {
        IReportFont ir = JPanelStyleSample.createIreportFont(s);
        Font font = ir.getJavaAWTFont();
        double zoom_factor = 1.0;
        int x_shift_origin = 0;
        int y_shift_origin = 0;
        Point position = new Point(5, 5);
        g.setColor(s.getAttributeColor("forecolor", Color.BLACK));
        int gfx_x = position.x + box.getLeftPadding() - x_shift_origin;
        int gfx_y = position.y + box.getTopPadding() - y_shift_origin;
        int gfx_width = width - box.getLeftPadding() - box.getRightPadding();
        int gfx_height = height - box.getTopPadding() - box.getBottomPadding();
        Java2DUtil.setClip(g, gfx_x, gfx_y, gfx_width, gfx_height);
        double angle = 0.0;
        double angle_restore = 0.0;
        AffineTransform transform = null;
        if (s.getAttributeString("rotation", "None").equals(ROTATION_LEFT.getName())) {
            transform = new AffineTransform();
            transform.rotate(-1.5707963267948966, gfx_x, gfx_y);
            transform.translate(-gfx_height, -gfx_height);
            gfx_y = position.y - y_shift_origin + height;
            gfx_width = height;
            gfx_height = width;
            Java2DUtil.setTransform(g, transform);
        } else if (s.getAttributeString("rotation", "None").equals(ROTATION_RIGHT.getName())) {
            transform = new AffineTransform();
            transform.rotate(1.5707963267948966, gfx_x, gfx_y);
            transform.translate(0.0, -gfx_width);
            gfx_x = position.x - x_shift_origin + width;
            gfx_width = height;
            gfx_height = width;
            Java2DUtil.setTransform(g, transform);
        }
        if (str != null && str.length() > 0) {
            TextReportElementLayout textReportElementLayout;
            int zoomedFieldHeight = gfx_height;
            String allText = Misc.treatNewLineChars(str);
            float formatWidth = gfx_width;
            float verticalOffset = 0.0f;
            FontRenderContext fontRenderContext = g.getFontRenderContext();
            Map<TextAttribute, ?> fontAttributes = font.getAttributes();
            fontAttributes.put(TextAttribute.SIZE, new Float(ir.getFontSize()));
            fontAttributes.put(TextAttribute.FAMILY, ir.getFontName());
            if (ir.isBold()) {
                fontAttributes.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
            }
            if (ir.isItalic()) {
                fontAttributes.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
            }
            if (ir.isUnderline()) {
                fontAttributes.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            }
            if (ir.isStrikeTrought()) {
                fontAttributes.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
            }
            float lineSpacing = 1.0f;
            String lineSpacingName = s.getAttributeString("lineSpacing", "Single");
            if (lineSpacingName.equals("Single")) {
                lineSpacing = 1.0f;
            } else if (lineSpacingName.equals("1_1_2")) {
                lineSpacing = 1.5f;
            } else if (lineSpacingName.equals("Double")) {
                lineSpacing = 2.0f;
            }
            TextLayout layout = null;
            String paragr_text = "";
            boolean isMaxHeightReached = false;
            StringTokenizer tkzer = new StringTokenizer(allText, "\n");
            float drawPosY = 0.0f;
            float drawPosX = 0.0f;
            paragr_text = "";
            isMaxHeightReached = false;
            tkzer = new StringTokenizer(allText, "\n");
            ArrayList<TextReportElementLayout> textLayouts = new ArrayList<TextReportElementLayout>();
            while (tkzer.hasMoreTokens() && !isMaxHeightReached) {
                paragr_text = tkzer.nextToken();
                AttributedString atext = new AttributedString(paragr_text, fontAttributes);
                AttributedCharacterIterator paragraph = atext.getIterator();
                int paragraphStart = paragraph.getBeginIndex();
                int paragraphEnd = paragraph.getEndIndex();
                LineBreakMeasurer lineMeasurer = new LineBreakMeasurer(paragraph, fontRenderContext);
                lineMeasurer.setPosition(paragraphStart);
                layout = null;
                while (lineMeasurer.getPosition() < paragraphEnd && !isMaxHeightReached) {
                    layout = lineMeasurer.nextLayout(formatWidth);
                    if ((drawPosY += layout.getLeading() + lineSpacing * layout.getAscent()) + layout.getDescent() <= (float)(zoomedFieldHeight + 1)) {
                        if (s.getAttributeString("hAlign", "Left").equals("Justify")) {
                            drawPosX = layout.isLeftToRight() ? 0.0f : formatWidth - layout.getAdvance();
                            if (lineMeasurer.getPosition() < paragraphEnd) {
                                layout = layout.getJustifiedLayout(formatWidth);
                            }
                        } else {
                            drawPosX = s.getAttributeString("hAlign", "Left").equals("Right") ? (layout.isLeftToRight() ? formatWidth - layout.getAdvance() : formatWidth) : (s.getAttributeString("hAlign", "Left").equals("Center") ? (formatWidth - layout.getAdvance()) / 2.0f : (layout.isLeftToRight() ? 0.0f : formatWidth - layout.getAdvance()));
                        }
                        float x = drawPosX + (float)gfx_x;
                        float y = drawPosY + (float)gfx_y;
                        textReportElementLayout = new TextReportElementLayout(layout, x, y);
                        textLayouts.add(textReportElementLayout);
                        drawPosY += layout.getDescent();
                        continue;
                    }
                    drawPosY -= layout.getLeading() + lineSpacing * layout.getAscent();
                    isMaxHeightReached = true;
                }
            }
            float textHeight = drawPosY;
            if (s.getAttributeString("vAlign", "Top").equals("Top")) {
                verticalOffset = 0.0f;
            } else if (s.getAttributeString("vAlign", "Top").equals("Middle")) {
                verticalOffset = ((float)zoomedFieldHeight - textHeight) / 2.0f;
            } else if (s.getAttributeString("vAlign", "Top").equals("Bottom")) {
                verticalOffset = (float)zoomedFieldHeight - textHeight;
            }
            Iterator i = textLayouts.iterator();
            while (i.hasNext()) {
                textReportElementLayout = (TextReportElementLayout)i.next();
                textReportElementLayout.drawWithOffset(g, verticalOffset);
            }
            if (transform != null) {
                Java2DUtil.resetTransform(g);
            }
        }
        Java2DUtil.resetClip(g);
    }

    static List getRotations() {
        return Rotation.rotations;
    }

    static class Rotation {
        private static ArrayList rotations;
        private String name;
        private int number;

        Rotation(String name, int number) {
            this.name = name;
            this.number = number;
            rotations = new ArrayList();
            rotations.add(this);
        }

        public int getNumber() {
            return this.number;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.getName();
        }
    }

    private class TextReportElementLayout {
        private TextLayout layout;
        private float x;
        private float y;

        private TextReportElementLayout(TextLayout layout, float x, float y) {
            this.layout = layout;
            this.x = x;
            this.y = y;
        }

        void drawWithOffset(Graphics2D g2, float yOffset) {
            this.layout.draw(g2, this.x, this.y + yOffset);
        }
    }
}

