/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.hibernate;

import bsh.EvalError;
import bsh.Interpreter;
import it.businesslogic.ireport.JRField;
import it.businesslogic.ireport.JRParameter;
import it.businesslogic.ireport.gui.ReportQueryDialog;
import it.businesslogic.ireport.util.Misc;
import java.beans.PropertyDescriptor;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.classic.Session;
import org.hibernate.type.Type;

public class HQLFieldsReader {
    private static final Map hibernateTypeMap = new HashMap();
    private Interpreter interpreter = null;
    private Vector reportParameters = null;
    private String queryString = "";
    private HashMap queryParameters = new HashMap();
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$util$Collection;

    public HQLFieldsReader(String query, Vector reportParameters) {
        this.setQueryString(query);
        this.setReportParameters(reportParameters);
    }

    public String prepareQuery() throws Exception {
        System.out.println(this.getReportParameters());
        Enumeration enumParams = this.getReportParameters().elements();
        while (enumParams.hasMoreElements()) {
            Object paramVal;
            JRParameter param = (JRParameter)enumParams.nextElement();
            String parameterName = param.getName();
            if (this.queryString.indexOf("$P!{" + parameterName + "}") > 0) {
                paramVal = ReportQueryDialog.recursiveInterpreter(this.getInterpreter(), param.getDefaultValueExpression(), this.getReportParameters());
                if (paramVal == null) {
                    paramVal = "";
                }
                this.queryString = Misc.string_replace("" + paramVal, "$P!{" + parameterName + "}", this.queryString);
                continue;
            }
            if (this.getQueryString().indexOf("$P{" + parameterName + "}") <= 0) continue;
            paramVal = ReportQueryDialog.recursiveInterpreter(this.getInterpreter(), param.getDefaultValueExpression(), this.getReportParameters());
            String parameterReplacement = "_" + HQLFieldsReader.getLiteral(parameterName);
            this.queryParameters.put(parameterReplacement, paramVal);
            this.queryString = Misc.string_replace(":" + parameterReplacement, "$P{" + parameterName + "}", this.queryString);
            System.out.println(this.queryString);
        }
        return this.queryString;
    }

    /*
     * Loose catch block
     */
    public Vector readFields() throws Exception {
        Exception ex22;
        Vector<JRField> vector;
        Transaction transaction;
        Session hb_session;
        block21: {
            this.prepareQuery();
            SessionFactory hb_sessionFactory = null;
            hb_session = null;
            transaction = null;
            hb_sessionFactory = new Configuration().configure().buildSessionFactory();
            if (hb_sessionFactory == null) {
                throw new Exception("Problem creating the SessionFactory for Hibernate");
            }
            hb_session = hb_sessionFactory.openSession();
            if (hb_session == null) {
                throw new Exception("Problem creating the Session object for Hibernate");
            }
            transaction = hb_session.beginTransaction();
            Query q = hb_session.createQuery(this.getQueryString());
            Iterator paramIterator = this.queryParameters.keySet().iterator();
            while (paramIterator.hasNext()) {
                String hqlParamName = "" + paramIterator.next();
                this.setParameter(hb_session, q, hqlParamName, this.queryParameters.get(hqlParamName));
            }
            q.setFetchSize(1);
            Iterator iterator = q.iterate();
            iterator.next();
            String[] aliases = q.getReturnAliases();
            Type[] types = q.getReturnTypes();
            Vector<JRField> fields = new Vector<JRField>();
            for (int i = 0; i < types.length; ++i) {
                JRField field;
                if (types[i].isComponentType() || types[i].isEntityType()) {
                    String aliasName = null;
                    if (aliases != null && aliases.length > i && !aliases[i].equals(i + "")) {
                        aliasName = aliases[i];
                        field = new JRField(aliases[i], types[i].getReturnedClass().getName());
                        field.setDescription(aliases[i]);
                        fields.add(field);
                    }
                    PropertyDescriptor[] pd = PropertyUtils.getPropertyDescriptors((Class)types[i].getReturnedClass());
                    for (int nd = 0; nd < pd.length; ++nd) {
                        String fieldName = pd[nd].getName();
                        if (pd[nd].getPropertyType() == null || pd[nd].getReadMethod() == null || fieldName.equals("class")) continue;
                        String returnType = pd[nd].getPropertyType().getName();
                        JRField field2 = new JRField(fieldName, returnType);
                        if (types.length > 1 && aliasName != null) {
                            fieldName = aliasName + "." + fieldName;
                            field2.setDescription(fieldName);
                        }
                        fields.add(field2);
                    }
                    continue;
                }
                String fieldName = types[i].getName();
                if (aliases != null && aliases.length > i && !aliases[i].equals("" + i)) {
                    fieldName = aliases[i];
                }
                field = new JRField(fieldName, types[i].getReturnedClass().getName());
                field.setDescription("");
                fields.add(field);
            }
            vector = fields;
            Object var18_19 = null;
            if (transaction == null) break block21;
            try {
                transaction.rollback();
            }
            catch (Exception ex22) {
                // empty catch block
            }
        }
        if (hb_session != null) {
            try {
                hb_session.close();
            }
            catch (Exception ex22) {
                // empty catch block
            }
        }
        return vector;
        catch (Exception ex3) {
            try {
                ex3.printStackTrace();
                throw ex3;
            }
            catch (Throwable throwable) {
                block23: {
                    Exception ex22;
                    Object var18_20 = null;
                    if (transaction != null) {
                        try {
                            transaction.rollback();
                        }
                        catch (Exception ex22) {
                            // empty catch block
                        }
                    }
                    if (hb_session == null) break block23;
                    try {
                        hb_session.close();
                    }
                    catch (Exception ex22) {}
                }
                throw throwable;
            }
        }
    }

    protected void setParameter(Session session, Query query, String hqlParamName, Object parameterValue) throws Exception {
        if (parameterValue == null) {
            System.out.println("Parameter: " + hqlParamName);
            query.setParameter(hqlParamName, parameterValue);
            return;
        }
        Class<?> clazz = parameterValue.getClass();
        Type type = (Type)hibernateTypeMap.get(clazz);
        if (type != null) {
            query.setParameter(hqlParamName, parameterValue, type);
        } else if ((class$java$util$Collection == null ? (class$java$util$Collection = HQLFieldsReader.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(clazz)) {
            query.setParameterList(hqlParamName, (Collection)parameterValue);
        } else if (session.getSessionFactory().getClassMetadata(clazz) != null) {
            query.setEntity(hqlParamName, parameterValue);
        } else {
            query.setParameter(hqlParamName, parameterValue);
        }
    }

    private Interpreter prepareExpressionEvaluator() throws EvalError {
        Interpreter interpreter = new Interpreter();
        interpreter.setClassLoader(interpreter.getClass().getClassLoader());
        return interpreter;
    }

    public static String getLiteral(String name) {
        if (HQLFieldsReader.isValidLiteral(name)) {
            return name;
        }
        StringBuffer buffer = new StringBuffer(name.length() + 5);
        char[] literalChars = new char[name.length()];
        name.getChars(0, literalChars.length, literalChars, 0);
        for (int i = 0; i < literalChars.length; ++i) {
            if (i == 0 && !Character.isJavaIdentifierStart(literalChars[i])) {
                buffer.append((int)literalChars[i]);
                continue;
            }
            if (i != 0 && !Character.isJavaIdentifierPart(literalChars[i])) {
                buffer.append((int)literalChars[i]);
                continue;
            }
            buffer.append(literalChars[i]);
        }
        return buffer.toString();
    }

    private static boolean isValidLiteral(String literal) {
        boolean result = true;
        char[] literalChars = new char[literal.length()];
        literal.getChars(0, literalChars.length, literalChars, 0);
        for (int i = 0; i < literalChars.length; ++i) {
            if (i == 0 && !Character.isJavaIdentifierStart(literalChars[i])) {
                result = false;
                break;
            }
            if (i == 0 || Character.isJavaIdentifierPart(literalChars[i])) continue;
            result = false;
            break;
        }
        return result;
    }

    public Interpreter getInterpreter() {
        if (this.interpreter == null) {
            try {
                this.interpreter = this.prepareExpressionEvaluator();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.interpreter;
    }

    public void setInterpreter(Interpreter interpreter) {
        this.interpreter = interpreter;
    }

    public Vector getReportParameters() {
        return this.reportParameters;
    }

    public void setReportParameters(Vector reportParameters) {
        this.reportParameters = reportParameters;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public HashMap getQueryParameters() {
        return this.queryParameters;
    }

    public void setQueryParameters(HashMap queryParameters) {
        this.queryParameters = queryParameters;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        hibernateTypeMap.put(class$java$lang$Boolean == null ? (class$java$lang$Boolean = HQLFieldsReader.class$("java.lang.Boolean")) : class$java$lang$Boolean, Hibernate.BOOLEAN);
        hibernateTypeMap.put(class$java$lang$Byte == null ? (class$java$lang$Byte = HQLFieldsReader.class$("java.lang.Byte")) : class$java$lang$Byte, Hibernate.BYTE);
        hibernateTypeMap.put(class$java$lang$Double == null ? (class$java$lang$Double = HQLFieldsReader.class$("java.lang.Double")) : class$java$lang$Double, Hibernate.DOUBLE);
        hibernateTypeMap.put(class$java$lang$Float == null ? (class$java$lang$Float = HQLFieldsReader.class$("java.lang.Float")) : class$java$lang$Float, Hibernate.FLOAT);
        hibernateTypeMap.put(class$java$lang$Integer == null ? (class$java$lang$Integer = HQLFieldsReader.class$("java.lang.Integer")) : class$java$lang$Integer, Hibernate.INTEGER);
        hibernateTypeMap.put(class$java$lang$Long == null ? (class$java$lang$Long = HQLFieldsReader.class$("java.lang.Long")) : class$java$lang$Long, Hibernate.LONG);
        hibernateTypeMap.put(class$java$lang$Short == null ? (class$java$lang$Short = HQLFieldsReader.class$("java.lang.Short")) : class$java$lang$Short, Hibernate.SHORT);
        hibernateTypeMap.put(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = HQLFieldsReader.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, Hibernate.BIG_DECIMAL);
        hibernateTypeMap.put(class$java$math$BigInteger == null ? (class$java$math$BigInteger = HQLFieldsReader.class$("java.math.BigInteger")) : class$java$math$BigInteger, Hibernate.BIG_INTEGER);
        hibernateTypeMap.put(class$java$lang$Character == null ? (class$java$lang$Character = HQLFieldsReader.class$("java.lang.Character")) : class$java$lang$Character, Hibernate.CHARACTER);
        hibernateTypeMap.put(class$java$lang$String == null ? (class$java$lang$String = HQLFieldsReader.class$("java.lang.String")) : class$java$lang$String, Hibernate.STRING);
        hibernateTypeMap.put(class$java$util$Date == null ? (class$java$util$Date = HQLFieldsReader.class$("java.util.Date")) : class$java$util$Date, Hibernate.DATE);
        hibernateTypeMap.put(class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = HQLFieldsReader.class$("java.sql.Timestamp")) : class$java$sql$Timestamp, Hibernate.TIMESTAMP);
        hibernateTypeMap.put(class$java$sql$Time == null ? (class$java$sql$Time = HQLFieldsReader.class$("java.sql.Time")) : class$java$sql$Time, Hibernate.TIME);
    }
}

