/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jmx;

import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.sql.Connection;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.UUIDHexGenerator;
import org.hibernate.impl.SessionFactoryObjectFactory;
import org.hibernate.jmx.HibernateService;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.metadata.CollectionMetadata;
import org.hibernate.stat.Statistics;

public class SessionFactoryStub
implements SessionFactory {
    private static final Log log = LogFactory.getLog((Class)(class$org$hibernate$jmx$SessionFactoryStub == null ? (class$org$hibernate$jmx$SessionFactoryStub = SessionFactoryStub.class$("org.hibernate.jmx.SessionFactoryStub")) : class$org$hibernate$jmx$SessionFactoryStub));
    private static final IdentifierGenerator UUID_GENERATOR = new UUIDHexGenerator();
    private transient SessionFactory impl;
    private transient HibernateService service;
    private String uuid;
    private String name;
    static /* synthetic */ Class class$org$hibernate$jmx$SessionFactoryStub;
    static /* synthetic */ Class class$org$hibernate$impl$SessionFactoryObjectFactory;

    SessionFactoryStub(HibernateService service) {
        this.service = service;
        this.name = service.getJndiName();
        try {
            this.uuid = (String)((Object)UUID_GENERATOR.generate(null, null));
        }
        catch (Exception e) {
            throw new AssertionFailure("Could not generate UUID");
        }
        SessionFactoryObjectFactory.addInstance(this.uuid, this.name, this, service.getProperties());
    }

    public Session openSession(Connection connection, Interceptor interceptor) {
        return this.getImpl().openSession(connection, interceptor);
    }

    public Session openSession(Interceptor interceptor) throws HibernateException {
        return this.getImpl().openSession(interceptor);
    }

    public Session openSession() throws HibernateException {
        return this.getImpl().openSession();
    }

    public Session openSession(Connection conn) {
        return this.getImpl().openSession(conn);
    }

    public Session getCurrentSession() {
        return this.getImpl().getCurrentSession();
    }

    private synchronized SessionFactory getImpl() {
        if (this.impl == null) {
            this.impl = this.service.buildSessionFactory();
        }
        return this.impl;
    }

    private Object readResolve() throws ObjectStreamException {
        Object result = SessionFactoryObjectFactory.getInstance(this.uuid);
        if (result == null) {
            result = SessionFactoryObjectFactory.getNamedInstance(this.name);
            if (result == null) {
                throw new InvalidObjectException("Could not find a stub SessionFactory named: " + this.name);
            }
            log.debug((Object)"resolved stub SessionFactory by name");
        } else {
            log.debug((Object)"resolved stub SessionFactory by uid");
        }
        return result;
    }

    public Reference getReference() throws NamingException {
        return new Reference((class$org$hibernate$jmx$SessionFactoryStub == null ? (class$org$hibernate$jmx$SessionFactoryStub = SessionFactoryStub.class$("org.hibernate.jmx.SessionFactoryStub")) : class$org$hibernate$jmx$SessionFactoryStub).getName(), new StringRefAddr("uuid", this.uuid), (class$org$hibernate$impl$SessionFactoryObjectFactory == null ? (class$org$hibernate$impl$SessionFactoryObjectFactory = SessionFactoryStub.class$("org.hibernate.impl.SessionFactoryObjectFactory")) : class$org$hibernate$impl$SessionFactoryObjectFactory).getName(), null);
    }

    public ClassMetadata getClassMetadata(Class persistentClass) throws HibernateException {
        return this.getImpl().getClassMetadata(persistentClass);
    }

    public ClassMetadata getClassMetadata(String entityName) throws HibernateException {
        return this.getImpl().getClassMetadata(entityName);
    }

    public CollectionMetadata getCollectionMetadata(String roleName) throws HibernateException {
        return this.getImpl().getCollectionMetadata(roleName);
    }

    public Map getAllClassMetadata() throws HibernateException {
        return this.getImpl().getAllClassMetadata();
    }

    public Map getAllCollectionMetadata() throws HibernateException {
        return this.getImpl().getAllCollectionMetadata();
    }

    public void close() throws HibernateException {
    }

    public boolean isClosed() {
        return false;
    }

    public void evict(Class persistentClass, Serializable id) throws HibernateException {
        this.getImpl().evict(persistentClass, id);
    }

    public void evict(Class persistentClass) throws HibernateException {
        this.getImpl().evict(persistentClass);
    }

    public void evictEntity(String entityName, Serializable id) throws HibernateException {
        this.getImpl().evictEntity(entityName, id);
    }

    public void evictEntity(String entityName) throws HibernateException {
        this.getImpl().evictEntity(entityName);
    }

    public void evictCollection(String roleName, Serializable id) throws HibernateException {
        this.getImpl().evictCollection(roleName, id);
    }

    public void evictCollection(String roleName) throws HibernateException {
        this.getImpl().evictCollection(roleName);
    }

    public void evictQueries() throws HibernateException {
        this.getImpl().evictQueries();
    }

    public void evictQueries(String cacheRegion) throws HibernateException {
        this.getImpl().evictQueries(cacheRegion);
    }

    public Statistics getStatistics() {
        return this.getImpl().getStatistics();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

