/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import jxl.CellView;
import jxl.JXLException;
import jxl.SheetSettings;
import jxl.Workbook;
import jxl.format.Alignment;
import jxl.format.BoldStyle;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.format.Orientation;
import jxl.format.PageOrientation;
import jxl.format.PaperSize;
import jxl.format.Pattern;
import jxl.format.UnderlineStyle;
import jxl.format.VerticalAlignment;
import jxl.write.Blank;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableHyperlink;
import jxl.write.WritableImage;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JExcelApiExporterParameter;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.JRGridLayout;
import net.sf.jasperreports.engine.export.JRXlsAbstractExporter;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.util.PngEncoderB;
import org.apache.commons.collections.ReferenceMap;

public class JExcelApiExporter
extends JRXlsAbstractExporter {
    private static final Colour WHITE = Colour.WHITE;
    private static final Colour BLACK = Colour.BLACK;
    private static Map colorsCache = new ReferenceMap();
    private Map loadedCellStyles = new HashMap();
    private WritableWorkbook workbook = null;
    private WritableSheet sheet = null;
    private WritableCellFormat emptyCellStyle = null;
    private boolean isFontSizeFixEnabled = false;
    private Pattern backgroundMode = Pattern.SOLID;

    protected void setParameters() {
        super.setParameters();
        Boolean isFontSizeFixEnabledParameter = (Boolean)this.parameters.get((Object)JExcelApiExporterParameter.IS_FONT_SIZE_FIX_ENABLED);
        if (isFontSizeFixEnabledParameter != null) {
            this.isFontSizeFixEnabled = isFontSizeFixEnabledParameter;
        }
    }

    protected void setBackground() {
        this.backgroundMode = Pattern.SOLID;
    }

    protected void openWorkbook(OutputStream os) throws JRException {
        try {
            this.workbook = Workbook.createWorkbook((OutputStream)os);
            this.emptyCellStyle = new WritableCellFormat();
            this.emptyCellStyle.setBackground(WHITE, this.backgroundMode);
        }
        catch (IOException e) {
            throw new JRException("Error generating XLS report : " + this.jasperPrint.getName(), (Throwable)e);
        }
        catch (WriteException e) {
            throw new JRException("Error generating XLS report : " + this.jasperPrint.getName(), (Throwable)e);
        }
    }

    protected void createSheet(String name) {
        this.sheet = this.workbook.createSheet(name, Integer.MAX_VALUE);
        this.setSheetSettings(this.sheet);
    }

    protected void closeWorkbook(OutputStream os) throws JRException {
        try {
            this.workbook.write();
            this.workbook.close();
        }
        catch (IOException e) {
            throw new JRException("Error generating XLS report : " + this.jasperPrint.getName(), (Throwable)e);
        }
        catch (WriteException e) {
            throw new JRException("Error generating XLS report : " + this.jasperPrint.getName(), (Throwable)e);
        }
    }

    protected void setColumnWidth(short index, short width) {
        CellView cv = new CellView();
        cv.setSize((int)width);
        this.sheet.setColumnView((int)index, cv);
    }

    protected void setRowHeight(int y, int lastRowHeight) throws JRException {
        try {
            this.sheet.setRowView(y, lastRowHeight * 20);
        }
        catch (RowsExceededException e) {
            throw new JRException("Error generating XLS report : " + this.jasperPrint.getName(), (Throwable)e);
        }
    }

    protected void setCell(int x, int y) {
    }

    protected void addBlankCell(JRExporterGridCell gridCell, int colIndex, int rowIndex) throws JRException {
        try {
            Colour forecolor = BLACK;
            if (gridCell.getForecolor() != null) {
                forecolor = JExcelApiExporter.getNearestColour(gridCell.getForecolor());
            }
            Colour backcolor = WHITE;
            if (gridCell.getBackcolor() != null) {
                backcolor = JExcelApiExporter.getNearestColour(gridCell.getBackcolor());
            }
            Pattern mode = this.backgroundMode;
            WritableFont cellFont = this.getLoadedFont(this.getDefaultFont(), forecolor.getValue());
            WritableCellFormat cellStyle = this.getLoadedCellStyle(mode, backcolor, Alignment.LEFT.getValue(), VerticalAlignment.TOP.getValue(), Orientation.HORIZONTAL.getValue(), cellFont, gridCell);
            this.sheet.addCell((WritableCell)new Blank(colIndex, rowIndex, (CellFormat)cellStyle));
        }
        catch (RowsExceededException e) {
            throw new JRException("Error generating XLS report : " + this.jasperPrint.getName(), (Throwable)e);
        }
        catch (WriteException e) {
            throw new JRException("Error generating XLS report : " + this.jasperPrint.getName(), (Throwable)e);
        }
    }

    protected void exportLine(JRPrintLine line, JRExporterGridCell gridCell, int x, int y) throws JRException {
        this.addMergeRegion(gridCell, x, y);
        Colour forecolor2 = JExcelApiExporter.getNearestColour(line.getForecolor());
        WritableFont cellFont2 = this.getLoadedFont(this.getDefaultFont(), forecolor2.getValue());
        WritableCellFormat cellStyle2 = this.getLoadedCellStyle(Pattern.SOLID, forecolor2, Alignment.LEFT.getValue(), VerticalAlignment.TOP.getValue(), Orientation.HORIZONTAL.getValue(), cellFont2, gridCell);
        Blank cell2 = new Blank(x, y, (CellFormat)cellStyle2);
        try {
            this.sheet.addCell((WritableCell)cell2);
        }
        catch (Exception e) {
            throw new JRException("Can't add cell.", (Throwable)e);
        }
    }

    protected void exportRectangle(JRPrintElement element, JRExporterGridCell gridCell, int x, int y) throws JRException {
        this.addMergeRegion(gridCell, x, y);
        Colour forecolor = JExcelApiExporter.getNearestColour(element.getForecolor());
        Colour backcolor = WHITE;
        Pattern mode = this.backgroundMode;
        if (element.getMode() == 1) {
            mode = Pattern.SOLID;
            backcolor = JExcelApiExporter.getNearestColour(element.getBackcolor());
        } else if (gridCell.getBackcolor() != null) {
            mode = Pattern.SOLID;
            backcolor = JExcelApiExporter.getNearestColour(gridCell.getBackcolor());
        }
        WritableFont cellFont2 = this.getLoadedFont(this.getDefaultFont(), forecolor.getValue());
        WritableCellFormat cellStyle2 = this.getLoadedCellStyle(mode, backcolor, Alignment.LEFT.getValue(), VerticalAlignment.TOP.getValue(), Orientation.HORIZONTAL.getValue(), cellFont2, gridCell);
        Blank cell2 = new Blank(x, y, (CellFormat)cellStyle2);
        try {
            this.sheet.addCell((WritableCell)cell2);
        }
        catch (Exception e) {
            throw new JRException("Can't add cell.", (Throwable)e);
        }
    }

    protected void exportText(JRPrintText text, JRExporterGridCell gridCell, int x, int y) throws JRException {
        this.addMergeRegion(gridCell, x, y);
        JRStyledText styledText = this.getStyledText(text);
        if (styledText != null) {
            Colour forecolor = JExcelApiExporter.getNearestColour(text.getForecolor());
            WritableFont cellFont2 = this.getLoadedFont((JRFont)text, forecolor.getValue());
            JRXlsAbstractExporter.TextAlignHolder alignment = JExcelApiExporter.getTextAlignHolder(text);
            int horizontalAlignment = this.getHorizontalAlignment(alignment);
            int verticalAlignment = this.getVerticalAlignment(alignment);
            int rotation = this.getRotation(alignment);
            Pattern mode = this.backgroundMode;
            Colour backcolor = WHITE;
            if (text.getMode() == 1) {
                mode = Pattern.SOLID;
                backcolor = JExcelApiExporter.getNearestColour(text.getBackcolor());
            } else if (gridCell.getBackcolor() != null) {
                mode = Pattern.SOLID;
                backcolor = JExcelApiExporter.getNearestColour(gridCell.getBackcolor());
            }
            WritableCellFormat cellStyle2 = this.getLoadedCellStyle(mode, backcolor, horizontalAlignment, verticalAlignment, rotation, cellFont2, gridCell);
            try {
                String textStr = styledText.getText();
                switch (text.getHyperlinkType()) {
                    case 2: {
                        if (text.getHyperlinkReference() != null) {
                            URL url = new URL(text.getHyperlinkReference());
                            WritableHyperlink hyperlink = new WritableHyperlink(x, y, x, y, url, textStr);
                            this.sheet.addHyperlink(hyperlink);
                            break;
                        }
                    }
                    default: {
                        if (this.isAutoDetectCellType) {
                            try {
                                double d = Double.parseDouble(textStr);
                                this.sheet.addCell((WritableCell)new Number(x, y, d, (CellFormat)cellStyle2));
                            }
                            catch (NumberFormatException nfe) {
                                this.sheet.addCell((WritableCell)new Label(x, y, textStr, (CellFormat)cellStyle2));
                            }
                            break;
                        }
                        this.sheet.addCell((WritableCell)new Label(x, y, textStr, (CellFormat)cellStyle2));
                        break;
                    }
                }
            }
            catch (Exception e) {
                throw new JRException("Can't add cell.", (Throwable)e);
            }
        }
    }

    protected void addMergeRegion(JRExporterGridCell gridCell, int x, int y) throws JRException {
        if (gridCell.colSpan > 1 || gridCell.rowSpan > 1) {
            try {
                this.sheet.mergeCells(x, y, x + gridCell.colSpan - 1, y + gridCell.rowSpan - 1);
            }
            catch (JXLException e) {
                throw new JRException("Can't merge cells.", (Throwable)e);
            }
        }
    }

    private int getHorizontalAlignment(JRXlsAbstractExporter.TextAlignHolder alignment) {
        switch (alignment.horizontalAlignment) {
            case 3: {
                return Alignment.RIGHT.getValue();
            }
            case 2: {
                return Alignment.CENTRE.getValue();
            }
            case 4: {
                return Alignment.JUSTIFY.getValue();
            }
        }
        return Alignment.LEFT.getValue();
    }

    private int getVerticalAlignment(JRXlsAbstractExporter.TextAlignHolder alignment) {
        switch (alignment.verticalAlignment) {
            case 3: {
                return VerticalAlignment.BOTTOM.getValue();
            }
            case 2: {
                return VerticalAlignment.CENTRE.getValue();
            }
            case 4: {
                return VerticalAlignment.JUSTIFY.getValue();
            }
        }
        return VerticalAlignment.TOP.getValue();
    }

    private int getRotation(JRXlsAbstractExporter.TextAlignHolder alignment) {
        switch (alignment.rotation) {
            case 1: {
                return Orientation.PLUS_90.getValue();
            }
            case 2: {
                return Orientation.MINUS_90.getValue();
            }
        }
        return Orientation.HORIZONTAL.getValue();
    }

    protected void exportImage(JRPrintImage element, JRExporterGridCell gridCell, int x, int y) throws JRException {
        this.addMergeRegion(gridCell, x, y);
        try {
            JRRenderable renderer = element.getRenderer();
            int leftPadding = element.getLeftPadding();
            int topPadding = element.getTopPadding();
            int rightPadding = element.getRightPadding();
            int bottomPadding = element.getBottomPadding();
            int availableImageWidth = element.getWidth() - leftPadding - rightPadding;
            availableImageWidth = availableImageWidth < 0 ? 0 : availableImageWidth;
            int availableImageHeight = element.getHeight() - topPadding - bottomPadding;
            int n = availableImageHeight = availableImageHeight < 0 ? 0 : availableImageHeight;
            if (availableImageWidth > 0 && availableImageHeight > 0 && renderer != null) {
                int normalWidth = availableImageWidth;
                int normalHeight = availableImageHeight;
                Dimension2D dimension = renderer.getDimension();
                if (dimension != null) {
                    normalWidth = (int)dimension.getWidth();
                    normalHeight = (int)dimension.getHeight();
                }
                float xalignFactor = 0.0f;
                switch (element.getHorizontalAlignment()) {
                    case 3: {
                        xalignFactor = 1.0f;
                        break;
                    }
                    case 2: {
                        xalignFactor = 0.5f;
                        break;
                    }
                    default: {
                        xalignFactor = 0.0f;
                    }
                }
                float yalignFactor = 0.0f;
                switch (element.getVerticalAlignment()) {
                    case 3: {
                        yalignFactor = 1.0f;
                        break;
                    }
                    case 2: {
                        yalignFactor = 0.5f;
                        break;
                    }
                    default: {
                        yalignFactor = 0.0f;
                    }
                }
                BufferedImage bi = new BufferedImage(availableImageWidth, availableImageHeight, 1);
                Graphics2D grx = bi.createGraphics();
                grx.setColor(element.getBackcolor());
                grx.fillRect(0, 0, availableImageWidth, availableImageHeight);
                switch (element.getScaleImage()) {
                    case 1: {
                        int xoffset = (int)(xalignFactor * (float)(availableImageWidth - normalWidth));
                        int yoffset = (int)(yalignFactor * (float)(availableImageHeight - normalHeight));
                        renderer.render(grx, (Rectangle2D)new Rectangle(xoffset, yoffset, normalWidth, normalHeight));
                        break;
                    }
                    case 2: {
                        renderer.render(grx, (Rectangle2D)new Rectangle(0, 0, availableImageWidth, availableImageHeight));
                        break;
                    }
                    default: {
                        if (element.getHeight() <= 0) break;
                        double ratio = (double)normalWidth / (double)normalHeight;
                        if (ratio > (double)availableImageWidth / (double)availableImageHeight) {
                            normalWidth = availableImageWidth;
                            normalHeight = (int)((double)availableImageWidth / ratio);
                        } else {
                            normalWidth = (int)((double)availableImageHeight * ratio);
                            normalHeight = availableImageHeight;
                        }
                        int xoffset = (int)(xalignFactor * (float)(availableImageWidth - normalWidth));
                        int yoffset = (int)(yalignFactor * (float)(availableImageHeight - normalHeight));
                        renderer.render(grx, (Rectangle2D)new Rectangle(xoffset, yoffset, normalWidth, normalHeight));
                    }
                }
                Pattern mode = this.backgroundMode;
                Colour background = WHITE;
                Colour forecolor = JExcelApiExporter.getNearestColour(element.getForecolor());
                if (element.getBox() != null && element.getBox().getBorderColor() != null) {
                    forecolor = JExcelApiExporter.getNearestColour(element.getBox().getBorderColor());
                }
                WritableFont cellFont2 = this.getLoadedFont(this.getDefaultFont(), forecolor.getValue());
                if (element.getMode() == 1) {
                    mode = Pattern.SOLID;
                    background = JExcelApiExporter.getNearestColour(element.getBackcolor());
                }
                WritableCellFormat cellStyle2 = this.getLoadedCellStyle(mode, background, Alignment.LEFT.getValue(), VerticalAlignment.TOP.getValue(), Orientation.HORIZONTAL.getValue(), cellFont2, gridCell);
                this.sheet.addCell((WritableCell)new Blank(x, y, (CellFormat)cellStyle2));
                WritableImage image = new WritableImage((double)x, (double)y, (double)gridCell.colSpan, (double)gridCell.rowSpan, PngEncoderB.loadImageDataFromAWTImage(bi));
                this.sheet.addImage(image);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new JRException("The cell cannot be added", (Throwable)ex);
        }
        catch (Error err) {
            err.printStackTrace();
            throw new JRException("The cell cannot be added", (Throwable)err);
        }
    }

    private static Colour getNearestColour(Color awtColor) {
        Colour color = (Colour)colorsCache.get(awtColor);
        if (color == null) {
            Colour[] colors = Colour.getAllColours();
            if (colors != null && colors.length > 0) {
                Colour crtColor = null;
                int[] rgb = null;
                int diff = 0;
                int minDiff = 999;
                for (int i = 0; i < colors.length; ++i) {
                    crtColor = colors[i];
                    rgb = new int[]{crtColor.getDefaultRGB().getRed(), crtColor.getDefaultRGB().getGreen(), crtColor.getDefaultRGB().getBlue()};
                    diff = Math.abs(rgb[0] - awtColor.getRed()) + Math.abs(rgb[1] - awtColor.getGreen()) + Math.abs(rgb[2] - awtColor.getBlue());
                    if (diff >= minDiff) continue;
                    minDiff = diff;
                    color = crtColor;
                }
            }
            colorsCache.put(awtColor, color);
        }
        return color;
    }

    private WritableFont getLoadedFont(JRFont font, int forecolor) throws JRException {
        int fontSize;
        WritableFont cellFont2 = null;
        if (this.loadedFonts != null && this.loadedFonts.size() > 0) {
            WritableFont cf2 = null;
            for (int i = 0; i < this.loadedFonts.size(); ++i) {
                cf2 = (WritableFont)this.loadedFonts.get(i);
                fontSize = font.getFontSize();
                if (this.isFontSizeFixEnabled) {
                    --fontSize;
                }
                if (!cf2.getName().equals(font.getFontName()) || cf2.getColour().getValue() != forecolor || cf2.getPointSize() != fontSize || !(cf2.getUnderlineStyle() == UnderlineStyle.SINGLE ? font.isUnderline() : !font.isUnderline()) || cf2.isStruckout() != font.isStrikeThrough() || !(cf2.getBoldWeight() == BoldStyle.BOLD.getValue() ? font.isBold() : !font.isBold()) || cf2.isItalic() != font.isItalic()) continue;
                cellFont2 = cf2;
                break;
            }
        }
        try {
            if (cellFont2 == null) {
                fontSize = font.getFontSize();
                if (this.isFontSizeFixEnabled) {
                    --fontSize;
                }
                cellFont2 = new WritableFont(WritableFont.createFont((String)font.getFontName()), fontSize, font.isBold() ? WritableFont.BOLD : WritableFont.NO_BOLD, font.isItalic(), font.isUnderline() ? UnderlineStyle.SINGLE : UnderlineStyle.NO_UNDERLINE, Colour.getInternalColour((int)forecolor));
                this.loadedFonts.add(cellFont2);
            }
        }
        catch (Exception e) {
            throw new JRException("Can't get loaded fonts.", (Throwable)e);
        }
        return cellFont2;
    }

    private WritableCellFormat getLoadedCellStyle(Pattern mode, Colour backcolor, int horizontalAlignment, int verticalAlignment, int rotation, WritableFont font, JRExporterGridCell gridCell) throws JRException {
        StyleKey styleKey = new StyleKey(mode, backcolor, horizontalAlignment, verticalAlignment, rotation, font, gridCell.getBox());
        WritableCellFormat cellStyle = (WritableCellFormat)this.loadedCellStyles.get(styleKey);
        if (cellStyle == null) {
            BorderLineStyle topBorder = BorderLineStyle.NONE;
            BorderLineStyle bottomBorder = BorderLineStyle.NONE;
            BorderLineStyle leftBorder = BorderLineStyle.NONE;
            BorderLineStyle rightBorder = BorderLineStyle.NONE;
            Colour topBorderColour = BLACK;
            Colour bottomBorderColour = BLACK;
            Colour leftBorderColour = BLACK;
            Colour rightBorderColour = BLACK;
            JRBox box = gridCell.getBox();
            if (box != null) {
                if (box.getTopBorder() != 0) {
                    topBorder = this.getBorderLineStyle(box.getTopBorder());
                    topBorderColour = JExcelApiExporter.getNearestColour(box.getTopBorderColor());
                }
                if (box.getBottomBorder() != 0) {
                    bottomBorder = this.getBorderLineStyle(box.getBottomBorder());
                    bottomBorderColour = JExcelApiExporter.getNearestColour(box.getBottomBorderColor());
                }
                if (box.getLeftBorder() != 0) {
                    leftBorder = this.getBorderLineStyle(box.getLeftBorder());
                    leftBorderColour = JExcelApiExporter.getNearestColour(box.getLeftBorderColor());
                }
                if (box.getRightBorder() != 0) {
                    rightBorder = this.getBorderLineStyle(box.getRightBorder());
                    rightBorderColour = JExcelApiExporter.getNearestColour(box.getRightBorderColor());
                }
            }
            try {
                cellStyle = new WritableCellFormat(font);
                cellStyle.setBackground(backcolor, mode);
                cellStyle.setAlignment(Alignment.getAlignment((int)horizontalAlignment));
                cellStyle.setVerticalAlignment(VerticalAlignment.getAlignment((int)verticalAlignment));
                cellStyle.setOrientation(Orientation.getOrientation((int)rotation));
                cellStyle.setWrap(true);
                cellStyle.setBorder(Border.TOP, topBorder, topBorderColour);
                cellStyle.setBorder(Border.BOTTOM, bottomBorder, bottomBorderColour);
                cellStyle.setBorder(Border.LEFT, leftBorder, leftBorderColour);
                cellStyle.setBorder(Border.RIGHT, rightBorder, rightBorderColour);
            }
            catch (Exception e) {
                throw new JRException("Error setting cellFormat-template.", (Throwable)e);
            }
            this.loadedCellStyles.put(styleKey, cellStyle);
        }
        return cellStyle;
    }

    private BorderLineStyle getBorderLineStyle(byte lineStyle) {
        BorderLineStyle retVal = null;
        switch (lineStyle) {
            case 5: {
                retVal = BorderLineStyle.THIN;
                break;
            }
            case 1: 
            case 2: {
                retVal = BorderLineStyle.MEDIUM;
                break;
            }
            case 3: {
                retVal = BorderLineStyle.THICK;
                break;
            }
            case 4: {
                retVal = BorderLineStyle.DOTTED;
                break;
            }
            default: {
                retVal = BorderLineStyle.NONE;
            }
        }
        return retVal;
    }

    private final void setSheetSettings(WritableSheet sheet) {
        PageOrientation po = this.jasperPrint.getOrientation() == 1 ? PageOrientation.PORTRAIT : PageOrientation.LANDSCAPE;
        PaperSize ps = this.getSuitablePaperSize(this.jasperPrint);
        if (ps != null) {
            sheet.setPageSetup(po, ps, 0.0, 0.0);
        } else {
            sheet.setPageSetup(po);
        }
        SheetSettings sheets = sheet.getSettings();
        sheets.setTopMargin(0.0);
        sheets.setLeftMargin(0.0);
        sheets.setRightMargin(0.0);
        sheets.setBottomMargin(0.0);
        sheets.setHeaderMargin(0.0);
        sheets.setFooterMargin(0.0);
    }

    private final PaperSize getSuitablePaperSize(JasperPrint jasP) {
        if (jasP == null) {
            return null;
        }
        long width = 0L;
        long height = 0L;
        PaperSize ps = null;
        if (jasP.getPageWidth() != 0 && jasP.getPageHeight() != 0) {
            double dWidth = (double)jasP.getPageWidth() / 72.0;
            double dHeight = (double)jasP.getPageHeight() / 72.0;
            height = Math.round(dHeight * 25.4);
            width = Math.round(dWidth * 25.4);
            for (int i = 3; i < 6; ++i) {
                int w = this.calculateWidthForDinAN(i);
                int h = this.calculateHeightForDinAN(i);
                if (((long)w != width || (long)h != height) && ((long)h != width || (long)w != height)) continue;
                if (i == 3) {
                    ps = PaperSize.A3;
                    break;
                }
                if (i == 4) {
                    ps = PaperSize.A4;
                    break;
                }
                if (i != 5) break;
                ps = PaperSize.A5;
                break;
            }
            if (ps == null) {
                if (width == 216L && height == 279L || width == 279L && height == 216L) {
                    ps = PaperSize.LETTER;
                }
                if (width == 216L && height == 356L || width == 356L && height == 216L) {
                    ps = PaperSize.LEGAL;
                }
            }
        }
        return ps;
    }

    public static JRXlsAbstractExporter.TextAlignHolder getTextAlignHolder(JRPrintText textElement) {
        short horizontalAlignment;
        short verticalAlignment;
        short rotation = textElement.getRotation();
        block0 : switch (textElement.getRotation()) {
            case 1: {
                switch (textElement.getHorizontalAlignment()) {
                    case 1: {
                        verticalAlignment = 3;
                        break;
                    }
                    case 2: {
                        verticalAlignment = 2;
                        break;
                    }
                    case 3: {
                        verticalAlignment = 1;
                        break;
                    }
                    case 4: {
                        verticalAlignment = 4;
                        break;
                    }
                    default: {
                        verticalAlignment = 3;
                    }
                }
                switch (textElement.getVerticalAlignment()) {
                    case 1: {
                        horizontalAlignment = 1;
                        break block0;
                    }
                    case 2: {
                        horizontalAlignment = 2;
                        break block0;
                    }
                    case 3: {
                        horizontalAlignment = 3;
                        break block0;
                    }
                }
                horizontalAlignment = 1;
                break;
            }
            case 2: {
                switch (textElement.getHorizontalAlignment()) {
                    case 1: {
                        verticalAlignment = 1;
                        break;
                    }
                    case 2: {
                        verticalAlignment = 2;
                        break;
                    }
                    case 3: {
                        verticalAlignment = 3;
                        break;
                    }
                    case 4: {
                        verticalAlignment = 4;
                        break;
                    }
                    default: {
                        verticalAlignment = 1;
                    }
                }
                switch (textElement.getVerticalAlignment()) {
                    case 1: {
                        horizontalAlignment = 3;
                        break block0;
                    }
                    case 2: {
                        horizontalAlignment = 2;
                        break block0;
                    }
                    case 3: {
                        horizontalAlignment = 1;
                        break block0;
                    }
                }
                horizontalAlignment = 3;
                break;
            }
            default: {
                horizontalAlignment = textElement.getHorizontalAlignment();
                verticalAlignment = textElement.getVerticalAlignment();
            }
        }
        return new JRXlsAbstractExporter.TextAlignHolder(horizontalAlignment, verticalAlignment, rotation);
    }

    private final int calculateWidthForDinAN(int n) {
        return (int)(Math.pow(2.0, -0.25 - (double)n / 2.0) * 1000.0);
    }

    private final int calculateHeightForDinAN(int n) {
        return (int)(Math.pow(2.0, 0.25 - (double)n / 2.0) * 1000.0);
    }

    private final int calculateWidthForDinBN(int n) {
        return (int)(Math.pow(2.0, -((double)n / 2.0)) * 1000.0);
    }

    private final int calculateHeightForDinBN(int n) {
        return (int)(Math.pow(2.0, 0.5 - (double)n / 2.0) * 1000.0);
    }

    private final int calculateWidthForDinCN(int n) {
        return (int)(Math.pow(2.0, -0.125 - (double)n / 2.0) * 1000.0);
    }

    private final int calculateHeightForDinCN(int n) {
        return (int)(Math.pow(2.0, 0.375 - (double)n / 2.0) * 1000.0);
    }

    protected JRGridLayout.ExporterElements getExporterElements() {
        return JRGridLayout.UNIVERSAL_EXPORTER;
    }

    protected void exportFrame(JRPrintFrame frame, JRExporterGridCell gridCell, int x, int y) throws JRException {
        this.addMergeRegion(gridCell, x, y);
        Colour forecolor = JExcelApiExporter.getNearestColour(frame.getForecolor());
        Colour backcolor = WHITE;
        Pattern mode = this.backgroundMode;
        if (frame.getMode() == 1) {
            mode = Pattern.SOLID;
            backcolor = JExcelApiExporter.getNearestColour(frame.getBackcolor());
        }
        WritableFont cellFont = this.getLoadedFont(this.getDefaultFont(), forecolor.getValue());
        WritableCellFormat cellStyle = this.getLoadedCellStyle(mode, backcolor, Alignment.LEFT.getValue(), VerticalAlignment.TOP.getValue(), Orientation.HORIZONTAL.getValue(), cellFont, gridCell);
        Blank cell = new Blank(x, y, (CellFormat)cellStyle);
        try {
            this.sheet.addCell((WritableCell)cell);
        }
        catch (JXLException e) {
            throw new JRException("Can't add cell.", (Throwable)e);
        }
    }

    protected static class StyleKey {
        int mode;
        int backcolor;
        int horizontalAlignment;
        int verticalAlignment;
        int rotation;
        int font;
        JRBox box;
        final int hashCode;

        protected StyleKey(Pattern mode, Colour backcolor, int horizontalAlignment, int verticalAlignment, int rotation, WritableFont font, JRBox box) {
            this.mode = mode.getValue();
            this.backcolor = backcolor.getValue();
            this.horizontalAlignment = horizontalAlignment;
            this.verticalAlignment = verticalAlignment;
            this.rotation = rotation;
            this.font = font.getFontIndex();
            this.box = box;
            int hash = this.mode;
            hash = 31 * hash + this.backcolor;
            hash = 31 * hash + horizontalAlignment;
            hash = 31 * hash + verticalAlignment;
            hash = 31 * hash + rotation;
            hash = 31 * hash + this.font;
            if (box != null) {
                hash = 31 * hash + box.hashCode();
            }
            this.hashCode = hash;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            StyleKey k = (StyleKey)o;
            return k.mode == this.mode && k.backcolor == this.backcolor && k.horizontalAlignment == this.horizontalAlignment && k.verticalAlignment == this.verticalAlignment && k.rotation == this.rotation && k.font == this.font && (k.box == null ? this.box == null : this.box != null && k.box.equals(this.box));
        }
    }
}

