/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.compilers;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.compilers.JRGroovyGenerator;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.design.JRAbstractJavaCompiler;
import net.sf.jasperreports.engine.design.JRCompilationUnit;
import net.sf.jasperreports.engine.design.JRSourceCompileTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class JRGroovyCompiler
extends JRAbstractJavaCompiler {
    private static final Log log = LogFactory.getLog((Class)JRGroovyCompiler.class);
    public static final String LANGUAGE_GROOVY = "groovy";

    public JRGroovyCompiler() {
        super(false);
    }

    protected String compileUnits(JRCompilationUnit[] units, String classpath, File tempDirFile) throws JRException {
        CompilerConfiguration config = new CompilerConfiguration();
        config.setClasspath(classpath);
        CompilationUnit unit = new CompilationUnit(config);
        for (int i = 0; i < units.length; ++i) {
            unit.addSource("calculator_" + units[i].getName(), (InputStream)new ByteArrayInputStream(units[i].getSourceCode().getBytes()));
        }
        ClassCollector collector = new ClassCollector();
        unit.setClassgenCallback((CompilationUnit.ClassgenCallback)collector);
        try {
            unit.compile(7);
        }
        catch (CompilationFailedException e) {
            throw new JRException("Errors were encountered when compiling report expressions class file:\n" + e.toString());
        }
        if (collector.classes.size() < units.length) {
            throw new JRException("Too few groovy class were generated.");
        }
        if (collector.classCount > units.length) {
            throw new JRException("Too many groovy classes were generated.\nPlease make sure that you don't use Groovy features such as closures that are not supported by this report compiler.\n");
        }
        for (int i = 0; i < units.length; ++i) {
            units[i].setCompileData((Serializable)collector.classes.get(units[i].getName()));
        }
        return null;
    }

    protected void checkLanguage(String language) throws JRException {
        if (!LANGUAGE_GROOVY.equals(language)) {
            throw new JRException("Language \"" + language + "\" not supported by this report compiler.\n" + "Expecting \"groovy\" instead.");
        }
    }

    protected String generateSourceCode(JRSourceCompileTask sourceTask) throws JRException {
        return JRGroovyGenerator.generateClass(sourceTask);
    }

    protected String getSourceFileName(String unitName) {
        return unitName + ".groovy";
    }

    private static class ClassCollector
    extends CompilationUnit.ClassgenCallback {
        public Map classes = new HashMap();
        public int classCount;

        private ClassCollector() {
        }

        public void call(ClassVisitor writer, ClassNode node) throws CompilationFailedException {
            ++this.classCount;
            String name = node.getName();
            if (!this.classes.containsKey(name)) {
                byte[] bytes = ((ClassWriter)writer).toByteArray();
                this.classes.put(name, bytes);
            }
        }
    }
}

