/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.crosstab.gui;

import it.businesslogic.ireport.CrosstabReportElement;
import it.businesslogic.ireport.crosstab.CrosstabColumnGroup;
import it.businesslogic.ireport.crosstab.CrosstabGroup;
import it.businesslogic.ireport.crosstab.CrosstabParameter;
import it.businesslogic.ireport.crosstab.CrosstabRowGroup;
import it.businesslogic.ireport.crosstab.GroupTotal;
import it.businesslogic.ireport.crosstab.Measure;
import it.businesslogic.ireport.crosstab.gui.CrosstabGroupDialog;
import it.businesslogic.ireport.crosstab.gui.CrosstabPropertiesDialog;
import it.businesslogic.ireport.crosstab.gui.MeasureDialog;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.docking.GenericDragTargetListener;
import it.businesslogic.ireport.gui.event.CrosstabLayoutChangedEvent;
import it.businesslogic.ireport.gui.event.CrosstabLayoutChangedListener;
import it.businesslogic.ireport.gui.library.LibraryTreeCellRenderer;
import it.businesslogic.ireport.gui.library.TreeTransfertHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class CrosstabMeasuresView
extends JPanel
implements CrosstabLayoutChangedListener {
    private CrosstabReportElement crosstabReportElement = null;
    private JMenuItem jMenuItemCopy;
    private JMenuItem jMenuItemCrosstabProperties;
    private JMenuItem jMenuItemCut;
    private JMenuItem jMenuItemDelete;
    private JMenuItem jMenuItemEditMeasure;
    private JMenuItem jMenuItemNewMeasure;
    private JMenuItem jMenuItemPaste;
    private JMenuItem jMenuItemRefresh;
    private JPopupMenu jPopupMenuMeasures;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JTree jTree;

    public CrosstabMeasuresView() {
        this.initComponents();
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("measures");
        DefaultTreeModel dtm = new DefaultTreeModel(root);
        this.jTree.setModel(dtm);
        this.jTree.setDragEnabled(true);
        this.jTree.setRootVisible(false);
        this.jTree.setTransferHandler(new TreeTransfertHandler());
        this.jTree.setCellRenderer(new LibraryTreeCellRenderer());
        this.jTree.expandPath(new TreePath(root));
        this.jTree.setDropTarget(new DropTarget(this, new GenericDragTargetListener()));
    }

    public CrosstabReportElement getCrosstabReportElement() {
        return this.crosstabReportElement;
    }

    public void setCrosstabReportElement(CrosstabReportElement crosstabReportElement) {
        if (this.crosstabReportElement != null && this.crosstabReportElement != crosstabReportElement) {
            this.crosstabReportElement.removeCrosstabLayoutChangedListener(this);
        }
        if (crosstabReportElement != null && this.crosstabReportElement != crosstabReportElement) {
            crosstabReportElement.addCrosstabLayoutChangedListener(this);
        }
        this.crosstabReportElement = crosstabReportElement;
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.jTree.getModel().getRoot();
        root.removeAllChildren();
        if (crosstabReportElement != null) {
            CrosstabGroup group;
            int i;
            for (i = 0; i < crosstabReportElement.getRowGroups().size(); ++i) {
                group = (CrosstabGroup)crosstabReportElement.getRowGroups().elementAt(i);
                root.add(new DefaultMutableTreeNode(group));
            }
            for (i = 0; i < crosstabReportElement.getColumnGroups().size(); ++i) {
                group = (CrosstabGroup)crosstabReportElement.getColumnGroups().elementAt(i);
                root.add(new DefaultMutableTreeNode(group));
            }
            for (i = 0; i < crosstabReportElement.getMeasures().size(); ++i) {
                CrosstabGroup group2;
                int j;
                Measure measure = (Measure)crosstabReportElement.getMeasures().elementAt(i);
                root.add(new DefaultMutableTreeNode(measure));
                for (j = 0; j < crosstabReportElement.getRowGroups().size(); ++j) {
                    group2 = (CrosstabGroup)crosstabReportElement.getRowGroups().elementAt(j);
                    root.add(new DefaultMutableTreeNode(new GroupTotal(measure.getName(), group2.getName(), measure.getClassType())));
                }
                for (j = 0; j < crosstabReportElement.getColumnGroups().size(); ++j) {
                    group2 = (CrosstabGroup)crosstabReportElement.getColumnGroups().elementAt(j);
                    root.add(new DefaultMutableTreeNode(new GroupTotal(measure.getName(), group2.getName(), measure.getClassType())));
                }
            }
            for (i = 0; i < crosstabReportElement.getCrosstabParameters().size(); ++i) {
                CrosstabParameter parameter = (CrosstabParameter)crosstabReportElement.getCrosstabParameters().elementAt(i);
                root.add(new DefaultMutableTreeNode(parameter));
            }
        }
        this.jTree.expandPath(new TreePath(root));
        this.jTree.updateUI();
    }

    private void initComponents() {
        this.jPopupMenuMeasures = new JPopupMenu();
        this.jMenuItemEditMeasure = new JMenuItem();
        this.jSeparator4 = new JSeparator();
        this.jMenuItemNewMeasure = new JMenuItem();
        this.jSeparator3 = new JSeparator();
        this.jMenuItemCrosstabProperties = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.jMenuItemCut = new JMenuItem();
        this.jMenuItemCopy = new JMenuItem();
        this.jMenuItemPaste = new JMenuItem();
        this.jMenuItemDelete = new JMenuItem();
        this.jSeparator2 = new JSeparator();
        this.jMenuItemRefresh = new JMenuItem();
        this.jScrollPane1 = new JScrollPane();
        this.jTree = new JTree();
        this.jPopupMenuMeasures.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent evt) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
                CrosstabMeasuresView.this.jPopupMenuMeasuresPopupMenuWillBecomeVisible(evt);
            }
        });
        this.jMenuItemEditMeasure.setIcon(new ImageIcon(""));
        this.jMenuItemEditMeasure.setText("Edit");
        this.jMenuItemEditMeasure.setActionCommand("Modify measure");
        this.jMenuItemEditMeasure.setEnabled(false);
        this.jMenuItemEditMeasure.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabMeasuresView.this.jMenuItemEditMeasureActionPerformed(evt);
            }
        });
        this.jPopupMenuMeasures.add(this.jMenuItemEditMeasure);
        this.jPopupMenuMeasures.add(this.jSeparator4);
        this.jMenuItemNewMeasure.setIcon(new ImageIcon(""));
        this.jMenuItemNewMeasure.setText("New measure");
        this.jMenuItemNewMeasure.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabMeasuresView.this.jMenuItemNewMeasureActionPerformed(evt);
            }
        });
        this.jPopupMenuMeasures.add(this.jMenuItemNewMeasure);
        this.jPopupMenuMeasures.add(this.jSeparator3);
        this.jMenuItemCrosstabProperties.setIcon(new ImageIcon(""));
        this.jMenuItemCrosstabProperties.setText("Crosstab properties");
        this.jMenuItemCrosstabProperties.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabMeasuresView.this.jMenuItemEditActionPerformed1(evt);
            }
        });
        this.jPopupMenuMeasures.add(this.jMenuItemCrosstabProperties);
        this.jPopupMenuMeasures.add(this.jSeparator1);
        this.jMenuItemCut.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/menu/cut.png")));
        this.jMenuItemCut.setText("Cut");
        this.jMenuItemCut.setEnabled(false);
        this.jMenuItemCut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabMeasuresView.this.jMenuItemCutActionPerformed(evt);
            }
        });
        this.jPopupMenuMeasures.add(this.jMenuItemCut);
        this.jMenuItemCopy.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/menu/copy.png")));
        this.jMenuItemCopy.setText("Copy");
        this.jMenuItemCopy.setEnabled(false);
        this.jMenuItemCopy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabMeasuresView.this.jMenuItemCopyActionPerformed(evt);
            }
        });
        this.jPopupMenuMeasures.add(this.jMenuItemCopy);
        this.jMenuItemPaste.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/menu/paste.png")));
        this.jMenuItemPaste.setText("Paste");
        this.jMenuItemPaste.setEnabled(false);
        this.jMenuItemPaste.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabMeasuresView.this.jMenuItemPasteActionPerformed(evt);
            }
        });
        this.jPopupMenuMeasures.add(this.jMenuItemPaste);
        this.jMenuItemDelete.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/menu/delete.png")));
        this.jMenuItemDelete.setText("Delete");
        this.jMenuItemDelete.setEnabled(false);
        this.jMenuItemDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabMeasuresView.this.jMenuItemDeleteActionPerformed(evt);
            }
        });
        this.jPopupMenuMeasures.add(this.jMenuItemDelete);
        this.jPopupMenuMeasures.add(this.jSeparator2);
        this.jMenuItemRefresh.setText("Refresh");
        this.jMenuItemRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabMeasuresView.this.jMenuItemRefreshActionPerformed(evt);
            }
        });
        this.jPopupMenuMeasures.add(this.jMenuItemRefresh);
        this.setLayout(new BorderLayout());
        this.jTree.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                CrosstabMeasuresView.this.jTreeMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTree);
        this.add((Component)this.jScrollPane1, "Center");
    }

    /*
     * Enabled aggressive block sorting
     */
    private void jTreeMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 1) {
            if (evt.getButton() == 3) {
                this.jPopupMenuMeasures.show(this, evt.getX(), evt.getY());
                return;
            }
        }
        if (evt.getClickCount() != 2) return;
        if (evt.getButton() != 1) return;
        this.jMenuItemEditMeasureActionPerformed(null);
    }

    private void jMenuItemEditActionPerformed1(ActionEvent evt) {
        CrosstabPropertiesDialog cpd = new CrosstabPropertiesDialog((Frame)MainFrame.getMainInstance(), true);
        cpd.setCurrentCrosstabReportElement(this.getCrosstabReportElement());
        cpd.setVisible(true);
    }

    private void jPopupMenuMeasuresPopupMenuWillBecomeVisible(PopupMenuEvent evt) {
        this.jMenuItemNewMeasure.setEnabled(true);
        this.jMenuItemRefresh.setEnabled(true);
        TreePath[] paths = this.jTree.getSelectionPaths();
        if (paths == null || paths.length == 0) {
            this.jMenuItemCut.setEnabled(false);
            this.jMenuItemCopy.setEnabled(false);
            this.jMenuItemDelete.setEnabled(false);
            this.jMenuItemPaste.setEnabled(false);
            this.jMenuItemEditMeasure.setEnabled(false);
            return;
        }
        if (paths.length == 1 && paths[0].getLastPathComponent() instanceof DefaultMutableTreeNode && ((DefaultMutableTreeNode)paths[0].getLastPathComponent()).getUserObject() instanceof Measure || ((DefaultMutableTreeNode)paths[0].getLastPathComponent()).getUserObject() instanceof CrosstabGroup) {
            this.jMenuItemEditMeasure.setEnabled(true);
            this.jMenuItemCut.setEnabled(true);
            this.jMenuItemCopy.setEnabled(true);
            this.jMenuItemDelete.setEnabled(true);
        } else {
            this.jMenuItemEditMeasure.setEnabled(false);
            this.jMenuItemCut.setEnabled(false);
            this.jMenuItemCopy.setEnabled(false);
            this.jMenuItemDelete.setEnabled(false);
        }
        this.jMenuItemPaste.setEnabled(false);
        if (MainFrame.getMainInstance().getMeasuresClipBoard().size() > 0) {
            this.jMenuItemPaste.setEnabled(true);
        }
    }

    private void jMenuItemRefreshActionPerformed(ActionEvent evt) {
        this.setCrosstabReportElement(this.crosstabReportElement);
    }

    private void jMenuItemDeleteActionPerformed(ActionEvent evt) {
        TreePath[] paths = this.jTree.getSelectionPaths();
        for (int i = 0; i < paths.length; ++i) {
            try {
                Object obj;
                if (!(paths[i].getLastPathComponent() instanceof DefaultMutableTreeNode) || !((obj = ((DefaultMutableTreeNode)paths[i].getLastPathComponent()).getUserObject()) instanceof Measure) || this.getCrosstabReportElement().getMeasures().size() <= 0) continue;
                this.getCrosstabReportElement().removeMeasure((Measure)obj);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void jMenuItemPasteActionPerformed(ActionEvent evt) {
        TreePath[] paths = this.jTree.getSelectionPaths();
        if (paths.length == 1 && paths[0].getLastPathComponent() instanceof DefaultMutableTreeNode) {
            for (int i = 0; i < MainFrame.getMainInstance().getMeasuresClipBoard().size(); ++i) {
                Measure measure = (Measure)MainFrame.getMainInstance().getMeasuresClipBoard().elementAt(i);
                measure = measure.cloneMe();
                String base_name = measure.getName();
                Vector measures = this.getCrosstabReportElement().getMeasures();
                int j = 0;
                while (true) {
                    boolean found = false;
                    for (int k = 0; k < measures.size(); ++k) {
                        Measure measure1 = (Measure)measures.elementAt(k);
                        if (j == 0) {
                            if (!measure1.getName().equals(base_name)) continue;
                            found = true;
                            break;
                        }
                        if (!measure1.getName().equals(base_name + "_" + j)) continue;
                        found = true;
                        break;
                    }
                    if (!found) break;
                    ++j;
                }
                measure.setName(base_name + (j == 0 ? "" : "_" + j));
                this.getCrosstabReportElement().addMeasure(measure);
            }
        }
    }

    private void jMenuItemCopyActionPerformed(ActionEvent evt) {
        TreePath[] paths = this.jTree.getSelectionPaths();
        boolean clearedMeasuresClipboard = false;
        for (int i = 0; i < paths.length; ++i) {
            Object obj;
            if (!(paths[i].getLastPathComponent() instanceof DefaultMutableTreeNode) || !((obj = ((DefaultMutableTreeNode)paths[i].getLastPathComponent()).getUserObject()) instanceof Measure)) continue;
            if (!clearedMeasuresClipboard) {
                clearedMeasuresClipboard = true;
                MainFrame.getMainInstance().getMeasuresClipBoard().removeAllElements();
            }
            MainFrame.getMainInstance().getMeasuresClipBoard().add(((Measure)obj).cloneMe());
        }
    }

    private void jMenuItemCutActionPerformed(ActionEvent evt) {
        TreePath[] paths = this.jTree.getSelectionPaths();
        boolean clearedMeasuresClipboard = false;
        for (int i = 0; i < paths.length; ++i) {
            Object obj;
            if (!(paths[i].getLastPathComponent() instanceof DefaultMutableTreeNode) || !((obj = ((DefaultMutableTreeNode)paths[i].getLastPathComponent()).getUserObject()) instanceof Measure)) continue;
            if (!clearedMeasuresClipboard) {
                clearedMeasuresClipboard = true;
                MainFrame.getMainInstance().getMeasuresClipBoard().removeAllElements();
            }
            MainFrame.getMainInstance().getMeasuresClipBoard().add(((Measure)obj).cloneMe());
            this.getCrosstabReportElement().removeMeasure((Measure)obj);
        }
    }

    private void jMenuItemNewMeasureActionPerformed(ActionEvent evt) {
        MeasureDialog jrpd = new MeasureDialog(null, MainFrame.getMainInstance(), true);
        jrpd.setExpressionContext(this.getCrosstabReportElement().isUseDataset() && this.getCrosstabReportElement().getDataset() != null ? this.getCrosstabReportElement().getDataset().getSubDataset() : null);
        jrpd.setVisible(true);
        if (jrpd.getDialogResult() == 0) {
            Measure measure = jrpd.getMeasure();
            this.getCrosstabReportElement().addMeasure(measure);
        }
    }

    private void jMenuItemEditMeasureActionPerformed(ActionEvent evt) {
        TreePath[] paths = this.jTree.getSelectionPaths();
        if (paths == null || paths.length == 0) {
            return;
        }
        if (paths.length == 1 && paths[0].getLastPathComponent() instanceof DefaultMutableTreeNode) {
            Object obj = ((DefaultMutableTreeNode)paths[0].getLastPathComponent()).getUserObject();
            if (obj instanceof Measure) {
                MeasureDialog jrpd = new MeasureDialog(null, MainFrame.getMainInstance(), true);
                jrpd.setExpressionContext(this.getCrosstabReportElement().isUseDataset() && this.getCrosstabReportElement().getDataset() != null ? this.getCrosstabReportElement().getDataset().getSubDataset() : null);
                jrpd.setMeasure((Measure)obj);
                jrpd.setVisible(true);
                if (jrpd.getDialogResult() == 0) {
                    Measure measure = (Measure)obj;
                    measure.setName(jrpd.getMeasure().getName());
                    measure.setExpression(jrpd.getMeasure().getExpression());
                    measure.setClassType(jrpd.getMeasure().getClassType());
                    measure.setCalculation(jrpd.getMeasure().getCalculation());
                    measure.setIncrementerFactoryClass(jrpd.getMeasure().getIncrementerFactoryClass());
                    measure.setPercentageCalculatorClass(jrpd.getMeasure().getPercentageCalculatorClass());
                    measure.setPercentageOf(jrpd.getMeasure().getPercentageOf());
                    this.getCrosstabReportElement().measureModified(measure);
                    this.setCrosstabReportElement(this.crosstabReportElement);
                }
            } else if (obj instanceof CrosstabGroup) {
                CrosstabGroup rg = (CrosstabGroup)obj;
                CrosstabGroupDialog jrpd = new CrosstabGroupDialog(rg instanceof CrosstabColumnGroup ? 1 : 0, MainFrame.getMainInstance(), true);
                jrpd.setExpressionContext(this.getCrosstabReportElement().isUseDataset() && this.getCrosstabReportElement().getDataset() != null ? this.getCrosstabReportElement().getDataset().getSubDataset() : null);
                jrpd.setGroup(rg);
                jrpd.setVisible(true);
                if (jrpd.getDialogResult() == 0) {
                    CrosstabGroup group = jrpd.getGroup();
                    String oldName = rg.getName();
                    rg.setName(group.getName());
                    rg.setBucketComparatorExpression(group.getBucketComparatorExpression());
                    rg.setBucketExpression(group.getBucketExpression());
                    rg.setBucketExpressionClass(group.getBucketExpressionClass());
                    rg.setBucketOrder(group.getBucketOrder());
                    rg.setHeaderPosition(group.getHeaderPosition());
                    rg.setTotalPosition(group.getTotalPosition());
                    rg.setName(group.getName());
                    rg.setSize(group.getSize());
                    rg.setHasHeader(group.isHasHeader());
                    rg.setHasTotal(group.isHasTotal());
                    if (rg instanceof CrosstabColumnGroup) {
                        this.getCrosstabReportElement().modifyGroup(oldName, (CrosstabColumnGroup)rg);
                    }
                    if (rg instanceof CrosstabRowGroup) {
                        this.getCrosstabReportElement().modifyGroup(oldName, (CrosstabRowGroup)rg);
                    }
                }
            }
        }
    }

    public void crosstabLayoutChanged(CrosstabLayoutChangedEvent evt) {
        this.setCrosstabReportElement(this.crosstabReportElement);
    }

    public void crosstabMeasureChanged(CrosstabLayoutChangedEvent evt) {
        this.setCrosstabReportElement(this.crosstabReportElement);
    }
}

