/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.docking;

import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.docking.JDraggableTabbedPane;
import it.businesslogic.ireport.gui.docking.PanelView;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.util.List;

public class GenericDragTargetListener
implements DropTargetListener {
    public static JDraggableTabbedPane lastDp = null;
    public static final int POSITION_UP = 0;
    public static final int POSITION_CENTER = 1;
    public static final int POSITION_BOTTOM = 2;
    public static final Color COLOR = new Color(255, 0, 0, 128);
    private int lastPosition = -1;
    public static final BasicStroke STROKE = new BasicStroke(3.0f);
    static /* synthetic */ Class class$it$businesslogic$ireport$gui$docking$PanelView;

    public void dragEnter(DropTargetDragEvent e) {
        this.handleMotion(e);
        e.acceptDrag(e.getDropAction());
    }

    public void dragOver(DropTargetDragEvent e) {
        this.handleMotion(e);
        e.acceptDrag(e.getDropAction());
    }

    public void handleMotion(DropTargetDragEvent dtde) {
        DropTargetContext context = dtde.getDropTargetContext();
        DropTargetDropEvent tempDTDropEvent = new DropTargetDropEvent(dtde.getDropTargetContext(), dtde.getLocation(), 0, 0);
        Transferable tr = tempDTDropEvent.getTransferable();
        DataFlavor[] df = tr.getTransferDataFlavors();
        if (df[0].getHumanPresentableName().equals("it.businesslogic.ireport.gui.docking.PanelView")) {
            JDraggableTabbedPane dp = this.lookForParentDraggablePane(dtde.getDropTargetContext().getComponent());
            if (lastDp != dp) {
                if (lastDp != null) {
                    lastDp.repaint();
                }
                lastDp = dp;
                this.lastPosition = -1;
            }
            if (dp != null) {
                Graphics2D g = (Graphics2D)dp.getGraphics();
                int height = dp.getHeight();
                if (dtde.getLocation() != null) {
                    try {
                        int position = (int)dtde.getLocation().getY();
                        if (position <= height / 3) {
                            if (this.lastPosition != 0) {
                                this.lastPosition = 0;
                                dp.paint(g);
                                g.setStroke(STROKE);
                                g.setColor(COLOR);
                                g.drawRect(1, 1, dp.getWidth() - 4, height / 3 - 6);
                            }
                        } else if (position <= height / 3 * 2) {
                            if (this.lastPosition != 1) {
                                this.lastPosition = 1;
                                dp.paint(g);
                                g.setStroke(STROKE);
                                g.setColor(COLOR);
                                g.drawRect(1, 1, dp.getWidth() - 4, height - 6);
                            }
                        } else if (this.lastPosition != 2 && this.lastPosition != 2) {
                            this.lastPosition = 2;
                            dp.paint(g);
                            g.setStroke(STROKE);
                            g.setColor(COLOR);
                            g.drawRect(1, height - height / 3, dp.getWidth() - 4, height / 3 - 4);
                        }
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public void dropActionChanged(DropTargetDragEvent e) {
    }

    public void dragExit(DropTargetEvent e) {
    }

    public JDraggableTabbedPane lookForParentDraggablePane(Component component) {
        if (component == null) {
            return null;
        }
        if (component instanceof JDraggableTabbedPane) {
            return (JDraggableTabbedPane)component;
        }
        return this.lookForParentDraggablePane(component.getParent());
    }

    public void drop(DropTargetDropEvent dtde) {
        try {
            DropTargetContext context = dtde.getDropTargetContext();
            Transferable tr = dtde.getTransferable();
            DataFlavor[] df = tr.getTransferDataFlavors();
            if (tr.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                dtde.acceptDrop(3);
                List fileList = (List)tr.getTransferData(DataFlavor.javaFileListFlavor);
                MainFrame.getMainInstance().openFiles(fileList);
            } else if (df[0].getHumanPresentableName().equals("it.businesslogic.ireport.gui.docking.PanelView")) {
                DataFlavor myFlavor = new DataFlavor(class$it$businesslogic$ireport$gui$docking$PanelView == null ? (class$it$businesslogic$ireport$gui$docking$PanelView = GenericDragTargetListener.class$("it.businesslogic.ireport.gui.docking.PanelView")) : class$it$businesslogic$ireport$gui$docking$PanelView, (class$it$businesslogic$ireport$gui$docking$PanelView == null ? (class$it$businesslogic$ireport$gui$docking$PanelView = GenericDragTargetListener.class$("it.businesslogic.ireport.gui.docking.PanelView")) : class$it$businesslogic$ireport$gui$docking$PanelView).getName());
                PanelView panelView = (PanelView)tr.getTransferData(myFlavor);
                JDraggableTabbedPane dp = lastDp;
                if (dp != null) {
                    if (dp.getDockingContainer() == panelView.getDockingContainer()) {
                        int containerPosition = dp.getPosition();
                        if (panelView.getDockingContainer().getPanelCount(panelView.getPosition()) != 1 || dp.getPosition() == panelView.getPosition()) {
                            // empty if block
                        }
                        if (dp.getTabCount() > 1 && dp.getPosition() == panelView.getPosition()) {
                            if (this.lastPosition == 0) {
                                dp.getDockingContainer().moveComponent(panelView, containerPosition);
                            }
                            if (this.lastPosition == 2) {
                                dp.getDockingContainer().moveComponent(panelView, containerPosition + 1);
                            }
                        } else if (dp.getPosition() != panelView.getPosition()) {
                            if (this.lastPosition == 0) {
                                if (containerPosition - 1 >= 0 && panelView.getPosition() < containerPosition) {
                                    --containerPosition;
                                }
                                dp.getDockingContainer().moveComponent(panelView, containerPosition);
                            }
                            if (this.lastPosition == 2 && (panelView.getPosition() != containerPosition + 1 || panelView.getDockingContainer().getPanelCount(panelView.getPosition()) > 0)) {
                                if (panelView.getPosition() > containerPosition) {
                                    ++containerPosition;
                                }
                                dp.getDockingContainer().moveComponent(panelView, containerPosition);
                            }
                            if (this.lastPosition == 1) {
                                if ((panelView.getPosition() >= containerPosition || panelView.getDockingContainer().getPanelCount(panelView.getPosition()) == 1) && containerPosition - 1 >= 0) {
                                    --containerPosition;
                                }
                                dp.getDockingContainer().moveComponent(panelView, containerPosition, 0);
                            }
                        }
                    } else {
                        int containerPosition = dp.getPosition();
                        panelView.getDockingContainer().removePanel(panelView.getComponent());
                        if (this.lastPosition == 0) {
                            dp.getDockingContainer().insertPanel(containerPosition, panelView.getName(), panelView.getComponent(), 1, panelView.isClosable());
                        }
                        if (this.lastPosition == 2) {
                            dp.getDockingContainer().insertPanel(containerPosition + 1, panelView.getName(), panelView.getComponent(), 1, panelView.isClosable());
                        }
                        if (this.lastPosition == 1) {
                            dp.getDockingContainer().insertPanel(containerPosition, panelView.getName(), panelView.getComponent(), 0, panelView.isClosable());
                        }
                    }
                }
            }
            context.dropComplete(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public int getLastPosition() {
        return this.lastPosition;
    }

    public void setLastPosition(int lastPosition) {
        this.lastPosition = lastPosition;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

