/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.style;

import it.businesslogic.ireport.Style;
import it.businesslogic.ireport.SubDataset;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.event.StyleChangedEvent;
import it.businesslogic.ireport.gui.event.StyleChangedListener;
import it.businesslogic.ireport.gui.style.StyleDialog;
import it.businesslogic.ireport.util.Misc;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;

public class StylesDialog
extends JDialog
implements StyleChangedListener {
    private JButton jButtonDefault;
    private JButton jButtonDelete;
    private JButton jButtonModify;
    private JButton jButtonNew;
    private JPanel jPanelButtons;
    private JPanel jPanelParameters;
    private JScrollPane jScrollPane1;
    private JTable jTableParameters;

    public StylesDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setSize(490, 250);
        DefaultListSelectionModel dlsm = (DefaultListSelectionModel)this.jTableParameters.getSelectionModel();
        dlsm.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                StylesDialog.this.jTableParametersListSelectionValueChanged(e);
            }
        });
        Misc.centerFrame(this);
        DefaultTableModel dtm = (DefaultTableModel)this.jTableParameters.getModel();
        MainFrame.getMainInstance().getActiveReportFrame().getReport().addStyleChangedListener(this);
        Enumeration e = MainFrame.getMainInstance().getActiveReportFrame().getReport().getStyles().elements();
        while (e.hasMoreElements()) {
            Style style = (Style)e.nextElement();
            this.addStyle(style);
        }
        DefaultTableColumnModel dtcm = (DefaultTableColumnModel)this.jTableParameters.getColumnModel();
        dtcm.getColumn(0).setPreferredWidth(350);
        dtcm.getColumn(1).setPreferredWidth(100);
    }

    public void jTableParametersListSelectionValueChanged(ListSelectionEvent e) {
        if (this.jTableParameters.getSelectedRowCount() > 0) {
            this.jButtonModify.setEnabled(true);
            this.jButtonDelete.setEnabled(true);
            this.jButtonDefault.setEnabled(true);
        } else {
            this.jButtonModify.setEnabled(false);
            this.jButtonDelete.setEnabled(false);
            this.jButtonDefault.setEnabled(false);
        }
    }

    private void initComponents() {
        this.jPanelParameters = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTableParameters = new JTable();
        this.jPanelButtons = new JPanel();
        this.jButtonNew = new JButton();
        this.jButtonModify = new JButton();
        this.jButtonDefault = new JButton();
        this.jButtonDelete = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Styles");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                StylesDialog.this.closeDialog(evt);
            }
        });
        this.jPanelParameters.setLayout(new BorderLayout(2, 2));
        this.jScrollPane1.setBackground(new Color(255, 255, 255));
        this.jTableParameters.setModel(new DefaultTableModel(new Object[0][], new String[]{"Style name", "Default"}){
            boolean[] canEdit = new boolean[]{false, false};

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jTableParameters.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                StylesDialog.this.jTableParametersMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTableParameters);
        this.jPanelParameters.add((Component)this.jScrollPane1, "Center");
        this.jPanelButtons.setLayout(new GridBagLayout());
        this.jPanelButtons.setMinimumSize(new Dimension(100, 10));
        this.jPanelButtons.setPreferredSize(new Dimension(100, 10));
        this.jButtonNew.setText("New");
        this.jButtonNew.setMargin(new Insets(2, 4, 2, 4));
        this.jButtonNew.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StylesDialog.this.jButtonNewActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanelButtons.add((Component)this.jButtonNew, gridBagConstraints);
        this.jButtonModify.setText("Modify");
        this.jButtonModify.setEnabled(false);
        this.jButtonModify.setMargin(new Insets(2, 4, 2, 4));
        this.jButtonModify.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StylesDialog.this.jButtonModifyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 3, 5, 3);
        this.jPanelButtons.add((Component)this.jButtonModify, gridBagConstraints);
        this.jButtonDefault.setText("Set as default");
        this.jButtonDefault.setEnabled(false);
        this.jButtonDefault.setMargin(new Insets(2, 4, 2, 4));
        this.jButtonDefault.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StylesDialog.this.jButtonDefaultActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 5, 3);
        this.jPanelButtons.add((Component)this.jButtonDefault, gridBagConstraints);
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.setEnabled(false);
        this.jButtonDelete.setMargin(new Insets(2, 4, 2, 4));
        this.jButtonDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StylesDialog.this.jButtonDeleteActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 5, 3);
        this.jPanelButtons.add((Component)this.jButtonDelete, gridBagConstraints);
        this.jPanelParameters.add((Component)this.jPanelButtons, "East");
        this.getContentPane().add((Component)this.jPanelParameters, "Center");
        this.pack();
    }

    private void jButtonDefaultActionPerformed(ActionEvent evt) {
        if (this.jTableParameters.getSelectedRow() < 0) {
            return;
        }
        Style irc = null;
        try {
            irc = (Style)this.jTableParameters.getModel().getValueAt(this.jTableParameters.getSelectedRow(), 0);
        }
        catch (Exception ex) {
            return;
        }
        if (irc == null) {
            return;
        }
        irc.getAttributes().put("isDefault", "true");
        this.jTableParameters.setValueAt("Yes", this.jTableParameters.getSelectedRow(), 1);
        for (int i = 0; i < this.jTableParameters.getRowCount(); ++i) {
            if (i == this.jTableParameters.getSelectedRow()) continue;
            Style s = (Style)this.jTableParameters.getModel().getValueAt(i, 0);
            if (s != null) {
                s.getAttributes().remove("isDefault");
            }
            this.jTableParameters.setValueAt("", i, 1);
        }
        MainFrame.getMainInstance().getActiveReportFrame().getReport().fireStyleChangedListenerStyleChanged(new StyleChangedEvent(MainFrame.getMainInstance().getActiveReportFrame().getReport(), 1, irc, irc));
    }

    private void jTableParametersMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            if (evt.getButton() == 1) {
                this.jButtonModifyActionPerformed(null);
            }
        }
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        if (this.jTableParameters.getSelectedRowCount() > 0) {
            SubDataset irc = null;
            try {
                irc = (SubDataset)this.jTableParameters.getModel().getValueAt(this.jTableParameters.getSelectedRow(), 0);
            }
            catch (Exception ex) {
                return;
            }
            if (JOptionPane.showConfirmDialog(this, "Do you want really remove this style?", "", 1, 3) == 0) {
                MainFrame.getMainInstance().getActiveReportFrame().getReport().removeSubDataset(irc);
                ((DefaultTableModel)this.jTableParameters.getModel()).removeRow(this.jTableParameters.getSelectedRow());
                this.jTableParameters.updateUI();
            }
        }
    }

    private void jButtonModifyActionPerformed(ActionEvent evt) {
        Frame parent = Misc.frameFromComponent(this);
        StyleDialog cd = new StyleDialog((Dialog)this, true);
        if (this.jTableParameters.getSelectedRow() < 0) {
            return;
        }
        Style irc = null;
        try {
            irc = (Style)this.jTableParameters.getModel().getValueAt(this.jTableParameters.getSelectedRow(), 0);
        }
        catch (Exception ex) {
            return;
        }
        if (irc == null) {
            return;
        }
        cd.setStyle(irc);
        cd.setVisible(true);
        if (cd.getDialogResult() == 0) {
            Style sub = cd.getStyle();
            try {
                this.jTableParameters.getModel().setValueAt(sub, this.jTableParameters.getSelectedRow(), 0);
            }
            catch (Exception ex) {
                return;
            }
        }
    }

    private void jButtonNewActionPerformed(ActionEvent evt) {
        Frame parent = Misc.frameFromComponent(this);
        StyleDialog cd = new StyleDialog((Dialog)this, true);
        cd.setVisible(true);
    }

    public void addStyle(Style s) {
        DefaultTableModel dtm = (DefaultTableModel)this.jTableParameters.getModel();
        dtm.addRow(new Object[]{s, s.getAttributeBoolean("isDefault", false) ? "Yes" : ""});
    }

    public void styleChanged(StyleChangedEvent evt) {
        int i;
        if (evt.getAction() == 0) {
            this.addStyle(evt.getNewValue());
        } else {
            for (i = 0; i < this.jTableParameters.getRowCount(); ++i) {
                if (this.jTableParameters.getModel().getValueAt(i, 0) != evt.getOldValue()) continue;
                if (evt.getAction() == 1) {
                    this.jTableParameters.getModel().setValueAt(evt.getNewValue(), i, 0);
                    this.jTableParameters.getModel().setValueAt(evt.getNewValue().getAttributeBoolean("isDefault", false) ? "Yes" : "", i, 1);
                } else {
                    ((DefaultTableModel)this.jTableParameters.getModel()).removeRow(i);
                }
                this.jTableParameters.updateUI();
                break;
            }
        }
        for (i = 0; i < this.jTableParameters.getRowCount(); ++i) {
            Style s = (Style)this.jTableParameters.getModel().getValueAt(i, 0);
            this.jTableParameters.setValueAt(s.getAttributeBoolean("isDefault", false) ? "Yes" : "", i, 1);
        }
    }

    private void closeDialog(WindowEvent evt) {
        MainFrame.getMainInstance().getActiveReportFrame().getReport().removeStyleChangedListener(this);
        this.setVisible(false);
    }
}

