/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.EmptyStatement;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.codegen.Label;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.LabelFlowContext;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;

public class LabeledStatement
extends Statement {
    public Statement statement;
    public char[] label;
    public Label targetLabel;
    int mergedInitStateIndex = -1;

    public LabeledStatement(char[] label, Statement statement, int sourceStart, int sourceEnd) {
        this.statement = statement;
        if (statement instanceof EmptyStatement) {
            statement.bits |= 1;
        }
        this.label = label;
        this.sourceStart = sourceStart;
        this.sourceEnd = sourceEnd;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.statement == null) {
            return flowInfo;
        }
        this.targetLabel = new Label();
        LabelFlowContext labelContext = new LabelFlowContext(flowContext, this, this.label, this.targetLabel, currentScope);
        UnconditionalFlowInfo mergedInfo = this.statement.analyseCode(currentScope, labelContext, flowInfo).mergedWith(labelContext.initsOnBreak);
        this.mergedInitStateIndex = currentScope.methodScope().recordInitializationStates(mergedInfo);
        return mergedInfo;
    }

    public ASTNode concreteStatement() {
        return this.statement;
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream) {
        int pc = codeStream.position;
        if (this.targetLabel != null) {
            this.targetLabel.initialize(codeStream);
            if (this.statement != null) {
                this.statement.generateCode(currentScope, codeStream);
            }
            this.targetLabel.place();
        }
        if (this.mergedInitStateIndex != -1) {
            codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.mergedInitStateIndex);
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    public StringBuffer printStatement(int tab, StringBuffer output) {
        ASTNode.printIndent(tab, output).append(this.label).append(": ");
        if (this.statement == null) {
            output.append(';');
        } else {
            this.statement.printStatement(0, output);
        }
        return output;
    }

    public void resolve(BlockScope scope) {
        if (this.statement != null) {
            this.statement.resolve(scope);
        }
    }

    public void traverse(ASTVisitor visitor, BlockScope blockScope) {
        if (visitor.visit(this, blockScope) && this.statement != null) {
            this.statement.traverse(visitor, blockScope);
        }
        visitor.endVisit(this, blockScope);
    }
}

