/*
 * FormatCommandElementMaximize.java
 *
 * Created on 17 mei 2005, 21:00
 */

package it.businesslogic.ireport.gui.command;

import it.businesslogic.ireport.OperationType;
import it.businesslogic.ireport.ReportElement;
import it.businesslogic.ireport.TransformationType;
import java.awt.Point;

/**
 *
 */
public class FormatCommandElementMaximize extends FormatCommand {
    
    {
        operationType = OperationType.ELEMENT_MAXIMIZE;
    }
    
    void executeDeeper() {
        
        resetEnumeration();

        processElements();  //register all elements once!
        
        sleepUndo = true;
        
        getCommand(OperationType.ALIGN_TOP_TO_BAND).execute();
        getCommand(OperationType.ALIGN_TO_LEFT_MARGIN).execute();
        
        int height = 0;
        int insideWidth = jrf.getReport().getWidth() - jrf.getReport().getRightMargin() - jrf.getReport().getLeftMargin() ;
        
        // this is the class processElements and here without the undo registration
        resetEnumeration();
        while (e.hasMoreElements()) {
            re = (ReportElement) e.nextElement();
            
            if (re.getBand() != null)
            {
                height = re.getBand().getHeight();
            
                re.trasform(new Point(insideWidth-re.getWidth(), height-re.getHeight()), TransformationType.TRANSFORMATION_RESIZE_SE);
                re.updateBounds();
            }
            else
            {
                re.trasform(new Point(re.getCell().getWidth()-re.getWidth(), re.getCell().getHeight()-re.getHeight()), TransformationType.TRANSFORMATION_RESIZE_SE);
                re.updateBounds();
            }
        }
        
        updateElements();
        
        sleepUndo = false;
    }
    
}
