/*
 * FormatCommandElementMaximizeH.java
 *
 * Created on 17 mei 2005, 21:00
 */

package it.businesslogic.ireport.gui.command;

import it.businesslogic.ireport.OperationType;
import it.businesslogic.ireport.ReportElement;
import it.businesslogic.ireport.TransformationType;
import java.awt.Point;

/**
 *
 */
public class FormatCommandElementMaximizeH extends FormatCommand {
    // Preparation is called before the while loop
    {
        operationType = OperationType.ELEMENT_MAXIMIZE_H;
    }
    
    void executeDeeper() {
        
        resetEnumeration();

        registerElements();  //register all elements once with no modification
                             // registerElements does not call modify().
                             // it simply register the elements to the undoOp stack.
        
        sleepUndo = true;
    
        getCommand(OperationType.ALIGN_TO_LEFT_MARGIN).execute();
        int insideWidth = jrf.getReport().getWidth() - jrf.getReport().getRightMargin() - jrf.getReport().getLeftMargin() ;
        
        // this is the class processElements and here without the undo registration
        resetEnumeration();
        while (e.hasMoreElements()) {
            re = (ReportElement) e.nextElement();
            
            if (re.getCell() != null)
            {
                re.setWidth(re.getCell().getWidth());
                //re.trasform(new Point(0,height-re.height), TransformationType.TRANSFORMATION_RESIZE_SE);
                re.updateBounds();
                
            }
            else
            {
                re.setWidth( insideWidth );
                //re.trasform(new Point(insideWidth - re.getWidth(),0), TransformationType.TRANSFORMATION_RESIZE_SE);
                re.updateBounds();
            }
        }
        
        updateElements();
        
        sleepUndo = false;
    }
    
}
