/*
 * FormatCommandJoinLeft.java
 *
 * Created on 9 mei 2005, 21:36
 */

package it.businesslogic.ireport.gui.command;

import it.businesslogic.ireport.Band;
import it.businesslogic.ireport.OperationType;
import it.businesslogic.ireport.ReportElement;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;

/**
 *
 *
 */
public class FormatCommandJoinLeft extends FormatCommand {
    int actual_x;
    
    {
        operationType = OperationType.JOIN_LEFT;
    }
    
    void executeDeeper() {
        
        Vector bands = getBands();
        
        if (bands.size() == 0 && getSelectedElements().size() > 0)
        {
            // We are working on a crosstab...
            Vector myElements = (Vector)getSelectedElements().clone();
            myElements = sortXY( myElements.elements() );
            actual_x = ((ReportElement) myElements.elementAt( 0 )).getPosition().x;
            processElements( getSelectedElements().elements() );
        }
        else
        {
            for (Iterator h = bands.iterator(); h.hasNext(); ) {

                Band b = (Band) h.next();

                Vector myElements = getBandElements(b);
                myElements = sortXY( myElements.elements());

                // Repositioning elements...
                actual_x = ((ReportElement) myElements.elementAt( 0 )).getPosition().x;

                // use myELements instead of jrf.getElements()
                processElements( myElements.elements() );

            }
        }
        
    }
    
    public void modify() {
        re.setPosition( new Point(actual_x, re.getPosition().y) );
        actual_x += re.getWidth();
        
    }
    
}
