/*
 * Decompiled with CFR 0.152.
 */
package jcmdline;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import jcmdline.CmdLineException;
import jcmdline.Parameter;
import jcmdline.Strings;

public abstract class AbstractParameter
implements Parameter {
    protected String tag;
    protected boolean optional = true;
    protected boolean multiValued = false;
    protected String desc;
    protected boolean hidden = false;
    protected boolean set;
    protected ArrayList values = new ArrayList();
    protected String optionLabel = null;
    protected String[] acceptableValues;
    protected boolean ignoreRequired;

    public boolean isSet() {
        return this.set;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setDesc(String desc) throws IllegalArgumentException {
        int minDescLen = 5;
        if (desc.length() < minDescLen) {
            throw new IllegalArgumentException(Strings.get("AbstractParameter.descTooShort", new Object[]{this.tag}));
        }
        this.desc = desc;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setTag(String tag) throws IllegalArgumentException {
        if (tag == null || tag.length() < 1) {
            throw new IllegalArgumentException(Strings.get("AbstractParameter.emptyTag"));
        }
        if (tag.indexOf("=") != -1) {
            throw new IllegalArgumentException(Strings.get("AbstractParameter.illegalCharInTag", new Object[]{tag, "="}));
        }
        this.tag = tag;
    }

    public String getTag() {
        return this.tag;
    }

    public void setMultiValued(boolean multiValued) {
        this.multiValued = multiValued;
    }

    public boolean isMultiValued() {
        return this.multiValued;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public String[] getAcceptableValues() {
        return this.acceptableValues;
    }

    public void setAcceptableValues(String[] vals) {
        this.acceptableValues = vals == null || vals.length == 0 ? null : vals;
    }

    public void setAcceptableValues(Collection vals) {
        if (vals == null || vals.size() == 0) {
            this.acceptableValues = null;
        } else {
            this.acceptableValues = new String[vals.size()];
            int i = 0;
            Iterator itr = vals.iterator();
            while (itr.hasNext()) {
                this.acceptableValues[i] = itr.next().toString();
                ++i;
            }
        }
    }

    public void addValue(String value) throws CmdLineException {
        if (this.values.size() >= 1 && !this.multiValued) {
            throw new CmdLineException(Strings.get("AbstractParameter.specifiedMoreThanOnce", new Object[]{this.tag}));
        }
        this.validateValue(value);
        this.values.add(value);
        this.set = true;
    }

    public void setValue(String value) throws CmdLineException {
        this.values.clear();
        this.addValue(value);
    }

    public void setValues(Collection values) throws CmdLineException {
        this.values.clear();
        Iterator itr = values.iterator();
        while (itr.hasNext()) {
            this.addValue((String)itr.next());
        }
    }

    public void setValues(String[] values) throws CmdLineException {
        this.values.clear();
        for (int i = 0; i < values.length; ++i) {
            this.addValue(values[i]);
        }
    }

    public void validateValue(String value) throws CmdLineException {
        if (this.acceptableValues != null) {
            for (int i = 0; i < this.acceptableValues.length; ++i) {
                if (!value.equals(this.acceptableValues[i])) continue;
                return;
            }
            int maxExpectedAVLen = 200;
            StringBuffer b = new StringBuffer(maxExpectedAVLen);
            for (int i = 0; i < this.acceptableValues.length; ++i) {
                b.append("\n   " + this.acceptableValues[i]);
            }
            throw new CmdLineException(Strings.get("Parameter.valNotAcceptableVal", new Object[]{value, this.tag, b.toString()}));
        }
    }

    public String getValue() {
        if (this.values.size() == 0) {
            return null;
        }
        return (String)this.values.get(0);
    }

    public Collection getValues() {
        return this.values;
    }

    public void setOptionLabel(String optionLabel) {
        this.optionLabel = optionLabel;
    }

    public String getOptionLabel() {
        return this.optionLabel == null ? "" : this.optionLabel;
    }

    public void setIgnoreRequired(boolean ignoreRequired) {
        this.ignoreRequired = ignoreRequired;
    }

    public boolean getIgnoreRequired() {
        return this.ignoreRequired;
    }
}

