/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.sheet;

import it.businesslogic.ireport.IReportFont;
import it.businesslogic.ireport.gui.sheet.FontSheetPropertyComponent;
import it.businesslogic.ireport.gui.sheet.SheetProperty;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import javax.swing.JComponent;

public class FontSheetProperty
extends SheetProperty {
    private FontSheetPropertyComponent editor = null;

    public FontSheetProperty(String key, String name) {
        super(key, name, 0, "");
    }

    public JComponent getEditor() {
        if (this.editor != null) {
            return this.editor;
        }
        this.editor = new FontSheetPropertyComponent();
        this.editor.addActionListener(this);
        return this.editor;
    }

    public Object getEditorValue(JComponent component) {
        return this.editor.getIreportFont();
    }

    public void actionPerformed(ActionEvent event) {
        super.actionPerformed(event);
        this.updateLabel();
    }

    public void setEditorValue(JComponent component, Object value) {
        try {
            this.getEditor();
            this.editor.setIreportFont((IReportFont)value);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setFontMode(int mode) {
        try {
            this.getEditor();
            this.editor.setFontMode(mode);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void updateLabel() {
        try {
            if (this.getLabelComponent() != null) {
                boolean allNullValue = true;
                IReportFont ifont = (IReportFont)this.getValue();
                if (ifont != null) {
                    Iterator i_keys = ifont.getBeanProperties().keySet().iterator();
                    while (i_keys.hasNext()) {
                        Object key = i_keys.next();
                        if (ifont.getBeanProperties().get(key) == null) continue;
                        allNullValue = false;
                        break;
                    }
                }
                Font f = this.getLabelComponent().getFont();
                Font f2 = new Font(f.getName(), allNullValue || this.isReadOnly() || !this.isShowResetButton() ? 0 : 1, f.getSize());
                this.getLabelComponent().setFont(f2);
                if (this.isReadOnly()) {
                    this.getLabelComponent().setEnabled(false);
                } else {
                    this.getLabelComponent().setEnabled(true);
                }
                this.getLabelComponent().updateUI();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

