/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport;

import it.businesslogic.ireport.Box;
import it.businesslogic.ireport.BoxElement;
import it.businesslogic.ireport.IReportFont;
import it.businesslogic.ireport.ReportElement;
import it.businesslogic.ireport.Style;
import it.businesslogic.ireport.util.Java2DUtil;
import it.businesslogic.ireport.util.Misc;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public abstract class TextReportElement
extends ReportElement
implements BoxElement {
    public static Rotation ROTATION_NONE = new Rotation("None", 0);
    public static Rotation ROTATION_LEFT = new Rotation("Left", 1);
    public static Rotation ROTATION_RIGHT = new Rotation("Right", 2);
    private String text = "Static text\nsecond line";
    public static String ALIGN = "ALIGN";
    public static String VERTICAL_ALIGN = "VERTICAL_ALIGN";
    public static String IS_STYLED_TEXT = "IS_STYLED_TEXT";
    public static String LINE_SPACING = "LINE_SPACING";
    public static String ROTATE = "ROTATE";
    public static String DEFAULT_ALIGN = "Left";
    public static String DEFAULT_VERTICAL_ALIGN = "Top";
    public static boolean DEFAULT_IS_STYLED_TEXT = false;
    public static String DEFAULT_LINE_SPACING = "single";
    public static String DEFAULT_ROTATE = "None";
    private Font font = null;
    private Box box = new Box();
    private IReportFont iReportFont;

    public TextReportElement(int x, int y, int width, int height) {
        super(x, y, width, height);
        this.transparentDefault = "Transparent";
        this.setIReportFont(new IReportFont());
    }

    public void setIReportFont(IReportFont newIreportFont) {
        this.iReportFont = newIreportFont == null ? new IReportFont() : (IReportFont)newIreportFont.clone();
        this.font = this.iReportFont.getJavaAWTFont();
    }

    public IReportFont getIReportFont() {
        if (this.iReportFont == null) {
            this.iReportFont = new IReportFont();
        }
        return this.iReportFont;
    }

    public void drawObject(Graphics2D g, double zoom_factor, int x_shift_origin, int y_shift_origin) {
        this.position.x -= 10;
        this.position.y -= 10;
        x_shift_origin -= 10;
        y_shift_origin -= 10;
        this.zoom_factor = zoom_factor;
        g.setColor(this.getBgcolor());
        if (!this.getTransparent().equalsIgnoreCase("Transparent")) {
            g.fillRect(this.getZoomedDim(this.position.x) - x_shift_origin, this.getZoomedDim(this.position.y) - y_shift_origin, this.getZoomedDim(this.width), this.getZoomedDim(this.height));
        }
        g.setColor(this.getFgcolor());
        if (this.font == null) {
            int style = 0;
            if (this.isBold()) {
                style |= 1;
            }
            if (this.isItalic()) {
                style |= 2;
            }
            if (style == 0) {
                style = 0;
            }
            this.font = new Font(this.getFontName(), style, this.getZoomedDim(this.getFontSize()));
        }
        int gfx_x = this.getZoomedDim(this.position.x + this.getBox().getLeftPadding()) - x_shift_origin;
        int gfx_y = this.getZoomedDim(this.position.y + this.getBox().getTopPadding()) - y_shift_origin;
        int gfx_width = this.getZoomedDim(this.width - this.getBox().getLeftPadding() - this.getBox().getRightPadding());
        int gfx_height = this.getZoomedDim(this.height - this.getBox().getTopPadding() - this.getBox().getBottomPadding());
        Java2DUtil.setClip(g, gfx_x, gfx_y, gfx_width, gfx_height);
        double angle = 0.0;
        double angle_restore = 0.0;
        AffineTransform transform = null;
        if (this.getRotate().equals(ROTATION_LEFT.getName())) {
            transform = new AffineTransform();
            transform.rotate(-1.5707963267948966, gfx_x, gfx_y);
            transform.translate(-gfx_height, -gfx_height);
            gfx_y = this.getZoomedDim(this.position.y) - y_shift_origin + this.getZoomedDim(this.height);
            gfx_width = this.getZoomedDim(this.height);
            gfx_height = this.getZoomedDim(this.width);
            Java2DUtil.setTransform(g, transform);
        } else if (this.getRotate().equals(ROTATION_RIGHT.getName())) {
            transform = new AffineTransform();
            transform.rotate(1.5707963267948966, gfx_x, gfx_y);
            transform.translate(0.0, -gfx_width);
            gfx_x = this.getZoomedDim(this.position.x) - x_shift_origin + this.getZoomedDim(this.width);
            gfx_width = this.getZoomedDim(this.height);
            gfx_height = this.getZoomedDim(this.width);
            Java2DUtil.setTransform(g, transform);
        }
        if (this.getText() != null && this.getText().length() > 0) {
            TextReportElementLayout textReportElementLayout;
            int zoomedFieldHeight = gfx_height;
            String allText = Misc.treatNewLineChars(this.getText());
            float formatWidth = gfx_width;
            float verticalOffset = 0.0f;
            FontRenderContext fontRenderContext = g.getFontRenderContext();
            Map<TextAttribute, ?> fontAttributes = this.font.getAttributes();
            fontAttributes.put(TextAttribute.SIZE, new Float(this.getZoomedDim(this.getFontSize())));
            fontAttributes.put(TextAttribute.FAMILY, this.getFontName());
            if (this.isBold()) {
                fontAttributes.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
            }
            if (this.isItalic()) {
                fontAttributes.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
            }
            if (this.isUnderline()) {
                fontAttributes.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            }
            if (this.isStrikeTrought()) {
                fontAttributes.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
            }
            float lineSpacing = 1.0f;
            if (this.getLineSpacing().equals("Single")) {
                lineSpacing = 1.0f;
            } else if (this.getLineSpacing().equals("1_1_2")) {
                lineSpacing = 1.5f;
            } else if (this.getLineSpacing().equals("Double")) {
                lineSpacing = 2.0f;
            }
            TextLayout layout = null;
            String paragr_text = "";
            boolean isMaxHeightReached = false;
            StringTokenizer tkzer = new StringTokenizer(allText, "\n");
            float drawPosY = 0.0f;
            float drawPosX = 0.0f;
            paragr_text = "";
            isMaxHeightReached = false;
            tkzer = new StringTokenizer(allText, "\n");
            ArrayList<TextReportElementLayout> textLayouts = new ArrayList<TextReportElementLayout>();
            while (tkzer.hasMoreTokens() && !isMaxHeightReached) {
                paragr_text = tkzer.nextToken();
                AttributedString atext = new AttributedString(paragr_text, fontAttributes);
                AttributedCharacterIterator paragraph = atext.getIterator();
                int paragraphStart = paragraph.getBeginIndex();
                int paragraphEnd = paragraph.getEndIndex();
                LineBreakMeasurer lineMeasurer = new LineBreakMeasurer(paragraph, fontRenderContext);
                lineMeasurer.setPosition(paragraphStart);
                layout = null;
                while (lineMeasurer.getPosition() < paragraphEnd && !isMaxHeightReached) {
                    layout = lineMeasurer.nextLayout(formatWidth);
                    if ((drawPosY += layout.getLeading() + lineSpacing * layout.getAscent()) + layout.getDescent() <= (float)(zoomedFieldHeight + 1)) {
                        if (this.getAlign().equals("Justify")) {
                            drawPosX = layout.isLeftToRight() ? 0.0f : formatWidth - layout.getAdvance();
                            if (lineMeasurer.getPosition() < paragraphEnd) {
                                layout = layout.getJustifiedLayout(formatWidth);
                            }
                        } else {
                            drawPosX = this.getAlign().equals("Right") ? (layout.isLeftToRight() ? formatWidth - layout.getAdvance() : formatWidth) : (this.getAlign().equals("Center") ? (formatWidth - layout.getAdvance()) / 2.0f : (layout.isLeftToRight() ? 0.0f : formatWidth - layout.getAdvance()));
                        }
                        float x = drawPosX + (float)gfx_x;
                        float y = drawPosY + (float)gfx_y;
                        textReportElementLayout = new TextReportElementLayout(layout, x, y);
                        textLayouts.add(textReportElementLayout);
                        drawPosY += layout.getDescent();
                        continue;
                    }
                    drawPosY -= layout.getLeading() + lineSpacing * layout.getAscent();
                    isMaxHeightReached = true;
                }
            }
            float textHeight = drawPosY;
            if (this.getVerticalAlign().equals("Top")) {
                verticalOffset = 0.0f;
            } else if (this.getVerticalAlign().equals("Middle")) {
                verticalOffset = ((float)zoomedFieldHeight - textHeight) / 2.0f;
            } else if (this.getVerticalAlign().equals("Bottom")) {
                verticalOffset = (float)zoomedFieldHeight - textHeight;
            }
            Iterator i = textLayouts.iterator();
            while (i.hasNext()) {
                textReportElementLayout = (TextReportElementLayout)i.next();
                textReportElementLayout.drawWithOffset(g, verticalOffset);
            }
        }
        if (transform != null) {
            Java2DUtil.resetTransform(g);
        }
        Java2DUtil.resetClip(g);
        this.position.x += 10;
        this.position.y += 10;
        this.drawBorder(g, zoom_factor, x_shift_origin += 10, y_shift_origin += 10);
        this.drawBorder(g, zoom_factor, x_shift_origin, y_shift_origin, this.getBox());
    }

    public String getAlign() {
        if (this.getPropertyValue(ALIGN) == null && this.getStyle() != null) {
            Style style = this.getStyle();
            this.getStyle();
            return style.getAttributeString("hAlign", DEFAULT_ALIGN, true);
        }
        return this.getStringValue(ALIGN, DEFAULT_ALIGN);
    }

    public void setAlign(String align) {
        this.setPropertyValue(ALIGN, align);
    }

    public boolean isBold() {
        if (this.getIReportFont().getPropertyValue("bold") == null && this.getStyle() != null) {
            Style style = this.getStyle();
            this.getStyle();
            return style.getAttributeBoolean("isBold", false, true);
        }
        return this.getIReportFont().getBooleanValue("bold", false);
    }

    public void setBold(boolean bold) {
        this.getIReportFont().setPropertyValue("bold", "" + bold);
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public String getFontName() {
        if (this.getIReportFont().getPropertyValue("fontName") == null && this.getStyle() != null) {
            Style style = this.getStyle();
            this.getStyle();
            return style.getAttributeString("fontName", "SansSerif", true);
        }
        return this.getIReportFont().getStringValue("fontName", "SansSerif");
    }

    public void setFontName(String fontName) {
        this.getIReportFont().setPropertyValue("fontName", fontName);
    }

    public int getFontSize() {
        if (this.getIReportFont().getPropertyValue("fontSize") == null && this.getStyle() != null) {
            Style style = this.getStyle();
            this.getStyle();
            return style.getAttributeInteger("fontSize", 10, true);
        }
        return this.getIReportFont().getIntValue("fontSize", 10);
    }

    public void setFontSize(int fontSize) {
        this.getIReportFont().setPropertyValue("fontSize", "" + fontSize);
    }

    public void modifyFontSize(int delta) {
        int newFonsSize = this.getFontSize() + delta;
        if (newFonsSize >= 5) {
            this.setFontSize(newFonsSize);
        }
    }

    public boolean isItalic() {
        if (this.getIReportFont().getPropertyValue("italic") == null && this.getStyle() != null) {
            Style style = this.getStyle();
            this.getStyle();
            return style.getAttributeBoolean("isItalic", false, true);
        }
        return this.getIReportFont().getBooleanValue("italic", false);
    }

    public void setItalic(boolean italic) {
        this.getIReportFont().setPropertyValue("italic", "" + italic);
    }

    public String getLineSpacing() {
        if (this.getPropertyValue(LINE_SPACING) == null && this.getStyle() != null) {
            Style style = this.getStyle();
            this.getStyle();
            return style.getAttributeString("lineSpacing", DEFAULT_LINE_SPACING, true);
        }
        return this.getStringValue(LINE_SPACING, DEFAULT_LINE_SPACING);
    }

    public void setLineSpacing(String lineSpacing) {
        this.setPropertyValue(LINE_SPACING, lineSpacing);
    }

    public boolean isPdfEmbedded() {
        if (this.getIReportFont().getPropertyValue("pdfEmbedded") == null && this.getStyle() != null) {
            Style style = this.getStyle();
            this.getStyle();
            return style.getAttributeBoolean("isPdfEmbedded", false, true);
        }
        return this.getIReportFont().getBooleanValue("pdfEmbedded", false);
    }

    public void setPdfEmbedded(boolean pdfEmbedded) {
        this.getIReportFont().setPropertyValue("pdfEmbedded", "" + pdfEmbedded);
    }

    public String getPdfEncoding() {
        if (this.getIReportFont().getPropertyValue("pdfEncoding") == null && this.getStyle() != null) {
            Style style = this.getStyle();
            this.getStyle();
            return style.getAttributeString("pdfEncoding", "Cp1252", true);
        }
        return this.getIReportFont().getStringValue("pdfEncoding", "Cp1252");
    }

    public void setPdfEncoding(String pdfEncoding) {
        this.getIReportFont().setPropertyValue("pdfEncoding", pdfEncoding);
    }

    public String getPDFFontName() {
        if (this.getIReportFont().getPropertyValue("PDFFontName") == null && this.getStyle() != null) {
            Style style = this.getStyle();
            this.getStyle();
            return style.getAttributeString("pdfFontName", "Helvetica", true);
        }
        return this.getIReportFont().getStringValue("PDFFontName", "Helvetica");
    }

    public void setPDFFontName(String PDFFontName) {
        this.getIReportFont().setPropertyValue("PDFFontName", PDFFontName);
    }

    public String getReportFont() {
        return this.getIReportFont().getStringValue("reportFont", "");
    }

    public void setReportFont(String reportFont) {
        this.getIReportFont().setPropertyValue("reportFont", reportFont);
    }

    public boolean isStrikeTrought() {
        if (this.getIReportFont().getPropertyValue("strikeTrought") == null && this.getStyle() != null) {
            Style style = this.getStyle();
            this.getStyle();
            return style.getAttributeBoolean("isStrikeThrough", false, true);
        }
        return this.getIReportFont().getBooleanValue("strikeTrought", false);
    }

    public void setStrikeTrought(boolean strikeTrought) {
        this.getIReportFont().setPropertyValue("strikeTrought", "" + strikeTrought);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getTTFFont() {
        if (this.getIReportFont().getPropertyValue("PDFFontName") == null && this.getStyle() != null) {
            Style style = this.getStyle();
            this.getStyle();
            return style.getAttributeString("pdfFontName", "", true);
        }
        return this.getIReportFont().getStringValue("PDFFontName", "");
    }

    public void setTTFFont(String TTFFont) {
        this.getIReportFont().setPropertyValue("PDFFontName", TTFFont);
    }

    public boolean isUnderline() {
        if (this.getIReportFont().getPropertyValue("underline") == null && this.getStyle() != null) {
            Style style = this.getStyle();
            this.getStyle();
            return style.getAttributeBoolean("isUnderline", false, true);
        }
        return this.getIReportFont().getBooleanValue("underline", false);
    }

    public void setUnderline(boolean underline) {
        this.getIReportFont().setPropertyValue("underline", "" + underline);
    }

    public String getVerticalAlign() {
        if (this.getPropertyValue(VERTICAL_ALIGN) == null && this.getStyle() != null) {
            Style style = this.getStyle();
            this.getStyle();
            return style.getAttributeString("vAlign", DEFAULT_VERTICAL_ALIGN, true);
        }
        return this.getStringValue(VERTICAL_ALIGN, DEFAULT_VERTICAL_ALIGN);
    }

    public void setVerticalAlign(String verticalAlign) {
        this.setPropertyValue(VERTICAL_ALIGN, verticalAlign);
    }

    public String getRotate() {
        if (this.getPropertyValue(ROTATE) == null && this.getStyle() != null) {
            Style style = this.getStyle();
            this.getStyle();
            return style.getAttributeString("rotation", DEFAULT_ROTATE, true);
        }
        return this.getStringValue(ROTATE, DEFAULT_ROTATE);
    }

    public void setRotate(String rotate) {
        this.setPropertyValue(ROTATE, rotate);
    }

    public int getTextHeight(FontMetrics fm) {
        return fm.getAscent() + (this.getLineCount() - 1) * fm.getHeight();
    }

    public int getLineCount() {
        String text = this.getText();
        text = text.replace('\r', ' ');
        int line = 1;
        while (text.indexOf(10) > 0) {
            ++line;
            text = text.substring(text.indexOf(10) + 1);
        }
        return line;
    }

    public void copyBaseReportElement(ReportElement destination, ReportElement source) {
        super.copyBaseReportElement(destination, source);
        if (destination instanceof TextReportElement && source instanceof TextReportElement) {
            TextReportElement tre = (TextReportElement)source;
            TextReportElement tred = (TextReportElement)destination;
            source.clone(tred);
            tre.getIReportFont().clone(tred.getIReportFont());
            ((TextReportElement)destination).setText(new String(((TextReportElement)source).getText()));
            ((TextReportElement)destination).setBox(((TextReportElement)source).getBox().cloneMe());
        }
    }

    static List getRotations() {
        return Rotation.rotations;
    }

    public boolean isIsStyledText() {
        if (this.getPropertyValue(IS_STYLED_TEXT) == null && this.getStyle() != null) {
            Style style = this.getStyle();
            this.getStyle();
            return style.getAttributeBoolean("isStyledText", DEFAULT_IS_STYLED_TEXT, true);
        }
        return this.getBooleanValue(IS_STYLED_TEXT, DEFAULT_IS_STYLED_TEXT);
    }

    public void setIsStyledText(boolean isStyledText) {
        this.setPropertyValue(IS_STYLED_TEXT, "" + isStyledText);
    }

    public Box getBox() {
        return this.box;
    }

    public void setBox(Box box) {
        this.box = box;
    }

    public void setStyle(Style style) {
        super.setStyle(style);
        if (style != null) {
            if (style.getAttributeString("border", null, true) != null) {
                this.getBox().setBorder(style.getAttributeString("border", null, true));
            }
            if (style.getAttributeColor("borderColor", null, true) != null) {
                this.getBox().setBorderColor(style.getAttributeColor("borderColor", null, true));
            }
            if (style.getAttributeString("padding", null, true) != null) {
                this.getBox().setPadding(Integer.parseInt(style.getAttributeString("padding", null, true)));
            }
            if (style.getAttributeString("topBorder", null, true) != null) {
                this.getBox().setTopBorder(style.getAttributeString("topBorder", null, true));
            }
            if (style.getAttributeColor("topBorderColor", null, true) != null) {
                this.getBox().setTopBorderColor(style.getAttributeColor("topBorderColor", null, true));
            }
            if (style.getAttributeString("topPadding", null, true) != null) {
                this.getBox().setTopPadding(Integer.parseInt(style.getAttributeString("topPadding", null, true)));
            }
            if (style.getAttributeString("leftBorder", null, true) != null) {
                this.getBox().setLeftBorder(style.getAttributeString("leftBorder", null, true));
            }
            if (style.getAttributeColor("leftBorderColor", null, true) != null) {
                this.getBox().setLeftBorderColor(style.getAttributeColor("leftBorderColor", null, true));
            }
            if (style.getAttributeString("leftPadding", null, true) != null) {
                this.getBox().setLeftPadding(Integer.parseInt(style.getAttributeString("leftPadding", null, true)));
            }
            if (style.getAttributeString("rightBorder", null, true) != null) {
                this.getBox().setRightBorder(style.getAttributeString("rightBorder", null, true));
            }
            if (style.getAttributeColor("rightBorderColor", null, true) != null) {
                this.getBox().setRightBorderColor(style.getAttributeColor("rightBorderColor", null, true));
            }
            if (style.getAttributeString("rightPadding", null, true) != null) {
                this.getBox().setRightPadding(Integer.parseInt(style.getAttributeString("rightPadding", null, true)));
            }
            if (style.getAttributeString("bottomBorder", null, true) != null) {
                this.getBox().setBottomBorder(style.getAttributeString("bottomBorder", null, true));
            }
            if (style.getAttributeColor("bottomBorderColor", null, true) != null) {
                this.getBox().setBottomBorderColor(style.getAttributeColor("bottomBorderColor", null, true));
            }
            if (style.getAttributeString("bottomPadding", null, true) != null) {
                this.getBox().setBottomPadding(Integer.parseInt(style.getAttributeString("bottomPadding", null, true)));
            }
        }
    }

    static class Rotation {
        private static ArrayList rotations;
        private String name;
        private int number;

        Rotation(String name, int number) {
            this.name = name;
            this.number = number;
            rotations = new ArrayList();
            rotations.add(this);
        }

        public int getNumber() {
            return this.number;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.getName();
        }
    }

    private class TextReportElementLayout {
        private TextLayout layout;
        private float x;
        private float y;

        private TextReportElementLayout(TextLayout layout, float x, float y) {
            this.layout = layout;
            this.x = x;
            this.y = y;
        }

        void drawWithOffset(Graphics2D g2, float yOffset) {
            this.layout.draw(g2, this.x, this.y + yOffset);
        }
    }
}

