/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import mondrian.olap.Aggregator;
import mondrian.olap.Cube;
import mondrian.olap.Dimension;
import mondrian.olap.DimensionType;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.ExpBase;
import mondrian.olap.FunCall;
import mondrian.olap.FunDef;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.LevelType;
import mondrian.olap.Literal;
import mondrian.olap.Member;
import mondrian.olap.NativeEvaluator;
import mondrian.olap.OlapElement;
import mondrian.olap.Property;
import mondrian.olap.SchemaReader;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.fun.AbstractAggregateFunDef;
import mondrian.olap.fun.AggregateFunDef;
import mondrian.olap.fun.BuiltinFunTable;
import mondrian.olap.fun.CacheFunDef;
import mondrian.olap.fun.CoalesceEmptyFunDef;
import mondrian.olap.fun.CrossJoinFunDef;
import mondrian.olap.fun.DescendantsFunDef;
import mondrian.olap.fun.DrilldownMemberFunDef;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.FunTableImpl;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.fun.FunkResolver;
import mondrian.olap.fun.IntersectFunDef;
import mondrian.olap.fun.LinReg;
import mondrian.olap.fun.MemberHelper;
import mondrian.olap.fun.MultiResolver;
import mondrian.olap.fun.NonEmptyCrossJoinFunDef;
import mondrian.olap.fun.OpeningClosingPeriodFunDef;
import mondrian.olap.fun.OrderFunDef;
import mondrian.olap.fun.ParameterFunDef;
import mondrian.olap.fun.ParenthesesFunDef;
import mondrian.olap.fun.PropertiesFunDef;
import mondrian.olap.fun.RankFunDef;
import mondrian.olap.fun.ResolverBase;
import mondrian.olap.fun.SetFunDef;
import mondrian.olap.fun.TupleFunDef;
import mondrian.olap.fun.XtdFunDef;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.SetType;
import mondrian.olap.type.TupleType;
import mondrian.olap.type.Type;
import mondrian.resource.MondrianResource;
import mondrian.util.Format;

public class BuiltinFunTable
extends FunTableImpl {
    private static BuiltinFunTable instance;
    static /* synthetic */ Class class$mondrian$olap$fun$BuiltinFunTable;

    private BuiltinFunTable() {
    }

    protected void defineFunctions() {
        this.defineReserved("NULL");
        this.define(new FunDefBase("Dimension", "<Hierarchy>.Dimension", "Returns the dimension that contains a specified hierarchy.", "pdh"){

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                Hierarchy hierarchy = 1.getHierarchyArg(evaluator, args, 0, true);
                return hierarchy.getDimension();
            }
        });
        this.define(new FunDefBase("Dimension", "<Dimension>.Dimension", "Returns the dimension that contains a specified hierarchy.", "pdd"){

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                Dimension dimension = 2.getDimensionArg(evaluator, args, 0, true);
                return dimension;
            }
        });
        this.define(new FunDefBase("Dimension", "<Level>.Dimension", "Returns the dimension that contains a specified level.", "pdl"){

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                Level level = 3.getLevelArg(evaluator, args, 0, true);
                return level.getDimension();
            }
        });
        this.define(new FunDefBase("Dimension", "<Member>.Dimension", "Returns the dimension that contains a specified member.", "pdm"){

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                Member member = 4.getMemberArg(evaluator, args, 0, true);
                return member.getDimension();
            }
        });
        this.define(new FunDefBase("Dimensions", "Dimensions(<Numeric Expression>)", "Returns the dimension whose zero-based position within the cube is specified by a numeric expression.", "fdn"){

            public Type getResultType(Validator validator, Exp[] args) {
                return new mondrian.olap.type.DimensionType(null);
            }

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                Cube cube = evaluator.getCube();
                Dimension[] dimensions = cube.getDimensions();
                int n = 5.getIntArg(evaluator, args, 0);
                if (n > dimensions.length || n < 1) {
                    throw 5.newEvalException(this, "Index '" + n + "' out of bounds");
                }
                return dimensions[n - 1];
            }
        });
        this.define(new FunDefBase("Dimensions", "Dimensions(<String Expression>)", "Returns the dimension whose name is specified by a string.", "fdS"){

            public Type getResultType(Validator validator, Exp[] args) {
                return new mondrian.olap.type.DimensionType(null);
            }

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                OlapElement o;
                String defValue = "Default Value";
                String s = 6.getStringArg(evaluator, args, 0, defValue);
                if (s.indexOf("[") == -1) {
                    s = Util.quoteMdxIdentifier(s);
                }
                if ((o = evaluator.getSchemaReader().lookupCompound(evaluator.getCube(), 6.explode(s), false, 2)) instanceof Dimension) {
                    return (Dimension)o;
                }
                if (o == null) {
                    throw 6.newEvalException(this, "Dimension '" + s + "' not found");
                }
                throw 6.newEvalException(this, "Dimensions(" + s + ") found " + o);
            }
        });
        this.define(new FunDefBase("Hierarchy", "<Level>.Hierarchy", "Returns a level's hierarchy.", "phl"){

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                Level level = 7.getLevelArg(evaluator, args, 0, true);
                return level.getHierarchy();
            }
        });
        this.define(new FunDefBase("Hierarchy", "<Member>.Hierarchy", "Returns a member's hierarchy.", "phm"){

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                Member member = 8.getMemberArg(evaluator, args, 0, true);
                return member.getHierarchy();
            }
        });
        this.define(new FunDefBase("Level", "<Member>.Level", "Returns a member's level.", "plm"){

            public Type getResultType(Validator validator, Exp[] args) {
                Type argType = args[0].getTypeX();
                return new mondrian.olap.type.LevelType(argType.getHierarchy(), argType.getLevel());
            }

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                Member member = 9.getMemberArg(evaluator, args, 0, true);
                return member.getLevel();
            }
        });
        this.define(new FunDefBase("Levels", "<Hierarchy>.Levels(<Numeric Expression>)", "Returns the level whose position in a hierarchy is specified by a numeric expression.", "mlhn"){

            public Type getResultType(Validator validator, Exp[] args) {
                Type argType = args[0].getTypeX();
                return new mondrian.olap.type.LevelType(argType.getHierarchy(), argType.getLevel());
            }

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                Hierarchy hierarchy = 10.getHierarchyArg(evaluator, args, 0, true);
                Level[] levels = hierarchy.getLevels();
                int n = 10.getIntArg(evaluator, args, 1);
                if (n >= levels.length || n < 0) {
                    throw 10.newEvalException(this, "Index '" + n + "' out of bounds");
                }
                return levels[n];
            }
        });
        this.define(new FunDefBase("Levels", "Levels(<String Expression>)", "Returns the level whose name is specified by a string expression.", "flS"){

            public Type getResultType(Validator validator, Exp[] args) {
                Type argType = args[0].getTypeX();
                return new mondrian.olap.type.LevelType(argType.getHierarchy(), argType.getLevel());
            }

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                OlapElement o;
                String s = 11.getStringArg(evaluator, args, 0, null);
                Cube cube = evaluator.getCube();
                OlapElement olapElement = o = s.startsWith("[") ? evaluator.getSchemaReader().lookupCompound(cube, 11.explode(s), false, 4) : null;
                if (o instanceof Level) {
                    return (Level)o;
                }
                if (o == null) {
                    throw 11.newEvalException(this, "Level '" + s + "' not found");
                }
                throw 11.newEvalException(this, "Levels('" + s + "') found " + o);
            }
        });
        this.define(new MultiResolver("IsEmpty", "IsEmpty(<Value Expression>)", "Determines if an expression evaluates to the empty cell value.", new String[]{"fbS", "fbn"}){

            protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
                return new FunDefBase(this, dummyFunDef){
                    private final /* synthetic */ 12 this$1;
                    {
                        this.this$1 = this$1;
                        super(x0);
                    }

                    public Object evaluate(Evaluator evaluator, Exp[] args) {
                        Object o = 13.getScalarArg(evaluator, args, 0);
                        return o == Util.nullValue;
                    }
                };
            }
        });
        this.define(new FunDefBase("IS NULL", "<Member> IS NULL", "Returns whether a member is null.", "pbm"){

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                Member member = 14.getMemberArg(evaluator, args, 0, true);
                return member.isNull();
            }
        });
        this.define(new MultiResolver("IS", "<Expression> IS <Expression>", "Returns whether two objects are the same (idempotent)", new String[]{"ibmm", "ibll", "ibhh", "ibdd"}){

            protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
                return new FunDefBase(this, dummyFunDef){
                    private final /* synthetic */ 15 this$1;
                    {
                        this.this$1 = this$1;
                        super(x0);
                    }

                    public Object evaluate(Evaluator evaluator, Exp[] args) {
                        Object arg1;
                        Object arg0 = 16.getArg(evaluator, args, 0);
                        return arg0 == (arg1 = 16.getArg(evaluator, args, 1));
                    }
                };
            }
        });
        this.define(new MultiResolver("Ancestor", "Ancestor(<Member>, {<Level>|<Numeric Expression>})", "Returns the ancestor of a member at a specified level.", new String[]{"fmml", "fmmn"}){

            protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
                return new FunDefBase(this, dummyFunDef){
                    private final /* synthetic */ 17 this$1;
                    {
                        this.this$1 = this$1;
                        super(x0);
                    }

                    public Object evaluate(Evaluator evaluator, Exp[] args) {
                        int distance;
                        Member member = 18.getMemberArg(evaluator, args, 0, false);
                        Object arg2 = 18.getArg(evaluator, args, 1);
                        Level level = null;
                        if (arg2 instanceof Level) {
                            level = (Level)arg2;
                            distance = member.getLevel().getDepth() - level.getDepth();
                        } else {
                            distance = ((Number)arg2).intValue();
                        }
                        return 18.ancestor(evaluator, member, distance, level);
                    }
                };
            }
        });
        this.define(new FunDefBase("Cousin", "Cousin(<member>, <ancestor member>)", "Returns the member with the same relative position under <ancestor member> as the member specified.", "fmmm"){

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                Member member = 19.getMemberArg(evaluator, args, 0, true);
                Member ancestorMember = 19.getMemberArg(evaluator, args, 1, true);
                Member cousin = 19.cousin(evaluator.getSchemaReader(), member, ancestorMember);
                return cousin;
            }
        });
        this.define(new FunDefBase("CurrentMember", "<Dimension>.CurrentMember", "Returns the current member along a dimension during an iteration.", "pmd"){

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                Dimension dimension = 20.getDimensionArg(evaluator, args, 0, true);
                return evaluator.getContext(dimension);
            }

            public boolean callDependsOn(FunCall call, Dimension dimension) {
                return call.getArg(0).getTypeX().usesDimension(dimension);
            }
        });
        this.define(new FunDefBase("CurrentMember", "<Hierarchy>.CurrentMember", "Returns the current member along a hierarchy during an iteration.", "pmh"){

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                Hierarchy hierarchy = 21.getHierarchyArg(evaluator, args, 0, true);
                Dimension dimension = hierarchy.getDimension();
                Member member = evaluator.getContext(dimension);
                if (member.getHierarchy() == hierarchy) {
                    return member;
                }
                return hierarchy.getDefaultMember();
            }

            public boolean callDependsOn(FunCall call, Dimension dimension) {
                return call.getArg(0).getTypeX().usesDimension(dimension);
            }
        });
        this.define(new FunDefBase("DataMember", "<Member>.DataMember", "Returns the system-generated data member that is associated with a nonleaf member of a dimension.", "pmm"){

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                Member member = 22.getMemberArg(evaluator, args, 0, true);
                return member.getDataMember();
            }
        });
        this.define(new FunDefBase("DefaultMember", "<Dimension>.DefaultMember", "Returns the default member of a dimension.", "pmd"){

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                Dimension dimension = 23.getDimensionArg(evaluator, args, 0, true);
                return evaluator.getSchemaReader().getHierarchyDefaultMember(dimension.getHierarchy());
            }
        });
        this.define(new FunDefBase("FirstChild", "<Member>.FirstChild", "Returns the first child of a member.", "pmm"){

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                Member member = 24.getMemberArg(evaluator, args, 0, true);
                Member[] children = evaluator.getSchemaReader().getMemberChildren(member);
                return children.length == 0 ? member.getHierarchy().getNullMember() : children[0];
            }
        });
        this.define(new FunDefBase("FirstSibling", "<Member>.FirstSibling", "Returns the first child of the parent of a member.", "pmm"){

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                Member[] children;
                Member member = 25.getMemberArg(evaluator, args, 0, true);
                Member parent = member.getParentMember();
                if (parent == null) {
                    if (member.isNull()) {
                        return member;
                    }
                    children = evaluator.getSchemaReader().getHierarchyRootMembers(member.getHierarchy());
                } else {
                    children = evaluator.getSchemaReader().getMemberChildren(parent);
                }
                return children[0];
            }
        });
        this.define(new MultiResolver("Lag", "<Member>.Lag(<Numeric Expression>)", "Returns a member further along the specified member's dimension.", new String[]{"mmmn"}){

            protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
                return new FunDefBase(this, dummyFunDef){
                    private final /* synthetic */ 26 this$1;
                    {
                        this.this$1 = this$1;
                        super(x0);
                    }

                    public Object evaluate(Evaluator evaluator, Exp[] args) {
                        Member member = 27.getMemberArg(evaluator, args, 0, true);
                        int n = 27.getIntArg(evaluator, args, 1);
                        return evaluator.getSchemaReader().getLeadMember(member, -n);
                    }
                };
            }
        });
        this.define(new FunDefBase("LastChild", "<Member>.LastChild", "Returns the last child of a member.", "pmm"){

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                Member member = 28.getMemberArg(evaluator, args, 0, true);
                Member[] children = evaluator.getSchemaReader().getMemberChildren(member);
                return children.length == 0 ? member.getHierarchy().getNullMember() : children[children.length - 1];
            }
        });
        this.define(new FunDefBase("LastSibling", "<Member>.LastSibling", "Returns the last child of the parent of a member.", "pmm"){

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                Member[] children;
                Member member = 29.getMemberArg(evaluator, args, 0, true);
                Member parent = member.getParentMember();
                SchemaReader schemaReader = evaluator.getSchemaReader();
                if (parent == null) {
                    if (member.isNull()) {
                        return member;
                    }
                    children = schemaReader.getHierarchyRootMembers(member.getHierarchy());
                } else {
                    children = schemaReader.getMemberChildren(parent);
                }
                return children[children.length - 1];
            }
        });
        this.define(new MultiResolver("Lead", "<Member>.Lead(<Numeric Expression>)", "Returns a member further along the specified member's dimension.", new String[]{"mmmn"}){

            protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
                return new FunDefBase(this, dummyFunDef){
                    private final /* synthetic */ 30 this$1;
                    {
                        this.this$1 = this$1;
                        super(x0);
                    }

                    public Object evaluate(Evaluator evaluator, Exp[] args) {
                        Member member = 31.getMemberArg(evaluator, args, 0, true);
                        int n = 31.getIntArg(evaluator, args, 1);
                        return evaluator.getSchemaReader().getLeadMember(member, n);
                    }
                };
            }
        });
        this.define(new FunDefBase("Members", "Members(<String Expression>)", "Returns the member whose name is specified by a string expression.", "fmS"));
        this.define(new FunDefBase("NextMember", "<Member>.NextMember", "Returns the next member in the level that contains a specified member.", "pmm"){

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                Member member = 32.getMemberArg(evaluator, args, 0, true);
                return evaluator.getSchemaReader().getLeadMember(member, 1);
            }
        });
        this.define(OpeningClosingPeriodFunDef.createResolver(true));
        this.define(OpeningClosingPeriodFunDef.createResolver(false));
        this.define(new MultiResolver("ParallelPeriod", "ParallelPeriod([<Level>[, <Numeric Expression>[, <Member>]]])", "Returns a member from a prior period in the same relative position as a specified member.", new String[]{"fm", "fml", "fmln", "fmlnm"}){

            protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
                return new FunDefBase(this, dummyFunDef){
                    private final /* synthetic */ 33 this$1;
                    {
                        this.this$1 = this$1;
                        super(x0);
                    }

                    public Type getResultType(Validator validator, Exp[] args) {
                        if (args.length == 0) {
                            Hierarchy hierarchy = validator.getQuery().getCube().getTimeDimension().getHierarchy();
                            return new MemberType(hierarchy, null, null);
                        }
                        return super.getResultType(validator, args);
                    }

                    public boolean callDependsOn(FunCall call, Dimension dimension) {
                        if (super.callDependsOn(call, dimension)) {
                            return true;
                        }
                        Exp[] args = call.getArgs();
                        switch (args.length) {
                            case 0: {
                                return dimension.getDimensionType() == DimensionType.TimeDimension;
                            }
                            case 1: 
                            case 2: {
                                return args[0].getTypeX().usesDimension(dimension);
                            }
                            case 3: {
                                return false;
                            }
                        }
                        throw Util.newInternal("bad arg count " + args.length);
                    }

                    public Object evaluate(Evaluator evaluator, Exp[] args) {
                        Level ancestorLevel;
                        int lagValue;
                        Member member = args.length == 3 ? 34.getMemberArg(evaluator, args, 2, true) : evaluator.getContext(evaluator.getCube().getTimeDimension());
                        int n = lagValue = args.length >= 2 ? 34.getIntArg(evaluator, args, 1) : 1;
                        if (args.length >= 1) {
                            ancestorLevel = 34.getLevelArg(evaluator, args, 0, true);
                        } else {
                            Member parent = member.getParentMember();
                            if (parent == null || parent.getCategory() != 6) {
                                return member.getHierarchy().getNullMember();
                            }
                            ancestorLevel = parent.getLevel();
                        }
                        if (member.getHierarchy() != ancestorLevel.getHierarchy()) {
                            MondrianResource.instance().FunctionMbrAndLevelHierarchyMismatch.ex("ParallelPeriod", ancestorLevel.getHierarchy().getUniqueName(), member.getHierarchy().getUniqueName());
                        }
                        int distance = member.getLevel().getDepth() - ancestorLevel.getDepth();
                        Member ancestor = 34.ancestor(evaluator, member, distance, ancestorLevel);
                        Member inLaw = evaluator.getSchemaReader().getLeadMember(ancestor, -lagValue);
                        return 34.cousin(evaluator.getSchemaReader(), member, inLaw);
                    }
                };
            }
        });
        this.define(new FunDefBase("Parent", "<Member>.Parent", "Returns the parent of a member.", "pmm"){

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                Member member = 35.getMemberArg(evaluator, args, 0, true);
                Member parent = evaluator.getSchemaReader().getMemberParent(member);
                if (parent == null) {
                    parent = member.getHierarchy().getNullMember();
                }
                return parent;
            }
        });
        this.define(new FunDefBase("PrevMember", "<Member>.PrevMember", "Returns the previous member in the level that contains a specified member.", "pmm"){

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                Member member = 36.getMemberArg(evaluator, args, 0, true);
                return evaluator.getSchemaReader().getLeadMember(member, -1);
            }
        });
        this.define(new FunDefBase("StrToMember", "StrToMember(<String Expression>)", "Returns a member from a unique name String in MDX format.", "fmS"){

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                String mname = 37.getStringArg(evaluator, args, 0, null);
                Cube cube = evaluator.getCube();
                SchemaReader schemaReader = evaluator.getSchemaReader();
                String[] uniqueNameParts = Util.explode(mname);
                Member member = (Member)schemaReader.lookupCompound(cube, uniqueNameParts, true, 6);
                return member;
            }
        });
        this.define(new AggregateFunDef.Resolver());
        this.define(new MultiResolver("$AggregateChildren", "$AggregateChildren(<Hierarchy>)", "Equivalent to 'Aggregate(<Hierarchy>.CurrentMember.Children); for internal use.", new String[]{"Inh"}){

            protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
                return new FunDefBase(this, dummyFunDef){
                    final Exp valueFunCall;
                    private final /* synthetic */ 38 this$1;
                    {
                        this.this$1 = this$1;
                        super(x0);
                        this.valueFunCall = FunTableImpl.createValueFunCall();
                    }

                    public void unparse(Exp[] args, PrintWriter pw) {
                        pw.print(this.getName());
                        pw.print("(");
                        args[0].unparse(pw);
                        pw.print(")");
                    }

                    public boolean callDependsOn(FunCall call, Dimension dimension) {
                        return true;
                    }

                    public Object evaluate(Evaluator evaluator, Exp[] args) {
                        Hierarchy hierarchy = 39.getHierarchyArg(evaluator, args, 0, true);
                        Member member = evaluator.getParent().getContext(hierarchy.getDimension());
                        List members = (List)member.getPropertyValue(Property.CONTRIBUTING_CHILDREN.name);
                        Aggregator aggregator = (Aggregator)evaluator.getProperty(Property.AGGREGATION_TYPE.name, null);
                        if (aggregator == null) {
                            throw 39.newEvalException(null, "Could not find an aggregator in the current evaluation context");
                        }
                        Aggregator rollup = aggregator.getRollup();
                        if (rollup == null) {
                            throw 39.newEvalException(null, "Don't know how to rollup aggregator '" + aggregator + "'");
                        }
                        return rollup.aggregate(evaluator.push(), members, this.valueFunCall);
                    }
                };
            }
        });
        this.define(new MultiResolver("Avg", "Avg(<Set>[, <Numeric Expression>])", "Returns the average value of a numeric expression evaluated over a set.", new String[]{"fnx", "fnxn"}){

            protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
                return new AbstractAggregateFunDef(this, dummyFunDef){
                    private final /* synthetic */ 40 this$1;
                    {
                        this.this$1 = this$1;
                        super(x0);
                    }

                    public Object evaluate(Evaluator evaluator, Exp[] args) {
                        List members = (List)41.getArg(evaluator, args, 0);
                        ExpBase exp = (ExpBase)41.getArgNoEval(args, 1, this.valueFunCall);
                        return 41.avg(evaluator.push(), members, exp);
                    }
                };
            }
        });
        this.define(new MultiResolver("Correlation", "Correlation(<Set>, <Numeric Expression>[, <Numeric Expression>])", "Returns the correlation of two series evaluated over a set.", new String[]{"fnxn", "fnxnn"}){

            protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
                return new AbstractAggregateFunDef(this, dummyFunDef){
                    private final /* synthetic */ 42 this$1;
                    {
                        this.this$1 = this$1;
                        super(x0);
                    }

                    public Object evaluate(Evaluator evaluator, Exp[] args) {
                        List members = (List)43.getArg(evaluator, args, 0);
                        ExpBase exp1 = (ExpBase)43.getArgNoEval(args, 1);
                        ExpBase exp2 = (ExpBase)43.getArgNoEval(args, 2, this.valueFunCall);
                        return 43.correlation(evaluator.push(), members, exp1, exp2);
                    }
                };
            }
        });
        final String[] resWords = new String[]{"INCLUDEEMPTY", "EXCLUDEEMPTY"};
        this.define(new MultiResolver("Count", "Count(<Set>[, EXCLUDEEMPTY | INCLUDEEMPTY])", "Returns the number of tuples in a set, empty cells included unless the optional EXCLUDEEMPTY flag is used.", new String[]{"fnx", "fnxy"}){

            protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
                return new AbstractAggregateFunDef(this, dummyFunDef){
                    private final /* synthetic */ 44 this$1;
                    {
                        this.this$1 = this$1;
                        super(x0);
                    }

                    public boolean callDependsOn(FunCall call, Dimension dimension) {
                        if (super.callDependsOn(call, dimension)) {
                            return true;
                        }
                        Exp[] args = call.getArgs();
                        String empties = 45.getLiteralArg(args, 1, "INCLUDEEMPTY", 44.access$000(this.this$1), null);
                        boolean includeEmpty = empties.equals("INCLUDEEMPTY");
                        if (includeEmpty) {
                            return false;
                        }
                        return !args[0].getTypeX().usesDimension(dimension);
                    }

                    public Object evaluate(Evaluator evaluator, Exp[] args) {
                        List members = (List)45.getArg(evaluator, args, 0);
                        String empties = 45.getLiteralArg(args, 1, "INCLUDEEMPTY", 44.access$000(this.this$1), null);
                        boolean includeEmpty = empties.equals("INCLUDEEMPTY");
                        return 45.count(evaluator, members, includeEmpty);
                    }
                };
            }

            public String[] getReservedWords() {
                return resWords;
            }

            static /* synthetic */ String[] access$000(44 x0) {
                return x0.resWords;
            }
        });
        this.define(new FunDefBase("Count", "<Set>.Count", "Returns the number of tuples in a set including empty cells.", "pnx"){

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                List members = (List)46.getArg(evaluator, args, 0);
                return 46.count(evaluator, members, true);
            }
        });
        this.define(new MultiResolver("Covariance", "Covariance(<Set>, <Numeric Expression>[, <Numeric Expression>])", "Returns the covariance of two series evaluated over a set (biased).", new String[]{"fnxn", "fnxnn"}){

            protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
                return new FunDefBase(this, dummyFunDef){
                    private final /* synthetic */ 47 this$1;
                    {
                        this.this$1 = this$1;
                        super(x0);
                    }

                    public Object evaluate(Evaluator evaluator, Exp[] args) {
                        List members = (List)48.getArg(evaluator, args, 0);
                        ExpBase exp1 = (ExpBase)48.getArgNoEval(args, 1);
                        ExpBase exp2 = (ExpBase)48.getArgNoEval(args, 2);
                        return 48.covariance(evaluator.push(), members, exp1, exp2, true);
                    }
                };
            }
        });
        this.define(new MultiResolver("CovarianceN", "CovarianceN(<Set>, <Numeric Expression>[, <Numeric Expression>])", "Returns the covariance of two series evaluated over a set (unbiased).", new String[]{"fnxn", "fnxnn"}){

            protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
                return new AbstractAggregateFunDef(this, dummyFunDef){
                    private final /* synthetic */ 49 this$1;
                    {
                        this.this$1 = this$1;
                        super(x0);
                    }

                    public Object evaluate(Evaluator evaluator, Exp[] args) {
                        List members = (List)50.getArg(evaluator, args, 0);
                        ExpBase exp1 = (ExpBase)50.getArgNoEval(args, 1);
                        ExpBase exp2 = (ExpBase)50.getArgNoEval(args, 2, this.valueFunCall);
                        return 50.covariance(evaluator.push(), members, exp1, exp2, false);
                    }
                };
            }
        });
        this.define(new FunDefBase("IIf", "IIf(<Logical Expression>, <Numeric Expression1>, <Numeric Expression2>)", "Returns one of two numeric values determined by a logical test.", "fnbnn"){

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                Boolean b = 51.getBooleanArg(evaluator, args, 0);
                if (b == null) {
                    51.getDoubleArg(evaluator, args, 1, null);
                    51.getDoubleArg(evaluator, args, 2, null);
                    return new Double(Double.NaN);
                }
                Double o = b != false ? 51.getDoubleArg(evaluator, args, 1, null) : 51.getDoubleArg(evaluator, args, 2, null);
                return o;
            }
        });
        this.define(new FunkResolver("LinRegIntercept", "LinRegIntercept(<Set>, <Numeric Expression>[, <Numeric Expression>])", "Calculates the linear regression of a set and returns the value of b in the regression line y = ax + b.", new String[]{"fnxn", "fnxnn"}, new LinReg.Intercept()));
        this.define(new FunkResolver("LinRegPoint", "LinRegPoint(<Numeric Expression>, <Set>, <Numeric Expression>[, <Numeric Expression>])", "Calculates the linear regression of a set and returns the value of y in the regression line y = ax + b.", new String[]{"fnnxn", "fnnxnn"}, new LinReg.Point()));
        this.define(new FunkResolver("LinRegR2", "LinRegR2(<Set>, <Numeric Expression>[, <Numeric Expression>])", "Calculates the linear regression of a set and returns R2 (the coefficient of determination).", new String[]{"fnxn", "fnxnn"}, new LinReg.R2()));
        this.define(new FunkResolver("LinRegSlope", "LinRegSlope(<Set>, <Numeric Expression>[, <Numeric Expression>])", "Calculates the linear regression of a set and returns the value of a in the regression line y = ax + b.", new String[]{"fnxn", "fnxnn"}, new LinReg.Slope()));
        this.define(new FunkResolver("LinRegVariance", "LinRegVariance(<Set>, <Numeric Expression>[, <Numeric Expression>])", "Calculates the linear regression of a set and returns the variance associated with the regression line y = ax + b.", new String[]{"fnxn", "fnxnn"}, new LinReg.Variance()));
        this.define(new MultiResolver("Max", "Max(<Set>[, <Numeric Expression>])", "Returns the maximum value of a numeric expression evaluated over a set.", new String[]{"fnx", "fnxn"}){

            protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
                return new AbstractAggregateFunDef(this, dummyFunDef){
                    private final /* synthetic */ 52 this$1;
                    {
                        this.this$1 = this$1;
                        super(x0);
                    }

                    public Object evaluate(Evaluator evaluator, Exp[] args) {
                        List members = (List)53.getArg(evaluator, args, 0);
                        ExpBase exp = (ExpBase)53.getArgNoEval(args, 1, this.valueFunCall);
                        return 53.max(evaluator.push(), members, exp);
                    }
                };
            }
        });
        this.define(new MultiResolver("Median", "Median(<Set>[, <Numeric Expression>])", "Returns the median value of a numeric expression evaluated over a set.", new String[]{"fnx", "fnxn"}){

            protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
                return new AbstractAggregateFunDef(this, dummyFunDef){
                    private final /* synthetic */ 54 this$1;
                    {
                        this.this$1 = this$1;
                        super(x0);
                    }

                    public Object evaluate(Evaluator evaluator, Exp[] args) {
                        List members = (List)55.getArg(evaluator, args, 0);
                        ExpBase exp = (ExpBase)55.getArgNoEval(args, 1, this.valueFunCall);
                        return 55.median(evaluator.push(), members, exp);
                    }
                };
            }
        });
        this.define(new MultiResolver("Min", "Min(<Set>[, <Numeric Expression>])", "Returns the minimum value of a numeric expression evaluated over a set.", new String[]{"fnx", "fnxn"}){

            protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
                return new AbstractAggregateFunDef(this, dummyFunDef){
                    private final /* synthetic */ 56 this$1;
                    {
                        this.this$1 = this$1;
                        super(x0);
                    }

                    public Object evaluate(Evaluator evaluator, Exp[] args) {
                        List members = (List)57.getArg(evaluator, args, 0);
                        ExpBase exp = (ExpBase)57.getArgNoEval(args, 1, this.valueFunCall);
                        return 57.min(evaluator.push(), members, exp);
                    }
                };
            }
        });
        this.define(new FunDefBase("Ordinal", "<Level>.Ordinal", "Returns the zero-based ordinal value associated with a level.", "pnl"){

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                Level level = 58.getLevelArg(evaluator, args, 0, false);
                return new Double(level.getDepth());
            }
        });
        this.define(RankFunDef.createResolver());
        this.define(new CacheFunDef.CacheFunResolver());
        this.define(new MultiResolver("Stddev", "Stddev(<Set>[, <Numeric Expression>])", "Alias for Stdev.", new String[]{"fnx", "fnxn"}){

            protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
                return new AbstractAggregateFunDef(this, dummyFunDef){
                    private final /* synthetic */ 59 this$1;
                    {
                        this.this$1 = this$1;
                        super(x0);
                    }

                    public Object evaluate(Evaluator evaluator, Exp[] args) {
                        List members = (List)60.getArg(evaluator, args, 0);
                        ExpBase exp = (ExpBase)60.getArgNoEval(args, 1, this.valueFunCall);
                        return 60.stdev(evaluator.push(), members, exp, false);
                    }
                };
            }
        });
        this.define(new MultiResolver("Stdev", "Stdev(<Set>[, <Numeric Expression>])", "Returns the standard deviation of a numeric expression evaluated over a set (unbiased).", new String[]{"fnx", "fnxn"}){

            protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
                return new AbstractAggregateFunDef(this, dummyFunDef){
                    private final /* synthetic */ 61 this$1;
                    {
                        this.this$1 = this$1;
                        super(x0);
                    }

                    public Object evaluate(Evaluator evaluator, Exp[] args) {
                        List members = (List)62.getArg(evaluator, args, 0);
                        ExpBase exp = (ExpBase)62.getArgNoEval(args, 1, this.valueFunCall);
                        return 62.stdev(evaluator.push(), members, exp, false);
                    }
                };
            }
        });
        this.define(new MultiResolver("StddevP", "StddevP(<Set>[, <Numeric Expression>])", "Alias for StdevP.", new String[]{"fnx", "fnxn"}){

            protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
                return new AbstractAggregateFunDef(this, dummyFunDef){
                    private final /* synthetic */ 63 this$1;
                    {
                        this.this$1 = this$1;
                        super(x0);
                    }

                    public Object evaluate(Evaluator evaluator, Exp[] args) {
                        List members = (List)64.getArg(evaluator, args, 0);
                        ExpBase exp = (ExpBase)64.getArgNoEval(args, 1, this.valueFunCall);
                        return 64.stdev(evaluator.push(), members, exp, true);
                    }
                };
            }
        });
        this.define(new MultiResolver("StdevP", "StdevP(<Set>[, <Numeric Expression>])", "Returns the standard deviation of a numeric expression evaluated over a set (biased).", new String[]{"fnx", "fnxn"}){

            protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
                return new AbstractAggregateFunDef(this, dummyFunDef){
                    private final /* synthetic */ 65 this$1;
                    {
                        this.this$1 = this$1;
                        super(x0);
                    }

                    public Object evaluate(Evaluator evaluator, Exp[] args) {
                        List members = (List)66.getArg(evaluator, args, 0);
                        ExpBase exp = (ExpBase)66.getArgNoEval(args, 1, this.valueFunCall);
                        return 66.stdev(evaluator.push(), members, exp, true);
                    }
                };
            }
        });
        this.define(new MultiResolver("Sum", "Sum(<Set>[, <Numeric Expression>])", "Returns the sum of a numeric expression evaluated over a set.", new String[]{"fnx", "fnxn"}){

            protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
                return new AbstractAggregateFunDef(this, dummyFunDef){
                    private final /* synthetic */ 67 this$1;
                    {
                        this.this$1 = this$1;
                        super(x0);
                    }

                    public Object evaluate(Evaluator evaluator, Exp[] args) {
                        List members = (List)68.getArg(evaluator, args, 0);
                        ExpBase exp = (ExpBase)68.getArgNoEval(args, 1, this.valueFunCall);
                        return 68.sum(evaluator.push(), members, exp);
                    }
                };
            }
        });
        this.define(new FunDefBase("Value", "<Measure>.Value", "Returns the value of a measure.", "pnm"){

            public boolean callDependsOn(FunCall call, Dimension dimension) {
                if (super.callDependsOn(call, dimension)) {
                    return true;
                }
                return !call.getArg(0).getTypeX().usesDimension(dimension);
            }

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                Member member = 69.getMemberArg(evaluator, args, 0, true);
                return member.evaluateScalar(evaluator);
            }
        });
        this.define(new FunDefBase("_Value", "_Value(<Tuple>)", "Returns the value of the current measure within the context of a tuple.", "fnt"){

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                throw new UnsupportedOperationException();
            }

            public boolean callDependsOn(FunCall call, Dimension dimension) {
                Exp[] args = call.getArgs();
                for (int i = 0; i < args.length; ++i) {
                    Exp arg = args[i];
                    Type argType = arg.getTypeX();
                    if (!argType.usesDimension(dimension)) continue;
                    return arg.dependsOn(dimension);
                }
                return true;
            }
        });
        this.define(new FunDefBase("_Value", "_Value()", "Returns the value of the current measure.", "fn"){

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                throw new UnsupportedOperationException();
            }
        });
        this.define(new MultiResolver("Var", "Var(<Set>[, <Numeric Expression>])", "Returns the variance of a numeric expression evaluated over a set (unbiased).", new String[]{"fnx", "fnxn"}){

            protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
                return new AbstractAggregateFunDef(this, dummyFunDef){
                    private final /* synthetic */ 73 this$1;
                    {
                        this.this$1 = this$1;
                        super(x0);
                    }

                    public Object evaluate(Evaluator evaluator, Exp[] args) {
                        List members = (List)74.getArg(evaluator, args, 0);
                        ExpBase exp = (ExpBase)74.getArgNoEval(args, 1, this.valueFunCall);
                        return 74.var(evaluator.push(), members, exp, false);
                    }
                };
            }
        });
        this.define(new MultiResolver("Variance", "Variance(<Set>[, <Numeric Expression>])", "Alias for Var.", new String[]{"fnx", "fnxn"}){

            protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
                return new AbstractAggregateFunDef(this, dummyFunDef){
                    private final /* synthetic */ 75 this$1;
                    {
                        this.this$1 = this$1;
                        super(x0);
                    }

                    public Object evaluate(Evaluator evaluator, Exp[] args) {
                        List members = (List)76.getArg(evaluator, args, 0);
                        ExpBase exp = (ExpBase)76.getArgNoEval(args, 1, this.valueFunCall);
                        return 76.var(evaluator.push(), members, exp, false);
                    }
                };
            }
        });
        this.define(new MultiResolver("VarianceP", "VarianceP(<Set>[, <Numeric Expression>])", "Alias for VarP.", new String[]{"fnx", "fnxn"}){

            protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
                return new AbstractAggregateFunDef(this, dummyFunDef){
                    private final /* synthetic */ 77 this$1;
                    {
                        this.this$1 = this$1;
                        super(x0);
                    }

                    public Object evaluate(Evaluator evaluator, Exp[] args) {
                        List members = (List)78.getArg(evaluator, args, 0);
                        ExpBase exp = (ExpBase)78.getArgNoEval(args, 1, this.valueFunCall);
                        return 78.var(evaluator.push(), members, exp, true);
                    }
                };
            }
        });
        this.define(new MultiResolver("VarP", "VarP(<Set>[, <Numeric Expression>])", "Returns the variance of a numeric expression evaluated over a set (biased).", new String[]{"fnx", "fnxn"}){

            protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
                return new AbstractAggregateFunDef(this, dummyFunDef){
                    private final /* synthetic */ 79 this$1;
                    {
                        this.this$1 = this$1;
                        super(x0);
                    }

                    public Object evaluate(Evaluator evaluator, Exp[] args) {
                        List members = (List)80.getArg(evaluator, args, 0);
                        ExpBase exp = (ExpBase)80.getArgNoEval(args, 1, this.valueFunCall);
                        return 80.var(evaluator.push(), members, exp, true);
                    }
                };
            }
        });
        this.define(new FunDefBase("AddCalculatedMembers", "AddCalculatedMembers(<Set>)", "Adds calculated members to a set.", "fxx"){

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                ArrayList memberList = (ArrayList)81.getArg(evaluator, args, 0);
                if (memberList != null) {
                    HashMap levelMap = new HashMap();
                    Dimension dim = null;
                    Iterator<Object> it = memberList.iterator();
                    while (it.hasNext()) {
                        Object obj = it.next();
                        if (!(obj instanceof Member)) {
                            throw 81.newEvalException(this, "Only single dimension members allowed in set for AddCalculatedMembers");
                        }
                        Member member = (Member)obj;
                        if (dim == null) {
                            dim = member.getDimension();
                        } else if (dim != member.getDimension()) {
                            throw 81.newEvalException(this, "Only members from the same dimension are allowed in the AddCalculatedMembers set: " + dim.toString() + " vs " + member.getDimension().toString());
                        }
                        if (levelMap.containsKey(member.getLevel())) continue;
                        levelMap.put(member.getLevel(), null);
                    }
                    ArrayList workingList = new ArrayList();
                    workingList.addAll(memberList);
                    it = levelMap.keySet().iterator();
                    while (it.hasNext()) {
                        Level level = (Level)it.next();
                        List tmp = evaluator.getSchemaReader().getCalculatedMembers(level);
                        if (tmp != null) {
                            workingList.addAll(tmp);
                        }
                        if ((tmp = evaluator.getQuery().getSchemaReader(true).getCalculatedMembers(level)) == null) continue;
                        workingList.addAll(tmp);
                    }
                    memberList = workingList;
                }
                return memberList;
            }
        });
        this.define(new FunDefBase("Ascendants", "Ascendants(<Member>)", "Returns the set of the ascendants of a specified member.", "fxm"){

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                Member member = 82.getMemberArg(evaluator, args, 0, false);
                if (member.isNull()) {
                    return new ArrayList();
                }
                Object[] members = member.getAncestorMembers();
                ArrayList<Member> result = new ArrayList<Member>(members.length + 1);
                result.add(member);
                82.addAll(result, (Object[])members);
                return result;
            }
        });
        this.define(new MultiResolver("BottomCount", "BottomCount(<Set>, <Count>[, <Numeric Expression>])", "Returns a specified number of items from the bottom of a set, optionally ordering the set first.", new String[]{"fxxnn", "fxxn"}){

            protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
                return new FunDefBase(this, dummyFunDef){
                    private final /* synthetic */ 83 this$1;
                    {
                        this.this$1 = this$1;
                        super(x0);
                    }

                    public Object evaluate(Evaluator evaluator, Exp[] args) {
                        SchemaReader schemaReader = evaluator.getSchemaReader();
                        NativeEvaluator nativeEvaluator = schemaReader.getNativeSetEvaluator(this, evaluator, args);
                        if (nativeEvaluator != null) {
                            return nativeEvaluator.execute();
                        }
                        List<E> list = (List<E>)84.getArg(evaluator, args, 0);
                        int n = 84.getIntArg(evaluator, args, 1);
                        ExpBase exp = (ExpBase)84.getArgNoEval(args, 2, null);
                        if (exp != null) {
                            boolean desc = false;
                            boolean brk = true;
                            84.sort(evaluator.push(), list, exp, desc, brk);
                        }
                        if (n < list.size()) {
                            list = list.subList(0, n);
                        }
                        return list;
                    }
                };
            }
        });
        this.define(new MultiResolver("BottomPercent", "BottomPercent(<Set>, <Percentage>, <Numeric Expression>)", "Sorts a set and returns the bottom N elements whose cumulative total is at least a specified percentage.", new String[]{"fxxnn"}){

            protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
                return new FunDefBase(this, dummyFunDef){
                    private final /* synthetic */ 85 this$1;
                    {
                        this.this$1 = this$1;
                        super(x0);
                    }

                    public Object evaluate(Evaluator evaluator, Exp[] args) {
                        List members = (List)86.getArg(evaluator, args, 0);
                        ExpBase exp = (ExpBase)86.getArgNoEval(args, 2);
                        Double n = 86.getDoubleArg(evaluator, args, 1);
                        return 86.topOrBottom(evaluator.push(), members, exp, false, true, n);
                    }
                };
            }
        });
        this.define(new MultiResolver("BottomSum", "BottomSum(<Set>, <Value>, <Numeric Expression>)", "Sorts a set and returns the bottom N elements whose cumulative total is at least a specified value.", new String[]{"fxxnn"}){

            protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
                return new FunDefBase(this, dummyFunDef){
                    private final /* synthetic */ 87 this$1;
                    {
                        this.this$1 = this$1;
                        super(x0);
                    }

                    public Object evaluate(Evaluator evaluator, Exp[] args) {
                        List members = (List)88.getArg(evaluator, args, 0);
                        ExpBase exp = (ExpBase)88.getArgNoEval(args, 2);
                        Double n = 88.getDoubleArg(evaluator, args, 1);
                        return 88.topOrBottom(evaluator.push(), members, exp, false, false, n);
                    }
                };
            }
        });
        this.define(new FunDefBase("Children", "<Member>.Children", "Returns the children of a member.", "pxm"){

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                Member member = 89.getMemberArg(evaluator, args, 0, true);
                Member[] children = BuiltinFunTable.this.getNonEmptyMemberChildren(evaluator, member);
                return Arrays.asList(children);
            }
        });
        this.define(new MultiResolver("Crossjoin", "Crossjoin(<Set1>, <Set2>)", "Returns the cross product of two sets.", new String[]{"fxxx"}){

            protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
                return new CrossJoinFunDef(dummyFunDef);
            }
        });
        this.define(new MultiResolver("NonEmptyCrossJoin", "NonEmptyCrossJoin(<Set1>, <Set2>)", "Returns the cross product of two sets, excluding empty tuples and tuples without associated fact table data.", new String[]{"fxxx"}){

            protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
                return new NonEmptyCrossJoinFunDef(dummyFunDef);
            }
        });
        this.define(new MultiResolver("*", "<Set1> * <Set2>", "Returns the cross product of two sets.", new String[]{"ixxx", "ixmx", "ixxm", "ixmm"}){

            public FunDef resolve(Exp[] args, Validator validator, int[] conversionCount) {
                if (validator.requiresExpression()) {
                    return null;
                }
                return super.resolve(args, validator, conversionCount);
            }

            protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
                return new CrossJoinFunDef(dummyFunDef);
            }
        });
        this.define(new DescendantsFunDef.Resolver());
        this.define(new FunDefBase("Distinct", "Distinct(<Set>)", "Eliminates duplicate tuples from a set.", "fxx"){

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                List list = (List)93.getArg(evaluator, args, 0);
                HashSet<MemberHelper> hashSet = new HashSet<MemberHelper>(list.size());
                Iterator iter = list.iterator();
                ArrayList result = new ArrayList();
                while (iter.hasNext()) {
                    Object element = iter.next();
                    MemberHelper lookupObj = new MemberHelper(element);
                    if (!hashSet.add(lookupObj)) continue;
                    result.add(element);
                }
                return result;
            }
        });
        this.define(new MultiResolver("DrilldownLevel", "DrilldownLevel(<Set>[, <Level>]) or DrilldownLevel(<Set>, , <Index>)", "Drills down the members of a set, at a specified level, to one level below. Alternatively, drills down on a specified dimension in the set.", new String[]{"fxx", "fxxl"}){

            protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
                return new FunDefBase(this, dummyFunDef){
                    private final /* synthetic */ 94 this$1;
                    {
                        this.this$1 = this$1;
                        super(x0);
                    }

                    public Object evaluate(Evaluator evaluator, Exp[] args) {
                        List set0 = (List)95.getArg(evaluator, args, 0);
                        if (set0.size() == 0) {
                            return set0;
                        }
                        int searchDepth = -1;
                        Level level = 95.getLevelArg(evaluator, args, 1, false);
                        if (level != null) {
                            searchDepth = level.getDepth();
                        }
                        if (searchDepth == -1) {
                            searchDepth = ((Member)set0.get(0)).getLevel().getDepth();
                            int m = set0.size();
                            for (int i = 1; i < m; ++i) {
                                Member member = (Member)set0.get(i);
                                int memberDepth = member.getLevel().getDepth();
                                if (memberDepth <= searchDepth) continue;
                                searchDepth = memberDepth;
                            }
                        }
                        ArrayList<Member> drilledSet = new ArrayList<Member>();
                        int m = set0.size();
                        for (int i = 0; i < m; ++i) {
                            Member nextMember;
                            Member member = (Member)set0.get(i);
                            drilledSet.add(member);
                            Member member2 = nextMember = i == m - 1 ? null : (Member)set0.get(i + 1);
                            if (member.getLevel().getDepth() != searchDepth || 95.isAncestorOf(member, nextMember, true)) continue;
                            Member[] childMembers = evaluator.getSchemaReader().getMemberChildren(member);
                            for (int j = 0; j < childMembers.length; ++j) {
                                drilledSet.add(childMembers[j]);
                            }
                        }
                        return drilledSet;
                    }
                };
            }
        });
        this.define(new DrilldownMemberFunDef.Resolver());
        this.define(new MultiResolver("Except", "Except(<Set1>, <Set2>[, ALL])", "Finds the difference between two sets, optionally retaining duplicates.", new String[]{"fxxx", "fxxxy"}){

            protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
                return new FunDefBase(this, dummyFunDef){
                    private final /* synthetic */ 96 this$1;
                    {
                        this.this$1 = this$1;
                        super(x0);
                    }

                    public Object evaluate(Evaluator evaluator, Exp[] args) {
                        HashSet<E> set = new HashSet<E>();
                        set.addAll((List)97.getArg(evaluator, args, 1));
                        List set1 = (List)97.getArg(evaluator, args, 0);
                        ArrayList<E> result = new ArrayList<E>();
                        int count = set1.size();
                        for (int i = 0; i < count; ++i) {
                            E o = set1.get(i);
                            if (set.contains(o)) continue;
                            result.add(o);
                        }
                        return result;
                    }
                };
            }
        });
        this.define(new FunDefBase("Filter", "Filter(<Set>, <Search Condition>)", "Returns the set resulting from filtering a set based on a search condition.", "fxxb"){

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                SchemaReader schemaReader = evaluator.getSchemaReader();
                NativeEvaluator nativeEvaluator = schemaReader.getNativeSetEvaluator(this, evaluator, args);
                if (nativeEvaluator != null) {
                    return nativeEvaluator.execute();
                }
                List members = (List)98.getArg(evaluator, args, 0);
                Exp exp = args[1];
                ArrayList result = new ArrayList();
                Evaluator evaluator2 = evaluator.push();
                int count = members.size();
                for (int i = 0; i < count; ++i) {
                    Object o = members.get(i);
                    if (o instanceof Member) {
                        evaluator2.setContext((Member)o);
                    } else if (o instanceof Member[]) {
                        evaluator2.setContext((Member[])o);
                    } else {
                        throw Util.newInternal("unexpected type in set: " + o.getClass());
                    }
                    Boolean b = (Boolean)exp.evaluateScalar(evaluator2);
                    if (b == null || !b.booleanValue()) continue;
                    result.add(o);
                }
                return result;
            }

            public boolean callDependsOn(FunCall call, Dimension dimension) {
                return FunUtil.callDependsOnSet(call, dimension);
            }
        });
        this.define(new MultiResolver("Generate", "Generate(<Set1>, <Set2>[, ALL])", "Applies a set to each member of another set and joins the resulting sets by union.", new String[]{"fxxx", "fxxxy"}){

            protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
                boolean all = 99.getLiteralArg(args, 2, "", new String[]{"ALL"}, dummyFunDef).equalsIgnoreCase("ALL");
                return new FunDefBase(this, dummyFunDef, all){
                    private final /* synthetic */ boolean val$all;
                    private final /* synthetic */ 99 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$all = val$all;
                        super(x0);
                    }

                    public boolean callDependsOn(FunCall call, Dimension dimension) {
                        return FunUtil.callDependsOnSet(call, dimension);
                    }

                    public Object evaluate(Evaluator evaluator, Exp[] args) {
                        List members = (List)100.getArg(evaluator, args, 0);
                        Evaluator evaluator2 = evaluator.push();
                        ArrayList<E> result = new ArrayList<E>();
                        HashSet<E> emitted = this.val$all ? null : new HashSet<E>();
                        for (int i = 0; i < members.size(); ++i) {
                            E o = members.get(i);
                            if (o instanceof Member) {
                                evaluator2.setContext((Member)o);
                            } else {
                                evaluator2.setContext((Member[])o);
                            }
                            List result2 = (List)args[1].evaluate(evaluator2);
                            if (this.val$all) {
                                result.addAll(result2);
                                continue;
                            }
                            for (int j = 0; j < result2.size(); ++j) {
                                E row = result2.get(j);
                                if (!emitted.add(row)) continue;
                                result.add(row);
                            }
                        }
                        return result;
                    }
                };
            }
        });
        this.define(new MultiResolver("Head", "Head(<Set>[, < Numeric Expression >])", "Returns the first specified number of elements in a set.", new String[]{"fxx", "fxxn"}){

            protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
                return new FunDefBase(this, dummyFunDef){
                    private final /* synthetic */ 101 this$1;
                    {
                        this.this$1 = this$1;
                        super(x0);
                    }

                    public Object evaluate(Evaluator evaluator, Exp[] args) {
                        int count;
                        List members = (List)102.getArg(evaluator, args, 0);
                        int n = count = args.length < 2 ? 1 : 102.getIntArg(evaluator, args, 1);
                        if (count >= members.size()) {
                            return members;
                        }
                        if (count <= 0) {
                            return new ArrayList<E>();
                        }
                        return members.subList(0, count);
                    }
                };
            }
        });
        final String[] prePost = new String[]{"PRE", "POST"};
        this.define(new MultiResolver("Hierarchize", "Hierarchize(<Set>[, POST])", "Orders the members of a set in a hierarchy.", new String[]{"fxx", "fxxy"}){

            protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
                String order = 103.getLiteralArg(args, 1, "PRE", prePost, dummyFunDef);
                boolean post = order.equals("POST");
                return new FunDefBase(this, dummyFunDef, post){
                    private final /* synthetic */ boolean val$post;
                    private final /* synthetic */ 103 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$post = val$post;
                        super(x0);
                    }

                    public Object evaluate(Evaluator evaluator, Exp[] args) {
                        List members = (List)104.getArg(evaluator, args, 0);
                        104.hierarchize(members, this.val$post);
                        return members;
                    }
                };
            }

            public String[] getReservedWords() {
                return prePost;
            }
        });
        this.define(new MultiResolver("Intersect", "Intersect(<Set1>, <Set2>[, ALL])", "Returns the intersection of two input sets, optionally retaining duplicates.", new String[]{"fxxxy", "fxxx"}){

            protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
                boolean all = 105.getLiteralArg(args, 2, "", new String[]{"ALL"}, dummyFunDef).equalsIgnoreCase("ALL");
                return new IntersectFunDef(dummyFunDef, all);
            }
        });
        this.define(new FunDefBase("Members", "<Dimension>.Members", "Returns the set of members in a dimension.", "pxd"){

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                Dimension dimension = (Dimension)106.getArg(evaluator, args, 0);
                Hierarchy hierarchy = dimension.getHierarchy();
                List memberList = 106.addMembers(evaluator.getSchemaReader(), new ArrayList(), hierarchy);
                if (memberList != null) {
                    106.removeCalculatedMembers(memberList);
                }
                106.hierarchize(memberList, false);
                return memberList;
            }
        });
        this.define(new FunDefBase("AllMembers", "<Dimension>.AllMembers", "Returns a set that contains all members, including calculated members, of the specified dimension.", "pxd"){

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                Dimension dimension = (Dimension)107.getArg(evaluator, args, 0);
                Hierarchy hierarchy = dimension.getHierarchy();
                List result = 107.addMembers(evaluator.getSchemaReader(), new ArrayList(), hierarchy);
                107.hierarchize(result, false);
                result.addAll(evaluator.getQuery().getSchemaReader(true).getCalculatedMembers(hierarchy));
                return result;
            }
        });
        this.define(new FunDefBase("Members", "<Hierarchy>.Members", "Returns the set of members in a hierarchy.", "pxh"){

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                Hierarchy hierarchy = (Hierarchy)108.getArg(evaluator, args, 0);
                List memberList = 108.addMembers(evaluator.getSchemaReader(), new ArrayList(), hierarchy);
                if (memberList != null) {
                    108.removeCalculatedMembers(memberList);
                }
                108.hierarchize(memberList, false);
                return memberList;
            }
        });
        this.define(new FunDefBase("AllMembers", "<Hierarchy>.AllMembers", "Returns a set that contains all members, including calculated members, of the specified hierarchy.", "pxh"){

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                Hierarchy hierarchy = (Hierarchy)109.getArg(evaluator, args, 0);
                List result = 109.addMembers(evaluator.getSchemaReader(), new ArrayList(), hierarchy);
                109.hierarchize(result, false);
                result.addAll(evaluator.getQuery().getSchemaReader(true).getCalculatedMembers(hierarchy));
                return result;
            }
        });
        this.define(new FunDefBase("Members", "<Level>.Members", "Returns the set of members in a level.", "pxl"){

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                Level level = (Level)110.getArg(evaluator, args, 0);
                Member[] members = BuiltinFunTable.this.getNonEmptyLevelMembers(evaluator, level);
                ArrayList<Member> memberList = new ArrayList<Member>(Arrays.asList(members));
                if (memberList != null) {
                    110.removeCalculatedMembers(memberList);
                }
                110.hierarchize(memberList, false);
                return memberList;
            }
        });
        this.define(new FunDefBase("AllMembers", "<Level>.AllMembers", "Returns a set that contains all members, including calculated members, of the specified level.", "pxl"){

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                Level level = (Level)111.getArg(evaluator, args, 0);
                Member[] members = evaluator.getSchemaReader().getLevelMembers(level);
                ArrayList<Member> memberList = new ArrayList<Member>(Arrays.asList(members));
                111.hierarchize(memberList, false);
                memberList.addAll(evaluator.getQuery().getSchemaReader(true).getCalculatedMembers(level));
                return memberList;
            }
        });
        this.define(new XtdFunDef.Resolver("Mtd", "Mtd([<Member>])", "A shortcut function for the PeriodsToDate function that specifies the level to be Month.", new String[]{"fx", "fxm"}, LevelType.TimeMonths));
        this.define(new OrderFunDef.OrderResolver());
        this.define(new MultiResolver("PeriodsToDate", "PeriodsToDate([<Level>[, <Member>]])", "Returns a set of periods (members) from a specified level starting with the first period and ending with a specified member.", new String[]{"fx", "fxl", "fxlm"}){

            protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
                return new FunDefBase(this, dummyFunDef){
                    private final /* synthetic */ 112 this$1;
                    {
                        this.this$1 = this$1;
                        super(x0);
                    }

                    public boolean callDependsOn(FunCall call, Dimension dimension) {
                        if (super.callDependsOn(call, dimension)) {
                            return true;
                        }
                        Exp[] args = call.getArgs();
                        switch (args.length) {
                            case 0: {
                                return dimension.getDimensionType() == DimensionType.TimeDimension;
                            }
                            case 1: {
                                return args[0].getTypeX().usesDimension(dimension);
                            }
                            case 2: {
                                return false;
                            }
                        }
                        throw Util.newInternal("bad arg count " + args.length);
                    }

                    public Type getResultType(Validator validator, Exp[] args) {
                        if (args.length == 0) {
                            Hierarchy hierarchy = validator.getQuery().getCube().getTimeDimension().getHierarchy();
                            return new SetType(new MemberType(hierarchy, null, null));
                        }
                        Type type = args[0].getTypeX();
                        if (type.getHierarchy().getDimension().getDimensionType() != DimensionType.TimeDimension) {
                            throw MondrianResource.instance().TimeArgNeeded.ex(this.getName());
                        }
                        return super.getResultType(validator, args);
                    }

                    public Object evaluate(Evaluator evaluator, Exp[] args) {
                        Level level;
                        Member member;
                        if (args.length == 0) {
                            member = evaluator.getContext(evaluator.getCube().getTimeDimension());
                            level = member.getLevel().getParentLevel();
                        } else {
                            level = 113.getLevelArg(evaluator, args, 0, false);
                            member = 113.getMemberArg(evaluator, args, 1, false);
                        }
                        return 113.periodsToDate(evaluator, level, member);
                    }
                };
            }
        });
        this.define(new XtdFunDef.Resolver("Qtd", "Qtd([<Member>])", "A shortcut function for the PeriodsToDate function that specifies the level to be Quarter.", new String[]{"fx", "fxm"}, LevelType.TimeQuarters));
        this.define(new FunDefBase("StripCalculatedMembers", "StripCalculatedMembers(<Set>)", "Removes calculated members from a set.", "fxx"){

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                List memberList = (List)114.getArg(evaluator, args, 0);
                if (memberList != null) {
                    114.removeCalculatedMembers(memberList);
                }
                return memberList;
            }
        });
        this.define(new FunDefBase("Siblings", "<Member>.Siblings", "Returns the siblings of a specified member, including the member itself.", "pxm"){

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                Member member = 115.getMemberArg(evaluator, args, 0, true);
                if (member.isNull()) {
                    return null;
                }
                Member parent = member.getParentMember();
                SchemaReader schemaReader = evaluator.getSchemaReader();
                Member[] siblings = parent == null ? schemaReader.getHierarchyRootMembers(member.getHierarchy()) : schemaReader.getMemberChildren(parent);
                return Arrays.asList(siblings);
            }
        });
        this.define(new FunDefBase("StrToSet", "StrToSet(<String Expression>)", "Constructs a set from a string expression.", "fxS"){

            public Exp validateCall(Validator validator, FunCall call) {
                Exp[] args = call.getArgs();
                int argCount = args.length;
                if (argCount <= 1) {
                    throw MondrianResource.instance().MdxFuncArgumentsNum.ex(this.getName());
                }
                for (int i = 1; i < argCount; ++i) {
                    Exp arg = args[i];
                    if (arg instanceof Dimension) {
                        args[i] = ((Dimension)arg).getHierarchy();
                        continue;
                    }
                    if (arg instanceof Hierarchy) continue;
                    throw MondrianResource.instance().MdxFuncNotHier.ex(new Integer(i + 1), this.getName());
                }
                return super.validateCall(validator, call);
            }

            public Type getResultType(Validator validator, Exp[] args) {
                if (args.length == 1) {
                    return new SetType(null);
                }
                ArrayList<Type> list = new ArrayList<Type>();
                for (int i = 1; i < args.length; ++i) {
                    Exp arg = args[i];
                    Type type = arg.getTypeX();
                    list.add(type);
                }
                Type[] types = list.toArray(new Type[list.size()]);
                return new SetType(new TupleType(types));
            }
        });
        this.define(new MultiResolver("Subset", "Subset(<Set>, <Start>[, <Count>])", "Returns a subset of elements from a set.", new String[]{"fxxn", "fxxnn"}){

            protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
                return new FunDefBase(this, dummyFunDef){
                    private final /* synthetic */ 117 this$1;
                    {
                        this.this$1 = this$1;
                        super(x0);
                    }

                    public Object evaluate(Evaluator evaluator, Exp[] args) {
                        int end;
                        List members = (List)118.getArg(evaluator, args, 0);
                        int start = 118.getIntArg(evaluator, args, 1);
                        if (args.length < 3) {
                            end = members.size();
                        } else {
                            int count = 118.getIntArg(evaluator, args, 2);
                            end = start + count;
                        }
                        if (start >= end || start < 0) {
                            return new ArrayList<E>();
                        }
                        if (start == 0 && end >= members.size()) {
                            return members;
                        }
                        return members.subList(start, end);
                    }
                };
            }
        });
        this.define(new MultiResolver("Tail", "Tail(<Set>[, <Count>])", "Returns a subset from the end of a set.", new String[]{"fxx", "fxxn"}){

            protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
                return new FunDefBase(this, dummyFunDef){
                    private final /* synthetic */ 119 this$1;
                    {
                        this.this$1 = this$1;
                        super(x0);
                    }

                    public Object evaluate(Evaluator evaluator, Exp[] args) {
                        int count;
                        List members = (List)120.getArg(evaluator, args, 0);
                        int n = count = args.length < 2 ? 1 : 120.getIntArg(evaluator, args, 1);
                        if (count >= members.size()) {
                            return members;
                        }
                        if (count <= 0) {
                            return new ArrayList<E>();
                        }
                        return members.subList(members.size() - count, members.size());
                    }
                };
            }
        });
        this.define(new MultiResolver("ToggleDrillState", "ToggleDrillState(<Set1>, <Set2>[, RECURSIVE])", "Toggles the drill state of members. This function is a combination of DrillupMember and DrilldownMember.", new String[]{"fxxx", "fxxxy"}){

            protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
                return new FunDefBase(this, dummyFunDef){
                    private final /* synthetic */ 121 this$1;
                    {
                        this.this$1 = this$1;
                        super(x0);
                    }

                    public Object evaluate(Evaluator evaluator, Exp[] args) {
                        List v0 = (List)122.getArg(evaluator, args, 0);
                        List v1 = (List)122.getArg(evaluator, args, 1);
                        if (args.length > 2) {
                            throw MondrianResource.instance().ToggleDrillStateRecursiveNotSupported.ex();
                        }
                        if (v1.isEmpty()) {
                            return v0;
                        }
                        if (v0.isEmpty()) {
                            return v0;
                        }
                        HashSet<E> set = new HashSet<E>();
                        set.addAll(v1);
                        HashSet<E> set1 = set;
                        ArrayList<Object> result = new ArrayList<Object>();
                        int i = 0;
                        int n = v0.size();
                        while (i < n) {
                            boolean strict;
                            Member nextMember;
                            E o = v0.get(i++);
                            result.add(o);
                            Member m = null;
                            int k = -1;
                            if (o instanceof Member) {
                                if (!set1.contains(o)) continue;
                                m = (Member)o;
                                k = -1;
                            } else {
                                Util.assertTrue(o instanceof Member[]);
                                Member[] members = (Member[])o;
                                for (int j = 0; j < members.length; ++j) {
                                    Member member = members[j];
                                    if (!set1.contains(member)) continue;
                                    k = j;
                                    m = member;
                                    break;
                                }
                                if (k == -1) continue;
                            }
                            boolean isDrilledDown = false;
                            if (i < n) {
                                E next = v0.get(i);
                                nextMember = k < 0 ? (Member)next : ((Member[])next)[k];
                                if (122.isAncestorOf(m, nextMember, strict = true)) {
                                    isDrilledDown = true;
                                }
                            }
                            if (isDrilledDown) {
                                E next;
                                do {
                                    next = v0.get(i);
                                } while (122.isAncestorOf(m, nextMember = k < 0 ? (Member)next : ((Member[])next)[k], strict = true) && ++i < n);
                                continue;
                            }
                            Member[] children = evaluator.getSchemaReader().getMemberChildren(m);
                            for (int j = 0; j < children.length; ++j) {
                                if (k < 0) {
                                    result.add(children[j]);
                                    continue;
                                }
                                Member[] members = (Member[])((Member[])o).clone();
                                members[k] = children[j];
                                result.add(members);
                            }
                        }
                        return result;
                    }
                };
            }

            public String[] getReservedWords() {
                return new String[]{"RECURSIVE"};
            }
        });
        this.define(new MultiResolver("TopCount", "TopCount(<Set>, <Count>[, <Numeric Expression>])", "Returns a specified number of items from the top of a set, optionally ordering the set first.", new String[]{"fxxnn", "fxxn"}){

            protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
                return new FunDefBase(this, dummyFunDef){
                    private final /* synthetic */ 123 this$1;
                    {
                        this.this$1 = this$1;
                        super(x0);
                    }

                    public Object evaluate(Evaluator evaluator, Exp[] args) {
                        SchemaReader schemaReader = evaluator.getSchemaReader();
                        NativeEvaluator nativeEvaluator = schemaReader.getNativeSetEvaluator(this, evaluator, args);
                        if (nativeEvaluator != null) {
                            return nativeEvaluator.execute();
                        }
                        List<E> list = (List<E>)124.getArg(evaluator, args, 0);
                        int n = 124.getIntArg(evaluator, args, 1);
                        ExpBase exp = (ExpBase)124.getArgNoEval(args, 2, null);
                        if (exp != null) {
                            boolean desc = true;
                            boolean brk = true;
                            124.sort(evaluator.push(), list, exp, desc, brk);
                        }
                        if (n < list.size()) {
                            list = list.subList(0, n);
                        }
                        return list;
                    }
                };
            }
        });
        this.define(new MultiResolver("TopPercent", "TopPercent(<Set>, <Percentage>, <Numeric Expression>)", "Sorts a set and returns the top N elements whose cumulative total is at least a specified percentage.", new String[]{"fxxnn"}){

            protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
                return new FunDefBase(this, dummyFunDef){
                    private final /* synthetic */ 125 this$1;
                    {
                        this.this$1 = this$1;
                        super(x0);
                    }

                    public Object evaluate(Evaluator evaluator, Exp[] args) {
                        List members = (List)126.getArg(evaluator, args, 0);
                        ExpBase exp = (ExpBase)126.getArgNoEval(args, 2);
                        Double n = 126.getDoubleArg(evaluator, args, 1);
                        return 126.topOrBottom(evaluator.push(), members, exp, true, true, n);
                    }
                };
            }
        });
        this.define(new MultiResolver("TopSum", "TopSum(<Set>, <Value>, <Numeric Expression>)", "Sorts a set and returns the top N elements whose cumulative total is at least a specified value.", new String[]{"fxxnn"}){

            protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
                return new FunDefBase(this, dummyFunDef){
                    private final /* synthetic */ 127 this$1;
                    {
                        this.this$1 = this$1;
                        super(x0);
                    }

                    public Object evaluate(Evaluator evaluator, Exp[] args) {
                        List members = (List)128.getArg(evaluator, args, 0);
                        ExpBase exp = (ExpBase)128.getArgNoEval(args, 2);
                        Double n = 128.getDoubleArg(evaluator, args, 1);
                        return 128.topOrBottom(evaluator.push(), members, exp, true, false, n);
                    }
                };
            }
        });
        final String[] allDistinct = new String[]{"ALL", "DISTINCT"};
        this.define(new MultiResolver("Union", "Union(<Set1>, <Set2>[, ALL])", "Returns the union of two sets, optionally retaining duplicates.", new String[]{"fxxx", "fxxxy"}){

            public String[] getReservedWords() {
                return allDistinct;
            }

            protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
                String allString = 129.getLiteralArg(args, 2, "DISTINCT", allDistinct, dummyFunDef);
                boolean all = allString.equalsIgnoreCase("ALL");
                129.checkCompatible(args[0], args[1], dummyFunDef);
                return new FunDefBase(this, dummyFunDef, all){
                    private final /* synthetic */ boolean val$all;
                    private final /* synthetic */ 129 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$all = val$all;
                        super(x0);
                    }

                    public Object evaluate(Evaluator evaluator, Exp[] args) {
                        List left = (List)130.getArg(evaluator, args, 0);
                        List right = (List)130.getArg(evaluator, args, 1);
                        if (this.val$all) {
                            if (left == null || left.isEmpty()) {
                                return right;
                            }
                            left.addAll(right);
                            return left;
                        }
                        HashSet<E> added = new HashSet<E>();
                        ArrayList<E> result = new ArrayList<E>();
                        130.addUnique(result, left, added);
                        130.addUnique(result, right, added);
                        return result;
                    }
                };
            }
        });
        this.define(new XtdFunDef.Resolver("Wtd", "Wtd([<Member>])", "A shortcut function for the PeriodsToDate function that specifies the level to be Week.", new String[]{"fx", "fxm"}, LevelType.TimeWeeks));
        this.define(new XtdFunDef.Resolver("Ytd", "Ytd([<Member>])", "A shortcut function for the PeriodsToDate function that specifies the level to be Year.", new String[]{"fx", "fxm"}, LevelType.TimeYears));
        this.define(new FunDefBase(":", "<Member>:<Member>", "Infix colon operator returns the set of members between a given pair of members.", "ixmm"){

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                Member member0 = 131.getMemberArg(evaluator, args, 0, true);
                Member member1 = 131.getMemberArg(evaluator, args, 1, true);
                if (member0.isNull() || member1.isNull()) {
                    return Collections.EMPTY_LIST;
                }
                if (member0.getLevel() != member1.getLevel()) {
                    throw 131.newEvalException(this, "Members must belong to the same level");
                }
                return FunUtil.memberRange(evaluator, member0, member1);
            }
        });
        this.define(new ResolverBase("{}", "{<Member> [, <Member>]...}", "Brace operator constructs a set.", Syntax.Braces){

            public FunDef resolve(Exp[] args, Validator validator, int[] conversionCount) {
                int[] parameterTypes = new int[args.length];
                for (int i = 0; i < args.length; ++i) {
                    if (validator.canConvert(args[i], 6, conversionCount)) {
                        parameterTypes[i] = 6;
                        continue;
                    }
                    if (validator.canConvert(args[i], 8, conversionCount)) {
                        parameterTypes[i] = 8;
                        continue;
                    }
                    if (validator.canConvert(args[i], 10, conversionCount)) {
                        parameterTypes[i] = 10;
                        continue;
                    }
                    return null;
                }
                return new SetFunDef(this, parameterTypes);
            }
        });
        this.define(new MultiResolver("Format", "Format(<Numeric Expression>, <String Expression>)", "Formats a number to string.", new String[]{"fSmS", "fSnS"}){

            protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
                Locale locale = Locale.getDefault();
                if (args[1] instanceof Literal) {
                    String formatString = (String)((Literal)args[1]).getValue();
                    Format format = new Format(formatString, locale);
                    return new FunDefBase(this, dummyFunDef, format){
                        private final /* synthetic */ Format val$format;
                        private final /* synthetic */ 133 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$format = val$format;
                            super(x0);
                        }

                        public Object evaluate(Evaluator evaluator, Exp[] args) {
                            Double o = 134.getDoubleArg(evaluator, args, 0);
                            return this.val$format.format(o);
                        }
                    };
                }
                return new FunDefBase(this, dummyFunDef, locale){
                    private final /* synthetic */ Locale val$locale;
                    private final /* synthetic */ 133 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$locale = val$locale;
                        super(x0);
                    }

                    public Object evaluate(Evaluator evaluator, Exp[] args) {
                        Double o = 135.getDoubleArg(evaluator, args, 0);
                        String formatString = 135.getStringArg(evaluator, args, 1, null);
                        Format format = new Format(formatString, this.val$locale);
                        return format.format(o);
                    }
                };
            }
        });
        this.define(new FunDefBase("IIf", "IIf(<Logical Expression>, <String Expression1>, <String Expression2>)", "Returns one of two string values determined by a logical test.", "fSbSS"){

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                Boolean b = 136.getBooleanArg(evaluator, args, 0);
                if (b == null) {
                    136.getStringArg(evaluator, args, 1, null);
                    136.getStringArg(evaluator, args, 2, null);
                    return null;
                }
                String o = b != false ? 136.getStringArg(evaluator, args, 1, null) : 136.getStringArg(evaluator, args, 2, null);
                return o;
            }
        });
        this.define(new FunDefBase("Caption", "<Dimension>.Caption", "Returns the caption of a dimension.", "pSd"){

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                Dimension dimension = 137.getDimensionArg(evaluator, args, 0, true);
                return dimension.getCaption();
            }
        });
        this.define(new FunDefBase("Caption", "<Hierarchy>.Caption", "Returns the caption of a hierarchy.", "pSh"){

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                Hierarchy hierarchy = 138.getHierarchyArg(evaluator, args, 0, true);
                return hierarchy.getCaption();
            }
        });
        this.define(new FunDefBase("Caption", "<Level>.Caption", "Returns the caption of a level.", "pSl"){

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                Level level = 139.getLevelArg(evaluator, args, 0, true);
                return level.getCaption();
            }
        });
        this.define(new FunDefBase("Caption", "<Member>.Caption", "Returns the caption of a member.", "pSm"){

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                Member member = 140.getMemberArg(evaluator, args, 0, true);
                return member.getCaption();
            }
        });
        this.define(new FunDefBase("Name", "<Dimension>.Name", "Returns the name of a dimension.", "pSd"){

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                Dimension dimension = 141.getDimensionArg(evaluator, args, 0, true);
                return dimension.getName();
            }
        });
        this.define(new FunDefBase("Name", "<Hierarchy>.Name", "Returns the name of a hierarchy.", "pSh"){

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                Hierarchy hierarchy = 142.getHierarchyArg(evaluator, args, 0, true);
                return hierarchy.getName();
            }
        });
        this.define(new FunDefBase("Name", "<Level>.Name", "Returns the name of a level.", "pSl"){

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                Level level = 143.getLevelArg(evaluator, args, 0, true);
                return level.getName();
            }
        });
        this.define(new FunDefBase("Name", "<Member>.Name", "Returns the name of a member.", "pSm"){

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                Member member = 144.getMemberArg(evaluator, args, 0, true);
                return member.getName();
            }
        });
        this.define(new FunDefBase("SetToStr", "SetToStr(<Set>)", "Constructs a string from a set.", "fSx"){

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                List items = (List)145.getArg(evaluator, args, 0);
                StringBuffer buf = new StringBuffer();
                buf.append("{");
                for (int i = 0; i < items.size(); ++i) {
                    if (i > 0) {
                        buf.append(", ");
                    }
                    Object o = items.get(i);
                    BuiltinFunTable.appendMemberOrTuple(buf, o);
                }
                buf.append("}");
                return buf.toString();
            }
        });
        this.define(new FunDefBase("TupleToStr", "TupleToStr(<Tuple>)", "Constructs a string from a tuple.", "fSt"){

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                Object o = 146.getArg(evaluator, args, 0);
                StringBuffer buf = new StringBuffer();
                BuiltinFunTable.appendMemberOrTuple(buf, o);
                return buf.toString();
            }
        });
        this.define(new FunDefBase("UniqueName", "<Dimension>.UniqueName", "Returns the unique name of a dimension.", "pSd"){

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                Dimension dimension = 147.getDimensionArg(evaluator, args, 0, true);
                return dimension.getUniqueName();
            }
        });
        this.define(new FunDefBase("UniqueName", "<Hierarchy>.UniqueName", "Returns the unique name of a hierarchy.", "pSh"){

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                Hierarchy hierarchy = 148.getHierarchyArg(evaluator, args, 0, true);
                return hierarchy.getUniqueName();
            }
        });
        this.define(new FunDefBase("UniqueName", "<Level>.UniqueName", "Returns the unique name of a level.", "pSl"){

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                Level level = 149.getLevelArg(evaluator, args, 0, true);
                return level.getUniqueName();
            }
        });
        this.define(new FunDefBase("UniqueName", "<Member>.UniqueName", "Returns the unique name of a member.", "pSm"){

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                Member member = 150.getMemberArg(evaluator, args, 0, true);
                return member.getUniqueName();
            }
        });
        this.define(new FunDefBase("Current", "<Set>.Current", "Returns the current tuple from a set during an iteration.", "ptx"));
        this.define(new FunDefBase("Item", "<Set>.Item(<Index>)", "Returns a tuple from the set specified in \u00abSet\u00bb. The tuple to be returned is specified by the zero-based position of the tuple in the set in \u00abIndex\u00bb.", "mmxn"){
            static final /* synthetic */ boolean $assertionsDisabled;

            public Type getResultType(Validator validator, Exp[] args) {
                SetType setType = (SetType)args[0].getTypeX();
                return setType.getElementType();
            }

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                Object arg0 = 151.getArg(evaluator, args, 0);
                int index = 151.getIntArg(evaluator, args, 1);
                Type type = args[0].getTypeX();
                if (arg0 == null) {
                    return this.makeNullMember(evaluator, args);
                }
                if (arg0 instanceof List) {
                    List theSet = (List)arg0;
                    int setSize = theSet.size();
                    if (index >= setSize || index < 0) {
                        return this.makeNullMember(evaluator, args);
                    }
                    return theSet.get(index);
                }
                if (!($assertionsDisabled || arg0 instanceof Member[] || arg0 instanceof Member)) {
                    throw new AssertionError();
                }
                if (arg0 instanceof Member) {
                    if (index == 0) {
                        return arg0;
                    }
                    return this.makeNullMember(evaluator, args);
                }
                Member[] tuple = (Member[])arg0;
                if (index < tuple.length && index >= 0) {
                    return tuple[index];
                }
                return this.makeNullMember(evaluator, args);
            }

            Object makeNullMember(Evaluator evaluator, Exp[] args) {
                Type elementType = ((SetType)args[0].getTypeX()).getElementType();
                if (elementType instanceof MemberType) {
                    MemberType memberType = (MemberType)elementType;
                    Hierarchy hierarchy = memberType.getHierarchy();
                    if (hierarchy == null) {
                        hierarchy = evaluator.getMembers()[0].getHierarchy();
                    }
                    return hierarchy.getNullMember();
                }
                if (elementType instanceof TupleType) {
                    TupleType tupleType = (TupleType)elementType;
                    Member[] members = new Member[tupleType.elementTypes.length];
                    for (int i = 0; i < tupleType.elementTypes.length; ++i) {
                        Type type = tupleType.elementTypes[i];
                        Hierarchy hierarchy = type.getHierarchy();
                        if (hierarchy == null) {
                            hierarchy = evaluator.getMembers()[0].getHierarchy();
                        }
                        members[i] = hierarchy.getNullMember();
                    }
                    return members;
                }
                throw Util.newInternal("bad type " + elementType);
            }

            static {
                $assertionsDisabled = !(class$mondrian$olap$fun$BuiltinFunTable == null ? (class$mondrian$olap$fun$BuiltinFunTable = BuiltinFunTable.class$("mondrian.olap.fun.BuiltinFunTable")) : class$mondrian$olap$fun$BuiltinFunTable).desiredAssertionStatus();
            }
        });
        this.define(new FunDefBase("Item", "<Tuple>.Item(<Index>)", "Returns a member from the tuple specified in \u00abTuple\u00bb. The member to be returned is specified by the zero-based position of the member in the set in \u00abIndex\u00bb.", "mmtn"){
            static final /* synthetic */ boolean $assertionsDisabled;

            public Type getResultType(Validator validator, Exp[] args) {
                return new MemberType(null, null, null);
            }

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                Object arg0 = 152.getArg(evaluator, args, 0);
                int index = 152.getIntArg(evaluator, args, 1);
                if (arg0 == null) {
                    return null;
                }
                if (!($assertionsDisabled || arg0 instanceof Member[] || arg0 instanceof Member)) {
                    throw new AssertionError();
                }
                if (arg0 instanceof Member) {
                    if (index == 0) {
                        return arg0;
                    }
                    return null;
                }
                Member[] tuple = (Member[])arg0;
                if (index >= tuple.length || index < 0) {
                    return null;
                }
                return tuple[index];
            }

            static {
                $assertionsDisabled = !(class$mondrian$olap$fun$BuiltinFunTable == null ? (class$mondrian$olap$fun$BuiltinFunTable = BuiltinFunTable.class$("mondrian.olap.fun.BuiltinFunTable")) : class$mondrian$olap$fun$BuiltinFunTable).desiredAssertionStatus();
            }
        });
        this.define(new FunDefBase("StrToTuple", "StrToTuple(<String Expression>)", "Constructs a tuple from a string.", "ftS"){

            public Exp validateCall(Validator validator, FunCall call) {
                Exp[] args = call.getArgs();
                int argCount = args.length;
                if (argCount <= 1) {
                    throw MondrianResource.instance().MdxFuncArgumentsNum.ex(this.getName());
                }
                for (int i = 1; i < argCount; ++i) {
                    Exp arg = args[i];
                    if (arg instanceof Dimension) {
                        args[i] = ((Dimension)arg).getHierarchy();
                        continue;
                    }
                    if (arg instanceof Hierarchy) continue;
                    throw MondrianResource.instance().MdxFuncNotHier.ex(new Integer(i + 1), this.getName());
                }
                return super.validateCall(validator, call);
            }

            public Type getResultType(Validator validator, Exp[] args) {
                if (args.length == 1) {
                    return new TupleType(null);
                }
                ArrayList<Type> list = new ArrayList<Type>();
                for (int i = 1; i < args.length; ++i) {
                    Exp arg = args[i];
                    Type type = arg.getTypeX();
                    list.add(type);
                }
                Type[] types = list.toArray(new Type[list.size()]);
                return new TupleType(types);
            }
        });
        this.define(new ResolverBase("()", null, null, Syntax.Parentheses){

            public FunDef resolve(Exp[] args, Validator validator, int[] conversionCount) {
                if (args.length == 1) {
                    return new ParenthesesFunDef(args[0].getCategory());
                }
                int[] argTypes = new int[args.length];
                Arrays.fill(argTypes, 6);
                return new TupleFunDef(argTypes);
            }
        });
        this.define(new ResolverBase("CoalesceEmpty", "CoalesceEmpty(<Value Expression>[, <Value Expression>]...)", "Coalesces an empty cell value to a different value. All of the expressions must be of the same type (number or string).", Syntax.Function){

            public FunDef resolve(Exp[] args, Validator validator, int[] conversionCount) {
                if (args.length < 1) {
                    return null;
                }
                int[] types = new int[]{7, 9};
                int[] argTypes = new int[args.length];
                for (int j = 0; j < types.length; ++j) {
                    int type = types[j];
                    int matchingArgs = 0;
                    conversionCount[0] = 0;
                    for (int i = 0; i < args.length; ++i) {
                        if (validator.canConvert(args[i], type, conversionCount)) {
                            ++matchingArgs;
                        }
                        argTypes[i] = type;
                    }
                    if (matchingArgs != args.length) continue;
                    return new CoalesceEmptyFunDef(this, type, argTypes);
                }
                return null;
            }

            public boolean requiresExpression(int k) {
                return true;
            }
        });
        this.define(new ResolverBase("_CaseTest", "Case When <Logical Expression> Then <Expression> [...] [Else <Expression>] End", "Evaluates various conditions, and returns the corresponding expression for the first which evaluates to true.", Syntax.Case){

            public FunDef resolve(Exp[] args, Validator validator, int[] conversionCount) {
                if (args.length < 1) {
                    return null;
                }
                int j = 0;
                int clauseCount = args.length / 2;
                int mismatchingArgs = 0;
                int returnType = args[1].getCategory();
                for (int i = 0; i < clauseCount; ++i) {
                    if (!validator.canConvert(args[j++], 5, conversionCount)) {
                        ++mismatchingArgs;
                    }
                    if (validator.canConvert(args[j++], returnType, conversionCount)) continue;
                    ++mismatchingArgs;
                }
                if (j < args.length && !validator.canConvert(args[j++], returnType, conversionCount)) {
                    ++mismatchingArgs;
                }
                Util.assertTrue(j == args.length);
                if (mismatchingArgs == 0) {
                    return new FunDefBase(this, this, returnType, ExpBase.getTypes(args)){
                        private final /* synthetic */ 156 this$1;
                        {
                            this.this$1 = this$1;
                            super(x0, x1, x2);
                        }

                        public Object evaluate(Evaluator evaluator, Exp[] args) {
                            return this.this$1.evaluateCaseTest(evaluator, args);
                        }
                    };
                }
                return null;
            }

            public boolean requiresExpression(int k) {
                return true;
            }

            Object evaluateCaseTest(Evaluator evaluator, Exp[] args) {
                int clauseCount = args.length / 2;
                int j = 0;
                for (int i = 0; i < clauseCount; ++i) {
                    boolean logical;
                    if (logical = 156.getBooleanArg(evaluator, args, j++, false)) {
                        return 156.getArg(evaluator, args, j);
                    }
                    ++j;
                }
                return j < args.length ? 156.getArg(evaluator, args, j) : null;
            }
        });
        this.define(new ResolverBase("_CaseMatch", "Case <Expression> When <Expression> Then <Expression> [...] [Else <Expression>] End", "Evaluates various expressions, and returns the corresponding expression for the first which matches a particular value.", Syntax.Case){

            public FunDef resolve(Exp[] args, Validator validator, int[] conversionCount) {
                if (args.length < 3) {
                    return null;
                }
                int valueType = args[0].getCategory();
                int returnType = args[2].getCategory();
                int j = 0;
                int clauseCount = (args.length - 1) / 2;
                int mismatchingArgs = 0;
                if (!validator.canConvert(args[j++], valueType, conversionCount)) {
                    ++mismatchingArgs;
                }
                for (int i = 0; i < clauseCount; ++i) {
                    if (!validator.canConvert(args[j++], valueType, conversionCount)) {
                        ++mismatchingArgs;
                    }
                    if (validator.canConvert(args[j++], returnType, conversionCount)) continue;
                    ++mismatchingArgs;
                }
                if (j < args.length && !validator.canConvert(args[j++], returnType, conversionCount)) {
                    ++mismatchingArgs;
                }
                Util.assertTrue(j == args.length);
                if (mismatchingArgs == 0) {
                    return new FunDefBase(this, this, returnType, ExpBase.getTypes(args)){
                        private final /* synthetic */ 158 this$1;
                        {
                            this.this$1 = this$1;
                            super(x0, x1, x2);
                        }

                        public Object evaluate(Evaluator evaluator, Exp[] args) {
                            return this.this$1.evaluateCaseMatch(evaluator, args);
                        }
                    };
                }
                return null;
            }

            public boolean requiresExpression(int k) {
                return true;
            }

            Object evaluateCaseMatch(Evaluator evaluator, Exp[] args) {
                int clauseCount = (args.length - 1) / 2;
                int j = 0;
                Object value = 158.getArg(evaluator, args, j++);
                for (int i = 0; i < clauseCount; ++i) {
                    Object match;
                    if ((match = 158.getArg(evaluator, args, j++)).equals(value)) {
                        return 158.getArg(evaluator, args, j);
                    }
                    ++j;
                }
                return j < args.length ? 158.getArg(evaluator, args, j) : null;
            }
        });
        this.define(new PropertiesFunDef.Resolver());
        this.define(new ParameterFunDef.ParameterResolver());
        this.define(new ParameterFunDef.ParamRefResolver());
        this.define(new FunDefBase("+", "<Numeric Expression> + <Numeric Expression>", "Adds two numbers.", "innn"){

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                Double o0 = 160.getDoubleArg(evaluator, args, 0, null);
                Double o1 = 160.getDoubleArg(evaluator, args, 1, null);
                if (o0 == null) {
                    if (o1 == null) {
                        return null;
                    }
                    return o1;
                }
                if (o1 == null) {
                    return o0;
                }
                return new Double(o0 + o1);
            }
        });
        this.define(new FunDefBase("-", "<Numeric Expression> - <Numeric Expression>", "Subtracts two numbers.", "innn"){

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                Double o0 = 161.getDoubleArg(evaluator, args, 0, null);
                Double o1 = 161.getDoubleArg(evaluator, args, 1, null);
                if (o0 == null) {
                    if (o1 == null) {
                        return null;
                    }
                    return new Double(-o1.doubleValue());
                }
                if (o1 == null) {
                    return o0;
                }
                return new Double(o0 - o1);
            }
        });
        this.define(new FunDefBase("*", "<Numeric Expression> * <Numeric Expression>", "Multiplies two numbers.", "innn"){

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                Double o0 = 162.getDoubleArg(evaluator, args, 0, null);
                Double o1 = 162.getDoubleArg(evaluator, args, 1, null);
                if (o0 == null || o1 == null) {
                    return null;
                }
                return new Double(o0 * o1);
            }
        });
        this.define(new FunDefBase("/", "<Numeric Expression> / <Numeric Expression>", "Divides two numbers.", "innn"){

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                Double o0 = 163.getDoubleArg(evaluator, args, 0, null);
                Double o1 = 163.getDoubleArg(evaluator, args, 1, null);
                if (o0 == null || o1 == null) {
                    return null;
                }
                return new Double(o0 / o1);
            }

            public double evaluate(double d1, double d2) {
                return d1 / d2;
            }
        });
        this.define(new FunDefBase("-", "- <Numeric Expression>", "Returns the negative of a number.", "Pnn"){

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                Double o0 = 164.getDoubleArg(evaluator, args, 0, null);
                if (o0 == null) {
                    return null;
                }
                return new Double(-o0.doubleValue());
            }
        });
        this.define(new FunDefBase("||", "<String Expression> || <String Expression>", "Concatenates two strings.", "iSSS"){

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                String o0 = 165.getStringArg(evaluator, args, 0, null);
                String o1 = 165.getStringArg(evaluator, args, 1, null);
                return o0 + o1;
            }
        });
        this.define(new FunDefBase("AND", "<Logical Expression> AND <Logical Expression>", "Returns the conjunction of two conditions.", "ibbb"){

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                Boolean b1 = 166.getBooleanArg(evaluator, args, 0);
                if (b1 != null && !b1.booleanValue()) {
                    return Boolean.FALSE;
                }
                Boolean b2 = 166.getBooleanArg(evaluator, args, 1);
                if (b2 != null && !b2.booleanValue()) {
                    return Boolean.FALSE;
                }
                if (b1 == null || b2 == null) {
                    return null;
                }
                return b1 != false && b2 != false;
            }
        });
        this.define(new FunDefBase("OR", "<Logical Expression> OR <Logical Expression>", "Returns the disjunction of two conditions.", "ibbb"){

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                Boolean b1 = 167.getBooleanArg(evaluator, args, 0);
                if (b1 != null && b1.booleanValue()) {
                    return Boolean.TRUE;
                }
                Boolean b2 = 167.getBooleanArg(evaluator, args, 1);
                if (b2 != null && b2.booleanValue()) {
                    return Boolean.TRUE;
                }
                if (b1 == null || b2 == null) {
                    return null;
                }
                return b1 != false || b2 != false;
            }
        });
        this.define(new FunDefBase("XOR", "<Logical Expression> XOR <Logical Expression>", "Returns whether two conditions are mutually exclusive.", "ibbb"){

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                Boolean b1 = 168.getBooleanArg(evaluator, args, 0);
                Boolean b2 = 168.getBooleanArg(evaluator, args, 1);
                if (b1 == null || b2 == null) {
                    return null;
                }
                return b1.booleanValue() != b2.booleanValue();
            }
        });
        this.define(new FunDefBase("NOT", "NOT <Logical Expression>", "Returns the negation of a condition.", "Pbb"){

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                Boolean b = 169.getBooleanArg(evaluator, args, 0);
                return b == null ? null : (b != false ? Boolean.FALSE : Boolean.TRUE);
            }
        });
        this.define(new FunDefBase("=", "<String Expression> = <String Expression>", "Returns whether two expressions are equal.", "ibSS"){

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                String o0 = 170.getStringArg(evaluator, args, 0, null);
                String o1 = 170.getStringArg(evaluator, args, 1, null);
                if (o0 == null || o1 == null) {
                    return null;
                }
                return o0.equals(o1);
            }
        });
        this.define(new FunDefBase("=", "<Numeric Expression> = <Numeric Expression>", "Returns whether two expressions are equal.", "ibnn"){

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                Double o0 = 171.getDoubleArg(evaluator, args, 0);
                Double o1 = 171.getDoubleArg(evaluator, args, 1);
                if (o0.isNaN() || o1.isNaN()) {
                    return null;
                }
                return o0.equals(o1);
            }
        });
        this.define(new FunDefBase("<>", "<String Expression> <> <String Expression>", "Returns whether two expressions are not equal.", "ibSS"){

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                String o0 = 172.getStringArg(evaluator, args, 0, null);
                String o1 = 172.getStringArg(evaluator, args, 1, null);
                if (o0 == null || o1 == null) {
                    return null;
                }
                return o0.equals(o1) ? Boolean.FALSE : Boolean.TRUE;
            }
        });
        this.define(new FunDefBase("<>", "<Numeric Expression> <> <Numeric Expression>", "Returns whether two expressions are not equal.", "ibnn"){

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                Double o0 = 173.getDoubleArg(evaluator, args, 0);
                Double o1 = 173.getDoubleArg(evaluator, args, 1);
                if (o0.isNaN() || o1.isNaN()) {
                    return null;
                }
                return o0.equals(o1) ? Boolean.FALSE : Boolean.TRUE;
            }
        });
        this.define(new FunDefBase("<", "<Numeric Expression> < <Numeric Expression>", "Returns whether an expression is less than another.", "ibnn"){

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                Double o0 = 174.getDoubleArg(evaluator, args, 0);
                Double o1 = 174.getDoubleArg(evaluator, args, 1);
                if (o0.isNaN() || o1.isNaN()) {
                    return null;
                }
                return o0.compareTo(o1) < 0;
            }
        });
        this.define(new FunDefBase("<", "<String Expression> < <String Expression>", "Returns whether an expression is less than another.", "ibSS"){

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                String o0 = 175.getStringArg(evaluator, args, 0, null);
                String o1 = 175.getStringArg(evaluator, args, 1, null);
                if (o0 == null || o1 == null) {
                    return null;
                }
                return o0.compareTo(o1) < 0;
            }
        });
        this.define(new FunDefBase("<=", "<Numeric Expression> <= <Numeric Expression>", "Returns whether an expression is less than or equal to another.", "ibnn"){

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                Double o0 = 176.getDoubleArg(evaluator, args, 0);
                Double o1 = 176.getDoubleArg(evaluator, args, 1);
                if (o0.isNaN() || o1.isNaN()) {
                    return null;
                }
                return o0.compareTo(o1) <= 0;
            }
        });
        this.define(new FunDefBase("<=", "<String Expression> <= <String Expression>", "Returns whether an expression is less than or equal to another.", "ibSS"){

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                String o0 = 177.getStringArg(evaluator, args, 0, null);
                String o1 = 177.getStringArg(evaluator, args, 1, null);
                if (o0 == null || o1 == null) {
                    return null;
                }
                return o0.compareTo(o1) <= 0;
            }
        });
        this.define(new FunDefBase(">", "<Numeric Expression> > <Numeric Expression>", "Returns whether an expression is greater than another.", "ibnn"){

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                Double o0 = 178.getDoubleArg(evaluator, args, 0);
                Double o1 = 178.getDoubleArg(evaluator, args, 1);
                if (o0.isNaN() || o1.isNaN()) {
                    return null;
                }
                return o0.compareTo(o1) > 0;
            }
        });
        this.define(new FunDefBase(">", "<String Expression> > <String Expression>", "Returns whether an expression is greater than another.", "ibSS"){

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                String o0 = 179.getStringArg(evaluator, args, 0, null);
                String o1 = 179.getStringArg(evaluator, args, 1, null);
                if (o0 == null || o1 == null) {
                    return null;
                }
                return o0.compareTo(o1) > 0;
            }
        });
        this.define(new FunDefBase(">=", "<Numeric Expression> >= <Numeric Expression>", "Returns whether an expression is greater than or equal to another.", "ibnn"){

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                Double o0 = 180.getDoubleArg(evaluator, args, 0);
                Double o1 = 180.getDoubleArg(evaluator, args, 1);
                if (o0.isNaN() || o1.isNaN()) {
                    return null;
                }
                return o0.compareTo(o1) >= 0;
            }
        });
        this.define(new FunDefBase(">=", "<String Expression> >= <String Expression>", "Returns whether an expression is greater than or equal to another.", "ibSS"){

            public Object evaluate(Evaluator evaluator, Exp[] args) {
                String o0 = 181.getStringArg(evaluator, args, 0, null);
                String o1 = 181.getStringArg(evaluator, args, 1, null);
                if (o0 == null || o1 == null) {
                    return null;
                }
                return o0.compareTo(o1) >= 0;
            }
        });
        this.define(new MultiResolver("FirstQ", "FirstQ(<Set>[, <Numeric Expression>])", "Returns the 1st quartile value of a numeric expression evaluated over a set.", new String[]{"fnx", "fnxn"}){

            protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
                return new AbstractAggregateFunDef(this, dummyFunDef){
                    private final /* synthetic */ 182 this$1;
                    {
                        this.this$1 = this$1;
                        super(x0);
                    }

                    public Object evaluate(Evaluator evaluator, Exp[] args) {
                        List members = (List)183.getArg(evaluator, args, 0);
                        ExpBase exp = (ExpBase)183.getArg(evaluator, args, 1, this.valueFunCall);
                        return 183.quartile(evaluator.push(), members, exp, 1);
                    }
                };
            }
        });
        this.define(new MultiResolver("ThirdQ", "ThirdQ(<Set>[, <Numeric Expression>])", "Returns the 3rd quartile value of a numeric expression evaluated over a set.", new String[]{"fnx", "fnxn"}){

            protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
                return new AbstractAggregateFunDef(this, dummyFunDef){
                    private final /* synthetic */ 184 this$1;
                    {
                        this.this$1 = this$1;
                        super(x0);
                    }

                    public Object evaluate(Evaluator evaluator, Exp[] args) {
                        List members = (List)185.getArg(evaluator, args, 0);
                        ExpBase exp = (ExpBase)185.getArg(evaluator, args, 1, this.valueFunCall);
                        return 185.quartile(evaluator.push(), members, exp, 3);
                    }
                };
            }
        });
    }

    private static void appendMemberOrTuple(StringBuffer buf, Object memberOrTuple) {
        if (memberOrTuple instanceof Member) {
            Member member = (Member)memberOrTuple;
            buf.append(member.getUniqueName());
        } else {
            Member[] members = (Member[])memberOrTuple;
            buf.append("(");
            for (int j = 0; j < members.length; ++j) {
                if (j > 0) {
                    buf.append(", ");
                }
                Member member = members[j];
                buf.append(member.getUniqueName());
            }
            buf.append(")");
        }
    }

    protected static Map getNameToResolversMap() {
        return Collections.unmodifiableMap(BuiltinFunTable.instance().mapNameToResolvers);
    }

    public static BuiltinFunTable instance() {
        if (instance == null) {
            instance = new BuiltinFunTable();
            instance.init();
        }
        return instance;
    }

    protected Member[] getNonEmptyMemberChildren(Evaluator evaluator, Member member) {
        SchemaReader sr = evaluator.getSchemaReader();
        if (evaluator.isNonEmpty()) {
            return sr.getMemberChildren(member, evaluator);
        }
        return sr.getMemberChildren(member);
    }

    protected Member[] getNonEmptyLevelMembers(Evaluator evaluator, Level level) {
        SchemaReader sr = evaluator.getSchemaReader();
        if (evaluator.isNonEmpty()) {
            return sr.getLevelMembers(level, evaluator);
        }
        return sr.getLevelMembers(level);
    }
}

