/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mondrian.olap.EnumeratedValues;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.fun.MultiResolver;
import mondrian.olap.type.NumericType;

class DescendantsFunDef
extends FunDefBase {
    private final boolean self;
    private final boolean before;
    private final boolean after;
    private final boolean depthSpecified;
    private final boolean leaves;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DescendantsFunDef(FunDef dummyFunDef, int flag, boolean depthSpecified) {
        super(dummyFunDef);
        this.self = FunUtil.checkFlag(flag, 1, true);
        this.after = FunUtil.checkFlag(flag, 2, true);
        this.before = FunUtil.checkFlag(flag, 4, true);
        this.leaves = FunUtil.checkFlag(flag, 8, true);
        this.depthSpecified = depthSpecified;
    }

    public Object evaluate(Evaluator evaluator, Exp[] args) {
        Evaluator context;
        Member member = DescendantsFunDef.getMemberArg(evaluator, args, 0, true);
        ArrayList result = new ArrayList();
        SchemaReader schemaReader = evaluator.getSchemaReader();
        Evaluator evaluator2 = context = evaluator.isNonEmpty() ? evaluator : null;
        if (this.depthSpecified) {
            int depthLimit = DescendantsFunDef.getIntArg(evaluator, args, 1);
            if (this.leaves) {
                if (depthLimit < 0) {
                    depthLimit = Integer.MAX_VALUE;
                }
                DescendantsFunDef.descendantsLeavesByDepth(member, result, schemaReader, depthLimit);
            } else {
                DescendantsFunDef.descendantsByDepth(member, result, schemaReader, depthLimit, this.before, this.self, this.after, context);
            }
        } else {
            Level level = args.length > 1 ? DescendantsFunDef.getLevelArg(evaluator, args, 1, true) : member.getLevel();
            DescendantsFunDef.descendantsByLevel(schemaReader, member, level, result, this.before, this.self, this.after, this.leaves, context);
        }
        DescendantsFunDef.hierarchize(result, false);
        return result;
    }

    private static void descendantsByDepth(Member member, List result, SchemaReader schemaReader, int depthLimitFinal, boolean before, boolean self, boolean after, Evaluator context) {
        Object[] children = new Member[]{member};
        int depth = 0;
        while (true) {
            if (depth == depthLimitFinal) {
                if (self) {
                    DescendantsFunDef.addAll((List)result, (Object[])children);
                }
                if (!after) {
                    break;
                }
            } else if (depth < depthLimitFinal) {
                if (before) {
                    DescendantsFunDef.addAll((List)result, (Object[])children);
                }
            } else {
                if (!after) break;
                DescendantsFunDef.addAll((List)result, (Object[])children);
            }
            if ((children = schemaReader.getMemberChildren((Member[])children, context)).length == 0) break;
            ++depth;
        }
    }

    private static void descendantsLeavesByDepth(Member member, List result, SchemaReader schemaReader, int depthLimit) {
        if (!schemaReader.isDrillable(member)) {
            if (depthLimit >= 0) {
                result.add(member);
            }
            return;
        }
        Member[] children = new Member[]{member};
        for (int depth = 0; depth <= depthLimit; ++depth) {
            if ((children = schemaReader.getMemberChildren(children)).length == 0) {
                throw Util.newInternal("drillable member must have children");
            }
            ArrayList<Member> nextChildren = new ArrayList<Member>();
            for (int i = 0; i < children.length; ++i) {
                Member child = children[i];
                if (schemaReader.isDrillable(child)) {
                    nextChildren.add(child);
                    continue;
                }
                result.add(child);
            }
            if (nextChildren.isEmpty()) break;
            children = nextChildren.toArray(new Member[nextChildren.size()]);
        }
    }

    static void descendantsByLevel(SchemaReader schemaReader, Member ancestor, Level level, List result, boolean before, boolean self, boolean after, boolean leaves, Evaluator context) {
        int levelDepth = level.getDepth();
        Member[] members = new Member[]{ancestor};
        if (leaves) {
            ArrayList<Member> nextMembers;
            if (!$assertionsDisabled && (before || self || after)) {
                throw new AssertionError();
            }
            do {
                nextMembers = new ArrayList<Member>();
                for (int i = 0; i < members.length; ++i) {
                    Member member = members[i];
                    int currentDepth = member.getLevel().getDepth();
                    Member[] childMembers = schemaReader.getMemberChildren(member, context);
                    if (childMembers.length == 0) {
                        if (currentDepth != levelDepth) continue;
                        result.add(member);
                        continue;
                    }
                    if (currentDepth > levelDepth) continue;
                    nextMembers.addAll(Arrays.asList(childMembers));
                }
            } while ((members = nextMembers.toArray(new Member[nextMembers.size()])).length > 0);
        } else {
            ArrayList<Member> fertileMembers = new ArrayList<Member>();
            do {
                fertileMembers.clear();
                for (int i = 0; i < members.length; ++i) {
                    Member member = members[i];
                    int currentDepth = member.getLevel().getDepth();
                    if (currentDepth == levelDepth) {
                        if (self) {
                            result.add(member);
                        }
                        if (!after) continue;
                        fertileMembers.add(member);
                        continue;
                    }
                    if (currentDepth < levelDepth) {
                        if (before) {
                            result.add(member);
                        }
                        fertileMembers.add(member);
                        continue;
                    }
                    if (!after) continue;
                    result.add(member);
                    fertileMembers.add(member);
                }
                members = new Member[fertileMembers.size()];
                members = fertileMembers.toArray(members);
            } while ((members = schemaReader.getMemberChildren(members, context)).length > 0);
        }
    }

    static {
        $assertionsDisabled = !DescendantsFunDef.class.desiredAssertionStatus();
    }

    static class Resolver
    extends MultiResolver {
        public Resolver() {
            super("Descendants", "Descendants(<Member>[, <Level>[, <Desc_flag>]])", "Returns the set of descendants of a member at a specified level, optionally including or excluding descendants in other levels.", new String[]{"fxm", "fxml", "fxmly", "fxmn", "fxmny"});
        }

        protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
            int flag = 1;
            if (args.length == 1) {
                flag = 7;
            }
            boolean depthSpecified = args.length >= 2 ? args[1].getTypeX() instanceof NumericType : false;
            if (args.length >= 3) {
                flag = FunUtil.getLiteralArg(args, 2, 1, Flags.instance, dummyFunDef);
            }
            return new DescendantsFunDef(dummyFunDef, flag, depthSpecified);
        }

        public String[] getReservedWords() {
            return Flags.instance.getNames();
        }
    }

    static class Flags
    extends EnumeratedValues {
        static final Flags instance = new Flags();
        public static final int SELF = 1;
        public static final int AFTER = 2;
        public static final int BEFORE = 4;
        public static final int BEFORE_AND_AFTER = 6;
        public static final int SELF_AND_AFTER = 3;
        public static final int SELF_AND_BEFORE = 5;
        public static final int SELF_BEFORE_AFTER = 7;
        public static final int LEAVES = 8;

        private Flags() {
            super(new String[]{"SELF", "AFTER", "BEFORE", "BEFORE_AND_AFTER", "SELF_AND_AFTER", "SELF_AND_BEFORE", "SELF_BEFORE_AFTER", "LEAVES"}, new int[]{1, 2, 4, 6, 3, 5, 7, 8});
        }
    }
}

