/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import java.io.PrintWriter;
import mondrian.olap.Cube;
import mondrian.olap.Exp;
import mondrian.olap.ExpBase;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.Literal;
import mondrian.olap.Member;
import mondrian.olap.MemberProperty;
import mondrian.olap.NamedSet;
import mondrian.olap.OlapElement;
import mondrian.olap.Property;
import mondrian.olap.Query;
import mondrian.olap.QueryPart;
import mondrian.olap.SchemaReader;
import mondrian.olap.SetBase;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.Walker;
import mondrian.olap.type.DecimalType;
import mondrian.olap.type.NumericType;
import mondrian.olap.type.Type;
import mondrian.olap.type.TypeUtil;
import mondrian.resource.MondrianResource;

public class Formula
extends QueryPart {
    private final String[] names;
    private ExpBase exp;
    private final MemberProperty[] memberProperties;
    private final boolean isMember;
    private Member mdxMember;
    private NamedSet mdxSet;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Formula(String[] names, Exp exp) {
        this(false, names, (ExpBase)exp, new MemberProperty[0], null, null);
        this.createElement(null);
    }

    public Formula(String[] names, Exp exp, MemberProperty[] memberProperties) {
        this(true, names, (ExpBase)exp, memberProperties, null, null);
    }

    private Formula(boolean isMember, String[] names, ExpBase exp, MemberProperty[] memberProperties, Member mdxMember, NamedSet mdxSet) {
        this.isMember = isMember;
        this.names = names;
        this.exp = exp;
        this.memberProperties = memberProperties;
        this.mdxMember = mdxMember;
        this.mdxSet = mdxSet;
        if (!$assertionsDisabled && !isMember && mdxMember != null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && isMember && mdxSet != null) {
            throw new AssertionError();
        }
    }

    public Object clone() {
        return new Formula(this.isMember, this.names, (ExpBase)this.exp.clone(), MemberProperty.cloneArray(this.memberProperties), this.mdxMember, this.mdxSet);
    }

    static Formula[] cloneArray(Formula[] x) {
        Formula[] x2 = new Formula[x.length];
        for (int i = 0; i < x.length; ++i) {
            x2[i] = (Formula)x[i].clone();
        }
        return x2;
    }

    void accept(Validator validator) {
        Exp formatExp;
        boolean scalar = this.isMember;
        this.exp = (ExpBase)validator.validate(this.exp, scalar);
        String id = Util.quoteMdxIdentifier(this.names);
        Type type = this.exp.getTypeX();
        if (this.isMember) {
            if (!TypeUtil.canEvaluate(type)) {
                throw MondrianResource.instance().MdxMemberExpIsSet.ex(id);
            }
        } else if (!TypeUtil.isSet(type)) {
            throw MondrianResource.instance().MdxSetExpNotSet.ex(id);
        }
        for (int i = 0; i < this.memberProperties.length; ++i) {
            validator.validate(this.memberProperties[i]);
        }
        if (this.isMember && (formatExp = this.getFormatExp()) != null) {
            this.mdxMember.setProperty(Property.FORMAT_EXP.name, formatExp);
        }
    }

    void createElement(Query q) {
        if (this.isMember) {
            if (this.mdxMember != null) {
                return;
            }
            OlapElement mdxElement = q.getCube();
            SchemaReader schemaReader = q.getSchemaReader(true);
            for (int i = 0; i < this.names.length; ++i) {
                Level level;
                Cube parent = mdxElement;
                if ((mdxElement = schemaReader.getElementChild(parent, this.names[i])) != null && i != this.names.length - 1) continue;
                Member parentMember = null;
                if (parent instanceof Member) {
                    parentMember = (Member)((Object)parent);
                    level = parentMember.getLevel().getChildLevel();
                } else {
                    Hierarchy hierarchy = parent.getHierarchy();
                    if (hierarchy == null) {
                        throw MondrianResource.instance().MdxCalculatedHierarchyError.ex(Util.quoteMdxIdentifier(this.names));
                    }
                    level = hierarchy.getLevels()[0];
                }
                Member mdxMember = level.getHierarchy().createMember(parentMember, level, this.names[i], this);
                mdxElement = mdxMember;
            }
            this.mdxMember = (Member)mdxElement;
        } else {
            Util.assertTrue(this.names.length == 1, "set names must not be compound");
            this.mdxSet = new SetBase(this.names[0], this.exp);
        }
    }

    public Object[] getChildren() {
        Object[] children = new Object[1 + this.memberProperties.length];
        children[0] = this.exp;
        System.arraycopy(this.memberProperties, 0, children, 1, this.memberProperties.length);
        return children;
    }

    public void replaceChild(int ordinal, QueryPart with) {
        Util.assertTrue(ordinal == 0);
        this.exp = (ExpBase)with;
    }

    public void unparse(PrintWriter pw) {
        if (this.isMember) {
            pw.print("member ");
            this.mdxMember.unparse(pw);
        } else {
            pw.print("set ");
            pw.print(Util.quoteMdxIdentifier(this.names));
        }
        pw.print(" as '");
        this.exp.unparse(pw);
        pw.print("'");
        if (this.memberProperties != null) {
            for (int i = 0; i < this.memberProperties.length; ++i) {
                pw.print(", ");
                this.memberProperties[i].unparse(pw);
            }
        }
    }

    public boolean isMember() {
        return this.isMember;
    }

    public NamedSet getNamedSet() {
        return this.mdxSet;
    }

    String[] getNames() {
        return this.names;
    }

    public String getName() {
        return this.isMember ? this.mdxMember.getName() : this.mdxSet.getName();
    }

    public String getCaption() {
        return this.isMember ? this.mdxMember.getCaption() : this.mdxSet.getName();
    }

    void rename(String newName) {
        String oldName = this.getElement().getName();
        Util.assertTrue(this.names[this.names.length - 1].equalsIgnoreCase(oldName));
        this.names[this.names.length - 1] = newName;
        if (this.isMember) {
            this.mdxMember.setName(newName);
        } else {
            this.mdxSet.setName(newName);
        }
    }

    String getUniqueName() {
        return this.isMember ? this.mdxMember.getUniqueName() : this.mdxSet.getUniqueName();
    }

    OlapElement getElement() {
        return this.isMember ? this.mdxMember : this.mdxSet;
    }

    public Exp getExpression() {
        return this.exp;
    }

    private Exp getMemberProperty(String name) {
        return MemberProperty.get(this.memberProperties, name);
    }

    public Member getMdxMember() {
        return this.mdxMember;
    }

    public int getSolveOrder() {
        Type type;
        Exp exp = this.getMemberProperty(Property.SOLVE_ORDER.name);
        if (exp != null && (type = exp.getTypeX()) instanceof NumericType) {
            return ((Literal)exp).getIntValue();
        }
        return 0;
    }

    private Exp getFormatExp() {
        for (int i = 0; i < Property.FORMAT_PROPERTIES.length; ++i) {
            Exp formatExp = this.getMemberProperty(Property.FORMAT_PROPERTIES[i]);
            if (formatExp == null) continue;
            return formatExp;
        }
        Type type = this.exp.getTypeX();
        if (type instanceof DecimalType) {
            int scale = ((DecimalType)type).getScale();
            String formatString = "#,##0";
            if (scale > 0) {
                formatString = formatString + ".";
                while (scale-- > 0) {
                    formatString = formatString + "0";
                }
            }
            return Literal.createString(formatString);
        }
        Walker walker = new Walker(this.exp);
        while (walker.hasMoreElements()) {
            Exp formatExp;
            Object o = walker.nextElement();
            if (!(o instanceof Member) || (formatExp = (Exp)((Member)o).getPropertyValue(Property.FORMAT_EXP.name)) == null) continue;
            return formatExp;
        }
        return null;
    }

    static {
        $assertionsDisabled = !Formula.class.desiredAssertionStatus();
    }
}

