/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mondrian.olap.MondrianDef;
import mondrian.olap.Util;
import mondrian.rolap.RolapStar;
import mondrian.rolap.agg.AbstractQuerySpec;
import mondrian.rolap.agg.CellRequest;
import mondrian.rolap.agg.ColumnConstraint;
import mondrian.rolap.sql.SqlQuery;

class DrillThroughQuerySpec
extends AbstractQuerySpec {
    private final CellRequest request;
    private final String[] columnNames;

    public DrillThroughQuerySpec(CellRequest request) {
        super(request.getMeasure().getStar());
        this.request = request;
        this.columnNames = this.computeDistinctColumnNames();
    }

    private String[] computeDistinctColumnNames() {
        ArrayList columnNames = new ArrayList();
        HashSet columnNameSet = new HashSet();
        RolapStar.Column[] columns = this.getColumns();
        for (int i = 0; i < columns.length; ++i) {
            RolapStar.Column column = columns[i];
            this.addColumnName(column, columnNames, columnNameSet);
        }
        this.addColumnName(this.request.getMeasure(), columnNames, columnNameSet);
        return columnNames.toArray(new String[columnNames.size()]);
    }

    private void addColumnName(RolapStar.Column column, List columnNames, Set columnNameSet) {
        String columnName = column.getName();
        if (columnName == null) {
            columnName = column.getExpression() instanceof MondrianDef.Column ? ((MondrianDef.Column)column.getExpression()).name : "c" + Integer.toString(columnNames.size());
        }
        int j = 0;
        while (!columnNameSet.add(columnName)) {
            columnName = "x" + Integer.toString(j);
            ++j;
        }
        columnNames.add(columnName);
    }

    public int getMeasureCount() {
        return 1;
    }

    public RolapStar.Measure getMeasure(int i) {
        Util.assertTrue(i == 0);
        return this.request.getMeasure();
    }

    public String getMeasureAlias(int i) {
        Util.assertTrue(i == 0);
        return this.columnNames[this.columnNames.length - 1];
    }

    public RolapStar.Column[] getColumns() {
        return this.request.getColumns();
    }

    public String getColumnAlias(int i) {
        return this.columnNames[i];
    }

    public ColumnConstraint[] getConstraints(int i) {
        ColumnConstraint[] columnConstraintArray;
        ColumnConstraint constr = (ColumnConstraint)this.request.getValueList().get(i);
        if (constr == null) {
            columnConstraintArray = null;
        } else {
            ColumnConstraint[] columnConstraintArray2 = new ColumnConstraint[1];
            columnConstraintArray = columnConstraintArray2;
            columnConstraintArray2[0] = constr;
        }
        return columnConstraintArray;
    }

    public String generateSqlQuery() {
        SqlQuery sqlQuery = this.newSqlQuery();
        this.nonDistinctGenerateSQL(sqlQuery);
        return sqlQuery.toString();
    }

    protected void addMeasure(int i, SqlQuery sqlQuery) {
        RolapStar.Measure measure = this.getMeasure(i);
        Util.assertTrue(measure.getTable() == this.getStar().getFactTable());
        measure.getTable().addToFrom(sqlQuery, false, true);
        String expr = measure.getExpression(sqlQuery);
        sqlQuery.addSelect(expr, this.getMeasureAlias(i));
    }

    protected boolean isAggregate() {
        return false;
    }
}

