/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.StringTokenizer;
import net.sf.jasperreports.engine.JRTextElement;
import net.sf.jasperreports.engine.export.TextRenderer;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.MaxFontSizeFinder;

public class TextMeasurer {
    private static final FontRenderContext FONT_RENDER_CONTEXT = TextRenderer.LINE_BREAK_FONT_RENDER_CONTEXT;
    private JRTextElement textElement = null;
    private MaxFontSizeFinder maxFontSizeFinder = null;
    private int width = 0;
    private int height = 0;
    private int topPadding = 0;
    private int leftPadding = 0;
    private int bottomPadding = 0;
    private int rightPadding = 0;
    private float lineSpacing = 0.0f;
    private float formatWidth = 0.0f;
    private int maxHeight = 0;
    private int textOffset = 0;
    private int lines = 0;
    private int fontSizeSum = 0;
    private int firstLineMaxFontSize = 0;
    private float textHeight = 0.0f;
    private float firstLineLeading = 0.0f;
    private boolean isLeftToRight = true;
    private boolean isMaxHeightReached = false;

    public TextMeasurer(JRTextElement textElement) {
        this.textElement = textElement;
    }

    private void initialize(int availableStretchHeight) {
        this.width = this.textElement.getWidth();
        this.height = this.textElement.getHeight();
        this.topPadding = this.textElement.getTopPadding();
        this.leftPadding = this.textElement.getLeftPadding();
        this.bottomPadding = this.textElement.getBottomPadding();
        this.rightPadding = this.textElement.getRightPadding();
        switch (this.textElement.getRotation()) {
            case 1: {
                this.width = this.textElement.getHeight();
                this.height = this.textElement.getWidth();
                int tmpPadding = this.topPadding;
                this.topPadding = this.leftPadding;
                this.leftPadding = this.bottomPadding;
                this.bottomPadding = this.rightPadding;
                this.rightPadding = tmpPadding;
                break;
            }
            case 2: {
                this.width = this.textElement.getHeight();
                this.height = this.textElement.getWidth();
                int tmpPadding = this.topPadding;
                this.topPadding = this.rightPadding;
                this.rightPadding = this.bottomPadding;
                this.bottomPadding = this.leftPadding;
                this.leftPadding = tmpPadding;
                break;
            }
        }
        switch (this.textElement.getLineSpacing()) {
            case 0: {
                this.lineSpacing = 1.0f;
                break;
            }
            case 1: {
                this.lineSpacing = 1.5f;
                break;
            }
            case 2: {
                this.lineSpacing = 2.0f;
                break;
            }
            default: {
                this.lineSpacing = 1.0f;
            }
        }
        this.maxFontSizeFinder = MaxFontSizeFinder.getInstance(this.textElement.isStyledText());
        this.formatWidth = this.width - this.leftPadding - this.rightPadding;
        this.formatWidth = this.formatWidth < 0.0f ? 0.0f : this.formatWidth;
        this.maxHeight = this.height + availableStretchHeight - this.topPadding - this.bottomPadding;
        this.maxHeight = this.maxHeight < 0 ? 0 : this.maxHeight;
        this.textOffset = 0;
        this.lines = 0;
        this.fontSizeSum = 0;
        this.firstLineMaxFontSize = 0;
        this.textHeight = 0.0f;
        this.firstLineLeading = 0.0f;
        this.isLeftToRight = true;
        this.isMaxHeightReached = false;
    }

    public void measure(JRStyledText styledText, String remainingText, int remainingTextStart, int availableStretchHeight) {
        this.initialize(availableStretchHeight);
        AttributedCharacterIterator allParagraphs = styledText.getAttributedString().getIterator();
        int tokenPosition = remainingTextStart;
        int lastParagraphStart = remainingTextStart;
        String lastParagraphText = null;
        StringTokenizer tkzer = new StringTokenizer(remainingText, "\n", true);
        while (tkzer.hasMoreTokens() && !this.isMaxHeightReached) {
            String token = tkzer.nextToken();
            if ("\n".equals(token)) {
                this.renderParagraph(allParagraphs, lastParagraphStart, lastParagraphText);
                lastParagraphStart = tokenPosition + (tkzer.hasMoreTokens() || tokenPosition == 0 ? 1 : 0);
                lastParagraphText = null;
            } else {
                lastParagraphStart = tokenPosition;
                lastParagraphText = token;
            }
            tokenPosition += token.length();
        }
        if (!this.isMaxHeightReached && lastParagraphStart < remainingTextStart + remainingText.length()) {
            this.renderParagraph(allParagraphs, lastParagraphStart, lastParagraphText);
        }
    }

    private void renderParagraph(AttributedCharacterIterator allParagraphs, int lastParagraphStart, String lastParagraphText) {
        AttributedCharacterIterator paragraph = null;
        paragraph = lastParagraphText == null ? new AttributedString(" ", new AttributedString(allParagraphs, lastParagraphStart, lastParagraphStart + 1).getIterator().getAttributes()).getIterator() : new AttributedString(allParagraphs, lastParagraphStart, lastParagraphStart + lastParagraphText.length()).getIterator();
        int positionWithinParagraph = 0;
        LineBreakMeasurer lineMeasurer = new LineBreakMeasurer(paragraph, FONT_RENDER_CONTEXT);
        while (lineMeasurer.getPosition() < paragraph.getEndIndex() && !this.isMaxHeightReached) {
            int lineStartPosition = lineMeasurer.getPosition();
            TextLayout layout = lineMeasurer.nextLayout(this.formatWidth);
            this.isLeftToRight = this.isLeftToRight && layout.isLeftToRight();
            this.textHeight += layout.getLeading() + this.lineSpacing * layout.getAscent();
            if (this.textHeight + layout.getDescent() <= (float)this.maxHeight) {
                ++this.lines;
                this.fontSizeSum += this.maxFontSizeFinder.findMaxFontSize(new AttributedString(paragraph, lineStartPosition, lineStartPosition + layout.getCharacterCount()).getIterator(), this.textElement.getFontSize());
                if (this.lines == 1) {
                    this.firstLineLeading = this.textHeight;
                    this.firstLineMaxFontSize = this.fontSizeSum;
                }
                positionWithinParagraph = lineMeasurer.getPosition();
                this.textHeight += layout.getDescent();
                continue;
            }
            this.textHeight -= layout.getLeading() + this.lineSpacing * layout.getAscent();
            this.isMaxHeightReached = true;
        }
        this.textOffset = lastParagraphStart + positionWithinParagraph;
    }

    protected boolean isLeftToRight() {
        return this.isLeftToRight;
    }

    protected int getTextOffset() {
        return this.textOffset;
    }

    public float getTextHeight() {
        return this.textHeight;
    }

    public float getLineSpacingFactor() {
        if (this.lines > 0) {
            return this.textHeight / (float)this.fontSizeSum;
        }
        return 0.0f;
    }

    public float getLeadingOffset() {
        return this.firstLineLeading - (float)this.firstLineMaxFontSize * this.getLineSpacingFactor();
    }
}

