/*
 * Decompiled with CFR 0.152.
 */
package mondrian.jolap;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.spi.InitialContextFactory;
import javax.olap.OLAPException;
import javax.olap.resource.ConnectionFactory;
import javax.olap.resource.ConnectionSpec;
import javax.olap.resource.ResourceAdapterMetaData;
import mondrian.jolap.MondrianJolapConnection;
import mondrian.jolap.MondrianJolapConnectionSpec;
import mondrian.jolap.RefObjectSupport;
import mondrian.olap.Connection;
import mondrian.olap.DriverManager;
import mondrian.olap.Util;
import mondrian.util.BarfingInvocationHandler;

public class MondrianJolapConnectionFactory
extends RefObjectSupport
implements ConnectionFactory,
InitialContextFactory {
    private static final String FOODMART_CATALOG_URL = "mondrian.test.foodmart.catalogURL";

    public javax.olap.resource.Connection getConnection() throws OLAPException {
        throw new UnsupportedOperationException();
    }

    public javax.olap.resource.Connection getConnection(ConnectionSpec properties) throws OLAPException {
        Util.PropertyList propertyList = new Util.PropertyList();
        MondrianJolapConnectionSpec cs = (MondrianJolapConnectionSpec)properties;
        propertyList.put("Provider", "mondrian");
        propertyList.put("User", cs.getName());
        propertyList.put("Password", cs.getPassword());
        propertyList.put("Jdbc", "jdbc:odbc:MondrianFoodMart");
        if (System.getProperty(FOODMART_CATALOG_URL) != null) {
            propertyList.put("Catalog", System.getProperty(FOODMART_CATALOG_URL));
        } else {
            propertyList.put("Catalog", "file:///e:/mondrian/demo/FoodMart.xml");
        }
        propertyList.put("JdbcDrivers", "sun.jdbc.odbc.JdbcOdbcDriver,oracle.jdbc.OracleDriver,com.mysql.jdbc.Driver");
        boolean fresh = false;
        Connection mondrianConnection = DriverManager.getConnection(propertyList, null, false);
        return new MondrianJolapConnection(mondrianConnection);
    }

    public ConnectionSpec createConnectionSpec() throws OLAPException {
        return new MondrianJolapConnectionSpec();
    }

    public ResourceAdapterMetaData getMetaData() throws OLAPException {
        throw new UnsupportedOperationException();
    }

    public Context getInitialContext(Hashtable environment) throws NamingException {
        return (Context)Proxy.newProxyInstance(null, new Class[]{Context.class}, (InvocationHandler)new ContextHandler());
    }

    public void setReference(Reference ref) {
        throw new UnsupportedOperationException();
    }

    public Reference getReference() throws NamingException {
        throw new UnsupportedOperationException();
    }

    public class ContextHandler
    extends BarfingInvocationHandler {
        public Object lookup(String name) throws NamingException {
            Util.assertTrue(name.equals("JOLAPServer"));
            return MondrianJolapConnectionFactory.this;
        }
    }
}

